/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.devices.services;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.ruyisdk.core.basedir.XdgDirs;
import org.ruyisdk.core.console.RuyiSdkConsole;
import org.ruyisdk.devices.model.Device;

public class PropertiesService {
    private static final Path FILE_PATH = Paths.get(XdgDirs.getConfigDir((String)"ruyisdkide").toString(), "devices.properties");
    private static final String DEFAULT_DEVICE_KEY = "default_device";

    public List<Device> loadDevices() {
        ArrayList<Device> devices = new ArrayList<Device>();
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = Files.newInputStream(FILE_PATH, new OpenOption[0]);){
                properties.load(inputStream);
                String defaultBoard = properties.getProperty(DEFAULT_DEVICE_KEY);
                int index = 1;
                while (properties.containsKey("device." + index + ".name")) {
                    String name = properties.getProperty("device." + index + ".name");
                    String chip = properties.getProperty("device." + index + ".chip");
                    String vendor = properties.getProperty("device." + index + ".vendor");
                    String version = properties.getProperty("device." + index + ".version");
                    boolean isDefault = ("device." + index).equals(defaultBoard);
                    devices.add(new Device(name, chip, vendor, version, isDefault));
                    ++index;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return devices;
    }

    /*
     * WARNING - void declaration
     */
    public void saveDevices(List<Device> devices) {
        Properties properties = new Properties();
        int index = 1;
        for (Device device : devices) {
            properties.setProperty("device." + index + ".name", device.getName());
            properties.setProperty("device." + index + ".chip", device.getChip());
            properties.setProperty("device." + index + ".vendor", device.getVendor());
            properties.setProperty("device." + index + ".version", device.getVersion());
            if (device.isDefault()) {
                properties.setProperty(DEFAULT_DEVICE_KEY, "device." + index);
            }
            ++index;
        }
        try {
            Throwable throwable = null;
            Iterator<Device> iterator = null;
            try (FileOutputStream output = new FileOutputStream(FILE_PATH.toString());){
                properties.store(output, "RuyiSDK Devices Configuration");
                RuyiSdkConsole.getInstance().logInfo("Devices is successfully stored to file :" + FILE_PATH.toString());
            }
            catch (Throwable throwable2) {
                void var4_10;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var4_10;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            RuyiSdkConsole.getInstance().logError("Devices storage failure!");
        }
    }
}

