/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.devices.services;

import java.util.ArrayList;
import java.util.List;
import org.ruyisdk.devices.model.Device;
import org.ruyisdk.devices.services.PropertiesService;

public class DeviceService {
    private List<Device> devices = new ArrayList<Device>();
    private PropertiesService propertiesService = new PropertiesService();

    public DeviceService() {
        this.devices = this.propertiesService.loadDevices();
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public void addDevice(Device device) {
        this.devices.add(device);
    }

    public void updateDevice(Device oldDevice, Device newDevice) {
        int index = this.devices.indexOf(oldDevice);
        if (index != -1) {
            this.devices.set(index, newDevice);
        }
    }

    public void deleteDevice(Device device) {
        this.devices.remove(device);
    }

    public void setDefaultDevice(Device device) {
        for (Device b : this.devices) {
            b.setDefault(false);
        }
        device.setDefault(true);
    }

    public void saveDevices() {
        this.propertiesService.saveDevices(this.devices);
    }
}

