/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.core.ruyi.model;

import java.util.Locale;

public class SystemInfo {
    public static Architecture detectArchitecture() {
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if (arch.contains("x86_64") || arch.contains("amd64")) {
            return Architecture.X86_64;
        }
        if (arch.contains("aarch64") || arch.contains("arm64")) {
            return Architecture.ARM;
        }
        if (arch.contains("riscv")) {
            return Architecture.RISCV;
        }
        return Architecture.UNKNOWN;
    }

    public static String getPlatformKey() {
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if (arch.contains("x86_64") || arch.contains("amd64")) {
            return "linux/x86_64";
        }
        if (arch.contains("aarch64") || arch.contains("arm64")) {
            return "linux/aarch64";
        }
        if (arch.contains("riscv")) {
            return "linux/riscv64";
        }
        return "linux/" + arch;
    }

    public static enum Architecture {
        X86_64("amd64"),
        ARM("arm64"),
        RISCV("riscv64"),
        UNKNOWN("unknown");

        private final String suffix;

        private Architecture(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

