/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.core.basedir;

import java.nio.file.Path;
import java.nio.file.Paths;

public class XdgDirs {
    public static Path getConfigDir(String appName) {
        return XdgDirs.getXdgDir("XDG_CONFIG_HOME", ".config", appName);
    }

    public static Path getCacheDir(String appName) {
        return XdgDirs.getXdgDir("XDG_CACHE_HOME", ".cache", appName);
    }

    public static Path getDataDir(String appName) {
        return XdgDirs.getXdgDir("XDG_DATA_HOME", ".local/share", appName);
    }

    public static Path getStateDir(String appName) {
        return XdgDirs.getXdgDir("XDG_STATE_HOME", ".local/state", appName);
    }

    private static Path getXdgDir(String xdgEnvVar, String defaultRelativePath, String appName) {
        String xdgHome = System.getenv(xdgEnvVar);
        if (xdgHome != null && !xdgHome.trim().isEmpty()) {
            return Paths.get(xdgHome, appName);
        }
        String userHome = System.getProperty("user.home");
        return Paths.get(userHome, defaultRelativePath, appName);
    }
}

