#!/bin/bash
#
#date:2021.12.22
#description:cardtype 0 mainline card
#					  1  4PF card
#					  2  8/16 VFs PF card
#					  3  64 VFs PF card
#                     4  VF card
#Version:1.0
#
#date:2022.1.21
#change info: 64 VFs PF card msi-->polling 
# Version:1.1
#

module="swcsm"

count=$(awk '/0x10ee/{count++} END{print count}' $(find /sys/devices/ -name vendor))
if [ ! $count ]; then
	echo -e "\033[31m lspci found card count: 0\033[0m"
	exit 1
else
	echo "lspci found card count: $count" 
fi

cpu_affinty()
{
	count=`grep 'swcsm' /proc/interrupts | wc -l`
	#irqn=`cat /proc/interrupts | grep swcsm | head -1 | cut -c 1-4 | sed -e 's/^[ \t]*//g'`
	irqn=`grep 'swcsm' /proc/interrupts  | awk -F: '{print $1}' | sed -ne '1s/[ \t]*//gp'`

	if [ ! $irqn ];then
		return;
	fi
	echo "PCIe Card irqnum from $irqn to $(($irqn + $count -1))"

	cpun=`cat /proc/cpuinfo | grep processor | tail -1 | awk '{print $3}'`
	#cpun=${cpun##* }
	cpun=$((cpun+1))
	echo "Machine cpus num $cpun"

	for((i=0;i<count;i++));  
	do   
		val=$(($i % $cpun))
		val=$((2**$val))
		val=`printf "%x\n" ${val}`
		echo "command: echo $val > /proc/irq/$[ $irqn + $i ]/smp_affinity"
		echo $val > /proc/irq/$[ $irqn + $i ]/smp_affinity
	done  
}

ubind_host(){

	exis=`uname -a | grep xen`
	if [ ! $exis ];
	then
		vir=kvm
	else
		vir=xen
	fi

	if [ $vir == "xen" ];then
		echo "xen virtual machine"
	elif [ $vir == "kvm" ];then
		echo "kvm virtual machine"
	fi

	for i in $(find /sys/devices/ -name vendor)
	do 
		tmp=`echo ${i%vendor}`
		if [ `cat $i` == "0x10ee" ]; then
			a=$tmp"device"
			# a=$a
			if [ `cat $a` == "0x1001" ]; then
				a=`echo ${a:0-19:12}`
				if [ $vir == "xen" ];then
					echo $a > /sys/bus/pci/drivers/pciback/new_slot
					echo $a > /sys/bus/pci/drivers/pciback/bind
					echo $a > /sys/bus/pci/devices/$a/driver/unbind
				elif [ $vir == "kvm" ];then
					echo "10ee 1001" > /sys/bus/pci/drivers/pci-stub/new_id
					echo $a > /sys/bus/pci/devices/$a/driver/unbind
					echo $a > /sys/bus/pci/drivers/pci-stub/bind
				fi
			fi
		fi 
	done  
}

rmmod $module
for i in $(find /sys/devices/ -name vendor)
do 
  tmp=`echo ${i%vendor}`
  if [ `cat $i` == 0x10ee ]; then
	arr[j]=$tmp
	arr[j++]=${arr[j]}config
  fi 
done  

cardtype=(0 0 0 0 0)
j=0


for((i=0;i<${#arr[@]};i++))
do
	# echo ${arr[i]}
	vfid=$(xxd ${arr[i]} | awk 'NR==1{print $3}')
	ver=$(xxd ${arr[i]} | awk 'NR==1{print $6}' | cut -c 1-2)
	vfnum=$(xxd ${arr[i]} | awk 'NR==21{print $9}' | cut -c 1-2)
	subid=$(xxd ${arr[i]} | awk 'NR==3{print $9}' | cut -c 1-2)
	if [ ! $vfnum ];then
		vfnum="00"
	fi
	# echo "debuginfo" $ver $vfid $vfnum $subid
	# echo ${arr[i]}
	if [ $vfid == "0110" ]; then
		 echo "vf card"
		 card[j++]=4
 		 cardtype[4]=$((${cardtype[4]}+1));	 
	else
		if [ $ver == "01" ]; then
			echo "mainline card"
			card[j++]=0
			cardtype[0]=$((${cardtype[0]}+1));
			
		elif [ $ver == "03" ]; then
			echo "4PF card"
			card[j++]=1
 			cardtype[1]=$((${cardtype[1]}+1));
		
		elif [ $ver == "02" ]; then
			echo "64vf PF card"
			card[j++]=3
			cardtype[3]=$((${cardtype[3]}+1));
			bdf[k++]=`echo ${arr[i]:0-19:12}`
		elif [ $subid == "07" ]; then
			# echo "any"
			if [[ ($vfnum == "08") || ($vfnum == "10") ]]; then ###sriov
				echo "vfnum 0x$vfnum PF card"
				card[j++]=2
				cardtype[2]=$((${cardtype[2]}+1));
				bdf[k++]=`echo ${arr[i]:0-19:12}`
			elif [ $i -lt $((${#arr[@]}-1)) ]; then ###4 PF
				if [ $(xxd ${arr[i+1]} | awk 'NR==3{print $9}' | cut -c 1-2) == "08" ]; then
					echo "4PF card"
					card[j++]=1
					cardtype[1]=$((${cardtype[1]}+1));
				else ####mainline
					echo "mainline card"
					card[j++]=0
					cardtype[0]=$((${cardtype[0]}+1));
				fi
			else ####mainline
				echo "mainline card"
				card[j++]=0
				cardtype[0]=$((${cardtype[0]}+1));
			fi
			 
		elif [ $subid == "08" ]; then
			if [ $vfnum == "40" ]; then ###sriov 64
				echo "vfnum 0x$vfnum PF card"
				card[j++]=3
				#i=$((i+3))
				cardtype[3]=$((${cardtype[3]}+1));
				bdf[k++]=`echo ${arr[i]:0-19:12}`
			#else
			#	echo "unkown card"
			fi
		else
			echo "unkown card"
		fi
	fi
done
 

echo -e "\033[31m mainline card count:    ${cardtype[0]}\033[0m"
echo -e "\033[31m 4 PF card count:        ${cardtype[1]}\033[0m"
echo -e "\033[31m 8/16 VFs PF card count: ${cardtype[2]}\033[0m"
echo -e "\033[31m 64 VFs PF card count:   ${cardtype[3]}\033[0m"
echo -e "\033[31m VF card count:          ${cardtype[4]}\033[0m"
# echo ${card[*]}
# echo ${bdf[*]}
# echo ${cardtype[*]}

if [[ (${cardtype[1]} -ne 0 && ${cardtype[4]} -ne 0)  || (${cardtype[1]} -ne 0 && ${cardtype[3]} -ne 0) ]];
then
	echo "unsupported error"
	exit 1
fi

if [[ (${cardtype[1]} -ne 0) ]];###msi driver
then
	echo "loading PF driver ..."	 
	/sbin/insmod $module.ko polling=0 || exit 1 
	cpu_affinty
else   ###msi or poll driver
	if [ ${cardtype[4]} -ne 0 ]; then
		/sbin/insmod $module.ko polling=1 VFnum=0 || exit 1
	elif [ ${cardtype[3]} -ne 0 ]; then
		echo -n "please input number of VFs within 3 seconds:"
		read -t 3 num
		num=${num:-512}
		echo ""
		/sbin/insmod $module.ko polling=1 VFnum=$num || exit 1
		ubind_host 
	else
		read -p "Please choose interrupt/polling driver:" -t 5 cho
		case $cho in
			"interrupt")
			/sbin/insmod $module.ko polling=0 || exit 1
			cpu_affinty
			;;
			"polling")
			/sbin/insmod $module.ko polling=1 || exit 1
			;;
			*)
			/sbin/insmod $module.ko polling=1 || exit 1
			;;
		esac
		if [ ${cardtype[2]} -ne 0 ]; then
			ubind_host
		fi
   fi
fi
