#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dlfcn.h>

#include "instanta_layer2vi_dl.h"

#define DLL_PATH "/usr/lib/libinstanta.so"

layer2vi_create_t             layer2vi_create;
layer2vi_create_ex_t          layer2vi_create_ex;
layer2vi_destroy_t            layer2vi_destroy;
layer2vi_add_filter_t         layer2vi_add_filter;
layer2vi_remove_filter_t      layer2vi_remove_filter;
layer2vi_filter_count_t       layer2vi_filter_count;
layer2vi_receive_frame_t      layer2vi_receive_frame;
layer2vi_receive_frame_nonblock_t layer2vi_receive_frame_nonblock;
layer2vi_receive_frame_nonblock_ex_t layer2vi_receive_frame_nonblock_ex;
layer2vi_transmit_frame_t     layer2vi_transmit_frame;
layer2vi_rx_statistics_t      layer2vi_rx_statistics;
layer2vi_tx_statistics_t      layer2vi_tx_statistics;
layer2vi_query_filter_by_id_t layer2vi_query_filter_by_id;

void *dlhandler = NULL;

__attribute__((constructor)) void layer2vi_dl_init()
{
    dlhandler = dlopen(DLL_PATH, RTLD_LAZY);
    if (dlhandler == NULL)
    {
        fprintf(stderr, "%s\n", dlerror());
        exit(-1);
    }

    layer2vi_create             = dlsym(dlhandler, "layer2vi_create");
    layer2vi_create_ex          = dlsym(dlhandler, "layer2vi_create_ex");
    layer2vi_destroy            = dlsym(dlhandler, "layer2vi_destroy");
    layer2vi_add_filter         = dlsym(dlhandler, "layer2vi_add_filter");
    layer2vi_remove_filter      = dlsym(dlhandler, "layer2vi_remove_filter");
    layer2vi_filter_count       = dlsym(dlhandler, "layer2vi_filter_count");
    layer2vi_receive_frame      = dlsym(dlhandler, "layer2vi_receive_frame");
    layer2vi_receive_frame_nonblock = dlsym(dlhandler, "layer2vi_receive_frame_nonblock");
    layer2vi_receive_frame_nonblock_ex = dlsym(dlhandler, "layer2vi_receive_frame_nonblock_ex");
    layer2vi_transmit_frame     = dlsym(dlhandler, "layer2vi_transmit_frame");
    layer2vi_rx_statistics      = dlsym(dlhandler, "layer2vi_rx_statistics");
    layer2vi_tx_statistics      = dlsym(dlhandler, "layer2vi_tx_statistics");
    layer2vi_query_filter_by_id = dlsym(dlhandler, "layer2vi_query_filter_by_id");
}

__attribute__((destructor)) void layer2vi_dl_destroy()
{
    dlclose(dlhandler);
}
