#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

int main(int argc, char* argv[])
{
    int fd, conn_sock, port, recv_len;
    char buf[1024];

    if (argc < 3)
    {
        printf("%s ip port\n", argv[0]);
        return -1;
    }

    fd = socket(AF_INET, SOCK_STREAM, 0);
    if (fd < 0)
    {
        printf("Create socket error: %d\n", errno);
        return -1;
    }

    port = atoi(argv[2]);

    struct sockaddr_in baddr;
    baddr.sin_family = AF_INET;
    baddr.sin_port = htons(port);
    if (!inet_pton(AF_INET, argv[1], &baddr.sin_addr.s_addr))
    {
        printf("Invalid IP\n");
        close(fd);
        return -1;
    }

    if (bind(fd, (struct sockaddr*)&baddr, sizeof(struct sockaddr)) < 0)
    { 
        printf("bind error: %d\n", errno);
        close(fd);
        return -1;
    }

    if (listen(fd, 0) < 0)
    {
        printf("listen error: %d\n", errno);
        close(fd);
        return -1;
    }

    struct sockaddr_in peer_addr;
    socklen_t peer_len = sizeof(struct sockaddr_in);
    conn_sock = accept(fd, (struct sockaddr *)&peer_addr, &peer_len);
    if (conn_sock < 0)
    {
        printf("accept error: %d\n", errno);
        close(fd);
        return -1;
    }

    while (1)
    {
        memset(buf, 0, sizeof(buf));
        recv_len = recv(conn_sock, buf, sizeof(buf), 0);
        if (recv_len < 0)
        {
            printf("recv error: %d\n", errno);
            break;
        }
        else if (recv_len == 0)
        {
            printf("Connection has been closed by peer\n");
            break;
        }
    }

    close(conn_sock);
    close(fd);

    return 0;
}