#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

int main(int argc, char* argv[])
{
    int fd, port, send_len;
    char buf[1024];

    if (argc < 3)
    {
        printf("%s ip port\n", argv[0]);
        return -1;
    }

    fd = socket(AF_INET, SOCK_STREAM, 0);
    if (fd < 0)
    {
        printf("Create socket error: %d\n", errno);
        return -1;
    }

    port = atoi(argv[2]);

    struct sockaddr_in daddr;
    daddr.sin_family = AF_INET;
    daddr.sin_port = htons(port);
    if (!inet_pton(AF_INET, argv[1], &daddr.sin_addr.s_addr))
    {
        printf("Invalid IP\n");
        close(fd);
        return -1;
    }

    if (connect(fd, (struct sockaddr*)&daddr, sizeof(struct sockaddr)) < 0)
    {
        printf("connect error: %d\n", errno);
        close(fd);
        return -1;
    }

    memset(buf, 0xFF, sizeof(buf));
    send_len = send(fd, buf, sizeof(buf), 0);
    if (send_len < sizeof(buf))
    {
        printf("send error: %d\n", errno);
    }

    close(fd);

    return 0;
}