#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <pthread.h>
#include <arpa/inet.h>
#include <sys/time.h>

int main()
{
    int nSocketFd = 0;
    int clifd = 0;
    struct sockaddr_in stServAddr,stClientAddr;
    socklen_t socketAddrLen;
    int nRet = 0;
    char szBuff[BUFSIZ] = {0};
    int nReadSocketLen = 0;
    pthread_t tid;
    int isReuse = 1;

    struct timeval tv;
    int maxfd = 0;
    int retval = 0;
    fd_set readfds;
    int selectFd[100] = {0};
    int selectCount = 0;
    int index = 0;
    int nRdSocketLen = 0;
    char szIP[100][20] = {0};

    /** 产生一个套接口的描数字 */
    nSocketFd = socket(AF_INET,SOCK_STREAM,0);

    memset(&stServAddr,0,sizeof(struct sockaddr_in));

    stServAddr.sin_family = AF_INET;
    stServAddr.sin_addr.s_addr = htonl(INADDR_ANY);
    stServAddr.sin_port = htons(8080);

    setsockopt(nSocketFd,SOL_SOCKET,SO_REUSEADDR,(const char*)&isReuse,sizeof(isReuse));

    /** 把这个套接字描述符和本地地址绑定起来 */
    nRet = bind(nSocketFd,(struct sockaddr*)&stServAddr,sizeof(stServAddr));
    if(-1 == nRet)
    {
        perror("bind failed :");
        close(nSocketFd);
        return -1;
    }

    /** 设置该套接口的监听状态， */
    listen(nSocketFd,1024);


    FD_ZERO(&readfds);
    FD_SET(nSocketFd,&readfds);
    tv.tv_sec = 10;
    tv.tv_usec = 0;
    maxfd = nSocketFd;

    while(1)
    {
        FD_ZERO(&readfds);
        FD_SET(nSocketFd,&readfds);
        tv.tv_sec = 10;
        tv.tv_usec = 0;
        maxfd = nSocketFd;

        /* 把所有的sock描述符都放入到这个描述符集中去 */
        for(index = 0;index < selectCount;index++)
        {
            FD_SET(selectFd[index],&readfds);
            if(selectFd[index] > maxfd)
            {
                maxfd = selectFd[index];
            }
        }

        retval = select(maxfd+1,&readfds,NULL,NULL,&tv);

        /* 出错 */
        if(retval < 0)  
        {
            perror("select");
        }

        /* 当没有响应 */
        if(retval == 0)
        {
            continue;
        }       

        memset(szBuff,0,BUFSIZ);
                /* 判断是哪个客户端的响应 */
        for(index = 0; index < selectCount;index++)
        {
            if(FD_ISSET(selectFd[index],&readfds))
            {
                nRdSocketLen = read(selectFd[index],szBuff,BUFSIZ);

                /* 数据回发 */
                write(selectFd[index],szBuff,strlen(szBuff));
                if(nRdSocketLen > 0)
                {
                    printf("read data from %s : %s\n",szIP[index],szBuff);
                }
            }
        }
        /* 当有新的客户端连接进来 */
        if(FD_ISSET(nSocketFd,&readfds))
        {
            /** 监听连接，如果有主机要连接过来，则建立套接口连接 */
            socketAddrLen = sizeof(struct sockaddr_in);
            clifd = accept(nSocketFd,(struct sockaddr*)&stClientAddr,&socketAddrLen);
            if(-1 == clifd)
            {
                perror("accept error: ");
                return -1;
            }
            else
            {
                selectFd[selectCount] = clifd;

                /* 把每一个ip地址存放起来*/
                strncpy(szIP[selectCount],inet_ntoa(stClientAddr.sin_addr),20);
                selectCount++;

                printf("commect %s %d successful\n",inet_ntoa(stClientAddr.sin_addr),ntohs(stClientAddr.sin_port));//ntohs(stClientAddr.sin_port)
            }
        }
    }
    close(nSocketFd);

    return 0;
}