#include <stdio.h>
#include <stdlib.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>

#define RECV_MSG_MAX_LENGTH 4096

int main(int argc, char *argv[])
{
    if (argc < 4)
    {
        printf("Please input local_ip, group_ip and group_port.\n");
        return -1;
    }

    int send_sock = socket(AF_INET, SOCK_DGRAM, 0);
    if (send_sock < 0)
    {
        printf("create send_sock error.\n");
        return -1;
    }

    struct sockaddr_in local_addr;
    memset(&local_addr, 0, sizeof(local_addr));
    local_addr.sin_family = AF_INET;
    local_addr.sin_addr.s_addr = inet_addr(argv[1]); // local_ip
    local_addr.sin_port = htons(54321); // 54321为任意值

    if (bind(send_sock, (struct sockaddr *)&local_addr, sizeof(local_addr)) < 0)
    {
        printf("bind error.\n");
        return -1;
    }

    struct sockaddr_in remote_addr;
    memset(&remote_addr, 0, sizeof(remote_addr));

    remote_addr.sin_family = AF_INET;
    remote_addr.sin_addr.s_addr = inet_addr(argv[2]); // group_ip
    remote_addr.sin_port = htons(atoi(argv[3])); // group_port

    int ttl = 64;
    if (setsockopt(send_sock, IPPROTO_IP, IP_MULTICAST_TTL, &ttl, sizeof(ttl)) < 0)
    {
        perror("setsockopt error: ");
        return -1;
    }

    char send_buf[RECV_MSG_MAX_LENGTH] = {0};
    int send_length = 0;

    int send_msg_total_len = 0;

    printf("Ready to send messages.\n");

    while (1)
    {
        scanf("%s", send_buf);

        send_length =
        sendto(send_sock, send_buf, strlen(send_buf), 0, (struct sockaddr *)&remote_addr, sizeof(remote_addr));
        if (send_length < 0)
        {
            return -1;
        }

        send_msg_total_len += send_length;
        printf("Send %d bytes already.\n", send_msg_total_len);
    }

    close(send_sock);
    return 0;
}