#include <stdio.h>
#include <stdlib.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>

#define RECV_MSG_MAX_LENGTH 4096


int main(int argc, char *argv[])
{
    if (argc < 5)
    {
        printf("Please input local_ip, group_ip, group_port and add_src_ip.\n");
        return -1;
    }

    int recv_sock = socket(AF_INET, SOCK_DGRAM, 0);
    if (recv_sock < 0)
    {
        printf("Create recv_sock failed.\n");
        return -1;
    }

    uint32_t on = 1;
    if (setsockopt(recv_sock, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on)) < 0)
    {
        perror("setsockopt error");
        return -1;
    }

    struct sockaddr_in local_addr;
    memset(&local_addr, 0, sizeof(local_addr));
    local_addr.sin_family = AF_INET;
    local_addr.sin_addr.s_addr = inet_addr(argv[2]); // group_ip
    local_addr.sin_port = htons(atoi(argv[3])); // group_port

    if (bind(recv_sock, (struct sockaddr *)&local_addr, sizeof(local_addr)) < 0)
    {
        perror("bind error");
        return -1;
    }

    struct ip_mreq_source mreq_source_add;
    mreq_source_add.imr_multiaddr.s_addr = inet_addr(argv[2]); // group_ip
    mreq_source_add.imr_interface.s_addr = inet_addr(argv[1]); // local_ip
    mreq_source_add.imr_sourceaddr.s_addr = inet_addr(argv[4]); // add_src_ip

    if (setsockopt(recv_sock, IPPROTO_IP, IP_ADD_SOURCE_MEMBERSHIP, &mreq_source_add, sizeof(mreq_source_add)) < 0)
    {
        printf("%s join in group %s error.\n", argv[1], argv[2]);
        return -1;
    }

    printf("%s in group %s add source %s\n", argv[1], argv[2], argv[4]);

    char recv_buf[RECV_MSG_MAX_LENGTH] = {0};
    int recv_length = 0;
    struct sockaddr_in sender_addr_in;
    memset(&sender_addr_in, 0, sizeof(sender_addr_in));
    socklen_t sender_len = sizeof(sender_addr_in);

    printf("Ready to receive messages.\n");

    while (1)
    {
        memset(recv_buf, 0, sizeof(recv_buf));
        recv_length =
        recvfrom(recv_sock, recv_buf, sizeof(recv_buf), 0, (struct sockaddr *)&sender_addr_in, &sender_len);
        if (recv_length < 0)
        {
            return -1;
        }
        printf(
            "receive %d bytes from ip: %s    port: %d\n",
            recv_length,
            inet_ntoa(sender_addr_in.sin_addr),
            ntohs(sender_addr_in.sin_port));

        if (memcmp(recv_buf, "quit", recv_length) == 0)
        {
            printf("Quit success.\n");
            close(recv_sock);
            return 0;
        }
    }

    setsockopt(recv_sock, IPPROTO_IP, IP_DROP_SOURCE_MEMBERSHIP, &mreq_source_add, sizeof(mreq_source_add));

    close(recv_sock);

        return 0;
}