#!/usr/bin/env bash
bdf="05:00.0"
firmware="swift2200n_t1.bin"
delay=1

#Author: Liujihong
#date: 2022-10-19 09:54:11
#last_author: Liujihong (liujh@yusur.tech)
#last_edit_time: 2022-11-9 16:27:59




function ys_pcie_disable_fatal_err(){
    if [[ ! -e "/sys/bus/pci/devices/0000:$bdf" ]]; then
        echo "there is no pci device: $bdf, please check!"
        exit 1
    fi
    bridge=$(basename $(dirname $(readlink "/sys/bus/pci/devices/0000:$bdf")))
    if [ $? -ne 0 ] ;then echo "#ys_pcie_disable_fatal_err running error"; exit 1 ;fi
    if [[ ! -e "/sys/bus/pci/devices/$bridge" ]]; then
        echo "Error: device $bridge not found"
        exit 1
    fi
    cmd=$(setpci -s $bridge COMMAND)
    if [ $? -ne 0 ] ;then echo "#ys_pcie_disable_fatal_err running error"; exit 1 ;fi
    setpci -s $bridge COMMAND=$(printf "%04x" $((0x$cmd & ~0x0100)))
    if [ $? -ne 0 ] ;then echo "#ys_pcie_disable_fatal_err running error"; exit 1 ;fi
    ctrl=$(setpci -s $bridge CAP_EXP+8.w)
    setpci -s $bridge CAP_EXP+8.w=$(printf "%04x" $((0x$ctrl & ~0x0004)))
    if [ $? -ne 0 ] ;then echo "#ys_pcie_disable_fatal_err running error"; exit 1 ;fi
}

function ys_detection_use_driver(){
    fuser -k /dev/instanta_socket > /dev/null 2>&1
    #if [ $? -ne 0 ] ;then echo "#ys_detection_use_driver running error"; exit 1 ;fi
    fuser -k /dev/swiftn* > /dev/null 2>&1
    #if [ $? -ne 0 ] ;then echo "#ys_detection_use_driver running error"; exit 1 ;fi
}

function ys_remove_driver(){
    result=`lsmod | awk '$1 ~ /instanta/'`
    if [[ $result != '' ]]; then
        rmmod instanta
    fi
    if [ $? -ne 0 ];then
        echo "rmmod instanta failed!"
        exit 1
    fi
    result=`lsmod | awk '$1 ~ /swiftn/'`
    if [[ $result != '' ]]; then
        rmmod swiftn
    fi
    if [ $? -ne 0 ];then
        echo "rmmod swiftn failed!"
        exit 1
    fi
}

function ys_pcie_close(){
    echo 1 > /sys/bus/pci/devices/0000:$bdf/remove
    if [ $? -ne 0 ] ;then echo "#ys_pcie_close running error" ; exit 1 ;fi
}

function ys_program_firmware(){
    yusur_ctl update -b $bdf -p -f $firmware
    if [ $? -ne 0 ] ;then echo "#ys_program_firmware running error" ; exit 1 ;fi
}

function ys_active_firmware(){
    yusur_ctl update -b $bdf -a$delay
    if [ $? -ne 0 ] ;then echo "#ys_active_firmware running error" ; exit 1 ;fi
}



argc=$#
if [[ argc -lt 2 ]];then
	echo "e.g. :python3 $0 01:00.0 swift2200n_t0.bin" 
	echo "e.g. :python3 $0 01:00.0 swift2200n_t1.bin 1\n"
	exit -1
fi

bdf=$1
firmware=$2
if [[ argc -eq 3 ]];then
	delay=$3
fi

ys_program_firmware $bdf $firmware
echo "start active new firmware...\n"
ys_pcie_disable_fatal_err $bdf
#关闭使用驱动的用户态进程
ys_detection_use_driver

#时延的设置目的是为了启动加载时，pcie已经close了。
ys_active_firmware $bdf $delay
#卸载驱动
ys_remove_driver
ys_pcie_close $bdf

#确保reboot时，fpga已经加载完成
let delay+=5
sleep $delay
echo "update success, restart system to active new hardware package, reboot...\n"
reboot
