#!/usr/bin/env bash
### Change to script directory


cat /etc/os-release | grep "^NAME" | grep -E 'Kylin|CentOS|Ubuntu'
if [ $? -ne 0 ];then
	echo "Just only support Kylin/CentOS/Ubuntu now!"
	exit -1;
fi
Ubuntu=0
cat /etc/os-release | grep "^NAME" | grep 'Ubuntu'
if [ $? -eq 0 ];then
	Ubuntu=1
fi


#drv_dir=lib/modules/$(uname -r)/kernel/drivers/net/ethernet/yusur
#initram_file=initramfs-$(uname -r).img

if [ $Ubuntu -eq 1 ];then
	whereis lsinitramfs | grep  '/lsinitramfs'
	if [ $? -ne 0 ];then
	echo "Need lsinitramfs but can not find lsinitramfs, plese install it frist"
	exit -1
	fi
else
	whereis lsinitrd | grep  '/lsinitrd'
	if [ $? -ne 0 ];then
		echo "Need lsinitrd but can not find lsinitrd, plese install it frist"
		exit -1
	fi
fi
whereis dracut | grep  '/dracut'
if [ $? -ne 0 ];then
	echo "Need dracut but can not find dracut, plese install it frist"
	exit -1
fi

if [ $Ubuntu -eq 1 ];then
	whereis update-grub | grep  '/update-grub'
	if [ $? -ne 0 ];then
	echo "Need update-grub but can not find update-grub, plese install it frist"
	exit -1
	fi
else
	whereis grub2-mkconfig | grep  '/grub2-mkconfig'
	if [ $? -ne 0 ];then
		echo "Need grub2-mkconfig but can not find grub2-mkconfig, plese install it frist"
		exit -1
	fi
fi

if [ $Ubuntu -eq 1 ];then
	lsinitramfs -l /boot/initrd.img-$(uname -r) | grep yusnic
	if [ $? -eq 0 ];then
		echo "driver has been integrated to initramfs, update initramfs ..."
	fi
else
	lsinitrd /boot/initramfs-$(uname -r).img | grep yusnic
	if [ $? -eq 0 ];then
		echo "driver has been integrated to initramfs, update initramfs ..."
	fi
fi
sleep 1

echo "update initramfs ..."
dracut --omit-drivers yusnic --force
dracut --omit-drivers swiftn --force
dracut --omit-drivers yusur_sock --force
dracut --omit-drivers instanta --force
#dracut --add-drivers ./yusnic.ko --force
if [ -d "/etc/dracut.conf.d/" ];then
	echo 'omit_drivers+=" yusnic yusur_sock swiftn instanta "' > /etc/dracut.conf.d/yusur.conf
fi

echo "update grub ..."
cat /etc/os-release | grep "^NAME" | grep  'Kylin'
if [ $? -eq 0 ];then
	grub2-mkconfig -o /boot/efi/EFI/kylin/grub.cfg
fi

cat /etc/os-release | grep "^NAME" | grep  'CentOS'
if [ $? -eq 0 ];then
	grub2-mkconfig -o /boot/efi/EFI/centos/grub.cfg
fi

cat /etc/os-release | grep "^NAME" | grep  'Ubuntu'
if [ $? -eq 0 ];then
	mv -f /boot/initramfs-$(uname -r).img /boot/initrd.img-$(uname -r) 
	update-grub
fi

echo "update initramfs successfully!"


