#!/usr/bin/env bash


if [ $UID -ne 0 ];
then
    echo "permition denied, please check and use root to operate."
    exit -1
fi

# 卸载旧版本文件
if [ -d "/usr/local/yusur/" ];
then
    echo "uninstall old version"
    rm -rf /usr/local/yusur/
fi

# 卸载驱动
result=`lsmod | awk '$1 ~ /yusur_sock/'`
if [[ $result != '' ]]; then
    rmmod yusur_sock
fi
result=`lsmod | awk '$1 ~ /instanta/'`
if [[ $result != '' ]]; then
    rmmod instanta
fi

result=`lsmod | awk '$1 ~ /yusnic/'`
if [[ $result != '' ]]; then
    rmmod yusnic
fi
result=`lsmod | awk '$1 ~ /swiftn/'`
if [[ $result != '' ]]; then
    rmmod swiftn
fi
if [ $? -ne 0 ];then
    modprobe instanta
    exit -1
fi
echo "Uninstall instanta module successfully!"

# install directory
rm -f /usr/local/bin/instanta*
rm -f /usr/local/bin/yusur*
rm -f /usr/local/bin/yusnic*
rm -f /usr/lib/libinstanta*
rm -rf /usr/local/include/yusur_socket/
rm -rf /usr/local/include/instanta_layer2vi/
ldconfig > /dev/null 2>&1
echo "Uninstall instanta socket SDK successfully!"

# 删除日志定时清理crontab任务
crontab -l > instanta_crontab > /dev/null 2>&1
install_persistent_bonding="@reboot instanta_bonding_persist.sh"
env_path="PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/bin"
sed -i '/instanta_del_expired_logs.sh/d' instanta_crontab
sed -i '/$env_path/d' instanta_crontab
sed -i '/$install_persistent_bonding/d' instanta_crontab

crontab instanta_crontab
rm -rf instanta_crontab

# 取消开机自动加载驱动
dst_dir=/lib/modules/$(uname -r)/kernel/drivers/net/ethernet/yusur
rm -rf ${dst_dir}
echo "The automatic driver loading function is disabled successfully!"
