# coding=utf-8
'''
Author: Mazhiwei
date: 2022-10-19 09:54:11
last_author: Mazhiwei (mazhw@yusur.tech)
last_edit_time: 2022-10-19 11:27:59
'''
import sys
import os
import time

bdf = "05:00.0"
firmware = "swift2200n_t1.bin"
delay = 1
def ys_pcie_disable_fatal_err(bdf):
    pci_file = "/sys/bus/pci/devices/%s" % (bdf) 
    ret = os.access(pci_file, os.F_OK)
    if not ret:
        print("there is no pci device: %s, please check!\n" % (bdf))
        return -1
    real_file = os.readlink(pci_file)
    file_dir = os.path.dirname(real_file)
    bridge = os.path.basename(file_dir)
    if -1 != bridge[5:7].rfind("00"):
        pfile = os.popen("setpci -s %s COMMAND" % (bdf))
        result = pfile.readline()
        cmd_word = int(result,16)
        cmd_word &= (~0x0100)
        pfile.close()
        os.system("setpci -s %s COMMAND=%04x" % (bdf, cmd_word))
    pfile = os.popen("setpci -s %s CAP_EXP+8.W" % (bdf))
    result = pfile.readline()
    cmd_word = int(result,16)
    cmd_word &= (~0x0004)
    os.system("setpci -s %s CAP_EXP+8.w=%04x" % (bdf, cmd_word))

def ys_detection_use_driver():
    os.system("fuser -k /dev/instanta_socket > /dev/null 2>&1")
    os.system("fuser -k /dev/swiftn* > /dev/null 2>&1")

def ys_remove_driver():
    pfile = os.popen("lsmod | awk '$1 ~ /instanta/'")
    result = pfile.readline()
    if result != "":
        ret = os.system("rmmod instanta")
        if ret:
            print("rmmod instanta failed!")
            exit(-1)

    pfile = os.popen("lsmod | awk '$1 ~ /swiftn/'")
    result = pfile.readline()
    if result != "":
        ret = os.system("rmmod swiftn")
        if ret:
            print("rmmod swiftn failed!")
            exit(-1)

def ys_pcie_close(bdf):
    os.system("echo 1 > /sys/bus/pci/devices/%s/remove" % (bdf))

def ys_program_firmware(bdf, firmware):
    os.system("yusur_ctl update -b {} -p -f {}".format(bdf, firmware))

def ys_active_firmware(bdf, delay):
    os.system("yusur_ctl update -b {} -a{}".format(bdf, delay))

if __name__ == '__main__':
    argc = len(sys.argv)
    if argc < 3:
        print("e.g. :python3 %s 0000:01:00.0 swift2200n_t0.bin" % sys.argv[0])
        print("e.g. :python3 %s 0000:01:00.0 swift2200n_t1.bin 1" % sys.argv[0])
        exit(-1)
    bdf = sys.argv[1]
    firmware = sys.argv[2]
    if argc == 4:
        delay = int(sys.argv[3])

    ys_program_firmware(bdf, firmware)
    print("start active new firmware...")
    ys_pcie_disable_fatal_err(bdf)
    #关闭使用驱动的用户态进程
    ys_detection_use_driver()
    #时延的设置目的是为了启动加载时，pcie已经close了。
    ys_active_firmware(bdf, delay)
    #卸载驱动
    ys_remove_driver()
    ys_pcie_close(bdf)
#确保reboot时，fpga已经加载完成
    time.sleep(5+delay)
    print("update success, restart system to active new hardware package, reboot...");
    os.system("reboot")
