#!/usr/bin/env bash
### Change to script directory
cd `dirname $0`

BINDIR=tools/bin

# install directory
inst_dir=/usr/local/bin

# 日志存放目录
log_dir=/home/instanta

# 使lspci显示Yusur的信息
function update_pciid(){
    #ubuntu
    if [ -e /usr/share/misc/pci.ids ]; then
	pciid_file=/usr/share/misc/pci.ids
    else
	pciid_file=/usr/share/hwdata/pci.ids
    fi

    cat $pciid_file | grep "^C 02  Network controller" > /dev/null
    if [ $? -ne 0 ];then
        echo "C 02  Network controller" >> $pciid_file
        echo -e "\t00  Ethernet controller" >> $pciid_file
    fi

    sed -i '/Yusur Corporation/d' $pciid_file
    if [ $? -ne 0 ];then
	return 0
    fi
    sed -i '/SWIFT-2200NX10 Ethernet Controller/d' $pciid_file

    echo "1f47  Yusur Corporation" >> $pciid_file
    echo -e "\t2018  SWIFT-2200NX10 Ethernet Controller" >> $pciid_file
    echo "Update pciid file successfully!"
}

function update_hwdb(){
    hwdb_file=/usr/lib/udev/hwdb.d/20-pci-vendor-model.hwdb;

    cat $hwdb_file | grep "pci:v00001F47*" > /dev/null
    if [ $? -eq 0 ];then
        return 0
    fi

    if [ !command -v systemd-hwdb>/dev/null 2>&1 ];then
        return 0
    fi
    if [ !command -v udevadm >/dev/null 2>&1 ];then
        return 0
    fi

    echo "" >> $hwdb_file
    echo "pci:v00001F47*" >> $hwdb_file
    echo " ID_VENDOR_FROM_DATABASE=Yusur Corporation" >> $hwdb_file
    echo "" >> $hwdb_file
    echo "pci:v00001F47d00002018*" >> $hwdb_file
    echo " ID_MODEL_FROM_DATABASE=SWIFT-2200NX10 Ethernet Controller" >> $hwdb_file

    systemd-hwdb update > /dev/null 2>&1
    if [ $? -ne 0 ];then
    return 0
    fi
    udevadm trigger > /dev/null 2>&1
    if [ $? -ne 0 ];then
    return 0
    fi

    echo "Update hwdb file successfully!"
}

check_result=`lsmod | awk '{print $1}' | sed -n '/instanta/p'`
if [ "$check_result" == "instanta" ]
then
    rmmod instanta
    if [ $? -ne 0 ];then
        exit -1
    fi
fi

check_result=`lsmod | awk '{print $1}' | sed -n '/swiftn/p'`
if [ "$check_result" == "swiftn" ]
then
    rmmod swiftn
    if [ $? -ne 0 ];then
        modprobe instanta
        exit -1
    fi
fi

update_pciid
update_hwdb

# 创建log目录
if [ ! -d "$log_dir" ]; then
    mkdir $log_dir
fi
# 1代表't'权限，控制目录下创建的文件无法被除root外的其他用户删除
chmod 1777 $log_dir

if [ ! -d "$inst_dir" ]; then
    mkdir $inst_dir
fi

# install SDK
chmod +x ${BINDIR}/*
cp ${BINDIR}/* $inst_dir > /dev/null 2>&1
if [ $? -ne 0 ];then
    echo "Can not install SDK to '$inst_dir'!"
    rm -f $inst_dir/instanta*
    rm -f $inst_dir/yusur*
    exit -1
fi
chmod 755 $inst_dir/instanta*
chmod 755 $inst_dir/yusur*
echo "Install instanta socket SDK to '$inst_dir' successfully!"

cp -rf include/yusur_socket/ /usr/local/include/ > /dev/null 2>&1
cp -rf include/instanta_layer2vi/ /usr/local/include/ > /dev/null 2>&1

cp NOE_SDK/lib/libinstanta.so /usr/lib > /dev/null 2>&1
if [ $? -ne 0 ];then
    echo "Can not install SDK to '/usr/lib'!"
    rm -f /usr/lib/libinstanta*
    rm -f $inst_dir/instanta*
    rm -f $inst_dir/yusur*
    exit -1
fi

cp NOE_SDK/lib/libinstanta.a /usr/lib > /dev/null 2>&1
if [ $? -ne 0 ];then
    echo "Can not install SDK to '/usr/lib'!"
    rm -f /usr/lib/libinstanta*
    rm -f $inst_dir/instanta*
    rm -f $inst_dir/yusur*
    exit -1
fi

chmod 755 /usr/lib/libinstanta.so
ldconfig > /dev/null 2>&1
echo "Use instanta socket SDK: Add 'LD_PRELOAD=libinstanta.so' before exec command!"

# 添加日志定时清理crontab任务
install_persistent_bonding="@reboot instanta_bonding_persist.sh"
env_path="PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/bin"
crontab -l > instanta_crontab > /dev/null 2>&1
sed -i '/instanta_del_expired_logs.sh/d' instanta_crontab
sed -i '/$env_path/d' instanta_crontab
sed -i '/$install_persistent_bonding/d' instanta_crontab

echo "$env_path" >> instanta_crontab
echo "0 */4 * * * $inst_dir/instanta_del_expired_logs.sh > /dev/null 2>&1" >> instanta_crontab
echo "$install_persistent_bonding" >> instanta_crontab
crontab instanta_crontab
rm -rf instanta_crontab

# 开机自动加载驱动
drv_dir=kernel_driver/linux-$(uname -r)
dst_dir=/lib/modules/$(uname -r)/kernel/drivers/net/ethernet/yusur

if [ -d "$dst_dir" ]; then
    rm -rf ${dst_dir}
fi
mkdir ${dst_dir}
cp ${drv_dir}/*.ko ${dst_dir} > /dev/null 2>&1
if [ $? -ne 0 ];then
    echo "Can not add drivers to '$dst_dir'!"
    rm -rf $dst_dir
    rm -f /usr/lib/libinstanta*
    rm -f $inst_dir/instanta*
    rm -f $inst_dir/yusur*
    ldconfig > /dev/null 2>&1
    exit -1
fi
cd ${dst_dir};depmod -a
cd ${dst_dir};modprobe instanta
if [ $? -ne 0 ];then
    echo -e "\033[31mError!!! Can not load instanta driver!\033[0m"
    rm -rf $dst_dir
    rm -f /usr/lib/libinstanta*
    rm -f $inst_dir/instanta*
    rm -f $inst_dir/yusur*
    ldconfig > /dev/null 2>&1
    exit -1
fi

echo "Loading the instanta driver successfully!"
