#!/bin/bash
#******************************************************************************
# Copyright (C), 2015-2020, Huawei Tech. Co., Ltd.
# File : install.sh
# 1.check firmware version
# 2.upgrade firmware version
#
#  History       :
#  1.Date        : 2015/10/15
#    Modification: Created file
#******************************************************************************

#get work path
path=$(dirname "$0")
path="${path/\./$(pwd)}"
pwd="${path}"

cd "${pwd}"
#init 
rm "${pwd}/result.xml" 2>/dev/null
rm "${pwd}/work.log" 2>/dev/null
tool_type=""
dev_num=0
flag_fail=0

#column for result.xml
result=""
error_code=""
description=""

#create result.xml for esight
create_result_xml(){	
	echo "<?xml version=\"1.0\" encoding=\"utf-8\"?>" >"${pwd}/result.xml"
	echo "<ConfigureResult>" >>"${pwd}/result.xml"
	echo "    <FwUpgrade>" >>"${pwd}/result.xml"
	echo "        <Result>${result}</Result>" >>"${pwd}/result.xml"
	echo "        <error_code>"${error_code}"</error_code>" >>"${pwd}/result.xml"
	echo "        <Description>${description}</Description>" >>"${pwd}/result.xml"
	echo "    </FwUpgrade>" >>"${pwd}/result.xml"
	echo "</ConfigureResult>" >>"${pwd}/result.xml"
}

#read version xml
read_version_xml(){
	if [ ! -f "${pwd}/version.xml" ]
	then
		#version xml not found
		result="Fail"
		error_code="5"
		description="Version xml not found"
		create_result_xml
		exit 5
	fi

	#get device info
	fw_file=$(cat "${pwd}/version.xml" |grep -i "<FileName>"|awk 'BEGIN{FS=">"}{print $2}'|awk 'BEGIN{FS="<"}{print $1}')
	cfg_fw_version=$(cat "${pwd}/version.xml" |grep -i "<Version>"|awk 'BEGIN{FS=">"}{print $2}'|awk 'BEGIN{FS="<"}{print $1}')
	cfg_devices=$(cat "${pwd}/version.xml" |grep -i "<SupportModel>"|awk 'BEGIN{FS=">"}{print $2}'|awk 'BEGIN{FS="<"}{print $1}' |sed 's/;/ /g')
	upgrade_devices=$(cat "${pwd}/version.xml" |grep -i "<SupportModelUID>"|awk 'BEGIN{FS=">"}{print $2}'|awk 'BEGIN{FS="<"}{print $1}' |sed 's/;/ /g')
    
	for device in ${cfg_devices}
	do
		case "${device}" in
			SP570|SP580|SP572|SP582)
				tool_type="Hi1822"
			;;
			SP520|SP521|SP522|SP523|SP525|SP526)
				tool_type="Hi1822FC"
			;;
			MX510)
				tool_type="Qlogic"
			;;
            MZ520|MZ522)
                tool_type="Qlogic_Huawei"
            ;;
			MZ910|MZ912|MZ220)
				tool_type="EmulexLancer"
			;;
			MZ510|MZ512)
				tool_type="EmulexBE3"
			;;		
			*)
				echo "${device}" |grep -i "QLE" >/dev/null
				if [ $? == 0 ]
				then
					tool_type="Qlogic"
				fi
				
				echo "${device}" |grep -i "LPe" >/dev/null
				if [ $? == 0 ]
				then
					tool_type="EmulexLancer"
				fi
				
				echo "${device}" |grep -i "OCE" >/dev/null
				if [ $? == 0 ]
				then
					tool_type="EmulexBE3"
				fi
			;;
		esac
	done
	
	if [ ""${tool_type}"" == "" ]
	then
		#unsupport device type
		result="Fail"
		error_code="7"
		description="Unsupport device type"
		create_result_xml
		exit 7;
	fi
}

#install tools
prepare_tools(){
	local tool_flag=0
	if [ -d "${pwd}/drivers/" ]
	then
	    cd "${pwd}/drivers/"
		cat /etc/*-release | grep -i "EulerOS 2.0 (SP9)" >/dev/null 2>&1
		if [ $? -eq 0 ]
		then
			insmod ./hifc_sdk.ko >>"${pwd}/work.log" 2>/dev/null
			insmod ./hifc.ko >>"${pwd}/work.log" 2>/dev/null
		fi
		cat /etc/*-release | grep -i "EulerOS 2.0 (SP8)" >/dev/null 2>&1
		if [ $? -eq 0 ]
		then
			rpm -ivh --ignoresize ./centos7-8_4.19.36_1906.1.0.h288/*.rpm >>"${pwd}/work.log" 2>/dev/null
		fi
	fi
	
	


	
	# load qla2xxx
	echo ${cfg_devices} | grep -i -E "QLE2692|QLE2690" >/dev/null 2>&1
	if [ $? -eq 0 ]
	then	
		rmmod -f qla2xxx >/dev/null 2>&1
		depmod
		modprobe qla2xxx
	fi
    
 

    # load hinic
	echo ${cfg_devices} | grep -i -E "SP570|SP580" >/dev/null 2>&1
	if [ $? -eq 0 ]
	then	
			rmmod -f hinic >/dev/null 2>&1
			depmod
			modprobe hinic

    fi

    if [ -d "${pwd}/tools/" ]
    then 
        cd "${pwd}/tools/"
        case "${tool_type}" in
			 Hi1822)
				if [ -f ./hinicadm*.rpm ]
                then
                    rpm -ivh --ignoresize ./hinicadm*.rpm >>"${pwd}/work.log" 2>/dev/null
                else
                    tool_flag=1
                    
                fi
            ;;
			Hi1822FC)
				if [ -f ./hifcadm*.rpm ]
                then
                    rpm -ivh --ignoresize ./hifcadm*.rpm >>"${pwd}/work.log" 2>/dev/null
					modprobe hifc
                else
                    tool_flag=1
                fi
            ;;
            EmulexLancer|EmulexBE3)
                hbacmd >>"${pwd}/work.log" 2>/dev/null
                if [ $? == 127 ]
                then
                    if [ -f ./elxocmcore*.rpm ] && [ -f ./elxocmlibhbaapi*.rpm ]
                    then                     
                        rpm -ivh --ignoresize ./elxocmlibhbaapi*.rpm >>"${pwd}/work.log" 2>/dev/null
                        rpm -ivh --ignoresize ./elxocmcore*.rpm >>"${pwd}/work.log" 2>/dev/null
                    else
                        tool_flag=1
                    fi	
                    /etc/init.d/elxhbamgrd start >>"${pwd}/work.log" 2>/dev/null
                    /etc/init.d/elxmilid start >>"${pwd}/work.log" 2>/dev/null
                    /etc/init.d/elxsnmpd start >>"${pwd}/work.log" 2>/dev/null
                    sleep 1
                fi
            ;;
            Qlogic)
                /opt/QLogic_Corporation/QConvergeConsoleCLI/qaucli -h >>"${pwd}/work.log" 2>/dev/null
                if [ $? == 127 ]
                then
                    if [ -f ./QConvergeConsoleCLI*.rpm ]
                    then
                        rpm -ivh --ignoresize ./QConvergeConsoleCLI*.rpm >>"${pwd}/work.log" 2>/dev/null
                    else
                        tool_flag=1
                    fi
                fi
            ;;
            Qlogic_Huawei)
                if [ -f ./load.sh ]
                then
                    chmod +x *
                    cp -fr * ../
                else
                    tool_flag=1
                fi
            ;;
            *)
            ;;
        esac
    else
        tool_flag=1
    fi
	
	cd "${pwd}/"
	if [ "${tool_flag}" == 1 ]
	then
		#prepare tools failed
		result="Fail"
		error_code="6"
		description="Prepare tools failed"
		create_result_xml
		exit 6;
	fi
}

#get device info by tools
get_device_info(){
	case "${tool_type}" in
		EmulexLancer|EmulexBE3)
			get_device_emulex
		;;
		Qlogic)
			get_device_qlogic
		;;
        Qlogic_Huawei)
			get_device_qlogic_hw
		;;
		Hi1822)
			get_device_hi1822
		;;
		Hi1822FC)
			get_device_hi1822fc
		;;
		*)
		;;
	esac
	
	#no device found in version.xml
	if [ "${dev_num}" == 0 ]
	then
		result="Fail"
		error_code="4"
		description="No available device found"
		create_result_xml
		exit 4;
	fi
}

#get device of Emulex
get_device_emulex(){
	hbacmd listhbas > tmp_Emulex.txt 2>/dev/null		
	num_hbas=$(cat tmp_Emulex.txt | egrep -i "Port WWN|Current MAC" |wc -l)	
	
	#set base info
	for ((i=1;i<=num_hbas;i++))
	do
		device_index[$dev_num]=$(cat tmp_Emulex.txt | egrep -i "Port WWN|Current MAC" |sed -n ''$i'p' | awk '{print $4}')		
		hbacmd hbaAttributes "${device_index[$dev_num]}" >tmp_attributes.txt
	
		#get base info
		vendor_id=$(cat tmp_attributes.txt |grep -i "Vendor Spec ID" |awk '{print $5}')
		device_id=$(cat tmp_attributes.txt |grep -i "Device ID" |awk '{print $4}')
		sub_vid=$(cat tmp_attributes.txt |grep -i "Sub Vendor ID" |awk '{print $5}')
		sub_did=$(cat tmp_attributes.txt |grep -i "Sub Device ID" |awk '{print $5}')
		
		#check device
		cat version.xml |grep -i "${vendor_id}" |grep -i "${device_id}" |grep -i "${sub_vid}" |grep -i "${sub_did}" >/dev/null
		if [ $? != 0 ]
		then	
			rm tmp_attributes.txt 2>/dev/null
			continue
		fi	
		
		#get BDF info
		bus_num[$dev_num]=$(cat tmp_attributes.txt |grep -i "PCI Bus Number" |awk 'BEGIN{FS=" "}{print $5}')		
		function_num[$dev_num]=$(cat tmp_attributes.txt |grep -i "PCI Func Number"  |awk 'BEGIN{FS=" "}{print $5}')
		cat tmp_Emulex.txt | egrep -i "Port WWN|Current MAC" |sed -n ''$i'p' |grep -i "Port WWN" >/dev/null
		if [ $? == 0 ]
		then
			device_num[$dev_num]=$(cat tmp_attributes.txt |grep -i "Number of Ports" |awk 'BEGIN{FS=" "}{print $5}')
		else
			device_num[$dev_num]=$(cat tmp_attributes.txt |grep -i "Port Number" |awk 'BEGIN{FS=" "}{print $4}')
		fi
		rm tmp_attributes.txt 2>/dev/null	
		
		#init BDF flag
		bdf_select[$dev_num]=0		
		let dev_num=$dev_num+1
	done	
	
	rm tmp_Emulex.txt 2>/dev/null
}

#get device of Qlogic
get_device_qlogic(){
	/opt/QLogic_Corporation/QConvergeConsoleCLI/qaucli -i | grep -i "Port Name" >>tmp_Qlogic.txt 2>/dev/null
	num_qlogic=$(cat tmp_Qlogic.txt |wc -l)
			
	#set base
	for ((i=1;i<=num_qlogic;i++))
	do
		device_index[$dev_num]=$(cat tmp_Qlogic.txt |sed -n ''$i'p' | awk '{print $4}')		
		/opt/QLogic_Corporation/QConvergeConsoleCLI/qaucli -i ${device_index[$dev_num]} >tmp_info.txt 2>/dev/null
		
		#get base info
		device_id=$(cat tmp_info.txt |grep -i "PCI Device ID" |awk '{print $5}')
		sub_vid=$(cat tmp_info.txt |grep -i "Subsystem Vendor ID" |awk '{print $5}')
		sub_did=$(cat tmp_info.txt |grep -i "Subsystem Device ID" |awk '{print $5}')		
		
		#check device
		cat version.xml |grep -i "${device_id}" |grep -i "${sub_vid}" |grep -i "${sub_did}" >/dev/null
		if [ $? != 0 ]
		then	
			continue
		fi
		
		bus_num[$dev_num]=$(cat tmp_info.txt |grep -i "PCI Bus Number" |awk 'BEGIN{FS=" "}{print $5}')
		device_num[$dev_num]=$(cat tmp_info.txt |grep -i "PCI Device Number" |awk 'BEGIN{FS=" "}{print $5}')
		function_num[$dev_num]=$(cat tmp_info.txt |grep -i "PCI Function Number"  |awk 'BEGIN{FS=" "}{print $5}')
		cur_fw[$dev_num]=$(cat tmp_info.txt |grep -i "Flash Firmware version" |awk 'BEGIN{FS=" "}{print $5}')
		rm tmp_info.txt 2>/dev/null
		
		#init BDF flag
		bdf_select[$dev_num]=0		
		let dev_num=$dev_num+1		
	done	
	rm tmp_info.txt 2>/dev/null
	rm tmp_Qlogic.txt 2>/dev/null
}

#get device of Huawei-developed Qlogic 
get_device_qlogic_hw(){
    cd "${pwd}"
    num_qlo_hw=$(lspci|grep -i 57810|wc -l)
    for ((i=1;i<=num_qlo_hw;i++))
	do
        if [ -f tmp_qlo_hw.txt ]
        then
            rm -fr tmp_qlo_hw.txt
        fi
        ##Create display script  
        echo "./load.sh -b10eng << EOF" > fw_display.sh
        echo "device $i" >> fw_display.sh;
        echo "nvm cfg -dump tmp_qlo_hw.txt" >> fw_display.sh
        echo "exit" >> fw_display.sh
        
        ##display info
        chmod +x fw_display.sh
        sh fw_display.sh > /dev/null 2>&1
        
        device_index[$dev_num]="${i}"
        
        #get base info
		device_id=$(cat tmp_qlo_hw.txt |grep -i "Vendor Device ID"|grep -v -i "MF" |awk '{print $NF}')
        dendor_id=$(cat tmp_qlo_hw.txt |grep -i "Vendor ID"|grep -v -i "sub" |awk '{print $NF}')
		sub_vid=$(cat tmp_qlo_hw.txt |grep -i "Subsystem Vendor ID" |awk '{print $NF}')
		sub_did=$(cat tmp_qlo_hw.txt |grep -i "Subsystem Device ID" |awk '{print $NF}')		
		
		#check device
		cat version.xml |grep -i "${device_id}" |grep -i "${dendor_id}" |grep -i "${sub_vid}" |grep -i "${sub_did}" >/dev/null
		if [ $? != 0 ]
		then
			continue
		fi
        
        #init BDF flag
		bdf_select[$dev_num]=0		
		let dev_num=$dev_num+1
	done	
    
    rm fw_display.sh > /dev/null 2>&1

}


#get device of Hi1822
get_device_hi1822(){
	hinicadm info  >tmp_Hi1822.txt
	num_hi1822_fw=$(cat tmp_Hi1822.txt|grep -i hinic*|wc -l)
	local num_index=0
	local fw_dev=0
	for ((i=1;i<=num_hi1822_fw;i++))
	do
		device_index[$dev_num]=$(cat tmp_Hi1822.txt|grep -i hinic*|sed -n ''$i'p'|awk -F"-" '{print $5}'|awk -F"(" '{print $1}')
		bus_num_tmp=$(cat tmp_Hi1822.txt |grep -i ${device_index[$dev_num]} -A 1|sed -n ''2'p' |awk -F"-" '{print $9}'|awk -F"(" '{print $1}')
		
		#get base info
		lspci -s "${bus_num_tmp}" -xx >base_info_Hi1822.txt
		vendor_id=$(sed -n '2p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $3}')$(sed -n '2p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $2}') >base_1822.txt
		device_id=$(sed -n '2p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $5}')$(sed -n '2p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $4}') >>base_1822.txt
		sub_vid=$(sed -n '4p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $15}')$(sed -n '4p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $14}') >>base_1822.txt
		sub_did=$(sed -n '4p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $17}')$(sed -n '4p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $16}') >>base_1822.txt
		
		#check device
		cat version.xml |grep -i "${vendor_id}" |grep -i "${device_id}" |grep -i "${sub_vid}" |grep -i "${sub_did}" >/dev/null
		if [ $? != 0 ]
		then	
			continue
		else
			let num_index=$num_index+1
		fi
			
		hinicadm version -i ${device_index[$dev_num]} >cur_version.txt
		cur_fw="$(cat cur_version.txt |grep -i 'up' |awk 'BEGIN{FS=" "}{print $2}')"	
		fw_version=$(cat "${pwd}/version.xml" |grep -i "<Version>"|awk 'BEGIN{FS=">"}{print $2}'|awk 'BEGIN{FS="<"}{print $1}')	
		if [ "${cur_fw}" == "${fw_version}" ]
		then
			let fw_dev=$fw_dev+1
			continue
		fi			
		bus_num[$dev_num]=$(cat tmp_Hi1822.txt |grep -i ${device_index[$dev_num]}|awk -F"-" '{print $5}') >>base_1822.txt
		function_num[$dev_num]=$(cat tmp_Hi1822.txt |grep -i ${device_index[$dev_num]} -A 1|awk -F":" '{print $2}'|awk -F"(" '{print $1}') >>base_1822.txt
		
		rm base_info_Hi1822.txt 2>/dev/null
		rm base_1822.txt 2>/dev/null
		#init BDF flag
		bdf_select[$dev_num]=0		
		let dev_num=$dev_num+1
		rm cur_version.txt 2>/dev/null
	done
	rm tmp_Hi1822.txt 2>/dev/null
	if [ "${fw_dev}" -eq "${num_index}" ] && [ "${num_index}" != 0 ]
	then
		#already upgrade
		result="OK"
		error_code="0"
		description="already upgrade"
		create_result_xml
		exit 0;
	fi
}

#get device of Hi1822FC
get_device_hi1822fc(){
	hifcadm info  >tmp_Hi1822.txt
	num_hi1822_fw=$(cat tmp_Hi1822.txt|grep -i hifc*|wc -l)
	local num_index=0
	local fw_dev=0
	for ((i=1;i<=num_hi1822_fw;i++))
	do
		device_index[$dev_num]=$(cat tmp_Hi1822.txt|grep -i hifc*|sed -n ''$i'p'|awk -F"-" '{print $5}'|awk -F"(" '{print $1}')
		bus_num_tmp=$(cat tmp_Hi1822.txt |grep -i ${device_index[$dev_num]} -A 1|sed -n ''2'p' |awk -F"-" '{print $9}'|awk -F"(" '{print $1}')
		
		#get base info
		lspci -s "${bus_num_tmp}" -xx >base_info_Hi1822.txt
		vendor_id=$(sed -n '2p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $3}')$(sed -n '2p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $2}') >base_1822.txt
		device_id=$(sed -n '2p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $5}')$(sed -n '2p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $4}') >>base_1822.txt
		sub_vid=$(sed -n '4p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $15}')$(sed -n '4p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $14}') >>base_1822.txt
		sub_did=$(sed -n '4p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $17}')$(sed -n '4p' base_info_Hi1822.txt |awk 'BEGIN{FS=" "}{print $16}') >>base_1822.txt
		
		#check device
		cat version.xml |grep -i "${vendor_id}" |grep -i "${device_id}" |grep -i "${sub_vid}" |grep -i "${sub_did}" >/dev/null
		if [ $? != 0 ]
		then	
			continue
		else
			let num_index=$num_index+1
		fi
			
		hifcadm version -i ${device_index[$dev_num]} >cur_version.txt
		cur_fw="$(cat cur_version.txt |grep -i 'up' |awk 'BEGIN{FS=" "}{print $2}')"	
		fw_version=$(cat "${pwd}/version.xml" |grep -i "<Version>"|awk 'BEGIN{FS=">"}{print $2}'|awk 'BEGIN{FS="<"}{print $1}')	
		if [ "${cur_fw}" == "${fw_version}" ]
		then
			let fw_dev=$fw_dev+1
			continue
		fi			
		bus_num[$dev_num]=$(cat tmp_Hi1822.txt |grep -i ${device_index[$dev_num]}|awk -F"-" '{print $5}') >>base_1822.txt
		function_num[$dev_num]=$(cat tmp_Hi1822.txt |grep -i ${device_index[$dev_num]} -A 1|awk -F":" '{print $2}'|awk -F"(" '{print $1}') >>base_1822.txt
		
		rm base_info_Hi1822.txt 2>/dev/null
		rm base_1822.txt 2>/dev/null
		#init BDF flag
		bdf_select[$dev_num]=0		
		let dev_num=$dev_num+1
		rm cur_version.txt 2>/dev/null
	done
	rm tmp_Hi1822.txt 2>/dev/null
	if [ "${fw_dev}" -eq "${num_index}" ] && [ "${num_index}" != 0 ]
	then
		#already upgrade
		result="OK"
		error_code="0"
		description="already upgrade"
		create_result_xml
		exit 0;
	fi
}




#upgrade firmware
upgrade_firmware(){
	
	#upgrade in loop
	for ((i=0;i<"${dev_num}";i++))
	do
		index=$i
		
		#this device is not in select BDFs
		if [ "${bdf_select[$index]}" != 0 ]
		then
			continue
		fi

		upgrade_by_tools	
	done
	
	if [ "${flag_fail}" == 1 ]
	then
		#upgrade Failed
		result="Fail"
		error_code="1"
		description="Upgrade failed"
		create_result_xml
		exit 1;
	else
		#upgrade Success
		result="OK"
		error_code="NA"
		description="NA"
		create_result_xml
		exit 0;
	fi
}

#filter devices by BDF
filter_by_bdf(){	
	flag_filter=0
	
	case "${tool_type}" in
		*)
			#check BDF
			for ((i=0;i<"${dev_num}";i++))
			do 
				if [ -z "${bus_num[$i]}" ] && [ -z "${device_num[$i]}" ] && [ -z "${function_num[$i]}" ]
				then
					continue
				fi
				
				echo "${select_bdfs}" |grep "\<${bus_num[$i]}:${device_num[$i]}.${function_num[$i]}" >/dev/null
				if [ $? != 0 ]
				then 
					bdf_select[$i]=1
				else 
					flag_filter=1
				fi
			done
		;;
	esac
	
	#no device found  by filter
	if [ "${flag_filter}" == 0 ]
	then 
		result="Fail"
		error_code="2"
		description="Error input"
		create_result_xml
		exit 2;
	fi
}



#upgrade FW 
upgrade_by_tools(){
	case "${tool_type}" in
		Qlogic)
			echo "${upgrade_bus}" |egrep ",${bus_num[$index]}" >/dev/null
			if [ $? != 0 ]
			then
				local error_code=0
				/opt/QLogic_Corporation/QConvergeConsoleCLI/qaucli -b ${device_index[$index]} "${pwd}/${fw_file}" >>"${pwd}/work.log"	
				error_code=$?
				if [ "${error_code}" -ne 0 ] && [ "${error_code}" -ne 201 ]
				then
					flag_fail=1
				fi
				upgrade_bus="${upgrade_bus},${bus_num[$index]}"
			fi
		;;
        Qlogic_Huawei)
			rmmod bnx2x >>"${pwd}/work.log"
			echo "./load.sh -b10eng << EOF" > fw_update.sh  
            echo "device ${device_index[$index]}" >> fw_update.sh
            echo "nvm upgrade -F -mbi ${pwd}/${fw_file} " >> fw_update.sh
            echo "exit 0" >> fw_update.sh
            ##Create Fw_update script Dynamiclly end

            ##update Fw
            chmod 777 fw_update.sh
            sh fw_update.sh > /dev/null 2>&1
            if [ $? != 0 ]
            then
                flag_fail=1
            fi
			rm fw_update.sh 2>/dev/null
		;;
		EmulexLancer|EmulexBE3)
			echo "${upgrade_bus}" |egrep ",${bus_num[$index]}" >/dev/null
			if [ $? != 0 ]
			then
				local err_code=0
				hbacmd download  ${device_index[$index]} "${pwd}/${fw_file}" >>"${pwd}/work.log"	
				err_code=$?			
				if [ "${err_code}" -ne 0 ] && [ "${err_code}" -ne 247 ]
				then
					flag_fail=1
				fi
				upgrade_bus="${upgrade_bus},${bus_num[$index]}"
			fi			
		;;		
		Hi1822)
            echo "${upgrade_bus}" |egrep ",${bus_num[$index]}" >/dev/null
			if [ $? != 0 ]
			then
                hinicadm updatefw -i ${device_index[$index]} -f "${pwd}/${fw_file}"  >>"${pwd}/work.log"
                if [ $? != 0 ]
                then
                    flag_fail=1
                fi	
                upgrade_bus="${upgrade_bus},${bus_num[$index]}"
			fi
		;;
		Hi1822FC)
            echo "${upgrade_bus}" |egrep ",${bus_num[$index]}" >/dev/null
			if [ $? != 0 ]
			then
                hifcadm updatefw -i ${device_index[$index]} -f "${pwd}/${fw_file}"  >>"${pwd}/work.log"
                if [ $? != 0 ]
                then
                    flag_fail=1
                fi	
                upgrade_bus="${upgrade_bus},${bus_num[$index]}"
			fi
		;;
		*)
		;;
	esac
	
}

#set select BDF
select_bdfs=""
if [ -n "$2" ] && [ "$2" == "BDF" ]  
then
	select_bdfs=$(echo $3 |sed 's/;/ /g')
fi

case "$1" in
	upgrade)
		#read version xml
		read_version_xml
		
		#install tools
		prepare_tools
		
		#get device info by tools
		get_device_info

		#filter BDFs by input
		if [ -n "${select_bdfs}" ]
		then
			filter_by_bdf
		fi
		
		#filter emulex by bus number
		upgrade_bus=""
		
		#upgrade firmware
		upgrade_firmware
	;;
	*)
	;;
esac

exit 0
