/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import redis.embedded.Redis;
import redis.embedded.RedisClusterBuilder;
import redis.embedded.exceptions.EmbeddedRedisException;

public class RedisCluster
implements Redis {
    private final List<Redis> sentinels = new LinkedList<Redis>();
    private final List<Redis> servers = new LinkedList<Redis>();

    RedisCluster(List<Redis> sentinels, List<Redis> servers) {
        this.servers.addAll(servers);
        this.sentinels.addAll(sentinels);
    }

    @Override
    public boolean isActive() {
        return this.sentinels.stream().allMatch(Redis::isActive) && this.servers.stream().allMatch(Redis::isActive);
    }

    @Override
    public void start() throws EmbeddedRedisException {
        this.sentinels.parallelStream().forEach(Redis::start);
        this.servers.parallelStream().forEach(Redis::start);
    }

    @Override
    public void stop() throws EmbeddedRedisException {
        this.servers.parallelStream().forEach(Redis::stop);
        this.sentinels.parallelStream().forEach(Redis::stop);
    }

    @Override
    public List<Integer> ports() {
        return Stream.concat(this.sentinels.stream().flatMap(s -> s.ports().stream()), this.servers.stream().flatMap(s -> s.ports().stream())).collect(Collectors.toList());
    }

    public List<Redis> sentinels() {
        return Lists.newLinkedList(this.sentinels);
    }

    public List<Integer> sentinelPorts() {
        return this.sentinels.stream().flatMap(s -> s.ports().stream()).collect(Collectors.toList());
    }

    public List<Redis> servers() {
        return Lists.newLinkedList(this.servers);
    }

    public List<Integer> serverPorts() {
        return this.servers.stream().flatMap(s -> s.ports().stream()).collect(Collectors.toList());
    }

    public static RedisClusterBuilder builder() {
        return new RedisClusterBuilder();
    }
}

