/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.io.OutputStream;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyCodec;

public class SnappyOutputStream
extends OutputStream {
    static final int DEFAULT_BLOCK_SIZE = 32768;
    protected final OutputStream out;
    private final int blockSize;
    private int cursor = 0;
    protected byte[] uncompressed;
    protected byte[] compressed;

    public SnappyOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 32768);
    }

    public SnappyOutputStream(OutputStream outputStream, int n) throws IOException {
        this.out = outputStream;
        this.blockSize = n;
        this.uncompressed = new byte[n];
        this.compressed = new byte[Snappy.maxCompressedLength(n)];
        this.writeHeader();
    }

    protected void writeHeader() throws IOException {
        SnappyCodec.currentHeader().writeHeader(this.out);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.rawWrite(byArray, n, n2);
    }

    public void write(long[] lArray, int n, int n2) throws IOException {
        this.rawWrite(lArray, n * 8, n2 * 8);
    }

    public void write(double[] dArray, int n, int n2) throws IOException {
        this.rawWrite(dArray, n * 8, n2 * 8);
    }

    public void write(float[] fArray, int n, int n2) throws IOException {
        this.rawWrite(fArray, n * 4, n2 * 4);
    }

    public void write(int[] nArray, int n, int n2) throws IOException {
        this.rawWrite(nArray, n * 4, n2 * 4);
    }

    public void write(short[] sArray, int n, int n2) throws IOException {
        this.rawWrite(sArray, n * 2, n2 * 2);
    }

    public void write(long[] lArray) throws IOException {
        this.write(lArray, 0, lArray.length);
    }

    public void write(double[] dArray) throws IOException {
        this.write(dArray, 0, dArray.length);
    }

    public void write(float[] fArray) throws IOException {
        this.write(fArray, 0, fArray.length);
    }

    public void write(int[] nArray) throws IOException {
        this.write(nArray, 0, nArray.length);
    }

    public void write(short[] sArray) throws IOException {
        this.write(sArray, 0, sArray.length);
    }

    public void rawWrite(Object object, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Math.min(this.uncompressed.length - this.cursor, n2 - n3);
            Snappy.arrayCopy(object, n + n3, n4, this.uncompressed, this.cursor);
            n3 += n4;
            this.cursor += n4;
            if (this.cursor < this.uncompressed.length) continue;
            this.dump();
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.cursor >= this.uncompressed.length) {
            this.dump();
        }
        this.uncompressed[this.cursor++] = (byte)n;
    }

    @Override
    public void flush() throws IOException {
        this.dump();
        this.out.flush();
    }

    static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 24 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 0 & 0xFF);
    }

    static int readInt(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24;
        int n3 = (byArray[n + 1] & 0xFF) << 16;
        int n4 = (byArray[n + 2] & 0xFF) << 8;
        int n5 = byArray[n + 3] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    protected void dump() throws IOException {
        if (this.cursor <= 0) {
            return;
        }
        int n = Snappy.compress(this.uncompressed, 0, this.cursor, this.compressed, 0);
        SnappyOutputStream.writeInt(this.out, n);
        this.out.write(this.compressed, 0, n);
        this.cursor = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
        this.out.close();
    }
}

