/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark-project.org.apache.hadoop.hive.shims.Utils;

public class DefaultFileAccess {
    private static Log LOG = LogFactory.getLog(DefaultFileAccess.class);
    private static List<String> emptyGroups = new ArrayList<String>(0);

    public static void checkFileAccess(FileSystem fs, FileStatus stat, FsAction action) throws IOException, AccessControlException, LoginException {
        UserGroupInformation currentUgi = Utils.getUGI();
        DefaultFileAccess.checkFileAccess(fs, stat, action, currentUgi.getShortUserName(), Arrays.asList(currentUgi.getGroupNames()));
    }

    public static void checkFileAccess(FileSystem fs, FileStatus stat, FsAction action, String user, List<String> groups) throws IOException, AccessControlException {
        String superGroupName;
        if (groups == null) {
            groups = emptyGroups;
        }
        if (DefaultFileAccess.userBelongsToSuperGroup(superGroupName = DefaultFileAccess.getSuperGroupName(fs.getConf()), groups)) {
            LOG.info("User \"" + user + "\" belongs to super-group \"" + superGroupName + "\". " + "Permission granted for action: " + action + ".");
            return;
        }
        FsPermission dirPerms = stat.getPermission();
        String grp = stat.getGroup();
        if (user.equals(stat.getOwner()) ? dirPerms.getUserAction().implies(action) : (groups.contains(grp) ? dirPerms.getGroupAction().implies(action) : dirPerms.getOtherAction().implies(action))) {
            return;
        }
        throw new AccessControlException("action " + action + " not permitted on path " + stat.getPath() + " for user " + user);
    }

    private static String getSuperGroupName(Configuration configuration) {
        return configuration.get("dfs.permissions.supergroup", "");
    }

    private static boolean userBelongsToSuperGroup(String superGroupName, List<String> groups) {
        return groups.contains(superGroupName);
    }
}

