/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.testkit;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.tools.testkit.AssertUtil;
import scala.tools.testkit.AssertUtil$Fast$;
import scala.tools.testkit.AssertUtil$Slow$;
import scala.tools.testkit.AssertUtil$class$u0020helper$;
import scala.tools.testkit.AssertUtil$field$u0020helper$;
import scala.tools.testkit.AssertUtil$ref$u0020helper$;
import scala.tools.testkit.NoTrace;
import scala.tools.testkit.NoTrace$;
import scala.tools.testkit.TestDuration$;
import scala.util.Failure;
import scala.util.Properties$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class AssertUtil$ {
    public static final AssertUtil$ MODULE$ = new AssertUtil$();

    public void assert8(Function0<Object> b, Function0<Object> msg) {
        block1: {
            block0: {
                if (Properties$.MODULE$.isJavaAtLeast("9")) break block0;
                Predef$.MODULE$.assert(b.apply$mcZ$sp(), msg);
                break block1;
            }
            if (b.apply$mcZ$sp()) break block1;
            Predef$.MODULE$.println((Object)new StringBuilder(11).append("assert not ").append(msg.apply()).toString());
        }
    }

    private final long timeout() {
        return 60000L;
    }

    private <A> Reference<A> ref$u0020helper(Reference<A> r) {
        return r;
    }

    private Class<?> class$u0020helper(Class<?> clazz) {
        return clazz;
    }

    private Field field$u0020helper(Field f) {
        return f;
    }

    public <T extends Throwable> void assertThrows(Function0<Object> body, Function1<String, Object> checkMessage, ClassTag<T> evidence$1) {
        try {
            body.apply();
            Assert.fail((String)"Expression did not throw!");
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = evidence$1.unapply((Object)throwable2)).isEmpty() && option.get() != null && BoxesRunTime.unboxToBoolean((Object)checkMessage.apply((Object)throwable2.getMessage()))) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public <T extends Throwable> Function1<String, Object> assertThrows$default$2() {
        return (Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AssertUtil$.$anonfun$assertThrows$default$2$1(s));
    }

    public <T extends Throwable> void assertThrown(Function1<T, Object> checker, Function0<Object> body, ClassTag<T> evidence$2) {
        try {
            body.apply();
            Assert.fail((String)"Expression did not throw!");
        }
        catch (Throwable throwable) {
            Option option;
            Option option2;
            Option option3;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option3 = evidence$2.unapply((Object)throwable2)).isEmpty() && option3.get() != null && BoxesRunTime.unboxToBoolean((Object)checker.apply((Object)throwable2))) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 != null && !(option2 = evidence$2.unapply((Object)throwable2)).isEmpty() && option2.get() != null) {
                AssertionError ae = new AssertionError((Object)new StringBuilder(24).append("Exception failed check: ").append(throwable2).toString());
                ((Throwable)((Object)ae)).addSuppressed(throwable2);
                throw ae;
            }
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable other = (Throwable)option.get();
                AssertionError ae = new AssertionError((Object)new StringBuilder(18).append("Exception not a ").append(Predef$.MODULE$.implicitly(evidence$2)).append(": ").append(other).toString());
                ((Throwable)((Object)ae)).addSuppressed(other);
                throw ae;
            }
            throw throwable;
        }
    }

    public <A, B> void assertSameElements(Iterable<A> expected, Iterable<B> actual, String message) {
        block0: {
            if (expected.iterator().sameElements(actual)) break block0;
            String arg$macro$1 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(message)) ? new StringBuilder(1).append(message).append(" ").toString() : "";
            String arg$macro$2 = ScalaRunTime$.MODULE$.stringOf(expected);
            String arg$macro$3 = ScalaRunTime$.MODULE$.stringOf(actual);
            Assert.fail((String)StringOps$.MODULE$.format$extension("%sexpected:<%s> but was:<%s>", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3})));
        }
    }

    public <A, B> void assertSameElements(Iterable<A> expected, IterableOnce<B> actual) {
        this.assertSameElements(expected, (Iterable)actual.iterator().to(IterableFactory$.MODULE$.toFactory((IterableFactory)List$.MODULE$)), "");
    }

    public <A, B> String assertSameElements$default$3() {
        return "";
    }

    public <A> void assertNotReachable(Function0<A> a, scala.collection.immutable.Seq<Object> roots, Function0<BoxedUnit> body) {
        WeakReference<Object> wkref = new WeakReference<Object>(a.apply());
        body.apply$mcV$sp();
        roots.withFilter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)AssertUtil$ref$u0020helper$.MODULE$.nonEmpty$extension(AssertUtil$.MODULE$.ref$u0020helper(wkref)))).foreach((Function1 & Serializable)r -> {
            AssertUtil$.$anonfun$assertNotReachable$6(this, wkref, r);
            return BoxedUnit.UNIT;
        });
    }

    public void assertZeroNetThreads(Function0<BoxedUnit> body) {
        ThreadGroup group = new ThreadGroup("junit");
        try {
            this.assertZeroNetThreads(group, body);
        }
        finally {
            group.destroy();
        }
    }

    public <A> Try<A> assertZeroNetThreads(ThreadGroup group, Function0<A> body) {
        Try try_;
        CountDownLatch testDone = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        long timeout = 10000L;
        Thread thread = new Thread(group, () -> this.test$1(result, testDone, group, body));
        try {
            thread.start();
            this.waitForIt((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> testDone.getCount() == 0L, AssertUtil$Fast$.MODULE$, (Function0<String>)(Function0 & Serializable)() -> "test result");
            try_ = testDone.await(timeout, TimeUnit.MILLISECONDS) ? (Try)result.get() : AssertUtil$.abort$1(group);
        }
        finally {
            thread.join(timeout);
        }
        return try_;
    }

    public void waitForIt(Function0<Object> terminated, AssertUtil.Progress progress, Function0<String> label) {
        Tuple2.mcJI.sp sp2;
        int limit = 5;
        int n = 1;
        AssertUtil.Progress progress2 = progress;
        if (AssertUtil$Slow$.MODULE$.equals(progress2)) {
            sp2 = new Tuple2.mcJI.sp(10000L, 5);
        } else if (AssertUtil$Fast$.MODULE$.equals(progress2)) {
            sp2 = new Tuple2.mcJI.sp(250L, 4);
        } else {
            throw new MatchError((Object)progress2);
        }
        Tuple2.mcJI.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        long dormancy = sp3._1$mcJ$sp();
        int factor = sp3._2$mcI$sp();
        Tuple2.mcJI.sp sp4 = new Tuple2.mcJI.sp(dormancy, factor);
        Tuple2.mcJI.sp sp5 = sp4;
        long dormancy2 = sp5._1$mcJ$sp();
        int factor2 = sp5._2$mcI$sp();
        long period = 0L;
        boolean done = false;
        boolean ended = false;
        while (!done && n < limit) {
            try {
                ended = terminated.apply$mcZ$sp();
                if (ended) {
                    done = true;
                } else {
                    Thread.sleep(dormancy2);
                    period += dormancy2;
                }
            }
            catch (InterruptedException interruptedException) {
                done = true;
            }
            ++n;
            dormancy2 *= (long)factor2;
        }
        Assert.assertTrue((String)new StringBuilder(65).append("Expired after dormancy period ").append(period).append(" waiting for termination condition ").append(label.apply()).toString(), (boolean)ended);
    }

    public AssertUtil.Progress waitForIt$default$2() {
        return AssertUtil$Fast$.MODULE$;
    }

    public String waitForIt$default$3() {
        return "test";
    }

    public boolean readyOrNot(Awaitable<?> awaitable) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> Await$.MODULE$.ready(awaitable, (Duration)TestDuration$.MODULE$.Standard())).isSuccess();
    }

    public <A> NoTrace<A> withoutATrace(Function0<A> body) {
        return NoTrace$.MODULE$.apply(body);
    }

    public static final /* synthetic */ boolean $anonfun$assertThrows$default$2$1(String s) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$assertNotReachable$1(Field f) {
        return !Modifier.isStatic(f.getModifiers());
    }

    public static final /* synthetic */ boolean $anonfun$assertNotReachable$2(Field f) {
        return !f.getType().isPrimitive();
    }

    public static final /* synthetic */ boolean $anonfun$assertNotReachable$3(Field f) {
        return !Reference.class.isAssignableFrom(f.getType());
    }

    private final void loop$2(Object o, WeakReference wkref$1, IdentityHashMap seen$1) {
        block0: {
            if (!AssertUtil$ref$u0020helper$.MODULE$.nonEmpty$extension(this.ref$u0020helper(wkref$1)) || o == null || seen$1.containsKey(o)) break block0;
            seen$1.put(o, BoxedUnit.UNIT);
            AssertUtil$class$u0020helper$.MODULE$.allFields$extension(this.class$u0020helper(o.getClass())).withFilter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AssertUtil$.$anonfun$assertNotReachable$1(f))).withFilter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AssertUtil$.$anonfun$assertNotReachable$2(f))).withFilter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AssertUtil$.$anonfun$assertNotReachable$3(f))).foreach((Function1 & Serializable)f -> {
                this.loop$2(AssertUtil$field$u0020helper$.MODULE$.follow$extension(AssertUtil$.MODULE$.field$u0020helper(f), o), wkref$1, seen$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private final Set refs$1(Object root, WeakReference wkref$1) {
        IdentityHashMap seen = new IdentityHashMap();
        this.loop$2(root, wkref$1, seen);
        return CollectionConverters$.MODULE$.SetHasAsScala(seen.keySet()).asScala();
    }

    public static final /* synthetic */ void $anonfun$assertNotReachable$6(AssertUtil$ $this, WeakReference wkref$1, Object r) {
        Assert.assertFalse((String)new StringBuilder(20).append("Root ").append(r).append(" held reference").toString(), (boolean)$this.refs$1(r, wkref$1).contains(wkref$1.get()));
    }

    private final Try check$1(ThreadGroup group$1, Function0 body$1) {
        int beforeCount = group$1.activeCount();
        Thread[] beforeThreads = new Thread[beforeCount];
        Assert.assertEquals((String)"Spurious early thread creation.", (long)beforeCount, (long)group$1.enumerate(beforeThreads));
        Try outcome = Try$.MODULE$.apply(body$1);
        JFunction0.mcZ.sp & Serializable x$1 = (JFunction0.mcZ.sp & Serializable)() -> group$1.activeCount() <= beforeCount;
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> "after count";
        AssertUtil.Progress x$3 = this.waitForIt$default$2();
        this.waitForIt((Function0<Object>)x$1, x$3, (Function0<String>)x$2);
        int afterCount = group$1.activeCount();
        Thread[] afterThreads = new Thread[afterCount];
        Assert.assertEquals((String)"Spurious late thread creation.", (long)afterCount, (long)group$1.enumerate(afterThreads));
        List staleThreads = (List)Predef$.MODULE$.wrapRefArray((Object[])afterThreads).toList().diff((Seq)Predef$.MODULE$.wrapRefArray((Object[])beforeThreads));
        String staleMessage = staleThreads.mkString("There are stale threads: ", ",", "");
        Assert.assertEquals((String)staleMessage, (long)beforeCount, (long)afterCount);
        Assert.assertTrue((String)staleMessage, (boolean)staleThreads.isEmpty());
        return outcome;
    }

    private final Try test$1(AtomicReference result$1, CountDownLatch testDone$1, ThreadGroup group$1, Function0 body$1) {
        Try try_;
        try {
            Try checked = this.check$1(group$1, body$1);
            result$1.set(checked);
            try_ = checked;
        }
        finally {
            testDone$1.countDown();
        }
        return try_;
    }

    private static final Try abort$1(ThreadGroup group$1) {
        group$1.interrupt();
        return new Failure((Throwable)((Object)new AssertionError((Object)"Test did not complete")));
    }

    private AssertUtil$() {
    }
}

