/*
 * Decompiled with CFR 0.152.
 */
package scala.reflect.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.io.AbstractFile;
import scala.reflect.io.Directory;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db!B\u0001\u0003\u0001\u0019A!\u0001\u0004)mC&tg*[8GS2,'BA\u0002\u0005\u0003\tIwN\u0003\u0002\u0006\r\u00059!/\u001a4mK\u000e$(\"A\u0004\u0002\u000bM\u001c\u0017\r\\1\u0014\u0005\u0001I\u0001C\u0001\u0006\f\u001b\u0005\u0011\u0011B\u0001\u0007\u0003\u00051\t%m\u001d;sC\u000e$h)\u001b7f\u0011!q\u0001A!A!\u0002\u0013\u0001\u0012a\u00028j_B\u000bG\u000f[\u0002\u0001!\t\t\u0002$D\u0001\u0013\u0015\t\u0019B#\u0001\u0003gS2,'BA\u000b\u0017\u0003\rq\u0017n\u001c\u0006\u0002/\u0005!!.\u0019<b\u0013\tI\"C\u0001\u0003QCRD\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e=A\u0011!\u0002\u0001\u0005\u0006\u001di\u0001\r\u0001\u0005\u0005\u0006'\u0001!\t\u0005I\u000b\u0002CA\u0011!\u0005J\u0007\u0002G)\u00111AF\u0005\u0003K\r\u0012AAR5mK\")q\u0005\u0001C!Q\u0005\u0001RO\u001c3fe2L\u0018N\\4T_V\u00148-Z\u000b\u0002SA\u0019!fK\u000f\u000e\u0003\u0019I!\u0001\f\u0004\u0003\tM{W.\u001a\u0005\b]\u0001\u0011\r\u0011\"\u00030\u0003\u00151\u0007/\u0019;i+\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$BA\u001a\u0017\u0003\u0011a\u0017M\\4\n\u0005U\u0012$AB*ue&tw\r\u0003\u00048\u0001\u0001\u0006I\u0001M\u0001\u0007MB\fG\u000f\u001b\u0011\t\u000be\u0002A\u0011A\u0018\u0002\t9\fW.\u001a\u0005\u0006w\u0001!\taL\u0001\u0005a\u0006$\b\u000eC\u0003>\u0001\u0011\u0005a(\u0001\u0005bEN|G.\u001e;f+\u0005i\u0002\"\u0002!\u0001\t\u0003\n\u0015!C2p]R\f\u0017N\\3s+\u0005I\u0001\"B\"\u0001\t\u0003\"\u0015!B5oaV$X#A#\u0011\u0005\t2\u0015BA$$\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000b%\u0003A\u0011\t&\u0002\r=,H\u000f];u+\u0005Y\u0005C\u0001\u0012M\u0013\ti5E\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0003P\u0001\u0011\u0005\u0003+\u0001\u0006tSj,w\n\u001d;j_:,\u0012!\u0015\t\u0004U-\u0012\u0006C\u0001\u0016T\u0013\t!fAA\u0002J]RDQA\u0016\u0001\u0005B]\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002%\")\u0011\f\u0001C!5\u00061Q-];bYN$\"a\u00170\u0011\u0005)b\u0016BA/\u0007\u0005\u001d\u0011un\u001c7fC:DQa\u0018-A\u0002\u0001\fA\u0001\u001e5biB\u0011!&Y\u0005\u0003E\u001a\u00111!\u00118z\u0011\u0015!\u0007\u0001\"\u0001f\u0003-I7\u000fR5sK\u000e$xN]=\u0016\u0003mCQa\u001a\u0001\u0005\u0002!\fA\u0002\\1ti6{G-\u001b4jK\u0012,\u0012!\u001b\t\u0003U)L!a\u001b\u0004\u0003\t1{gn\u001a\u0005\u0006[\u0002!\tA\\\u0001\tSR,'/\u0019;peV\tq\u000eE\u0002qg&q!AK9\n\u0005I4\u0011a\u00029bG.\fw-Z\u0005\u0003iV\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003e\u001aAQa\u001e\u0001\u0005\u0002a\f!\u0002\\8pWV\u0004h*Y7f)\u0011I\u00110!\u0003\t\u000be2\b\u0019\u0001>\u0011\u0007m\f)AD\u0002}\u0003\u0003\u0001\"! \u0004\u000e\u0003yT!a`\b\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019AB\u0001\u0007!J,G-\u001a4\n\u0007U\n9AC\u0002\u0002\u0004\u0019Aa!a\u0003w\u0001\u0004Y\u0016!\u00033je\u0016\u001cGo\u001c:z\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\taa\u0019:fCR,GCAA\n!\rQ\u0013QC\u0005\u0004\u0003/1!\u0001B+oSRDq!a\u0007\u0001\t\u0003\t\t\"\u0001\u0004eK2,G/\u001a\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003Mawn\\6va:\u000bW.Z+oG\",7m[3e)\u0015I\u00111EA\u0013\u0011\u0019I\u0014Q\u0004a\u0001u\"9\u00111BA\u000f\u0001\u0004Y\u0006")
public class PlainNioFile
extends AbstractFile {
    private final Path nioPath;
    private final String fpath;

    @Override
    public File file() {
        File file;
        try {
            file = this.nioPath.toFile();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            file = null;
        }
        return file;
    }

    public Some<PlainNioFile> underlyingSource() {
        return new Some((Object)this);
    }

    private String fpath() {
        return this.fpath;
    }

    @Override
    public String name() {
        return ((Object)this.nioPath.getFileName()).toString();
    }

    @Override
    public String path() {
        return ((Object)this.nioPath).toString();
    }

    @Override
    public PlainNioFile absolute() {
        return new PlainNioFile(this.nioPath.toAbsolutePath());
    }

    @Override
    public AbstractFile container() {
        return new PlainNioFile(this.nioPath.getParent());
    }

    @Override
    public InputStream input() {
        return Files.newInputStream(this.nioPath, new OpenOption[0]);
    }

    @Override
    public OutputStream output() {
        return Files.newOutputStream(this.nioPath, new OpenOption[0]);
    }

    public Some<Object> sizeOption() {
        return new Some((Object)BoxesRunTime.boxToInteger((int)((int)Files.size(this.nioPath))));
    }

    public int hashCode() {
        return this.fpath().hashCode();
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof PlainNioFile) {
            PlainNioFile plainNioFile = (PlainNioFile)object;
            String string = this.fpath();
            String string2 = plainNioFile.fpath();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.nioPath, new LinkOption[0]);
    }

    @Override
    public long lastModified() {
        return Files.getLastModifiedTime(this.nioPath, new LinkOption[0]).toMillis();
    }

    @Override
    public Iterator<AbstractFile> iterator() {
        Iterator iterator;
        try {
            java.util.Iterator<Path> it = Files.newDirectoryStream(this.nioPath).iterator();
            iterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(it).asScala()).map((Function1 & java.io.Serializable & Serializable)x$3 -> new PlainNioFile((Path)x$3));
        }
        catch (NotDirectoryException notDirectoryException) {
            iterator = package$.MODULE$.Iterator().empty();
        }
        return iterator;
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        Path child = this.nioPath.resolve(name);
        return Files.isDirectory(child, new LinkOption[0]) && directory || Files.isRegularFile(child, new LinkOption[0]) && !directory ? new PlainNioFile(child) : null;
    }

    @Override
    public void create() {
        block0: {
            if (this.exists()) break block0;
            Files.createFile(this.nioPath, new FileAttribute[0]);
        }
    }

    @Override
    public void delete() {
        block1: {
            block0: {
                if (!Files.isRegularFile(this.nioPath, new LinkOption[0])) break block0;
                Files.deleteIfExists(this.nioPath);
                break block1;
            }
            if (!Files.isDirectory(this.nioPath, new LinkOption[0])) break block1;
            new Directory(this.nioPath.toFile()).deleteRecursively();
        }
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        return new PlainNioFile(this.nioPath.resolve(name));
    }

    public PlainNioFile(Path nioPath) {
        this.nioPath = nioPath;
        Predef$.MODULE$.assert(nioPath != null);
        this.fpath = ((Object)nioPath.toAbsolutePath()).toString();
    }
}

