/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.nest;

import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.io.Source$;
import scala.reflect.io.Directory;
import scala.reflect.io.File$;
import scala.reflect.io.Path;
import scala.reflect.io.Path$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.tools.partest.package$;

public final class FileManager$ {
    public static final FileManager$ MODULE$ = new FileManager$();

    public File getLogFile(File dir, String fileBase, String kind) {
        return new File(dir, new StringBuilder(5).append(fileBase).append("-").append(kind).append(".log").toString());
    }

    public File getLogFile(File file, String kind) {
        File dir = file.getParentFile();
        String fileBase = package$.MODULE$.basename(file.getName());
        return this.getLogFile(dir, fileBase, kind);
    }

    public boolean logFileExists(File file, String kind) {
        return this.getLogFile(file, kind).canRead();
    }

    public boolean overwriteFileWith(File dest, File file) {
        return dest.isFile() && this.copyFile(file, dest);
    }

    public boolean copyFile(File from, File dest) {
        boolean bl;
        if (from.isDirectory()) {
            Predef$.MODULE$.assert(dest.isDirectory(), (Function0 & Serializable)() -> "cannot copy directory to file");
            Directory subDir = package$.MODULE$.Path().apply(dest).$div(package$.MODULE$.Directory().apply(Path$.MODULE$.string2path(from.getName())));
            subDir.createDirectory(subDir.createDirectory$default$1(), subDir.createDirectory$default$2());
            bl = Predef$.MODULE$.wrapRefArray((Object[])from.listFiles()).toList().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileManager$.MODULE$.copyFile(x$1, package$.MODULE$.temporaryPath2File((Path)subDir))));
        } else {
            File to = dest.isDirectory() ? new File(dest, from.getName()) : dest;
            try {
                package$.MODULE$.SFile().apply(Path$.MODULE$.jfile2path(to), package$.MODULE$.codec()).writeAll((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{package$.MODULE$.SFile().apply(Path$.MODULE$.jfile2path(from), package$.MODULE$.codec()).slurp()}));
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    public void mapFile(File file, Function1<String, String> replace) {
        scala.reflect.io.File f = package$.MODULE$.SFile().apply(Path$.MODULE$.jfile2path(file), package$.MODULE$.codec());
        f.printlnAll((Seq)f.lines().toList().map(replace));
    }

    public Iterator<scala.reflect.io.File> jarsWithPrefix(Directory dir, String name) {
        return dir.files().filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileManager$.$anonfun$jarsWithPrefix$1(name, f)));
    }

    public Iterator<Directory> dirsWithPrefix(Directory dir, String name) {
        return dir.dirs().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileManager$.$anonfun$dirsWithPrefix$1(name, x$2)));
    }

    public String joinPaths(List<Path> paths) {
        return package$.MODULE$.ClassPath().join((Seq)paths.map((Function1 & Serializable)x$3 -> package$.MODULE$.temporaryPath2File((Path)x$3).getAbsolutePath()).distinct());
    }

    public String compareFiles(File original, File revised) {
        return this.compareContents((Seq<String>)Source$.MODULE$.fromFile(original, package$.MODULE$.codec()).getLines().toSeq(), (Seq<String>)Source$.MODULE$.fromFile(revised, package$.MODULE$.codec()).getLines().toSeq(), original.getName(), revised.getName());
    }

    public String compareContents(Seq<String> original, Seq<String> revised, String originalName, String revisedName) {
        Patch diff = DiffUtils.diff((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava()), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(revised).asJava()));
        return diff.getDeltas().isEmpty() ? "" : ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(DiffUtils.generateUnifiedDiff((String)originalName, (String)revisedName, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava()), (Patch)diff, (int)1)).asScala()).mkString("\n");
    }

    public String compareContents$default$3() {
        return "a";
    }

    public String compareContents$default$4() {
        return "b";
    }

    public <A> A withTempFile(File outFile, String fileBase, Seq<String> lines, Function1<File, A> body) {
        Object object;
        String prefix = new StringBuilder(4).append("tmp-").append(fileBase).toString();
        String suffix = ".check";
        File f = File.createTempFile(prefix, suffix, outFile);
        try {
            File$.MODULE$.apply(Path$.MODULE$.jfile2path(f), package$.MODULE$.codec()).writeAll((Seq)lines.map((Function1 & Serializable)line -> {
                String arg$macro$1 = line;
                return StringOps$.MODULE$.format$extension("%s%n", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}));
            }));
            object = body.apply((Object)f);
        }
        finally {
            f.delete();
        }
        return (A)object;
    }

    public static final /* synthetic */ boolean $anonfun$jarsWithPrefix$1(String name$1, scala.reflect.io.File f) {
        return f.hasExtension("jar", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])) && f.name().startsWith(name$1);
    }

    public static final /* synthetic */ boolean $anonfun$dirsWithPrefix$1(String name$2, Directory x$2) {
        return x$2.name().startsWith(name$2);
    }

    private FileManager$() {
    }
}

