/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.RedBlackTree;
import scala.collection.immutable.RedBlackTree$BlackTree$;
import scala.collection.immutable.RedBlackTree$RedTree$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.sys.package$;

public final class RedBlackTree$ {
    public static final RedBlackTree$ MODULE$ = new RedBlackTree$();

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A x, Ordering<A> evidence$1) {
        return this.lookup(tree, x, evidence$1) != null;
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> evidence$2) {
        RedBlackTree.Tree<A, B> tree2 = this.lookup(tree, x, evidence$2);
        Option option = tree2 == null ? None$.MODULE$ : new Some<B>(tree2.value());
        return option;
    }

    public <A, B> RedBlackTree.Tree<A, B> lookup(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        block3: {
            while (true) {
                if (tree == null) {
                    tree2 = null;
                    break block3;
                }
                int cmp = ordering.compare(x, tree.key());
                if (cmp < 0) {
                    tree = tree.left();
                    continue;
                }
                if (cmp <= 0) break;
                tree = tree.right();
            }
            tree2 = tree;
        }
        return tree2;
    }

    public int count(RedBlackTree.Tree<?, ?> tree) {
        return tree == null ? 0 : tree.count();
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> update(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> evidence$3) {
        return this.blacken(this.upd(tree, k, v, overwrite, evidence$3));
    }

    public <A, B> RedBlackTree.Tree<A, B> delete(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> evidence$4) {
        return this.blacken(this.del(tree, k, evidence$4));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A, B> RedBlackTree.Tree<A, B> rangeImpl(RedBlackTree.Tree<A, B> tree, Option<A> from, Option<A> until, Ordering<A> evidence$5) {
        Tuple2<Option<A>, Option<A>> tuple2 = new Tuple2<Option<A>, Option<A>>(from, until);
        if (tuple2 != null) {
            Option<A> option = tuple2._1();
            Option<A> option2 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object from2 = some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object until2 = some2.value();
                    return this.range(tree, from2, until2, evidence$5);
                }
            }
        }
        if (tuple2 != null) {
            Option<A> option = tuple2._1();
            Option<A> option3 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object from3 = some.value();
                if (None$.MODULE$.equals(option3)) {
                    return this.from(tree, from3, evidence$5);
                }
            }
        }
        if (tuple2 != null) {
            Option<A> option = tuple2._1();
            Option<A> option4 = tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                Some some = (Some)option4;
                Object until3 = some.value();
                return this.until(tree, until3, evidence$5);
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Option<A> option = tuple2._1();
        Option<A> option5 = tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError(tuple2);
        if (!None$.MODULE$.equals(option5)) throw new MatchError(tuple2);
        return tree;
    }

    public <A, B> RedBlackTree.Tree<A, B> range(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> evidence$6) {
        return this.blacken(this.doRange(tree, from, until, evidence$6));
    }

    public <A, B> RedBlackTree.Tree<A, B> from(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> evidence$7) {
        return this.blacken(this.doFrom(tree, from, evidence$7));
    }

    public <A, B> RedBlackTree.Tree<A, B> to(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> evidence$8) {
        return this.blacken(this.doTo(tree, to, evidence$8));
    }

    public <A, B> RedBlackTree.Tree<A, B> until(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$9) {
        return this.blacken(this.doUntil(tree, key, evidence$9));
    }

    public <A, B> RedBlackTree.Tree<A, B> drop(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$10) {
        return this.blacken(this.doDrop(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> take(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$11) {
        return this.blacken(this.doTake(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> slice(RedBlackTree.Tree<A, B> tree, int from, int until, Ordering<A> evidence$12) {
        return this.blacken(this.doSlice(tree, from, until));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> smallest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (result.left() != null) {
            result = result.left();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> greatest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (result.right() != null) {
            result = result.right();
        }
        return var2_2;
    }

    public <A, B> RedBlackTree.Tree<A, B> tail(RedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._tail$1(tree));
    }

    public <A, B> RedBlackTree.Tree<A, B> init(RedBlackTree.Tree<A, B> tree) {
        return this.blacken(this._init$1(tree));
    }

    public <A, B> RedBlackTree.Tree<A, B> minAfter(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        while (true) {
            if (tree == null) {
                tree2 = null;
                break;
            }
            int cmp = ordering.compare(x, tree.key());
            if (cmp == 0) {
                tree2 = tree;
                break;
            }
            if (cmp < 0) {
                RedBlackTree.Tree<A, B> l = this.minAfter(tree.left(), x, ordering);
                if (l != null) {
                    tree2 = l;
                    break;
                }
                tree2 = tree;
                break;
            }
            tree = tree.right();
        }
        return tree2;
    }

    public <A, B> RedBlackTree.Tree<A, B> maxBefore(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        block2: {
            while (true) {
                if (tree == null) {
                    tree2 = null;
                    break block2;
                }
                int cmp = ordering.compare(x, tree.key());
                if (cmp > 0) break;
                tree = tree.left();
            }
            RedBlackTree.Tree<A, B> r = this.maxBefore(tree.right(), x, ordering);
            tree2 = r != null ? r : tree;
        }
        return tree2;
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        block0: {
            if (tree == null) break block0;
            this._foreach(tree, f);
        }
    }

    private <A, B, U> void _foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreach(tree.left(), f);
            }
            f.apply(new Tuple2<A, B>(tree.key(), tree.value()));
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        block0: {
            if (tree == null) break block0;
            this._foreachKey(tree, f);
        }
    }

    private <A, U> void _foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreachKey(tree.left(), f);
            }
            f.apply(tree.key());
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, B, U> void foreachEntry(RedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        block0: {
            if (tree == null) break block0;
            this._foreachEntry(tree, f);
        }
    }

    private <A, B, U> void _foreachEntry(RedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreachEntry(tree.left(), f);
            }
            f.apply(tree.key(), tree.value());
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$13) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, evidence$13);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Ordering<A> evidence$14) {
        return new RedBlackTree.KeysIterator(tree, start, evidence$14);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$15) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, evidence$15);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> RedBlackTree.Tree<A, B> nth(RedBlackTree.Tree<A, B> tree, int n) {
        while (true) {
            int count;
            if (n < (count = this.count(tree.left()))) {
                tree = tree.left();
                continue;
            }
            if (n <= count) break;
            n = n - count - 1;
            tree = tree.right();
        }
        return tree;
    }

    public boolean isBlack(RedBlackTree.Tree<?, ?> tree) {
        return tree == null || this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree);
    }

    private boolean isRedTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.RedTree;
    }

    public boolean scala$collection$immutable$RedBlackTree$$isBlackTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.BlackTree;
    }

    private <A, B> RedBlackTree.Tree<A, B> blacken(RedBlackTree.Tree<A, B> t) {
        return t == null ? null : t.black();
    }

    private <A, B> RedBlackTree.Tree<A, B> maybeBlacken(RedBlackTree.Tree<A, B> t) {
        return this.isBlack(t) ? t : (this.isRedTree(t.left()) || this.isRedTree(t.right()) ? t.black() : t);
    }

    private <A, B> RedBlackTree.Tree<A, B> mkTree(boolean isBlack, A k, B v, RedBlackTree.Tree<A, B> l, RedBlackTree.Tree<A, B> r) {
        return isBlack ? RedBlackTree$BlackTree$.MODULE$.apply(k, v, l, r) : RedBlackTree$RedTree$.MODULE$.apply(k, v, l, r);
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> balanceLeft(boolean isBlack, A z, B zv, RedBlackTree.Tree<A, B1> l, RedBlackTree.Tree<A, B1> d) {
        return this.isRedTree(l) && this.isRedTree(l.left()) ? RedBlackTree$RedTree$.MODULE$.apply(l.key(), l.value(), RedBlackTree$BlackTree$.MODULE$.apply(l.left().key(), l.left().value(), l.left().left(), l.left().right()), RedBlackTree$BlackTree$.MODULE$.apply(z, zv, l.right(), d)) : (this.isRedTree(l) && this.isRedTree(l.right()) ? RedBlackTree$RedTree$.MODULE$.apply(l.right().key(), l.right().value(), RedBlackTree$BlackTree$.MODULE$.apply(l.key(), l.value(), l.left(), l.right().left()), RedBlackTree$BlackTree$.MODULE$.apply(z, zv, l.right().right(), d)) : this.mkTree(isBlack, z, zv, l, d));
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> balanceRight(boolean isBlack, A x, B xv, RedBlackTree.Tree<A, B1> a, RedBlackTree.Tree<A, B1> r) {
        return this.isRedTree(r) && this.isRedTree(r.left()) ? RedBlackTree$RedTree$.MODULE$.apply(r.left().key(), r.left().value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, a, r.left().left()), RedBlackTree$BlackTree$.MODULE$.apply(r.key(), r.value(), r.left().right(), r.right())) : (this.isRedTree(r) && this.isRedTree(r.right()) ? RedBlackTree$RedTree$.MODULE$.apply(r.key(), r.value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, a, r.left()), RedBlackTree$BlackTree$.MODULE$.apply(r.right().key(), r.right().value(), r.right().left(), r.right().right())) : this.mkTree(isBlack, x, xv, a, r));
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> upd(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> ordering) {
        int cmp;
        return tree == null ? RedBlackTree$RedTree$.MODULE$.apply(k, v, null, null) : ((cmp = ordering.compare(k, tree.key())) < 0 ? this.balanceLeft(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), tree.key(), tree.value(), this.upd(tree.left(), k, v, overwrite, ordering), tree.right()) : (cmp > 0 ? this.balanceRight(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), tree.key(), tree.value(), tree.left(), this.upd(tree.right(), k, v, overwrite, ordering)) : (overwrite ? this.mkTree(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), tree.key(), v, tree.left(), tree.right()) : tree)));
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> updNth(RedBlackTree.Tree<A, B> tree, int idx, A k, B1 v, boolean overwrite) {
        int rank;
        return tree == null ? RedBlackTree$RedTree$.MODULE$.apply(k, v, null, null) : (idx < (rank = this.count(tree.left()) + 1) ? this.balanceLeft(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), tree.key(), tree.value(), this.updNth(tree.left(), idx, k, v, overwrite), tree.right()) : (idx > rank ? this.balanceRight(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), tree.key(), tree.value(), tree.left(), this.updNth(tree.right(), idx - rank, k, v, overwrite)) : (overwrite ? this.mkTree(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), k, v, tree.left(), tree.right()) : tree)));
    }

    private <A, B> RedBlackTree.Tree<A, B> doFrom(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doFrom(tree.right(), from, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        return newLeft == tree.left() ? tree : (newLeft == null ? this.upd(tree.right(), tree.key(), tree.value(), false, ordering) : this.join(newLeft, tree.key(), tree.value(), tree.right()));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTo(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(to, tree.key())) {
            return this.doTo(tree.left(), to, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTo(tree.right(), to, ordering);
        return newRight == tree.right() ? tree : (newRight == null ? this.upd(tree.left(), tree.key(), tree.value(), false, ordering) : this.join(tree.left(), tree.key(), tree.value(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doUntil(RedBlackTree.Tree<A, B> tree, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doUntil(tree.left(), until, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        return newRight == tree.right() ? tree : (newRight == null ? this.upd(tree.left(), tree.key(), tree.value(), false, ordering) : this.join(tree.left(), tree.key(), tree.value(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doRange(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doRange(tree.right(), from, until, ordering);
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doRange(tree.left(), from, until, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        return newLeft == tree.left() && newRight == tree.right() ? tree : (newLeft == null ? this.upd(newRight, tree.key(), tree.value(), false, ordering) : (newRight == null ? this.upd(newLeft, tree.key(), tree.value(), false, ordering) : this.join(newLeft, tree.key(), tree.value(), newRight)));
    }

    private <A, B> RedBlackTree.Tree<A, B> doDrop(RedBlackTree.Tree<A, B> tree, int n) {
        RedBlackTree.Tree<A, B> tree2;
        block3: {
            int l;
            while (true) {
                if (tree == null || n <= 0) {
                    tree2 = tree;
                    break block3;
                }
                if (n >= tree.count()) {
                    tree2 = null;
                    break block3;
                }
                l = this.count(tree.left());
                if (n <= l) break;
                n = n - l - 1;
                tree = tree.right();
            }
            tree2 = n == l ? this.join(null, tree.key(), tree.value(), tree.right()) : this.join(this.doDrop(tree.left(), n), tree.key(), tree.value(), tree.right());
        }
        return tree2;
    }

    private <A, B> RedBlackTree.Tree<A, B> doTake(RedBlackTree.Tree<A, B> tree, int n) {
        RedBlackTree.Tree<A, B> tree2;
        block3: {
            int l;
            while (true) {
                if (tree == null || n <= 0) {
                    tree2 = null;
                    break block3;
                }
                if (n >= tree.count()) {
                    tree2 = tree;
                    break block3;
                }
                l = this.count(tree.left());
                if (n > l) break;
                tree = tree.left();
            }
            tree2 = n == l + 1 ? this.maybeBlacken(this.updNth(tree.left(), n, tree.key(), tree.value(), false)) : this.join(tree.left(), tree.key(), tree.value(), this.doTake(tree.right(), n - l - 1));
        }
        return tree2;
    }

    private <A, B> RedBlackTree.Tree<A, B> doSlice(RedBlackTree.Tree<A, B> tree, int from, int until) {
        RedBlackTree.Tree<A, B> tree2;
        block4: {
            int l;
            while (true) {
                if (tree == null || from >= until || from >= tree.count() || until <= 0) {
                    tree2 = null;
                    break block4;
                }
                if (from <= 0 && until >= tree.count()) {
                    tree2 = tree;
                    break block4;
                }
                l = this.count(tree.left());
                if (until <= l) {
                    tree = tree.left();
                    continue;
                }
                if (from <= l) break;
                until = until - l - 1;
                from = from - l - 1;
                tree = tree.right();
            }
            tree2 = this.join(this.doDrop(tree.left(), from), tree.key(), tree.value(), this.doTake(tree.right(), until - l - 1));
        }
        return tree2;
    }

    public <A> RedBlackTree.Tree<A, Null$> fromOrderedKeys(Iterator<A> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return this.f$1(1, size, maxUsedDepth, xs);
    }

    public <A, B> RedBlackTree.Tree<A, B> fromOrderedEntries(Iterator<Tuple2<A, B>> xs, int size) {
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return this.f$2(1, size, xs, maxUsedDepth);
    }

    public <A, B, C> RedBlackTree.Tree<A, C> transform(RedBlackTree.Tree<A, B> t, Function2<A, B, C> f) {
        RedBlackTree.Tree<A, Object> tree;
        if (t == null) {
            tree = null;
        } else {
            A k = t.key();
            B v = t.value();
            RedBlackTree.Tree<A, B> l = t.left();
            RedBlackTree.Tree<A, B> r = t.right();
            RedBlackTree.Tree<A, C> l2 = this.transform(l, f);
            C v2 = f.apply(k, v);
            RedBlackTree.Tree<A, C> r2 = this.transform(r, f);
            tree = v2 == v && l2 == l && r2 == r ? t : this.mkTree(this.scala$collection$immutable$RedBlackTree$$isBlackTree(t), k, v2, l2, r2);
        }
        return tree;
    }

    public <A, B> RedBlackTree.Tree<A, B> filterEntries(RedBlackTree.Tree<A, B> t, Function2<A, B, Object> f) {
        return t == null ? null : this.blacken(this.fk$1(t, f));
    }

    public <A, B> RedBlackTree.Tree<A, B> filterKeys(RedBlackTree.Tree<A, B> t, Function1<A, Object> f) {
        return t == null ? null : this.blacken(this.fk$2(t, f));
    }

    public <A, B> Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> partitionEntries(RedBlackTree.Tree<A, B> t, Function2<A, B, Object> p) {
        Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple2;
        if (t == null) {
            tuple2 = new Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(null, null);
        } else {
            ObjectRef<Object> tmpk = ObjectRef.create(null);
            ObjectRef<Object> tmpd = ObjectRef.create(null);
            this.fk$3(t, tmpk, tmpd, p);
            tuple2 = new Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(this.blacken((RedBlackTree.Tree)tmpk.elem), this.blacken((RedBlackTree.Tree)tmpd.elem));
        }
        return tuple2;
    }

    public <A, B> Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> partitionKeys(RedBlackTree.Tree<A, B> t, Function1<A, Object> p) {
        Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple2;
        if (t == null) {
            tuple2 = new Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(null, null);
        } else {
            ObjectRef<Object> tmpk = ObjectRef.create(null);
            ObjectRef<Object> tmpd = ObjectRef.create(null);
            this.fk$4(t, tmpk, tmpd, p);
            tuple2 = new Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(this.blacken((RedBlackTree.Tree)tmpk.elem), this.blacken((RedBlackTree.Tree)tmpd.elem));
        }
        return tuple2;
    }

    private <A, B> RedBlackTree.Tree<A, B> del(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering) {
        int cmp;
        return tree == null ? null : ((cmp = ordering.compare(k, tree.key())) < 0 ? this.delLeft$1(tree, k, ordering) : (cmp > 0 ? this.delRight$1(tree, k, ordering) : this.append(tree.left(), tree.right())));
    }

    private <A, B> RedBlackTree.Tree<A, B> balance(A x, B xv, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        return this.isRedTree(tl) ? (this.isRedTree(tr) ? RedBlackTree$RedTree$.MODULE$.apply(x, xv, tl.black(), tr.black()) : (this.isRedTree(tl.left()) ? RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left().black(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl.right(), tr)) : (this.isRedTree(tl.right()) ? RedBlackTree$RedTree$.MODULE$.apply(tl.right().key(), tl.right().value(), RedBlackTree$BlackTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), tl.right().left()), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl.right().right(), tr)) : RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr)))) : (this.isRedTree(tr) ? (this.isRedTree(tr.right()) ? RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr.left()), tr.right().black()) : (this.isRedTree(tr.left()) ? RedBlackTree$RedTree$.MODULE$.apply(tr.left().key(), tr.left().value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr.left().left()), RedBlackTree$BlackTree$.MODULE$.apply(tr.key(), tr.value(), tr.left().right(), tr.right())) : RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr))) : RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr));
    }

    private <A, B> RedBlackTree.Tree<A, B> balLeft(A x, B xv, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.Tree tree;
        if (this.isRedTree(tl)) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(x, xv, tl.black(), tr);
        } else if (this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr)) {
            tree = this.balance(x, xv, tl, tr.red());
        } else if (this.isRedTree(tr) && this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr.left())) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(tr.left().key(), tr.left().value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr.left().left()), this.balance(tr.key(), tr.value(), tr.left().right(), tr.right().red()));
        } else {
            throw package$.MODULE$.error("Defect: invariance violation");
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> balRight(A x, B xv, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.Tree tree;
        if (this.isRedTree(tr)) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(x, xv, tl, tr.black());
        } else if (this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl)) {
            tree = this.balance(x, xv, tl.red(), tr);
        } else if (this.isRedTree(tl) && this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl.right())) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(tl.right().key(), tl.right().value(), this.balance(tl.key(), tl.value(), tl.left().red(), tl.right().left()), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl.right().right(), tr));
        } else {
            throw package$.MODULE$.error("Defect: invariance violation");
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> append(RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.Tree tree;
        if (tl == null) {
            tree = tr;
        } else if (tr == null) {
            tree = tl;
        } else if (this.isRedTree(tl) && this.isRedTree(tr)) {
            RedBlackTree.Tree<A, B> bc = this.append(tl.right(), tr.left());
            tree = this.isRedTree(bc) ? RedBlackTree$RedTree$.MODULE$.apply(bc.key(), bc.value(), RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), bc.left()), RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), bc.right(), tr.right())) : RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), bc, tr.right()));
        } else if (this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl) && this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr)) {
            RedBlackTree.Tree<A, B> bc = this.append(tl.right(), tr.left());
            tree = this.isRedTree(bc) ? RedBlackTree$RedTree$.MODULE$.apply(bc.key(), bc.value(), RedBlackTree$BlackTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), bc.left()), RedBlackTree$BlackTree$.MODULE$.apply(tr.key(), tr.value(), bc.right(), tr.right())) : this.balLeft(tl.key(), tl.value(), tl.left(), RedBlackTree$BlackTree$.MODULE$.apply(tr.key(), tr.value(), bc, tr.right()));
        } else if (this.isRedTree(tr)) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), this.append(tl, tr.left()), tr.right());
        } else if (this.isRedTree(tl)) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), this.append(tl.right(), tr));
        } else {
            throw package$.MODULE$.error(new StringBuilder(28).append("unmatched tree on append: ").append(tl).append(", ").append(tr).toString());
        }
        return tree;
    }

    public <A, B> RedBlackTree.Tree<A, B> union(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        return this.blacken(this._union(t1, t2, ordering));
    }

    public <A, B> RedBlackTree.Tree<A, B> intersect(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        return this.blacken(this._intersect(t1, t2, ordering));
    }

    public <A, B> RedBlackTree.Tree<A, B> difference(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, ?> t2, Ordering<A> ordering) {
        return this.blacken(this._difference(t1, t2, ordering));
    }

    private int rank(RedBlackTree.Tree<?, ?> t, int bh) {
        return t == null ? 0 : (this.scala$collection$immutable$RedBlackTree$$isBlackTree(t) ? 2 * (bh - 1) : 2 * bh - 1);
    }

    private <A, B> RedBlackTree.Tree<A, B> joinRight(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr, int bhtl, int rtr) {
        RedBlackTree.Tree tree;
        int rtl = this.rank(tl, bhtl);
        if (rtl == rtr / 2 * 2) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(k, v, tl, tr);
        } else {
            boolean tlBlack = this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl);
            int bhtlr = tlBlack ? bhtl - 1 : bhtl;
            RedBlackTree.Tree<A, B> ttr = this.joinRight(tl.right(), k, v, tr, bhtlr, rtr);
            tree = tlBlack && this.isRedTree(ttr) && this.isRedTree(ttr.right()) ? RedBlackTree$RedTree$.MODULE$.apply(ttr.key(), ttr.value(), RedBlackTree$BlackTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), ttr.left()), ttr.right().black()) : this.mkTree(tlBlack, tl.key(), tl.value(), tl.left(), ttr);
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> joinLeft(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr, int rtl, int bhtr) {
        RedBlackTree.Tree tree;
        int rtr = this.rank(tr, bhtr);
        if (rtr == rtl / 2 * 2) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(k, v, tl, tr);
        } else {
            boolean trBlack = this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr);
            int bhtrl = trBlack ? bhtr - 1 : bhtr;
            RedBlackTree.Tree<A, B> ttl = this.joinLeft(tl, k, v, tr.left(), rtl, bhtrl);
            tree = trBlack && this.isRedTree(ttl) && this.isRedTree(ttl.left()) ? RedBlackTree$RedTree$.MODULE$.apply(ttl.key(), ttl.value(), ttl.left().black(), RedBlackTree$BlackTree$.MODULE$.apply(tr.key(), tr.value(), ttl.right(), tr.right())) : this.mkTree(trBlack, tr.key(), tr.value(), ttl, tr.right());
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> join(RedBlackTree.Tree<A, B> tl, A k, B v, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.Tree<A, B> tt;
        RedBlackTree.Tree<A, B> tt2;
        int bhtr;
        int bhtl = this.h$1(tl, 0);
        RedBlackTree.Tree<A, B> tree = bhtl > (bhtr = this.h$1(tr, 0)) ? (this.isRedTree(tt2 = this.joinRight(tl, k, v, tr, bhtl, this.rank(tr, bhtr))) && this.isRedTree(tt2.right()) ? tt2.black() : tt2) : (bhtr > bhtl ? (this.isRedTree(tt = this.joinLeft(tl, k, v, tr, this.rank(tl, bhtl), bhtr)) && this.isRedTree(tt.left()) ? tt.black() : tt) : this.mkTree(this.isRedTree(tl) || this.isRedTree(tr), k, v, tl, tr));
        return tree;
    }

    private <A, B> Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> split(RedBlackTree.Tree<A, B> t, A k, Ordering<A> ordering) {
        Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple3;
        if (t == null) {
            tuple3 = new Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(null, null, null);
        } else {
            int cmp = ordering.compare(k, t.key());
            if (cmp == 0) {
                tuple3 = new Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(t.left(), t, t.right());
            } else if (cmp < 0) {
                Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple32 = this.split(t.left(), k, ordering);
                if (tuple32 == null) {
                    throw new MatchError(tuple32);
                }
                RedBlackTree.Tree<A, B> ll = tuple32._1();
                RedBlackTree.Tree<A, B> b = tuple32._2();
                RedBlackTree.Tree<A, B> lr = tuple32._3();
                Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple33 = new Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(ll, b, lr);
                Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple34 = tuple33;
                RedBlackTree.Tree<A, B> ll2 = tuple34._1();
                RedBlackTree.Tree<A, B> b2 = tuple34._2();
                RedBlackTree.Tree<A, B> lr2 = tuple34._3();
                tuple3 = new Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(ll2, b2, this.join(lr2, t.key(), t.value(), t.right()));
            } else {
                Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple35 = this.split(t.right(), k, ordering);
                if (tuple35 == null) {
                    throw new MatchError(tuple35);
                }
                RedBlackTree.Tree<A, B> rl = tuple35._1();
                RedBlackTree.Tree<A, B> b = tuple35._2();
                RedBlackTree.Tree<A, B> rr = tuple35._3();
                Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple36 = new Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(rl, b, rr);
                Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple37 = tuple36;
                RedBlackTree.Tree<A, B> rl2 = tuple37._1();
                RedBlackTree.Tree<A, B> b3 = tuple37._2();
                RedBlackTree.Tree<A, B> rr2 = tuple37._3();
                tuple3 = new Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(this.join(t.left(), t.key(), t.value(), rl2), b3, rr2);
            }
        }
        return tuple3;
    }

    private <A, B> Tuple3<RedBlackTree.Tree<A, B>, A, B> splitLast(RedBlackTree.Tree<A, B> t) {
        Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple3;
        if (t.right() == null) {
            tuple3 = new Tuple3<RedBlackTree.Tree<A, B>, A, B>(t.left(), t.key(), t.value());
        } else {
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple32 = this.splitLast(t.right());
            if (tuple32 == null) {
                throw new MatchError(tuple32);
            }
            RedBlackTree.Tree<A, B> tt = tuple32._1();
            A kk = tuple32._2();
            B vv = tuple32._3();
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple33 = new Tuple3<RedBlackTree.Tree<A, B>, A, B>(tt, kk, vv);
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple34 = tuple33;
            RedBlackTree.Tree<A, B> tt2 = tuple34._1();
            A kk2 = tuple34._2();
            B vv2 = tuple34._3();
            tuple3 = new Tuple3<RedBlackTree.Tree<A, B>, A, B>(this.join(t.left(), t.key(), t.value(), tt2), kk2, vv2);
        }
        return tuple3;
    }

    private <A, B> RedBlackTree.Tree<A, B> join2(RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.Tree<A, B> tree;
        if (tl == null) {
            tree = tr;
        } else if (tr == null) {
            tree = tl;
        } else {
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple3 = this.splitLast(tl);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            RedBlackTree.Tree<A, B> ttl = tuple3._1();
            A k = tuple3._2();
            B v = tuple3._3();
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple32 = new Tuple3<RedBlackTree.Tree<A, B>, A, B>(ttl, k, v);
            Tuple3<RedBlackTree.Tree<A, B>, A, B> tuple33 = tuple32;
            RedBlackTree.Tree<A, B> ttl2 = tuple33._1();
            A k2 = tuple33._2();
            B v2 = tuple33._3();
            tree = this.join(ttl2, k2, v2, tr);
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> _union(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree;
        if (t1 == null) {
            tree = t2;
        } else if (t2 == null) {
            tree = t1;
        } else {
            Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple3 = this.split(t1, t2.key(), ordering);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            RedBlackTree.Tree<A, B> l1 = tuple3._1();
            RedBlackTree.Tree<A, B> r1 = tuple3._3();
            Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple2 = new Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(l1, r1);
            Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple22 = tuple2;
            RedBlackTree.Tree<A, B> l12 = tuple22._1();
            RedBlackTree.Tree<A, B> r12 = tuple22._2();
            RedBlackTree.Tree<A, B> tl = this._union(l12, t2.left(), ordering);
            RedBlackTree.Tree<A, B> tr = this._union(r12, t2.right(), ordering);
            tree = this.join(tl, t2.key(), t2.value(), tr);
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> _intersect(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree;
        if (t1 == null || t2 == null) {
            tree = null;
        } else {
            Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple3 = this.split(t1, t2.key(), ordering);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            RedBlackTree.Tree<A, B> l1 = tuple3._1();
            RedBlackTree.Tree<A, B> b = tuple3._2();
            RedBlackTree.Tree<A, B> r1 = tuple3._3();
            Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple32 = new Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(l1, b, r1);
            Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple33 = tuple32;
            RedBlackTree.Tree<A, B> l12 = tuple33._1();
            RedBlackTree.Tree<A, B> b2 = tuple33._2();
            RedBlackTree.Tree<A, B> r12 = tuple33._3();
            RedBlackTree.Tree<A, B> tl = this._intersect(l12, t2.left(), ordering);
            RedBlackTree.Tree<A, B> tr = this._intersect(r12, t2.right(), ordering);
            tree = b2 != null ? this.join(tl, t2.key(), t2.value(), tr) : this.join2(tl, tr);
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> _difference(RedBlackTree.Tree<A, B> t1, RedBlackTree.Tree<A, B> t2, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree;
        if (t1 == null || t2 == null) {
            tree = t1;
        } else {
            Tuple3<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple3 = this.split(t1, t2.key(), ordering);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            RedBlackTree.Tree<A, B> l1 = tuple3._1();
            RedBlackTree.Tree<A, B> r1 = tuple3._3();
            Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple2 = new Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>>(l1, r1);
            Tuple2<RedBlackTree.Tree<A, B>, RedBlackTree.Tree<A, B>> tuple22 = tuple2;
            RedBlackTree.Tree<A, B> l12 = tuple22._1();
            RedBlackTree.Tree<A, B> r12 = tuple22._2();
            RedBlackTree.Tree<A, B> tl = this._difference(l12, t2.left(), ordering);
            RedBlackTree.Tree<A, B> tr = this._difference(r12, t2.right(), ordering);
            tree = this.join2(tl, tr);
        }
        return tree;
    }

    private final RedBlackTree.Tree _tail$1(RedBlackTree.Tree tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        return tree.left() == null ? tree.right() : (this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree.left()) ? this.balLeft(tree.key(), tree.value(), this._tail$1(tree.left()), tree.right()) : RedBlackTree$RedTree$.MODULE$.apply(tree.key(), tree.value(), this._tail$1(tree.left()), tree.right()));
    }

    private final RedBlackTree.Tree _init$1(RedBlackTree.Tree tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty tree");
        }
        return tree.right() == null ? tree.left() : (this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree.right()) ? this.balRight(tree.key(), tree.value(), tree.left(), this._init$1(tree.right())) : RedBlackTree$RedTree$.MODULE$.apply(tree.key(), tree.value(), tree.left(), this._init$1(tree.right())));
    }

    private final RedBlackTree.Tree f$1(int level, int size, int maxUsedDepth$1, Iterator xs$1) {
        RedBlackTree.Tree tree;
        int n = size;
        switch (n) {
            case 0: {
                tree = null;
                break;
            }
            case 1: {
                tree = this.mkTree(level != maxUsedDepth$1 || level == 1, xs$1.next(), null, null, null);
                break;
            }
            default: {
                int leftSize = (size - 1) / 2;
                RedBlackTree.Tree left = this.f$1(level + 1, leftSize, maxUsedDepth$1, xs$1);
                Object x = xs$1.next();
                RedBlackTree.Tree right = this.f$1(level + 1, size - 1 - leftSize, maxUsedDepth$1, xs$1);
                tree = RedBlackTree$BlackTree$.MODULE$.apply(x, null, left, right);
                break;
            }
        }
        return tree;
    }

    private final RedBlackTree.Tree f$2(int level, int size, Iterator xs$2, int maxUsedDepth$2) {
        RedBlackTree.Tree tree;
        int n = size;
        switch (n) {
            case 0: {
                tree = null;
                break;
            }
            case 1: {
                Tuple2 tuple2 = (Tuple2)xs$2.next();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = new Tuple2(k, v);
                Tuple2 tuple23 = tuple22;
                Object k2 = tuple23._1();
                Object v2 = tuple23._2();
                tree = this.mkTree(level != maxUsedDepth$2 || level == 1, k2, v2, null, null);
                break;
            }
            default: {
                int leftSize = (size - 1) / 2;
                RedBlackTree.Tree left = this.f$2(level + 1, leftSize, xs$2, maxUsedDepth$2);
                Tuple2 tuple2 = (Tuple2)xs$2.next();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple24 = new Tuple2(k, v);
                Tuple2 tuple25 = tuple24;
                Object k3 = tuple25._1();
                Object v3 = tuple25._2();
                RedBlackTree.Tree right = this.f$2(level + 1, size - 1 - leftSize, xs$2, maxUsedDepth$2);
                tree = RedBlackTree$BlackTree$.MODULE$.apply(k3, v3, left, right);
                break;
            }
        }
        return tree;
    }

    private final RedBlackTree.Tree fk$1(RedBlackTree.Tree t, Function2 f$3) {
        RedBlackTree.Tree r2;
        Object k = t.key();
        Object v = t.value();
        RedBlackTree.Tree l = t.left();
        RedBlackTree.Tree r = t.right();
        RedBlackTree.Tree l2 = l == null ? null : this.fk$1(l, f$3);
        boolean keep = BoxesRunTime.unboxToBoolean(f$3.apply(k, v));
        RedBlackTree.Tree tree = r2 = r == null ? null : this.fk$1(r, f$3);
        return !keep ? this.join2(l2, r2) : (l2 == l && r2 == r ? t : this.join(l2, k, v, r2));
    }

    private final RedBlackTree.Tree fk$2(RedBlackTree.Tree t, Function1 f$4) {
        RedBlackTree.Tree r2;
        Object k = t.key();
        RedBlackTree.Tree l = t.left();
        RedBlackTree.Tree r = t.right();
        RedBlackTree.Tree l2 = l == null ? null : this.fk$2(l, f$4);
        boolean keep = BoxesRunTime.unboxToBoolean(f$4.apply(k));
        RedBlackTree.Tree tree = r2 = r == null ? null : this.fk$2(r, f$4);
        return !keep ? this.join2(l2, r2) : (l2 == l && r2 == r ? t : this.join(l2, k, t.value(), r2));
    }

    private final void fk$3(RedBlackTree.Tree t, ObjectRef tmpk$1, ObjectRef tmpd$1, Function2 p$1) {
        RedBlackTree.Tree jk;
        Object k = t.key();
        Object v = t.value();
        RedBlackTree.Tree l = t.left();
        RedBlackTree.Tree r = t.right();
        RedBlackTree.Tree l2k = null;
        RedBlackTree.Tree l2d = null;
        RedBlackTree.Tree r2k = null;
        RedBlackTree.Tree r2d = null;
        if (l != null) {
            this.fk$3(l, tmpk$1, tmpd$1, p$1);
            l2k = (RedBlackTree.Tree)tmpk$1.elem;
            l2d = (RedBlackTree.Tree)tmpd$1.elem;
        }
        boolean keep = BoxesRunTime.unboxToBoolean(p$1.apply(k, v));
        if (r != null) {
            this.fk$3(r, tmpk$1, tmpd$1, p$1);
            r2k = (RedBlackTree.Tree)tmpk$1.elem;
            r2d = (RedBlackTree.Tree)tmpd$1.elem;
        }
        RedBlackTree.Tree tree = !keep ? this.join2(l2k, r2k) : (jk = l2k == l && r2k == r ? t : this.join(l2k, k, v, r2k));
        RedBlackTree.Tree jd = keep ? this.join2(l2d, r2d) : (l2d == l && r2d == r ? t : this.join(l2d, k, v, r2d));
        tmpk$1.elem = jk;
        tmpd$1.elem = jd;
    }

    private final void fk$4(RedBlackTree.Tree t, ObjectRef tmpk$2, ObjectRef tmpd$2, Function1 p$2) {
        RedBlackTree.Tree jk;
        Object k = t.key();
        Object v = t.value();
        RedBlackTree.Tree l = t.left();
        RedBlackTree.Tree r = t.right();
        RedBlackTree.Tree l2k = null;
        RedBlackTree.Tree l2d = null;
        RedBlackTree.Tree r2k = null;
        RedBlackTree.Tree r2d = null;
        if (l != null) {
            this.fk$4(l, tmpk$2, tmpd$2, p$2);
            l2k = (RedBlackTree.Tree)tmpk$2.elem;
            l2d = (RedBlackTree.Tree)tmpd$2.elem;
        }
        boolean keep = BoxesRunTime.unboxToBoolean(p$2.apply(k));
        if (r != null) {
            this.fk$4(r, tmpk$2, tmpd$2, p$2);
            r2k = (RedBlackTree.Tree)tmpk$2.elem;
            r2d = (RedBlackTree.Tree)tmpd$2.elem;
        }
        RedBlackTree.Tree tree = !keep ? this.join2(l2k, r2k) : (jk = l2k == l && r2k == r ? t : this.join(l2k, k, v, r2k));
        RedBlackTree.Tree jd = keep ? this.join2(l2d, r2d) : (l2d == l && r2d == r ? t : this.join(l2d, k, v, r2d));
        tmpk$2.elem = jk;
        tmpd$2.elem = jd;
    }

    private final RedBlackTree.Tree delLeft$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        return this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree$1.left()) ? this.balLeft(tree$1.key(), tree$1.value(), this.del(tree$1.left(), k$1, ordering$1), tree$1.right()) : RedBlackTree$RedTree$.MODULE$.apply(tree$1.key(), tree$1.value(), this.del(tree$1.left(), k$1, ordering$1), tree$1.right());
    }

    private final RedBlackTree.Tree delRight$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        return this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree$1.right()) ? this.balRight(tree$1.key(), tree$1.value(), tree$1.left(), this.del(tree$1.right(), k$1, ordering$1)) : RedBlackTree$RedTree$.MODULE$.apply(tree$1.key(), tree$1.value(), tree$1.left(), this.del(tree$1.right(), k$1, ordering$1));
    }

    private final int h$1(RedBlackTree.Tree t, int i) {
        while (t != null) {
            i = this.scala$collection$immutable$RedBlackTree$$isBlackTree(t) ? i + 1 : i;
            t = t.left();
        }
        return i + 1;
    }

    private RedBlackTree$() {
    }
}

