/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import scala.Function0;
import scala.Predef$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.StrictOptimizedSeqFactory;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.Builder;
import scala.collection.mutable.GrowableBuilder;
import scala.runtime.ModuleSerializationProxy;

public final class ArrayDeque$
implements StrictOptimizedSeqFactory<ArrayDeque> {
    public static final ArrayDeque$ MODULE$ = new ArrayDeque$();
    private static final long serialVersionUID = 3L;

    static {
        IterableFactory.$init$(MODULE$);
        SeqFactory.$init$(MODULE$);
        StrictOptimizedSeqFactory.$init$(MODULE$);
    }

    public <A> int $lessinit$greater$default$1() {
        return 16;
    }

    @Override
    public <B> ArrayDeque<B> from(IterableOnce<B> coll) {
        ArrayDeque arrayDeque;
        int s = coll.knownSize();
        if (s >= 0) {
            Object[] array = this.alloc(s);
            Iterator<B> it = coll.iterator();
            int i = 0;
            while (it.hasNext()) {
                array[i] = it.next();
                ++i;
            }
            arrayDeque = new ArrayDeque(array, 0, s);
        } else {
            arrayDeque = (ArrayDeque)((AbstractBuffer)this.empty()).$plus$plus$eq((IterableOnce)coll);
        }
        return arrayDeque;
    }

    @Override
    public <A> Builder<A, ArrayDeque<A>> newBuilder() {
        return new GrowableBuilder<A, ArrayDeque<A>>(){

            public void sizeHint(int size) {
                ((ArrayDeque)this.elems()).ensureSize(size);
            }
        };
    }

    @Override
    public <A> ArrayDeque<A> empty() {
        return new ArrayDeque(this.$lessinit$greater$default$1());
    }

    public final int DefaultInitialSize() {
        return 16;
    }

    public final int StableSize() {
        return 256;
    }

    public Object[] alloc(int len) {
        Predef$.MODULE$.require(len >= 0, (Function0<Object>)(Function0<String> & Serializable)() -> "Non-negative array size required");
        int size = Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(len) << 1;
        Predef$.MODULE$.require(size >= 0, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(58).append("ArrayDeque too big - cannot allocate ArrayDeque of length ").append(len).toString());
        return new Object[Math.max(size, 16)];
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArrayDeque$.class);
    }

    private ArrayDeque$() {
    }
}

