/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent;

import java.util.concurrent.TimeUnit;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0003i3A!\u0001\u0002\u0001\u000f\t91+\u001f8d-\u0006\u0014(BA\u0002\u0005\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0002\u000b\u0005)1oY1mC\u000e\u0001QC\u0001\u0005\u0015'\t\u0001\u0011\u0002\u0005\u0002\u000b\u00175\tA!\u0003\u0002\r\t\t1\u0011I\\=SK\u001aDQA\u0004\u0001\u0005\u0002=\ta\u0001P5oSRtD#\u0001\t\u0011\u0007E\u0001!#D\u0001\u0003!\t\u0019B\u0003\u0004\u0001\u0005\u000bU\u0001!\u0019\u0001\f\u0003\u0003\u0005\u000b\"a\u0006\u000e\u0011\u0005)A\u0012BA\r\u0005\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AC\u000e\n\u0005q!!aA!os\"9a\u0004\u0001a\u0001\n\u0013y\u0012!C5t\t\u00164\u0017N\\3e+\u0005\u0001\u0003C\u0001\u0006\"\u0013\t\u0011CAA\u0004C_>dW-\u00198\t\u000f\u0011\u0002\u0001\u0019!C\u0005K\u0005i\u0011n\u001d#fM&tW\rZ0%KF$\"AJ\u0015\u0011\u0005)9\u0013B\u0001\u0015\u0005\u0005\u0011)f.\u001b;\t\u000f)\u001a\u0013\u0011!a\u0001A\u0005\u0019\u0001\u0010J\u0019\t\r1\u0002\u0001\u0015)\u0003!\u0003)I7\u000fR3gS:,G\r\t\u0005\n]\u0001\u0001\r\u00111A\u0005\n=\nQA^1mk\u0016,\u0012A\u0005\u0005\nc\u0001\u0001\r\u00111A\u0005\nI\n\u0011B^1mk\u0016|F%Z9\u0015\u0005\u0019\u001a\u0004b\u0002\u00161\u0003\u0003\u0005\rA\u0005\u0005\nk\u0001\u0001\r\u0011!Q!\nI\taA^1mk\u0016\u0004\u0003\"B\u001c\u0001\t\u0003y\u0013aA4fi\")\u0011\b\u0001C\u0005u\u0005!r/Y5u\u001b\u0016\f7/\u001e:j]\u001e,E.\u00199tK\u0012$\"a\u000f \u0011\u0005)a\u0014BA\u001f\u0005\u0005\u0011auN\\4\t\u000b}B\u0004\u0019A\u001e\u0002\u000fQLW.Z8vi\")q\u0007\u0001C\u0001\u0003R\u0011!)\u0012\t\u0004\u0015\r\u0013\u0012B\u0001#\u0005\u0005\u0019y\u0005\u000f^5p]\")q\b\u0011a\u0001w!)q\t\u0001C\u0001\u0011\u0006!A/Y6f)\u0005\u0011\u0002\"B$\u0001\t\u0003QEC\u0001\nL\u0011\u0015y\u0014\n1\u0001<\u0011\u0015i\u0005\u0001\"\u0001O\u0003\r\u0001X\u000f\u001e\u000b\u0003M=CQ\u0001\u0015'A\u0002I\t\u0011\u0001\u001f\u0005\u0006%\u0002!\taH\u0001\u0006SN\u001cV\r\u001e\u0005\u0006)\u0002!I!V\u0001\u0007g\u0016$h+\u00197\u0015\u0005\u00192\u0006\"\u0002)T\u0001\u0004\u0011\u0002\"\u0002-\u0001\t\u0013I\u0016\u0001C;og\u0016$h+\u00197\u0015\u0003\u0019\u0002")
public class SyncVar<A> {
    private boolean isDefined = false;
    private A value;

    private boolean isDefined() {
        return this.isDefined;
    }

    private void isDefined_$eq(boolean x$1) {
        this.isDefined = x$1;
    }

    private A value() {
        return this.value;
    }

    private void value_$eq(A x$1) {
        this.value = x$1;
    }

    public synchronized A get() {
        while (!this.isDefined()) {
            this.wait();
        }
        return this.value();
    }

    private long waitMeasuringElapsed(long timeout) {
        long l;
        if (timeout <= 0L) {
            l = 0L;
        } else {
            long start = System.nanoTime();
            this.wait(timeout);
            long elapsed = System.nanoTime() - start;
            l = elapsed < 0L ? 0L : TimeUnit.NANOSECONDS.toMillis(elapsed);
        }
        return l;
    }

    public synchronized Option<A> get(long timeout) {
        long elapsed;
        for (long rest = timeout; !this.isDefined() && rest > 0L; rest -= elapsed) {
            elapsed = this.waitMeasuringElapsed(rest);
        }
        return this.isDefined() ? new Some<A>(this.value()) : None$.MODULE$;
    }

    public synchronized A take() {
        A a;
        try {
            a = this.get();
        }
        finally {
            this.unsetVal();
        }
        return a;
    }

    public synchronized A take(long timeout) {
        A a;
        try {
            a = this.get(timeout).get();
        }
        finally {
            this.unsetVal();
        }
        return a;
    }

    public synchronized void put(A x) {
        while (this.isDefined()) {
            this.wait();
        }
        this.setVal(x);
    }

    public synchronized boolean isSet() {
        return this.isDefined();
    }

    private synchronized void setVal(A x) {
        this.isDefined_$eq(true);
        this.value_$eq(x);
        this.notifyAll();
    }

    private synchronized void unsetVal() {
        this.isDefined_$eq(false);
        this.value_$eq(null);
        this.notifyAll();
    }
}

