/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.ImmutableArray$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public final class ArrayOps$ {
    public static ArrayOps$ MODULE$;

    static {
        new ArrayOps$();
    }

    public <A> Object copyOf(Object original, int newLength) {
        Object[] objectArray;
        Object object = original;
        if (object instanceof Object[]) {
            Object[] objectArray2 = (Object[])object;
            objectArray = Arrays.copyOf(objectArray2, newLength);
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            objectArray = Arrays.copyOf(nArray, newLength);
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            objectArray = Arrays.copyOf(dArray, newLength);
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            objectArray = Arrays.copyOf(lArray, newLength);
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            objectArray = Arrays.copyOf(fArray, newLength);
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            objectArray = Arrays.copyOf(cArray, newLength);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            objectArray = Arrays.copyOf(byArray, newLength);
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            objectArray = Arrays.copyOf(sArray, newLength);
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            objectArray = Arrays.copyOf(blArray, newLength);
        } else if (object instanceof BoxedUnit[]) {
            BoxedUnit[] dest = new BoxedUnit[newLength];
            Array$.MODULE$.copy(original, 0, dest, 0, ScalaRunTime$.MODULE$.array_length(original));
            objectArray = dest;
        } else {
            throw new MatchError(object);
        }
        return objectArray;
    }

    public <A> Object copyAs(Object original, int newLength, ClassTag<A> ct) {
        Object object;
        Class<?> destClass = ct.runtimeClass();
        if (destClass.isAssignableFrom(original.getClass())) {
            object = destClass.getComponentType().isPrimitive() ? this.copyOf(original, newLength) : Arrays.copyOf((Object[])original, newLength, destClass);
        } else {
            Object dest = ct.newArray(newLength);
            Array$.MODULE$.copy(original, 0, dest, 0, ScalaRunTime$.MODULE$.array_length(original));
            object = dest;
        }
        return object;
    }

    public final <A> ClassTag<A> elemTag$extension(Object $this) {
        return ClassTag$.MODULE$.apply($this.getClass().getComponentType());
    }

    public final <A> int size$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this);
    }

    public final <A> boolean isEmpty$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) == 0;
    }

    public final <A> boolean nonEmpty$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) != 0;
    }

    public final <A> A head$extension(Object $this) {
        return (A)ScalaRunTime$.MODULE$.array_apply($this, 0);
    }

    public final <A> A last$extension(Object $this) {
        return (A)ScalaRunTime$.MODULE$.array_apply($this, ScalaRunTime$.MODULE$.array_length($this) - 1);
    }

    public final <A> Option<A> headOption$extension(Object $this) {
        return this.isEmpty$extension($this) ? None$.MODULE$ : new Some<A>(this.head$extension($this));
    }

    public final <A> Option<A> lastOption$extension(Object $this) {
        return this.isEmpty$extension($this) ? None$.MODULE$ : new Some<A>(this.last$extension($this));
    }

    public final <A> Object slice$extension(Object $this, int from, int until) {
        Object[] objectArray;
        int lo = package$.MODULE$.max(from, 0);
        int hi = package$.MODULE$.min(until, ScalaRunTime$.MODULE$.array_length($this));
        int len = hi - lo;
        if (len > 0) {
            Object[] objectArray2;
            Object object = $this;
            if (object instanceof Object[]) {
                Object[] objectArray3 = (Object[])object;
                objectArray2 = Arrays.copyOfRange(objectArray3, lo, hi);
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                objectArray2 = Arrays.copyOfRange(nArray, lo, hi);
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                objectArray2 = Arrays.copyOfRange(dArray, lo, hi);
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                objectArray2 = Arrays.copyOfRange(lArray, lo, hi);
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                objectArray2 = Arrays.copyOfRange(fArray, lo, hi);
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                objectArray2 = Arrays.copyOfRange(cArray, lo, hi);
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                objectArray2 = Arrays.copyOfRange(byArray, lo, hi);
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                objectArray2 = Arrays.copyOfRange(sArray, lo, hi);
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                objectArray2 = Arrays.copyOfRange(blArray, lo, hi);
            } else if (object instanceof BoxedUnit[]) {
                BoxedUnit[] res = new BoxedUnit[len];
                Array$.MODULE$.copy($this, lo, res, 0, len);
                objectArray2 = res;
            } else {
                throw new MatchError(object);
            }
            objectArray = objectArray2;
        } else {
            objectArray = this.elemTag$extension($this).newArray(0);
        }
        return objectArray;
    }

    public final <A> Object tail$extension(Object $this) {
        return this.slice$extension($this, 1, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object init$extension(Object $this) {
        return this.slice$extension($this, 0, ScalaRunTime$.MODULE$.array_length($this) - 1);
    }

    public final <A> Object take$extension(Object $this, int n) {
        return this.slice$extension($this, 0, package$.MODULE$.min(n, ScalaRunTime$.MODULE$.array_length($this)));
    }

    public final <A> Object drop$extension(Object $this, int n) {
        return this.slice$extension($this, package$.MODULE$.min(n, ScalaRunTime$.MODULE$.array_length($this)), ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object takeRight$extension(Object $this, int n) {
        return this.drop$extension($this, ScalaRunTime$.MODULE$.array_length($this) - package$.MODULE$.max(n, 0));
    }

    public final <A> Object dropRight$extension(Object $this, int n) {
        return this.take$extension($this, ScalaRunTime$.MODULE$.array_length($this) - package$.MODULE$.max(n, 0));
    }

    public final <A> Object takeWhile$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$takeWhile$1(p, x)), this.indexWhere$default$2$extension($this));
        int hi = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return this.slice$extension($this, 0, hi);
    }

    public final <A> Object dropWhile$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$dropWhile$1(p, x)), this.indexWhere$default$2$extension($this));
        int lo = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return this.slice$extension($this, lo, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Iterator<A> iterator$extension(Object $this) {
        return new ArrayOps.ArrayIterator($this);
    }

    public final <A> Iterator<Object> grouped$extension(Object $this, int size) {
        return new ArrayOps.GroupedIterator($this, size);
    }

    public final <A> Tuple2<Object, Object> splitAt$extension(Object $this, int n) {
        return new Tuple2<Object, Object>(this.take$extension($this, n), this.drop$extension($this, n));
    }

    public final <A> Tuple2<Object, Object> partition$extension(Object $this, Function1<A, Object> p) {
        ArrayBuilder<A> res1 = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        ArrayBuilder<A> res2 = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object x = ScalaRunTime$.MODULE$.array_apply($this, i);
            (BoxesRunTime.unboxToBoolean(p.apply(x)) ? res1 : res2).$plus$eq((A)x);
        }
        return new Tuple2<Object, Object>(res1.result(), res2.result());
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Object reverse$extension(Object $this) {
        void var3_3;
        int len = ScalaRunTime$.MODULE$.array_length($this);
        Object res = this.elemTag$extension($this).newArray(len);
        for (int i = 0; i < len; ++i) {
            ScalaRunTime$.MODULE$.array_update(res, len - i - 1, ScalaRunTime$.MODULE$.array_apply($this, i));
        }
        return var3_3;
    }

    public final <A> Iterator<A> reverseIterator$extension(Object $this) {
        return new ArrayOps.ReverseIterator($this);
    }

    public final <A> Object filter$extension(Object $this, Function1<A, Object> p) {
        ArrayBuilder<A> res = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object x = ScalaRunTime$.MODULE$.array_apply($this, i);
            Object object = BoxesRunTime.unboxToBoolean(p.apply(x)) ? res.$plus$eq((A)x) : BoxedUnit.UNIT;
        }
        return res.result();
    }

    public final <A> Object filterNot$extension(Object $this, Function1<A, Object> p) {
        return this.filter$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$filterNot$1(p, x)));
    }

    public final <B, A> Object sorted$extension(Object $this, Ordering<B> ord) {
        Object object;
        int len = ScalaRunTime$.MODULE$.array_length($this);
        if ($this.getClass().getComponentType().isPrimitive() && len > 1) {
            int i;
            Object[] a = new Object[len];
            for (i = 0; i < len; ++i) {
                a[i] = ScalaRunTime$.MODULE$.array_apply($this, i);
            }
            Arrays.sort(a, ord);
            Object res = this.elemTag$extension($this).newArray(len);
            for (i = 0; i < len; ++i) {
                ScalaRunTime$.MODULE$.array_update(res, i, a[i]);
            }
            object = res;
        } else {
            Object copy = this.slice$extension($this, 0, len);
            if (len > 1) {
                Arrays.sort((Object[])copy, ord);
            }
            object = copy;
        }
        return object;
    }

    public final <A> Object sortWith$extension(Object $this, Function2<A, A, Object> lt) {
        return this.sorted$extension($this, Ordering$.MODULE$.fromLessThan(lt));
    }

    public final <B, A> Object sortBy$extension(Object $this, Function1<A, B> f, Ordering<B> ord) {
        return this.sorted$extension($this, ord.on(f));
    }

    public final <A> ArrayOps.WithFilter<A> withFilter$extension(Object $this, Function1<A, Object> p) {
        return new ArrayOps.WithFilter<A>(p, $this);
    }

    public final <A> int indexWhere$extension(Object $this, Function1<A, Object> f, int from) {
        for (int i = from; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (!BoxesRunTime.unboxToBoolean(f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int indexWhere$default$2$extension(Object $this) {
        return 0;
    }

    public final <A> Option<A> find$extension(Object $this, Function1<A, Object> f) {
        int idx = this.indexWhere$extension($this, f, this.indexWhere$default$2$extension($this));
        return idx == -1 ? None$.MODULE$ : new Some<Object>(ScalaRunTime$.MODULE$.array_apply($this, idx));
    }

    public final <A> boolean exists$extension(Object $this, Function1<A, Object> f) {
        return this.indexWhere$extension($this, f, this.indexWhere$default$2$extension($this)) >= 0;
    }

    public final <A> boolean forall$extension(Object $this, Function1<A, Object> f) {
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (BoxesRunTime.unboxToBoolean(f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return false;
        }
        return true;
    }

    public final <B, A> B foldLeft$extension(Object $this, B z, Function2<B, A, B> op) {
        B v = z;
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            v = op.apply(v, ScalaRunTime$.MODULE$.array_apply($this, i));
        }
        return v;
    }

    public final <B, A> B foldRight$extension(Object $this, B z, Function2<A, B, B> op) {
        B v = z;
        for (int i = ScalaRunTime$.MODULE$.array_length($this) - 1; i >= 0; --i) {
            v = op.apply(ScalaRunTime$.MODULE$.array_apply($this, i), v);
        }
        return v;
    }

    public final <B, A> Object map$extension(Object $this, Function1<A, B> f, ClassTag<B> evidence$3) {
        Object res = evidence$3.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update(res, i, f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return res;
    }

    public final <A> Object mapInPlace$extension(Object $this, Function1<A, A> f) {
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update($this, i, f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return $this;
    }

    public final <B, A> Object flatMap$extension0(Object $this, Function1<A, IterableOnce<B>> f, ClassTag<B> evidence$4) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$4);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            b.$plus$plus$eq(f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return b.result();
    }

    public final <BS, B, A> Object flatMap$extension1(Object $this, Function1<A, BS> f, Function1<BS, Iterable<B>> asIterable, ClassTag<B> m) {
        return this.flatMap$extension0($this, (Function1<Object, Iterable> & java.io.Serializable & Serializable)x -> (Iterable)asIterable.apply(f.apply(x)), m);
    }

    public final <B, A> Object flatten$extension(Object $this, Function1<A, Iterable<B>> asIterable, ClassTag<B> m) {
        ArrayBuilder b = ArrayBuilder$.MODULE$.make(m);
        int[] sizes = (int[])this.map$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToInteger(ArrayOps$.$anonfun$flatten$1(x0$1)), ClassTag$.MODULE$.Int());
        b.sizeHint(BoxesRunTime.unboxToInt(Predef$.MODULE$.wrapIntArray(sizes).sum(Numeric$IntIsIntegral$.MODULE$)));
        this.foreach$extension($this, (Function1<Object, ArrayBuilder> & java.io.Serializable & Serializable)xs -> (ArrayBuilder)b.$plus$plus$eq((IterableOnce)asIterable.apply(xs)));
        return b.result();
    }

    public final <B, A> Object collect$extension(Object $this, PartialFunction<A, B> f, ClassTag<B> evidence$5) {
        BooleanRef matched = BooleanRef.create(true);
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$5);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            matched.elem = true;
            Object v = f.applyOrElse(ScalaRunTime$.MODULE$.array_apply($this, i), (Function1<Object, Object> & java.io.Serializable & Serializable)x -> ArrayOps$.d$1(x, matched));
            Object object = matched.elem ? b.$plus$eq((B)v) : BoxedUnit.UNIT;
        }
        return b.result();
    }

    public final <B, A> Object $plus$plus$extension(Object $this, Iterable<B> xs, ClassTag<B> evidence$6) {
        return this.appendedAll$extension($this, xs, evidence$6);
    }

    public final <B, A> Tuple2<A, B>[] zip$extension(Object $this, Iterable<B> that) {
        ArrayBuilder.ofRef b = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(Tuple2.class));
        int k = that.knownSize();
        b.sizeHint(k >= 0 ? package$.MODULE$.min(k, ScalaRunTime$.MODULE$.array_length($this)) : ScalaRunTime$.MODULE$.array_length($this));
        Iterator it = that.iterator();
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this) && it.hasNext(); ++i) {
            b.$plus$eq(new Tuple2(ScalaRunTime$.MODULE$.array_apply($this, i), it.next()));
        }
        return (Tuple2[])b.result();
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Tuple2<A, Object>[] zipWithIndex$extension(Object $this) {
        void var2_2;
        Tuple2[] b = new Tuple2[ScalaRunTime$.MODULE$.array_length($this)];
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            b[i] = new Tuple2<Object, Integer>(ScalaRunTime$.MODULE$.array_apply($this, i), BoxesRunTime.boxToInteger(i));
        }
        return var2_2;
    }

    public final <B, A> Object appended$extension(Object $this, B x, ClassTag<B> evidence$7) {
        Object dest = this.copyAs($this, ScalaRunTime$.MODULE$.array_length($this) + 1, evidence$7);
        ScalaRunTime$.MODULE$.array_update(dest, ScalaRunTime$.MODULE$.array_length($this), x);
        return dest;
    }

    public final <B, A> Object $colon$plus$extension(Object $this, B x, ClassTag<B> evidence$8) {
        return this.appended$extension($this, x, evidence$8);
    }

    public final <B, A> Object prepended$extension(Object $this, B x, ClassTag<B> evidence$9) {
        Object dest = evidence$9.newArray(ScalaRunTime$.MODULE$.array_length($this) + 1);
        ScalaRunTime$.MODULE$.array_update(dest, 0, x);
        Array$.MODULE$.copy($this, 0, dest, 1, ScalaRunTime$.MODULE$.array_length($this));
        return dest;
    }

    public final <B, A> Object $plus$colon$extension(Object $this, B x, ClassTag<B> evidence$10) {
        return this.prepended$extension($this, x, evidence$10);
    }

    public final <B, A> Object prependedAll$extension(Object $this, Iterable<B> prefix, ClassTag<B> evidence$11) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$11);
        int k = prefix.knownSize();
        if (k >= 0) {
            b.sizeHint(k + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll((IterableOnce)prefix);
        if (k < 0) {
            b.sizeHint(b.length() + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll($this);
        return b.result();
    }

    public final <B, A> Object $plus$plus$colon$extension(Object $this, Iterable<B> prefix, ClassTag<B> evidence$12) {
        return this.prependedAll$extension($this, prefix, evidence$12);
    }

    public final <B, A> Object appendedAll$extension(Object $this, Iterable<B> suffix, ClassTag<B> evidence$13) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$13);
        int k = suffix.knownSize();
        if (k >= 0) {
            b.sizeHint(k + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll($this);
        b.addAll((IterableOnce)suffix);
        return b.result();
    }

    public final <B, A> Object $colon$plus$plus$extension(Object $this, Iterable<B> suffix, ClassTag<B> evidence$14) {
        return this.appendedAll$extension($this, suffix, evidence$14);
    }

    public final <B, A> Object concat$extension(Object $this, Iterable<B> suffix, ClassTag<B> evidence$15) {
        return this.appendedAll$extension($this, suffix, evidence$15);
    }

    public final <B, A> Object patch$extension(Object $this, int from, IterableOnce<B> other, int replaced, ClassTag<B> evidence$16) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$16);
        int k = other.knownSize();
        if (k >= 0) {
            b.sizeHint(ScalaRunTime$.MODULE$.array_length($this) + k - replaced);
        }
        int chunk1 = from > 0 ? package$.MODULE$.min(from, ScalaRunTime$.MODULE$.array_length($this)) : 0;
        java.io.Serializable serializable = chunk1 > 0 ? b.addAll($this, 0, chunk1) : BoxedUnit.UNIT;
        b.$plus$plus$eq(other);
        int remaining = ScalaRunTime$.MODULE$.array_length($this) - chunk1 - replaced;
        java.io.Serializable serializable2 = remaining > 0 ? b.addAll($this, ScalaRunTime$.MODULE$.array_length($this) - remaining, remaining) : BoxedUnit.UNIT;
        return b.result();
    }

    public final <A1, A2, A> Tuple2<Object, Object> unzip$extension(Object $this, Function1<A, Tuple2<A1, A2>> asPair, ClassTag<A1> ct1, ClassTag<A2> ct2) {
        Object a1 = ct1.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a2 = ct2.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Tuple2<A1, A2> e = asPair.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            ScalaRunTime$.MODULE$.array_update(a1, i, e._1());
            ScalaRunTime$.MODULE$.array_update(a2, i, e._2());
        }
        return new Tuple2<Object, Object>(a1, a2);
    }

    public final <A1, A2, A3, A> Tuple3<Object, Object, Object> unzip3$extension(Object $this, Function1<A, Tuple3<A1, A2, A3>> asTriple, ClassTag<A1> ct1, ClassTag<A2> ct2, ClassTag<A3> ct3) {
        Object a1 = ct1.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a2 = ct2.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a3 = ct3.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Tuple3<A1, A2, A3> e = asTriple.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            ScalaRunTime$.MODULE$.array_update(a1, i, e._1());
            ScalaRunTime$.MODULE$.array_update(a2, i, e._2());
            ScalaRunTime$.MODULE$.array_update(a3, i, e._3());
        }
        return new Tuple3<Object, Object, Object>(a1, a2, a3);
    }

    public final <B, A> Object[] transpose$extension(Object $this, Function1<A, Object> asArray) {
        Object[] objectArray;
        Class<?> aClass = $this.getClass().getComponentType();
        ArrayBuilder.ofRef bb = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(aClass));
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            objectArray = bb.result();
        } else {
            ArrayBuilder[] bs = (ArrayBuilder[])this.map$extension(Predef$.MODULE$.genericArrayOps(asArray.apply(ScalaRunTime$.MODULE$.array_apply($this, 0))), (Function1<Object, ArrayBuilder> & java.io.Serializable & Serializable)x -> ArrayOps$.mkRowBuilder$1(aClass), ClassTag$.MODULE$.apply(ArrayBuilder.class));
            boolean j = false;
            this.foreach$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)xs -> {
                ArrayOps$.$anonfun$transpose$2(bs, asArray, xs);
                return BoxedUnit.UNIT;
            });
            this.foreach$extension(Predef$.MODULE$.refArrayOps(bs), (Function1<ArrayBuilder, ArrayBuilder.ofRef> & java.io.Serializable & Serializable)b -> (ArrayBuilder.ofRef)bb.$plus$eq(b.result()));
            objectArray = bb.result();
        }
        return objectArray;
    }

    public final <U, A> void foreach$extension(Object $this, Function1<A, U> f) {
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            f.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
        }
    }

    public final <A> Object distinct$extension(Object $this) {
        return this.distinctBy$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    public final <B, A> Object distinctBy$extension(Object $this, Function1<A, B> f) {
        return ArrayBuilder$.MODULE$.make(this.elemTag$extension($this)).addAll((IterableOnce)this.iterator$extension($this).distinctBy(f)).result();
    }

    public final <B, A> Object padTo$extension(Object $this, int len, B elem, ClassTag<B> evidence$17) {
        int i;
        int newlen = package$.MODULE$.max(i, len);
        Object dest = this.copyAs($this, newlen, evidence$17);
        for (i = ScalaRunTime$.MODULE$.array_length($this); i < newlen; ++i) {
            ScalaRunTime$.MODULE$.array_update(dest, i, elem);
        }
        return dest;
    }

    public final <A> Range indices$extension(Object $this) {
        return Range$.MODULE$.apply(0, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object diff$extension(Object $this, Seq<? super A> that) {
        return ((WrappedArray)WrappedArray$.MODULE$.make($this).diff((Seq)that)).array();
    }

    public final <A> Object intersect$extension(Object $this, Seq<? super A> that) {
        return ((WrappedArray)WrappedArray$.MODULE$.make($this).intersect((Seq)that)).array();
    }

    public final <K, A> Map<K, Object> groupBy$extension(Object $this, Function1<A, K> f) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            Object elem = ScalaRunTime$.MODULE$.array_apply($this, i);
            K key = f.apply(elem);
            ArrayBuilder bldr = (ArrayBuilder)m.getOrElseUpdate(key, (Function0<ArrayBuilder> & java.io.Serializable & Serializable)() -> ArrayBuilder$.MODULE$.make(MODULE$.elemTag$extension($this)));
            bldr.$plus$eq(elem);
        }
        return m.mapValues((Function1<ArrayBuilder, Object> & java.io.Serializable & Serializable)x$1 -> x$1.result()).toMap(Predef$.MODULE$.$conforms());
    }

    public final <A> scala.collection.immutable.Seq<A> toSeq$extension(Object $this) {
        return this.toIndexedSeq$extension($this);
    }

    public final <A> scala.collection.immutable.IndexedSeq<A> toIndexedSeq$extension(Object $this) {
        return ImmutableArray$.MODULE$.unsafeWrapArray(this.copyOf($this, ScalaRunTime$.MODULE$.array_length($this)));
    }

    public final <A> int hashCode$extension(Object $this) {
        return $this.hashCode();
    }

    public final <A> boolean equals$extension(Object $this, Object x$1) {
        Object object;
        Object object2 = x$1;
        boolean bl = object2 instanceof ArrayOps;
        return bl && BoxesRunTime.equals($this, object = x$1 == null ? null : ((ArrayOps)x$1).xs());
    }

    public static final /* synthetic */ boolean $anonfun$takeWhile$1(Function1 p$1, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$1.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$dropWhile$1(Function1 p$2, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$2.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$filterNot$1(Function1 p$3, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$3.apply(x));
    }

    public static final /* synthetic */ int $anonfun$flatten$1(Object x0$1) {
        int n;
        Object object = x0$1;
        if (object instanceof IndexedSeq) {
            Object object2 = object;
            n = ((SeqOps)object2).size();
        } else {
            n = 0;
        }
        return n;
    }

    private static final Object d$1(Object x, BooleanRef matched$1) {
        matched$1.elem = false;
        return null;
    }

    private static final ArrayBuilder mkRowBuilder$1(Class aClass$1) {
        return ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(aClass$1.getComponentType()));
    }

    public static final /* synthetic */ void $anonfun$transpose$3(ArrayBuilder[] bs$1, IntRef i$1, Object x) {
        bs$1[i$1.elem].$plus$eq(x);
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$transpose$2(ArrayBuilder[] bs$1, Function1 asArray$1, Object xs) {
        IntRef i = IntRef.create(0);
        MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(asArray$1.apply(xs)), (Function1<Object, Object> & java.io.Serializable & Serializable)x -> {
            ArrayOps$.$anonfun$transpose$3(bs$1, i, x);
            return BoxedUnit.UNIT;
        });
    }

    private ArrayOps$() {
        MODULE$ = this;
    }
}

