/*
 * Decompiled with CFR 0.152.
 */
package scala.sys.process;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.sys.process.BasicIO$Uncloseable$;
import scala.sys.process.ProcessIO;
import scala.sys.process.ProcessLogger;
import scala.sys.process.package$;
import scala.sys.process.processInternal$;

public final class BasicIO$ {
    public static BasicIO$ MODULE$;
    private final String Newline;

    static {
        new BasicIO$();
    }

    public final int BufferSize() {
        return 8192;
    }

    public final String Newline() {
        return this.Newline;
    }

    public ProcessIO apply(boolean withIn, Function1<String, BoxedUnit> output, Option<ProcessLogger> log) {
        return new ProcessIO(this.input(withIn), this.processFully(output), this.getErr(log));
    }

    public ProcessIO apply(boolean withIn, StringBuffer buffer, Option<ProcessLogger> log) {
        return new ProcessIO(this.input(withIn), this.processFully(buffer), this.getErr(log));
    }

    public ProcessIO apply(boolean withIn, ProcessLogger log) {
        return new ProcessIO(this.input(withIn), this.processOutFully(log), this.processErrFully(log));
    }

    public Function1<InputStream, BoxedUnit> getErr(Option<ProcessLogger> log) {
        Function1<InputStream, BoxedUnit> function1;
        Option<ProcessLogger> option = log;
        if (option instanceof Some) {
            Some some = (Some)option;
            ProcessLogger lg = (ProcessLogger)some.value();
            function1 = this.processErrFully(lg);
        } else if (None$.MODULE$.equals(option)) {
            function1 = this.toStdErr();
        } else {
            throw new MatchError(option);
        }
        return function1;
    }

    private Function1<InputStream, BoxedUnit> processErrFully(ProcessLogger log) {
        return this.processFully((Function1<String, BoxedUnit>)(Function1<String, Object> & java.io.Serializable & Serializable)x$1 -> {
            log.err((Function0<String> & java.io.Serializable & Serializable)() -> x$1);
            return BoxedUnit.UNIT;
        });
    }

    private Function1<InputStream, BoxedUnit> processOutFully(ProcessLogger log) {
        return this.processFully((Function1<String, BoxedUnit>)(Function1<String, Object> & java.io.Serializable & Serializable)x$2 -> {
            log.out((Function0<String> & java.io.Serializable & Serializable)() -> x$2);
            return BoxedUnit.UNIT;
        });
    }

    public void close(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {}
    }

    public Function1<InputStream, BoxedUnit> processFully(Appendable buffer) {
        return this.processFully(this.appendLine(buffer));
    }

    public Function1<InputStream, BoxedUnit> processFully(Function1<String, BoxedUnit> processLine) {
        return (Function1<InputStream, Object> & java.io.Serializable & Serializable)in -> {
            BasicIO$.$anonfun$processFully$1(this, processLine, in);
            return BoxedUnit.UNIT;
        };
    }

    public void processLinesFully(Function1<String, BoxedUnit> processLine, Function0<String> readLine) {
        this.readFully$1(processLine, readLine);
    }

    public void connectToIn(OutputStream o) {
        this.transferFully(BasicIO$Uncloseable$.MODULE$.protect(package$.MODULE$.stdin()), o);
    }

    public Function1<OutputStream, BoxedUnit> input(boolean connect) {
        return (Function1<OutputStream, Object> & java.io.Serializable & Serializable)outputToProcess -> {
            BasicIO$.$anonfun$input$1(this, connect, outputToProcess);
            return BoxedUnit.UNIT;
        };
    }

    public ProcessIO standard(boolean connectInput) {
        return this.standard(this.input(connectInput));
    }

    public ProcessIO standard(Function1<OutputStream, BoxedUnit> in) {
        return new ProcessIO(in, this.toStdOut(), this.toStdErr());
    }

    public Function1<InputStream, BoxedUnit> toStdErr() {
        return (Function1<InputStream, Object> & java.io.Serializable & Serializable)in -> {
            this.transferFully(in, package$.MODULE$.stderr());
            return BoxedUnit.UNIT;
        };
    }

    public Function1<InputStream, BoxedUnit> toStdOut() {
        return (Function1<InputStream, Object> & java.io.Serializable & Serializable)in -> {
            this.transferFully(in, package$.MODULE$.stdout());
            return BoxedUnit.UNIT;
        };
    }

    public void transferFully(InputStream in, OutputStream out) {
        try {
            this.transferFullyImpl(in, out);
        }
        catch (Throwable x$3) {
            PartialFunction catchExpr$1 = processInternal$.MODULE$.onIOInterrupt((JFunction0$mcV$sp & Serializable)() -> {});
            if (catchExpr$1.isDefinedAt(x$3)) {
                catchExpr$1.apply(x$3);
            }
            throw x$3;
        }
    }

    private Function1<String, BoxedUnit> appendLine(Appendable buffer) {
        return (Function1<String, Object> & java.io.Serializable & Serializable)line -> {
            BasicIO$.$anonfun$appendLine$1(this, buffer, line);
            return BoxedUnit.UNIT;
        };
    }

    private void transferFullyImpl(InputStream in, OutputStream out) {
        byte[] buffer = new byte[8192];
        this.loop$1(in, out, buffer);
        in.close();
    }

    public static final /* synthetic */ void $anonfun$processFully$1(BasicIO$ $this, Function1 processLine$1, InputStream in) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            $this.processLinesFully(processLine$1, (Function0<String> & java.io.Serializable & Serializable)() -> reader.readLine());
        }
    }

    private static final boolean working$1() {
        return !Thread.currentThread().isInterrupted();
    }

    private static final Null$ halting$1() {
        Thread.currentThread().interrupt();
        return null;
    }

    private final void readFully$1(Function1 processLine$2, Function0 readLine$1) {
        block8: {
            BoxedUnit boxedUnit;
            while (BasicIO$.working$1()) {
                String line;
                String string;
                try {
                    string = (String)readLine$1.apply();
                }
                catch (Throwable throwable) {
                    Object var4_3;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InterruptedException) {
                        BasicIO$.halting$1();
                        var4_3 = null;
                    } else if (throwable2 instanceof IOException && !BasicIO$.working$1()) {
                        BasicIO$.halting$1();
                        var4_3 = null;
                    } else {
                        throw throwable;
                    }
                    string = line = var4_3;
                }
                if (line != null) {
                    processLine$2.apply(line);
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                break block8;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$input$1(BasicIO$ $this, boolean connect$1, OutputStream outputToProcess) {
        if (connect$1) {
            $this.connectToIn(outputToProcess);
        }
        outputToProcess.close();
    }

    public static final /* synthetic */ void $anonfun$appendLine$1(BasicIO$ $this, Appendable buffer$1, String line) {
        buffer$1.append(line);
        buffer$1.append($this.Newline());
    }

    private final void loop$1(InputStream in$2, OutputStream out$2, byte[] buffer$2) {
        block3: {
            BoxedUnit boxedUnit;
            int byteCount;
            while ((byteCount = in$2.read(buffer$2)) > 0) {
                boolean available;
                boolean bl;
                out$2.write(buffer$2, 0, byteCount);
                try {
                    out$2.flush();
                    bl = true;
                }
                catch (IOException iOException) {
                    bl = available = false;
                }
                if (available) continue;
                boxedUnit = BoxedUnit.UNIT;
                break block3;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private BasicIO$() {
        MODULE$ = this;
        this.Newline = System.lineSeparator();
    }
}

