/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent;

import java.util.concurrent.TimeUnit;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u000f\t91+\u001f8d-\u0006\u0014(BA\u0002\u0005\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0002\u000b\u0005)1oY1mC\u000e\u0001QC\u0001\u0005\u0015'\t\u0001\u0011\u0002\u0005\u0002\u000b\u00175\tA!\u0003\u0002\r\t\t1\u0011I\\=SK\u001aDQA\u0004\u0001\u0005\u0002=\ta\u0001P5oSRtD#\u0001\t\u0011\u0007E\u0001!#D\u0001\u0003!\t\u0019B\u0003\u0004\u0001\u0005\u000bU\u0001!\u0019\u0001\f\u0003\u0003\u0005\u000b\"a\u0006\u000e\u0011\u0005)A\u0012BA\r\u0005\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AC\u000e\n\u0005q!!aA!os\"9a\u0004\u0001a\u0001\n\u0013y\u0012!C5t\t\u00164\u0017N\\3e+\u0005\u0001\u0003C\u0001\u0006\"\u0013\t\u0011CAA\u0004C_>dW-\u00198\t\u000f\u0011\u0002\u0001\u0019!C\u0005K\u0005i\u0011n\u001d#fM&tW\rZ0%KF$\"AJ\u0015\u0011\u0005)9\u0013B\u0001\u0015\u0005\u0005\u0011)f.\u001b;\t\u000f)\u001a\u0013\u0011!a\u0001A\u0005\u0019\u0001\u0010J\u0019\t\r1\u0002\u0001\u0015)\u0003!\u0003)I7\u000fR3gS:,G\r\t\u0005\n]\u0001\u0001\r\u00111A\u0005\n=\nQA^1mk\u0016,\u0012A\u0005\u0005\nc\u0001\u0001\r\u00111A\u0005\nI\n\u0011B^1mk\u0016|F%Z9\u0015\u0005\u0019\u001a\u0004b\u0002\u00161\u0003\u0003\u0005\rA\u0005\u0005\u0007k\u0001\u0001\u000b\u0015\u0002\n\u0002\rY\fG.^3!\u0011\u00159\u0004\u0001\"\u00010\u0003\r9W\r\u001e\u0005\u0006s\u0001!IAO\u0001\u0015o\u0006LG/T3bgV\u0014\u0018N\\4FY\u0006\u00048/\u001a3\u0015\u0005mr\u0004C\u0001\u0006=\u0013\tiDA\u0001\u0003M_:<\u0007\"B 9\u0001\u0004Y\u0014a\u0002;j[\u0016|W\u000f\u001e\u0005\u0006o\u0001!\t!\u0011\u000b\u0003\u0005\u0016\u00032AC\"\u0013\u0013\t!EA\u0001\u0004PaRLwN\u001c\u0005\u0006\u007f\u0001\u0003\ra\u000f\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u0005i\u0006\\W\rF\u0001\u0013\u0011\u00159\u0005\u0001\"\u0001K)\t\u00112\nC\u0003@\u0013\u0002\u00071\bC\u0003N\u0001\u0011\u0005a*A\u0002tKR$\"AJ(\t\u000bAc\u0005\u0019\u0001\n\u0002\u0003aDC\u0001\u0014*V/B\u0011!bU\u0005\u0003)\u0012\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u00051\u0016AN;tK\u0002\u0002\u0007/\u001e;aA%t7\u000f^3bI2\u0002\u0013m\u001d\u0011ag\u0016$\b\rI5tAA|G/\u001a8uS\u0006dG.\u001f\u0011feJ|'/\f9s_:,\u0017%\u0001-\u0002\rIr\u0013\u0007\r\u00181\u0011\u0015Q\u0006\u0001\"\u0001\\\u0003\r\u0001X\u000f\u001e\u000b\u0003MqCQ\u0001U-A\u0002IAQA\u0018\u0001\u0005\u0002}\tQ![:TKRDQ\u0001\u0019\u0001\u0005\u0002\u0005\fQ!\u001e8tKR$\u0012A\n\u0015\u0005?J\u001bw+I\u0001e\u0003e*8/\u001a\u0011ai\u0006\\W\r\u0019\u0011j]N$X-\u00193-A\u0005\u001c\b\u0005Y;og\u0016$\b\rI5tAA|G/\u001a8uS\u0006dG.\u001f\u0011feJ|'/\f9s_:,\u0007\"\u00024\u0001\t\u00139\u0017AB:fiZ\u000bG\u000e\u0006\u0002'Q\")\u0001+\u001aa\u0001%!)!\u000e\u0001C\u0005C\u0006AQO\\:fiZ\u000bG\u000e")
public class SyncVar<A> {
    private boolean isDefined = false;
    private A value;

    private boolean isDefined() {
        return this.isDefined;
    }

    private void isDefined_$eq(boolean x$1) {
        this.isDefined = x$1;
    }

    private A value() {
        return this.value;
    }

    private void value_$eq(A x$1) {
        this.value = x$1;
    }

    public synchronized A get() {
        while (!this.isDefined()) {
            this.wait();
        }
        return this.value();
    }

    private long waitMeasuringElapsed(long timeout) {
        long l;
        if (timeout <= 0L) {
            l = 0L;
        } else {
            long start = System.nanoTime();
            this.wait(timeout);
            long elapsed = System.nanoTime() - start;
            l = elapsed < 0L ? 0L : TimeUnit.NANOSECONDS.toMillis(elapsed);
        }
        return l;
    }

    public synchronized Option<A> get(long timeout) {
        long elapsed;
        for (long rest = timeout; !this.isDefined() && rest > 0L; rest -= elapsed) {
            elapsed = this.waitMeasuringElapsed(rest);
        }
        return this.isDefined() ? new Some<A>(this.value()) : None$.MODULE$;
    }

    public synchronized A take() {
        A a;
        try {
            a = this.get();
        }
        finally {
            this.unsetVal();
        }
        return a;
    }

    public synchronized A take(long timeout) {
        A a;
        try {
            a = this.get(timeout).get();
        }
        finally {
            this.unsetVal();
        }
        return a;
    }

    public void set(A x) {
        this.setVal(x);
    }

    public synchronized void put(A x) {
        while (this.isDefined()) {
            this.wait();
        }
        this.setVal(x);
    }

    public synchronized boolean isSet() {
        return this.isDefined();
    }

    public synchronized void unset() {
        this.isDefined_$eq(false);
        this.value_$eq(null);
        this.notifyAll();
    }

    private synchronized void setVal(A x) {
        this.isDefined_$eq(true);
        this.value_$eq(x);
        this.notifyAll();
    }

    private synchronized void unsetVal() {
        this.isDefined_$eq(false);
        this.value_$eq(null);
        this.notifyAll();
    }
}

