/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.impl;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.impl.ExecutionContextImpl;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;

public final class ExecutionContextImpl$ {
    public static final ExecutionContextImpl$ MODULE$;

    static {
        new ExecutionContextImpl$();
    }

    public ExecutorService createDefaultExecutorService(Function1<Throwable, BoxedUnit> reporter) {
        int numThreads = this.getInt$1("scala.concurrent.context.numThreads", "x1");
        int maxNoOfThreads = this.getInt$1("scala.concurrent.context.maxThreads", "x1");
        int desiredParallelism = this.range$1(this.getInt$1("scala.concurrent.context.minThreads", "1"), numThreads, maxNoOfThreads);
        int maxExtraThreads = this.getInt$1("scala.concurrent.context.maxExtraThreads", "256");
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(reporter){
            private final Function1 reporter$3;

            public void uncaughtException(Thread thread, Throwable cause) {
                this.reporter$3.apply(cause);
            }
            {
                this.reporter$3 = reporter$3;
            }
        };
        ExecutionContextImpl.DefaultThreadFactory threadFactory = new ExecutionContextImpl.DefaultThreadFactory(true, maxNoOfThreads + maxExtraThreads, "scala-execution-context-global", uncaughtExceptionHandler);
        return new ForkJoinPool(desiredParallelism, uncaughtExceptionHandler, threadFactory){

            public void execute(Runnable runnable) {
                ForkJoinWorkerThread forkJoinWorkerThread;
                ForkJoinTask<V> forkJoinTask;
                Runnable runnable2 = runnable;
                ForkJoinTask<V> forkJoinTask2 = runnable2 instanceof ForkJoinTask ? (forkJoinTask = (ForkJoinTask<V>)((Object)runnable2)) : new ExecutionContextImpl.AdaptedForkJoinTask(runnable2);
                ForkJoinTask<V> fjt = forkJoinTask2;
                Thread thread = Thread.currentThread();
                if (thread instanceof ForkJoinWorkerThread && (forkJoinWorkerThread = (ForkJoinWorkerThread)thread).getPool() == this) {
                    fjt.fork();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    super.execute(fjt);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        };
    }

    public ExecutionContextImpl fromExecutor(Executor e, Function1<Throwable, BoxedUnit> reporter) {
        return new ExecutionContextImpl((Executor)Option$.MODULE$.apply(e).getOrElse((JFunction0 & java.io.Serializable & Serializable)() -> this.createDefaultExecutorService(reporter)), reporter);
    }

    public Function1<Throwable, BoxedUnit> fromExecutor$default$2() {
        return ExecutionContext$.MODULE$.defaultReporter();
    }

    public ExecutionContextImpl fromExecutorService(ExecutorService es, Function1<Throwable, BoxedUnit> reporter) {
        return new ExecutionContextExecutorService(es, reporter){

            private final ExecutorService asExecutorService() {
                return (ExecutorService)this.executor();
            }

            public void execute(Runnable command) {
                this.executor().execute(command);
            }

            public void shutdown() {
                this.asExecutorService().shutdown();
            }

            public List<Runnable> shutdownNow() {
                return this.asExecutorService().shutdownNow();
            }

            public boolean isShutdown() {
                return this.asExecutorService().isShutdown();
            }

            public boolean isTerminated() {
                return this.asExecutorService().isTerminated();
            }

            public boolean awaitTermination(long l, TimeUnit timeUnit) {
                return this.asExecutorService().awaitTermination(l, timeUnit);
            }

            public <T> Future<T> submit(Callable<T> callable) {
                return this.asExecutorService().submit(callable);
            }

            public <T> Future<T> submit(Runnable runnable, T t) {
                return this.asExecutorService().submit(runnable, t);
            }

            public Future<?> submit(Runnable runnable) {
                return this.asExecutorService().submit(runnable);
            }

            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) {
                return this.asExecutorService().invokeAll(callables);
            }

            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) {
                return this.asExecutorService().invokeAll(callables, l, timeUnit);
            }

            public <T> T invokeAny(Collection<? extends Callable<T>> callables) {
                return this.asExecutorService().invokeAny(callables);
            }

            public <T> T invokeAny(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) {
                return this.asExecutorService().invokeAny(callables, l, timeUnit);
            }
        };
    }

    public Function1<Throwable, BoxedUnit> fromExecutorService$default$2() {
        return ExecutionContext$.MODULE$.defaultReporter();
    }

    private final int getInt$1(String name, String string) {
        String string2;
        String string3;
        try {
            string3 = System.getProperty(name, string);
        }
        catch (SecurityException e) {
            string3 = string2 = string;
        }
        int n = string2.charAt(0) == 'x' ? (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)Runtime.getRuntime().availableProcessors() * new StringOps(Predef$.MODULE$.augmentString(string2.substring(1))).toDouble())) : new StringOps(Predef$.MODULE$.augmentString(string2)).toInt();
        return n;
    }

    private final int range$1(int floor, int desired, int ceiling) {
        return package$.MODULE$.min(package$.MODULE$.max(floor, desired), ceiling);
    }

    private ExecutionContextImpl$() {
        MODULE$ = this;
    }
}

