/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Numeric$BigDecimalAsIfIntegral$;
import scala.math.Numeric$BigIntIsIntegral$;
import scala.math.Numeric$ByteIsIntegral$;
import scala.math.Numeric$CharIsIntegral$;
import scala.math.Numeric$DoubleAsIfIntegral$;
import scala.math.Numeric$FloatAsIfIntegral$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Numeric$ShortIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$BigDecimal$;
import scala.math.Ordering$BigInt$;
import scala.math.Ordering$Byte$;
import scala.math.Ordering$Char$;
import scala.math.Ordering$Double$;
import scala.math.Ordering$Float$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$Long$;
import scala.math.Ordering$Short$;
import scala.runtime.BoxesRunTime;

public final class NumericRange$
implements Serializable {
    public static final NumericRange$ MODULE$;
    private final Map<Numeric<?>, Ordering<?>> defaultOrdering;

    static {
        new NumericRange$();
    }

    public <T> int count(T start, T end, T step, boolean isInclusive, Integral<T> num) {
        int n;
        Object zero = num.zero();
        boolean upward = num.lt(start, end);
        boolean posStep = num.gt(step, zero);
        if (BoxesRunTime.equals(step, zero)) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        if (BoxesRunTime.equals(start, end)) {
            n = isInclusive ? 1 : 0;
        } else if (upward != posStep) {
            n = 0;
        } else {
            Object object;
            int endside;
            int stepint;
            int endint;
            int startint = num.toInt(start);
            if (BoxesRunTime.equals(start, num.fromInt(startint)) && BoxesRunTime.equals(end, num.fromInt(endint = num.toInt(end))) && BoxesRunTime.equals(step, num.fromInt(stepint = num.toInt(step)))) {
                return isInclusive ? Range$.MODULE$.inclusive(startint, endint, stepint).length() : Range$.MODULE$.apply(startint, endint, stepint).length();
            }
            Object one = num.one();
            Object limit = num.fromInt(Integer.MAX_VALUE);
            int startside = num.signum(start);
            if (startside * (endside = num.signum(end)) >= 0) {
                T diff = num.minus(end, start);
                Object quotient = this.check$1(num.quot(diff, step), num, limit);
                Object remainder = num.minus(diff, num.times(quotient, step));
                object = !isInclusive && BoxesRunTime.equals(zero, remainder) ? quotient : this.check$1(num.plus(quotient, one), num, limit);
            } else {
                Object object2;
                Object negone = num.fromInt(-1);
                Object startlim = posStep ? negone : one;
                Object startdiff = num.minus(startlim, start);
                Object startq = this.check$1(num.quot(startdiff, step), num, limit);
                Object waypointA = BoxesRunTime.equals(startq, zero) ? start : num.plus(start, num.times(startq, step));
                T waypointB = num.plus(waypointA, step);
                if (num.lt(waypointB, end) != upward) {
                    object2 = isInclusive && BoxesRunTime.equals(waypointB, end) ? num.plus(startq, num.fromInt(2)) : num.plus(startq, one);
                } else {
                    T enddiff = num.minus(end, waypointB);
                    Object endq = this.check$1(num.quot(enddiff, step), num, limit);
                    T last = BoxesRunTime.equals(endq, zero) ? waypointB : num.plus(waypointB, num.times(endq, step));
                    object2 = num.plus(startq, num.plus(endq, !isInclusive && BoxesRunTime.equals(last, end) ? one : num.fromInt(2)));
                }
                object = this.check$1(object2, num, limit);
            }
            n = num.toInt(object);
        }
        return n;
    }

    public <T> NumericRange.Exclusive<T> apply(T start, T end, T step, Integral<T> num) {
        return new NumericRange.Exclusive<T>(start, end, step, num);
    }

    public <T> NumericRange.Inclusive<T> inclusive(T start, T end, T step, Integral<T> num) {
        return new NumericRange.Inclusive<T>(start, end, step, num);
    }

    public Map<Numeric<?>, Ordering<?>> defaultOrdering() {
        return this.defaultOrdering;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Object check$1(Object t, Integral num$1, Object limit$1) {
        if (num$1.gt(t, limit$1)) {
            throw new IllegalArgumentException("More than Int.MaxValue elements.");
        }
        return t;
    }

    private NumericRange$() {
        MODULE$ = this;
        this.defaultOrdering = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$BigIntIsIntegral$.MODULE$), Ordering$BigInt$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$IntIsIntegral$.MODULE$), Ordering$Int$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$ShortIsIntegral$.MODULE$), Ordering$Short$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$ByteIsIntegral$.MODULE$), Ordering$Byte$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$CharIsIntegral$.MODULE$), Ordering$Char$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$LongIsIntegral$.MODULE$), Ordering$Long$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$FloatAsIfIntegral$.MODULE$), Ordering$Float$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$DoubleAsIfIntegral$.MODULE$), Ordering$Double$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$BigDecimalAsIfIntegral$.MODULE$), Ordering$BigDecimal$.MODULE$)}));
    }
}

