/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.PatternSyntaxException;
import scala.Predef$;
import scala.Serializable;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringLike;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.WrappedString;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.math.ScalaNumber;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.matching.Regex;
import scala.util.matching.Regex$;

public abstract class StringLike$class {
    private static /* synthetic */ Map $deserializeLambdaCache$;

    public static char apply(StringLike $this, int n) {
        return $this.toString().charAt(n);
    }

    public static int length(StringLike $this) {
        return $this.toString().length();
    }

    public static String mkString(StringLike $this) {
        return $this.toString();
    }

    public static Object slice(StringLike $this, int from, int until) {
        int end;
        int start = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(from), 0);
        return start >= (end = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(until), $this.length())) ? $this.newBuilder().result() : ((Builder)$this.newBuilder().$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString($this.toString().substring(start, end))))).result();
    }

    public static String $times(StringLike $this, int n) {
        StringBuilder buf = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((JFunction1 & java.io.Serializable & Serializable)i -> buf.append($this.toString()));
        return buf.toString();
    }

    public static int compare(StringLike $this, String other) {
        return $this.toString().compareTo(other);
    }

    public static boolean scala$collection$immutable$StringLike$$isLineBreak(StringLike $this, char c) {
        return c == '\n' || c == '\f';
    }

    public static String stripLineEnd(StringLike $this) {
        String string;
        int len = $this.toString().length();
        if (len == 0) {
            string = $this.toString();
        } else {
            char last = $this.apply(len - 1);
            string = StringLike$class.scala$collection$immutable$StringLike$$isLineBreak($this, last) ? $this.toString().substring(0, last == '\n' && len >= 2 && $this.apply(len - 2) == '\r' ? len - 2 : len - 1) : $this.toString();
        }
        return string;
    }

    public static Iterator linesWithSeparators(StringLike $this) {
        return new AbstractIterator<String>($this){
            private final String str;
            private final int len;
            private int index;
            private final /* synthetic */ StringLike $outer;

            private String str() {
                return this.str;
            }

            private int len() {
                return this.len;
            }

            private int index() {
                return this.index;
            }

            private void index_$eq(int x$1) {
                this.index = x$1;
            }

            public boolean hasNext() {
                return this.index() < this.len();
            }

            public String next() {
                if (this.index() >= this.len()) {
                    throw new NoSuchElementException("next on empty iterator");
                }
                int start = this.index();
                while (this.index() < this.len() && !StringLike$class.scala$collection$immutable$StringLike$$isLineBreak(this.$outer, this.$outer.apply(this.index()))) {
                    this.index_$eq(this.index() + 1);
                }
                this.index_$eq(this.index() + 1);
                return this.str().substring(start, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.index()), this.len()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.str = $outer.toString();
                this.len = this.str().length();
                this.index = 0;
            }
        };
    }

    public static Iterator lines(StringLike $this) {
        return $this.linesWithSeparators().map((JFunction1 & java.io.Serializable & Serializable)line -> new WrappedString((String)line).stripLineEnd());
    }

    public static Iterator linesIterator(StringLike $this) {
        return $this.linesWithSeparators().map((JFunction1 & java.io.Serializable & Serializable)line -> new WrappedString((String)line).stripLineEnd());
    }

    public static String capitalize(StringLike $this) {
        String string;
        if ($this.toString() == null) {
            string = null;
        } else if ($this.toString().length() == 0) {
            string = "";
        } else if (RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper($this.toString().charAt(0)))) {
            string = $this.toString();
        } else {
            char[] chars = $this.toString().toCharArray();
            chars[0] = RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(chars[0]));
            string = new String(chars);
        }
        return string;
    }

    public static String stripPrefix(StringLike $this, String prefix) {
        return $this.toString().startsWith(prefix) ? $this.toString().substring(prefix.length()) : $this.toString();
    }

    public static String stripSuffix(StringLike $this, String suffix) {
        return $this.toString().endsWith(suffix) ? $this.toString().substring(0, $this.toString().length() - suffix.length()) : $this.toString();
    }

    public static String replaceAllLiterally(StringLike $this, String literal, String replacement) {
        String arg1 = Regex$.MODULE$.quote(literal);
        String arg2 = Regex$.MODULE$.quoteReplacement(replacement);
        return $this.toString().replaceAll(arg1, arg2);
    }

    public static String stripMargin(StringLike $this, char marginChar) {
        StringBuilder buf = new StringBuilder();
        $this.linesWithSeparators().foreach((JFunction1 & java.io.Serializable & Serializable)line -> {
            int index;
            int len = line.length();
            for (index = 0; index < len && line.charAt(index) <= ' '; ++index) {
            }
            return buf.append(index < len && line.charAt(index) == marginChar ? line.substring(index + 1) : line);
        });
        return buf.toString();
    }

    public static String stripMargin(StringLike $this) {
        return $this.stripMargin('|');
    }

    private static String escape(StringLike $this, char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' ? ((Object)BoxesRunTime.boxToCharacter(ch)).toString() : new StringBuilder().append((Object)"\\").append(BoxesRunTime.boxToCharacter(ch)).toString();
    }

    public static String[] split(StringLike $this, char separator) {
        return $this.toString().split(StringLike$class.escape($this, separator));
    }

    public static String[] split(StringLike $this, char[] separators) throws PatternSyntaxException {
        String re = new StringBuilder().append((Object)new ArrayOps.ofChar(Predef$.MODULE$._charArrayOps(separators)).foldLeft("[", (JFunction2 & java.io.Serializable & Serializable)(x$12, x$2) -> StringLike$class.scala$collection$immutable$StringLike$class$$$anonfun$5($this, x$12, BoxesRunTime.unboxToChar(x$2)))).append((Object)"]").toString();
        return $this.toString().split(re);
    }

    public static Regex r(StringLike $this) {
        return $this.r(Nil$.MODULE$);
    }

    public static Regex r(StringLike $this, Seq groupNames) {
        return new Regex($this.toString(), (Seq<String>)groupNames);
    }

    public static boolean toBoolean(StringLike $this) {
        return StringLike$class.parseBoolean($this, $this.toString());
    }

    public static byte toByte(StringLike $this) {
        return Byte.parseByte($this.toString());
    }

    public static short toShort(StringLike $this) {
        return Short.parseShort($this.toString());
    }

    public static int toInt(StringLike $this) {
        return Integer.parseInt($this.toString());
    }

    public static long toLong(StringLike $this) {
        return Long.parseLong($this.toString());
    }

    public static float toFloat(StringLike $this) {
        return Float.parseFloat($this.toString());
    }

    public static double toDouble(StringLike $this) {
        return Double.parseDouble($this.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean parseBoolean(StringLike $this, String s) {
        if (s == null) throw new IllegalArgumentException("For input string: \"null\"");
        String string = s.toLowerCase();
        if ("true".equals(string)) return true;
        if ("false".equals(string)) return false;
        throw new IllegalArgumentException(new StringBuilder().append((Object)"For input string: \"").append((Object)s).append((Object)"\"").toString());
    }

    public static Object toArray(StringLike $this, ClassTag evidence$1) {
        return $this.toString().toCharArray();
    }

    private static Object unwrapArg(StringLike $this, Object arg) {
        Object object;
        Object object2 = arg;
        if (object2 instanceof ScalaNumber) {
            ScalaNumber scalaNumber = (ScalaNumber)object2;
            object = scalaNumber.underlying();
        } else {
            object = object2;
        }
        return object;
    }

    public static String format(StringLike $this, Seq args) {
        return String.format($this.toString(), (Object[])((TraversableOnce)args.map((JFunction1 & java.io.Serializable & Serializable)arg -> StringLike$class.unwrapArg($this, arg), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public static String formatLocal(StringLike $this, Locale l, Seq args) {
        return String.format(l, $this.toString(), (Object[])((TraversableOnce)args.map((JFunction1 & java.io.Serializable & Serializable)arg -> StringLike$class.unwrapArg($this, arg), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public static final /* synthetic */ String scala$collection$immutable$StringLike$class$$$anonfun$5(StringLike $this, String x$1, char x$2) {
        return new StringBuilder().append((Object)x$1).append((Object)StringLike$class.escape($this, x$2)).toString();
    }

    public static void $init$(StringLike $this) {
    }
}

