/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.AbstractSeq;
import scala.collection.CustomParallelizable;
import scala.collection.CustomParallelizable$class;
import scala.collection.GenSeqLike$class;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$class;
import scala.collection.IndexedSeqLike$class;
import scala.collection.Iterator;
import scala.collection.TraversableOnce$class;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.Iterable$class;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range$;
import scala.collection.immutable.Seq$class;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Traversable$class;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.immutable.ParRange;
import scala.math.Numeric;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0011]c\u0001B\u0001\u0003\u0001%\u0011QAU1oO\u0016T!a\u0001\u0003\u0002\u0013%lW.\u001e;bE2,'BA\u0003\u0007\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u000f\u0005)1oY1mC\u000e\u00011#\u0002\u0001\u000b%Y\u0001\u0003cA\u0006\r\u001d5\tA!\u0003\u0002\u000e\t\tY\u0011IY:ue\u0006\u001cGoU3r!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0002J]R\u00042a\u0005\u000b\u000f\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0005\u0017]q\u0011$\u0003\u0002\u0019\t\t!2)^:u_6\u0004\u0016M]1mY\u0016d\u0017N_1cY\u0016\u0004\"A\u0007\u0010\u000e\u0003mQ!a\u0001\u000f\u000b\u0005u!\u0011\u0001\u00039be\u0006dG.\u001a7\n\u0005}Y\"\u0001\u0003)beJ\u000bgnZ3\u0011\u0005=\t\u0013B\u0001\u0012\u0007\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!!\u0003A!b\u0001\n\u0003)\u0013!B:uCJ$X#\u0001\b\t\u0011\u001d\u0002!\u0011!Q\u0001\n9\taa\u001d;beR\u0004\u0003\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011A\u0013\u0002\u0007\u0015tG\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003\u000f\u0003\u0011)g\u000e\u001a\u0011\t\u00115\u0002!Q1A\u0005\u0002\u0015\nAa\u001d;fa\"Aq\u0006\u0001B\u0001B\u0003%a\"A\u0003ti\u0016\u0004\b\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0005gQ*d\u0007\u0005\u0002\u0014\u0001!)A\u0005\ra\u0001\u001d!)\u0011\u0006\ra\u0001\u001d!)Q\u0006\ra\u0001\u001d!)\u0001\b\u0001C!s\u0005\u0019\u0001/\u0019:\u0016\u0003eAQa\u000f\u0001\u0005\nq\n1aZ1q+\u0005i\u0004CA\b?\u0013\tydA\u0001\u0003M_:<\u0007\"B!\u0001\t\u0013\u0011\u0015aB5t\u000bb\f7\r^\u000b\u0002\u0007B\u0011q\u0002R\u0005\u0003\u000b\u001a\u0011qAQ8pY\u0016\fg\u000eC\u0003H\u0001\u0011%!)A\u0004iCN\u001cF/\u001e2\t\u000b%\u0003A\u0011\u0002\u001f\u0002\u00151|gn\u001a'f]\u001e$\b\u000eC\u0004L\u0001\t\u0007IQ\t\"\u0002\u000f%\u001cX)\u001c9us\"1Q\n\u0001Q\u0001\u000e\r\u000b\u0001\"[:F[B$\u0018\u0010\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u0002&\u0003AqW/\u001c*b]\u001e,W\t\\3nK:$8\u000f\u000b\u0003O#R3\u0006CA\bS\u0013\t\u0019fA\u0001\u0006eKB\u0014XmY1uK\u0012\f\u0013!V\u00018)\"L7\u000fI7fi\"|G\rI<jY2\u0004#-\u001a\u0011nC\u0012,\u0007\u0005\u001d:jm\u0006$X\r\f\u0011vg\u0016\u0004\u0003\r\\3oORD\u0007\rI5ogR,\u0017\r\u001a\u0018\"\u0003]\u000bAA\r\u00182c!1\u0011\f\u0001Q\u0001\u000e9\t\u0011C\\;n%\u0006tw-Z#mK6,g\u000e^:!\u0011\u001dY\u0006A1A\u0005\u0006\u0015\n1\u0002\\1ti\u0016cW-\\3oi\"\"!,U/WC\u0005q\u0016!\u000e+iSN\u0004S.\u001a;i_\u0012\u0004s/\u001b7mA\t,\u0007%\\1eK\u0002\u0002(/\u001b<bi\u0016d\u0003%^:fA\u0001d\u0017m\u001d;aA%t7\u000f^3bI:Ba\u0001\u0019\u0001!\u0002\u001bq\u0011\u0001\u00047bgR,E.Z7f]R\u0004\u0003b\u00022\u0001\u0005\u0004%)!J\u0001\u0010i\u0016\u0014X.\u001b8bY\u0016cW-\\3oi\"\"\u0011-\u00153WC\u0005)\u0017!\t+iSN\u0004S.\u001a;i_\u0012\u0004s/\u001b7mA\t,\u0007%\\1eK\u0002\u0002(/\u001b<bi\u0016t\u0003BB4\u0001A\u00035a\"\u0001\tuKJl\u0017N\\1m\u000b2,W.\u001a8uA!)\u0011\u000e\u0001C!K\u0005!A.Y:u\u0011\u0015Y\u0007\u0001\"\u0011&\u0003\u0011AW-\u00193\t\u000b5\u0004A\u0011\t8\u0002\u00075Lg.\u0006\u0002pwR\u0011a\u0002\u001d\u0005\u0006c2\u0004\u001dA]\u0001\u0004_J$\u0007cA:ws:\u0011q\u0002^\u0005\u0003k\u001a\tq\u0001]1dW\u0006<W-\u0003\u0002xq\nAqJ\u001d3fe&twM\u0003\u0002v\rA\u0011!p\u001f\u0007\u0001\t\u0015aHN1\u0001~\u0005\t\t\u0015'\u0005\u0002\u000f}B\u0011qb`\u0005\u0004\u0003\u00031!aA!os\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0011aA7bqV!\u0011\u0011BA\t)\rq\u00111\u0002\u0005\bc\u0006\r\u00019AA\u0007!\u0011\u0019h/a\u0004\u0011\u0007i\f\t\u0002\u0002\u0004}\u0003\u0007\u0011\r! \u0005\b\u0003+\u0001A\u0011CA\f\u0003\u0011\u0019w\u000e]=\u0015\u000fM\nI\"a\u0007\u0002\u001e!1A%a\u0005A\u00029Aa!KA\n\u0001\u0004q\u0001BB\u0017\u0002\u0014\u0001\u0007a\u0002C\u0004\u0002\"\u0001!\t!a\t\u0002\u0005\tLHcA\u001a\u0002&!1Q&a\bA\u00029Aa!!\u000b\u0001\t\u0003\u0011\u0015aC5t\u0013:\u001cG.^:jm\u0016Da!!\f\u0001\t\u0003*\u0013\u0001B:ju\u0016Da!!\r\u0001\t\u0003*\u0013A\u00027f]\u001e$\b\u000eC\u0004\u00026\u0001!I!a\u000e\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u000b\u0003\u0003s\u0001B!a\u000f\u0002B9\u0019q\"!\u0010\n\u0007\u0005}b!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\n)E\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u007f1\u0001bBA%\u0001\u0011%\u00111J\u0001\u0005M\u0006LG\u000e\u0006\u0002\u0002NA\u0019q\"a\u0014\n\u0007\u0005EcAA\u0004O_RD\u0017N\\4\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X\u0005\tb/\u00197jI\u0006$X-T1y\u0019\u0016tw\r\u001e5\u0015\u0005\u0005e\u0003cA\b\u0002\\%\u0019\u0011Q\f\u0004\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003C\u0002AQAA2\u0003\u0015\t\u0007\u000f\u001d7z)\rq\u0011Q\r\u0005\b\u0003O\ny\u00061\u0001\u000f\u0003\rIG\r\u001f\u0005\b\u0003W\u0002AQIA7\u0003\u001d1wN]3bG\",B!a\u001c\u0002~Q!\u0011\u0011LA9\u0011!\t\u0019(!\u001bA\u0002\u0005U\u0014!\u00014\u0011\r=\t9HDA>\u0013\r\tIH\u0002\u0002\n\rVt7\r^5p]F\u00022A_A?\t1\ty(!\u001b!\u0002\u0003\u0005)\u0019AAA\u0005\u0005)\u0016cAA'}\"2\u0011QPAC\u0003\u0017\u00032aDAD\u0013\r\tII\u0002\u0002\fgB,7-[1mSj,G-M\u0004%\u0003\u001b\u000by)!%\u000f\u0007=\ty)C\u0002\u0002\u0012\u001a\tA!\u00168ji\"\"\u0011\u0011NAK!\ry\u0011qS\u0005\u0004\u000333!AB5oY&tW\rC\u0004\u0002\u001e\u0002!)%a(\u0002\tQ\f7.\u001a\u000b\u0004g\u0005\u0005\u0006bBAR\u00037\u0003\rAD\u0001\u0002]\"9\u0011q\u0015\u0001\u0005F\u0005%\u0016\u0001\u00023s_B$2aMAV\u0011\u001d\t\u0019+!*A\u00029Aq!a,\u0001\t\u0003\n\t,A\u0003tY&\u001cW\rF\u00034\u0003g\u000b9\fC\u0004\u00026\u00065\u0006\u0019\u0001\b\u0002\t\u0019\u0014x.\u001c\u0005\b\u0003s\u000bi\u000b1\u0001\u000f\u0003\u0015)h\u000e^5m\u0011\u001d\ti\f\u0001C#\u0003\u007f\u000bA!\u001b8jiV\t1\u0007C\u0004\u0002D\u0002!)%a0\u0002\tQ\f\u0017\u000e\u001c\u0005\b\u0003\u000f\u0004A\u0011BAe\u00031\t'o\u001a+bW\u0016<\u0006.\u001b7f)\ri\u00141\u001a\u0005\t\u0003\u001b\f)\r1\u0001\u0002P\u0006\t\u0001\u000fE\u0003\u0010\u0003or1\tC\u0004\u0002T\u0002!I!!6\u0002\u001d1|7-\u0019;j_:\fe\r^3s\u001dR\u0019a\"a6\t\u000f\u0005\r\u0016\u0011\u001ba\u0001\u001d!9\u00111\u001c\u0001\u0005\n\u0005u\u0017!\u00048fo\u0016k\u0007\u000f^=SC:<W\rF\u00024\u0003?Dq!!9\u0002Z\u0002\u0007a\"A\u0003wC2,X\rC\u0004\u0002f\u0002!)%a:\u0002\u0013Q\f7.Z,iS2,GcA\u001a\u0002j\"A\u0011QZAr\u0001\u0004\ty\rC\u0004\u0002n\u0002!)%a<\u0002\u0013\u0011\u0014x\u000e],iS2,GcA\u001a\u0002r\"A\u0011QZAv\u0001\u0004\ty\rC\u0004\u0002v\u0002!)%a>\u0002\tM\u0004\u0018M\u001c\u000b\u0005\u0003s\fy\u0010E\u0003\u0010\u0003w\u001c4'C\u0002\u0002~\u001a\u0011a\u0001V;qY\u0016\u0014\u0004\u0002CAg\u0003g\u0004\r!a4\t\u000f\t\r\u0001\u0001\"\u0012\u0003\u0006\u000591\u000f\u001d7ji\u0006#H\u0003BA}\u0005\u000fAq!a)\u0003\u0002\u0001\u0007a\u0002C\u0004\u0003\f\u0001!)E!\u0004\u0002\u0013Q\f7.\u001a*jO\"$HcA\u001a\u0003\u0010!9\u00111\u0015B\u0005\u0001\u0004q\u0001b\u0002B\n\u0001\u0011\u0015#QC\u0001\nIJ|\u0007OU5hQR$2a\rB\f\u0011\u001d\t\u0019K!\u0005A\u00029AqAa\u0007\u0001\t\u000b\ny,A\u0004sKZ,'o]3\t\u000f\t}\u0001\u0001\"\u0001\u0002@\u0006I\u0011N\\2mkNLg/\u001a\u0005\b\u0005G\u0001AQ\u0001B\u0013\u0003!\u0019wN\u001c;bS:\u001cHcA\"\u0003(!9!\u0011\u0006B\u0011\u0001\u0004q\u0011!\u0001=\t\u000f\t5\u0002\u0001\"\u0012\u00030\u0005\u00191/^7\u0016\t\tE\"q\b\u000b\u0004\u001d\tM\u0002\u0002\u0003B\u001b\u0005W\u0001\u001dAa\u000e\u0002\u00079,X\u000eE\u0003t\u0005s\u0011i$C\u0002\u0003<a\u0014qAT;nKJL7\rE\u0002{\u0005\u007f!qA!\u0011\u0003,\t\u0007QPA\u0001C\u0011\u001d\u0011)\u0005\u0001C!\u0003\u007f\u000b!\u0002^8Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0011I\u0005\u0001C!\u0003\u007f\u000bQ\u0001^8TKFDqA!\u0014\u0001\t\u0003\u0012y%\u0001\u0004fcV\fGn\u001d\u000b\u0004\u0007\nE\u0003b\u0002B*\u0005\u0017\u0002\rA`\u0001\u0006_RDWM\u001d\u0005\b\u0005/\u0002A\u0011\tB-\u0003!!xn\u0015;sS:<GCAA\u001dQ\u001d\u0001!Q\fB2\u0005O\u00022a\u0004B0\u0013\r\u0011\tG\u0002\u0002\u0016I\u0016\u0004(/Z2bi\u0016$\u0017J\u001c5fe&$\u0018M\\2fC\t\u0011)'\u0001#UQ\u0016\u0004\u0013.\u001c9mK6,g\u000e^1uS>t\u0007\u0005Z3uC&d7\u000fI8gAI\u000bgnZ3![\u0006\\Wm\u001d\u0011j]\",'/\u001b;j]\u001e\u0004cM]8nA%$\b%\u001e8xSN,g&\t\u0002\u0003j\u00051!GL\u00192]ABs\u0001\u0001B7\u0003C\u0014\u0019\bE\u0002\u0010\u0005_J1A!\u001d\u0007\u0005A\u0019VM]5bYZ+'o]5p]VKEI\b\u0005jw\u000f&66\u0006\u001a\u000e\u000f\u001d\u00119H\u0001E\u0001\u0005s\nQAU1oO\u0016\u00042a\u0005B>\r\u0019\t!\u0001#\u0001\u0003~M)!1\u0010B@AA\u0019qB!!\n\u0007\t\reA\u0001\u0004B]f\u0014VM\u001a\u0005\bc\tmD\u0011\u0001BD)\t\u0011I\b\u0003\u0006\u0003\f\nm$\u0019!C\u0001\u0005\u0015\n\u0011\"T!Y?B\u0013\u0016J\u0014+\t\u0011\t=%1\u0010Q\u0001\n9\t!\"T!Y?B\u0013\u0016J\u0014+!\u0011!\u0011\u0019Ja\u001f\u0005\u0002\tU\u0015!B2pk:$H#\u0003\b\u0003\u0018\ne%1\u0014BO\u0011\u0019!#\u0011\u0013a\u0001\u001d!1\u0011F!%A\u00029Aa!\fBI\u0001\u0004q\u0001bBA\u0015\u0005#\u0003\ra\u0011\u0005\t\u0005'\u0013Y\b\"\u0001\u0003\"R9aBa)\u0003&\n\u001d\u0006B\u0002\u0013\u0003 \u0002\u0007a\u0002\u0003\u0004*\u0005?\u0003\rA\u0004\u0005\u0007[\t}\u0005\u0019\u0001\b\u0007\u000f\t-&1\u0010\u0001\u0003.\nI\u0011J\\2mkNLg/Z\n\u0004\u0005S\u001b\u0004B\u0003\u0013\u0003*\n\u0005\t\u0015!\u0003\u000fG!Q\u0011F!+\u0003\u0002\u0003\u0006IA\u0004\u0015\t\u00155\u0012IK!A!\u0002\u0013qA\u0006C\u00042\u0005S#\tAa.\u0015\u0011\te&Q\u0018B`\u0005\u0003\u0004BAa/\u0003*6\u0011!1\u0010\u0005\u0007I\tU\u0006\u0019\u0001\b\t\r%\u0012)\f1\u0001\u000f\u0011\u0019i#Q\u0017a\u0001\u001d!9\u0011\u0011\u0006BU\t\u0003\u0012\u0005\u0002CA\u000b\u0005S#\tFa2\u0015\u000fM\u0012IMa3\u0003N\"1AE!2A\u00029Aa!\u000bBc\u0001\u0004q\u0001BB\u0017\u0003F\u0002\u0007a\u0002\u0003\u0005\u0002b\tmD\u0011\u0001Bi)\u001d\u0019$1\u001bBk\u0005/Da\u0001\nBh\u0001\u0004q\u0001BB\u0015\u0003P\u0002\u0007a\u0002\u0003\u0004.\u0005\u001f\u0004\rA\u0004\u0005\t\u0003C\u0012Y\b\"\u0001\u0003\\R)1G!8\u0003`\"1AE!7A\u00029Aa!\u000bBm\u0001\u0004q\u0001\u0002\u0003B\u0010\u0005w\"\tAa9\u0015\u0011\t\u0015(\u0011\u001eBv\u0005[\u0004BAa:\u0003*:\u00191C!\u001e\t\r\u0011\u0012\t\u000f1\u0001\u000f\u0011\u0019I#\u0011\u001da\u0001\u001d!1QF!9A\u00029A\u0001Ba\b\u0003|\u0011\u0005!\u0011\u001f\u000b\u0007\u0005K\u0014\u0019P!>\t\r\u0011\u0012y\u000f1\u0001\u000f\u0011\u0019I#q\u001ea\u0001\u001d\u001dA!\u0011 B>\u0011\u0003\u0011Y0\u0001\u0004CS\u001eLe\u000e\u001e\t\u0005\u0005w\u0013iP\u0002\u0005\u0003\u0000\nm\u0004\u0012AB\u0001\u0005\u0019\u0011\u0015nZ%oiN!!Q B@\u0011\u001d\t$Q C\u0001\u0007\u000b!\"Aa?\t\u0011\u0005\u0005$Q C\u0001\u0007\u0013!\u0002ba\u0003\u0004\u001e\r}1\u0011\u0005\t\u0007\u0007\u001b\u0019\u0019b!\u0007\u000f\u0007M\u0019y!C\u0002\u0004\u0012\t\tABT;nKJL7MU1oO\u0016LAa!\u0006\u0004\u0018\tIQ\t_2mkNLg/\u001a\u0006\u0004\u0007#\u0011\u0001cA:\u0004\u001c%\u0019!q =\t\u000f\u0011\u001a9\u00011\u0001\u0004\u001a!9\u0011fa\u0002A\u0002\re\u0001bB\u0017\u0004\b\u0001\u00071\u0011\u0004\u0005\t\u0005?\u0011i\u0010\"\u0001\u0004&QA1qEB\u0016\u0007[\u0019y\u0003\u0005\u0004\u0004\u000e\r%2\u0011D\u0005\u0005\u0005W\u001b9\u0002C\u0004%\u0007G\u0001\ra!\u0007\t\u000f%\u001a\u0019\u00031\u0001\u0004\u001a!9Qfa\tA\u0002\req\u0001CB\u001a\u0005wB\ta!\u000e\u0002\t1{gn\u001a\t\u0005\u0005w\u001b9DB\u0004@\u0005wB\ta!\u000f\u0014\t\r]\"q\u0010\u0005\bc\r]B\u0011AB\u001f)\t\u0019)\u0004\u0003\u0005\u0002b\r]B\u0011AB!)!\u0019\u0019e!\u0012\u0004H\r%\u0003#BB\u0007\u0007'i\u0004B\u0002\u0013\u0004@\u0001\u0007Q\b\u0003\u0004*\u0007\u007f\u0001\r!\u0010\u0005\u0007[\r}\u0002\u0019A\u001f\t\u0011\t}1q\u0007C\u0001\u0007\u001b\"\u0002ba\u0014\u0004R\rM3Q\u000b\t\u0006\u0007\u001b\u0019I#\u0010\u0005\u0007I\r-\u0003\u0019A\u001f\t\r%\u001aY\u00051\u0001>\u0011\u0019i31\na\u0001{\u001dA1\u0011\fB>\u0011\u0003\u0019Y&\u0001\u0006CS\u001e$UmY5nC2\u0004BAa/\u0004^\u0019A1q\fB>\u0011\u0003\u0019\tG\u0001\u0006CS\u001e$UmY5nC2\u001cBa!\u0018\u0003\u0000!9\u0011g!\u0018\u0005\u0002\r\u0015DCAB.\u0011)\u0019Ig!\u0018C\u0002\u0013\r11N\u0001\u0011E&<G)Z2Bg&sG/Z4sC2,\"a!\u001c\u000f\t\r=4q\u0011\b\u0005\u0007c\u001a\tI\u0004\u0003\u0004t\rud\u0002BB;\u0007wj!aa\u001e\u000b\u0007\re\u0004\"\u0001\u0004=e>|GOP\u0005\u0002\u000f%\u00191q\u0010\u0004\u0002\t5\fG\u000f[\u0005\u0005\u0007\u0007\u001b))A\u0004Ok6,'/[2\u000b\u0007\r}d!\u0003\u0003\u0004\n\u000e-\u0015A\u0006\"jO\u0012+7-[7bY\u0006\u001b\u0018JZ%oi\u0016<'/\u00197\u000b\t\r\r5Q\u0011\u0005\n\u0007\u001f\u001bi\u0006)A\u0005\u0007[\n\u0011CY5h\t\u0016\u001c\u0017i]%oi\u0016<'/\u00197!\u0011!\t\tg!\u0018\u0005\u0002\rME\u0003CBK\u00077\u001bija(\u0011\r\r511CBL!\r\u00198\u0011T\u0005\u0004\u0007?B\bb\u0002\u0013\u0004\u0012\u0002\u00071q\u0013\u0005\bS\rE\u0005\u0019ABL\u0011\u001di3\u0011\u0013a\u0001\u0007/C\u0001Ba\b\u0004^\u0011\u000511\u0015\u000b\t\u0007K\u001b9k!+\u0004,B11QBB\u0015\u0007/Cq\u0001JBQ\u0001\u0004\u00199\nC\u0004*\u0007C\u0003\raa&\t\u000f5\u001a\t\u000b1\u0001\u0004\u0018\u001eA1q\u0016B>\u0011\u0003\u0019\t,\u0001\u0004E_V\u0014G.\u001a\t\u0005\u0005w\u001b\u0019L\u0002\u0005\u00046\nm\u0004\u0012AB\\\u0005\u0019!u.\u001e2mKN!11\u0017B@\u0011\u001d\t41\u0017C\u0001\u0007w#\"a!-\t\u0015\r%41\u0017b\u0001\n\u0007\u0019Y\u0007C\u0005\u0004\u0010\u000eM\u0006\u0015!\u0003\u0004n!Q11YBZ\u0005\u0004%\u0019a!2\u0002!\u0011|WO\u00197f\u0003NLe\u000e^3he\u0006dWCABd\u001d\u0011\u0019yg!3\n\t\r-71R\u0001\u0013\t>,(\r\\3Bg&3\u0017J\u001c;fOJ\fG\u000eC\u0005\u0004P\u000eM\u0006\u0015!\u0003\u0004H\u0006\tBm\\;cY\u0016\f5/\u00138uK\u001e\u0014\u0018\r\u001c\u0011\t\u0011\rM71\u0017C\u0001\u0007+\fA\u0001^8C\tR!1qSBl\u0011!\u0011Ic!5A\u0002\re\u0007cA\b\u0004\\&\u00191Q\u0017\u0004\t\u0011\u0005\u000541\u0017C\u0001\u0007?$\u0002b!9\u0004h\u000e%81\u001e\t\u0006'\r\r8\u0011\\\u0005\u0004\u0007K\u0014!\u0001\u0004(v[\u0016\u0014\u0018n\u0019*b]\u001e,\u0007b\u0002\u0013\u0004^\u0002\u00071\u0011\u001c\u0005\bS\ru\u0007\u0019ABm\u0011\u001di3Q\u001ca\u0001\u00073D\u0001Ba\b\u00044\u0012\u00051q\u001e\u000b\t\u0007C\u001c\tpa=\u0004v\"9Ae!<A\u0002\re\u0007bB\u0015\u0004n\u0002\u00071\u0011\u001c\u0005\b[\r5\b\u0019ABm\r\u001d\u0019IPa\u001f\u0001\u0007w\u0014q\u0001U1si&\fG.\u0006\u0004\u0004~\u0012\u0015A1B\n\u0005\u0007o\u0014y\bC\u0006\u0002t\r](\u0011!Q\u0001\n\u0011\u0005\u0001cB\b\u0002x\u0011\rA\u0011\u0002\t\u0004u\u0012\u0015A\u0001\u0003C\u0004\u0007o\u0014\r!!!\u0003\u0003Q\u00032A\u001fC\u0006\t!\tyha>C\u0002\u0005\u0005\u0005bB\u0019\u0004x\u0012\u0005Aq\u0002\u000b\u0005\t#!\u0019\u0002\u0005\u0005\u0003<\u000e]H1\u0001C\u0005\u0011!\t\u0019\b\"\u0004A\u0002\u0011\u0005\u0001\u0002CA\u0011\u0007o$\t\u0001b\u0006\u0015\t\u0011%A\u0011\u0004\u0005\t\u0005S!)\u00021\u0001\u0005\u0004\u001dAAQ\u0004B>\u0011\u0003!y\"A\u0002J]R\u0004BAa/\u0005\"\u00199\u0011Ca\u001f\t\u0002\u0011\r2\u0003\u0002C\u0011\u0005\u007fBq!\rC\u0011\t\u0003!9\u0003\u0006\u0002\u0005 !A\u0011\u0011\rC\u0011\t\u0003!Y\u0003\u0006\u0005\u0005.\u0011=B\u0011\u0007C\u001a!\u0015\u0019iaa\u0005\u000f\u0011\u0019!C\u0011\u0006a\u0001\u001d!1\u0011\u0006\"\u000bA\u00029Aa!\fC\u0015\u0001\u0004q\u0001\u0002\u0003B\u0010\tC!\t\u0001b\u000e\u0015\u0011\u0011eB1\bC\u001f\t\u007f\u0001Ra!\u0004\u0004*9Aa\u0001\nC\u001b\u0001\u0004q\u0001BB\u0015\u00056\u0001\u0007a\u0002\u0003\u0004.\tk\u0001\rA\u0004\u0005\u000b\t\u0007\u0012Y(!A\u0005\n\u0011\u0015\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"\u0001b\u0012\u0011\t\u0011%C1K\u0007\u0003\t\u0017RA\u0001\"\u0014\u0005P\u0005!A.\u00198h\u0015\t!\t&\u0001\u0003kCZ\f\u0017\u0002\u0002C+\t\u0017\u0012aa\u00142kK\u000e$\b")
public class Range
extends AbstractSeq<Object>
implements scala.collection.immutable.IndexedSeq<Object>,
CustomParallelizable<Object, ParRange>,
Serializable {
    public static final long serialVersionUID = 7618862778670199309L;
    private final int start;
    private final int end;
    private final int step;
    private final boolean isEmpty;
    private final int numRangeElements;
    private final int lastElement;
    private final int terminalElement;

    @Override
    public Combiner<Object, ParRange> parCombiner() {
        return CustomParallelizable$class.parCombiner(this);
    }

    @Override
    public GenericCompanion<scala.collection.immutable.IndexedSeq> companion() {
        return scala.collection.immutable.IndexedSeq$class.companion(this);
    }

    @Override
    public scala.collection.immutable.IndexedSeq<Object> toIndexedSeq() {
        return scala.collection.immutable.IndexedSeq$class.toIndexedSeq(this);
    }

    @Override
    public scala.collection.immutable.IndexedSeq<Object> seq() {
        return scala.collection.immutable.IndexedSeq$class.seq(this);
    }

    @Override
    public int hashCode() {
        return IndexedSeqLike$class.hashCode(this);
    }

    @Override
    public IndexedSeq<Object> thisCollection() {
        return IndexedSeqLike$class.thisCollection(this);
    }

    @Override
    public IndexedSeq toCollection(Object repr) {
        return IndexedSeqLike$class.toCollection(this, repr);
    }

    @Override
    public Iterator<Object> iterator() {
        return IndexedSeqLike$class.iterator(this);
    }

    @Override
    public <A1> Buffer<A1> toBuffer() {
        return IndexedSeqLike$class.toBuffer(this);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int step() {
        return this.step;
    }

    @Override
    public ParRange par() {
        return new ParRange(this);
    }

    private long gap() {
        return (long)this.end() - (long)this.start();
    }

    private boolean isExact() {
        return this.gap() % (long)this.step() == 0L;
    }

    private boolean hasStub() {
        return this.isInclusive() || !this.isExact();
    }

    private long longLength() {
        return this.gap() / (long)this.step() + (long)(this.hasStub() ? 1 : 0);
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public final int numRangeElements() {
        return this.numRangeElements;
    }

    public final int lastElement() {
        return this.lastElement;
    }

    public final int terminalElement() {
        return this.terminalElement;
    }

    @Override
    public int last() {
        return this.isEmpty() ? BoxesRunTime.unboxToInt(Nil$.MODULE$.last()) : this.lastElement();
    }

    @Override
    public int head() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.start();
    }

    @Override
    public <A1> int min(Ordering<A1> ord) {
        return ord == Ordering$Int$.MODULE$ ? (this.step() > 0 ? this.head() : this.last()) : BoxesRunTime.unboxToInt(TraversableOnce$class.min(this, ord));
    }

    @Override
    public <A1> int max(Ordering<A1> ord) {
        return ord == Ordering$Int$.MODULE$ ? (this.step() > 0 ? this.last() : this.head()) : BoxesRunTime.unboxToInt(TraversableOnce$class.max(this, ord));
    }

    public Range copy(int start, int end, int step) {
        return new Range(start, end, step);
    }

    public Range by(int step) {
        return this.copy(this.start(), this.end(), step);
    }

    public boolean isInclusive() {
        return false;
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public int length() {
        if (this.numRangeElements() < 0) {
            throw this.fail();
        }
        return this.numRangeElements();
    }

    private String description() {
        Object[] objectArray = new Object[4];
        objectArray[0] = BoxesRunTime.boxToInteger(this.start());
        objectArray[1] = this.isInclusive() ? "to" : "until";
        objectArray[2] = BoxesRunTime.boxToInteger(this.end());
        objectArray[3] = BoxesRunTime.boxToInteger(this.step());
        return new StringOps(Predef$.MODULE$.augmentString("%d %s %d by %s")).format(Predef$.MODULE$.genericWrapArray(objectArray));
    }

    private Nothing$ fail() {
        throw new IllegalArgumentException(new StringBuilder().append((Object)this.description()).append((Object)": seqs cannot contain more than Int.MaxValue elements.").toString());
    }

    public void scala$collection$immutable$Range$$validateMaxLength() {
        if (this.numRangeElements() < 0) {
            throw this.fail();
        }
    }

    @Override
    public final int apply(int idx) {
        return this.apply$mcII$sp(idx);
    }

    @Override
    public final <U> void foreach(Function1<Object, U> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply(BoxesRunTime.boxToInteger(i));
                if (i == this.lastElement()) {
                    return;
                }
                i += this.step();
            }
        }
    }

    @Override
    public final Range take(int n) {
        return n <= 0 || this.isEmpty() ? this.newEmptyRange(this.start()) : (n >= this.numRangeElements() && this.numRangeElements() >= 0 ? this : new Inclusive(this.start(), this.locationAfterN(n - 1), this.step()));
    }

    @Override
    public final Range drop(int n) {
        return n <= 0 || this.isEmpty() ? this : (n >= this.numRangeElements() && this.numRangeElements() >= 0 ? this.newEmptyRange(this.end()) : this.copy(this.locationAfterN(n), this.end(), this.step()));
    }

    @Override
    public Range slice(int from, int until) {
        Range range;
        if (from <= 0) {
            range = this.take(until);
        } else if (until >= this.numRangeElements() && this.numRangeElements() >= 0) {
            range = this.drop(from);
        } else {
            int fromValue = this.locationAfterN(from);
            range = from >= until ? this.newEmptyRange(fromValue) : new Inclusive(fromValue, this.locationAfterN(until - 1), this.step());
        }
        return range;
    }

    @Override
    public final Range init() {
        Object object = this.isEmpty() ? Nil$.MODULE$.init() : BoxedUnit.UNIT;
        return this.dropRight(1);
    }

    @Override
    public final Range tail() {
        Object object = this.isEmpty() ? Nil$.MODULE$.tail() : BoxedUnit.UNIT;
        return this.drop(1);
    }

    private long argTakeWhile(Function1<Object, Object> p) {
        long l;
        if (this.isEmpty()) {
            l = this.start();
        } else {
            int current;
            int stop = this.last();
            for (current = this.start(); current != stop && p.apply$mcZI$sp(current); current += this.step()) {
            }
            l = current != stop || !p.apply$mcZI$sp(current) ? (long)current : (long)current + (long)this.step();
        }
        return l;
    }

    private int locationAfterN(int n) {
        return this.start() + this.step() * n;
    }

    private Range newEmptyRange(int value) {
        return new Range(value, value, this.step());
    }

    @Override
    public final Range takeWhile(Function1<Object, Object> p) {
        Range range;
        long stop = this.argTakeWhile(p);
        if (stop == (long)this.start()) {
            range = this.newEmptyRange(this.start());
        } else {
            int x = (int)(stop - (long)this.step());
            range = x == this.last() ? this : new Inclusive(this.start(), x, this.step());
        }
        return range;
    }

    @Override
    public final Range dropWhile(Function1<Object, Object> p) {
        Range range;
        long stop = this.argTakeWhile(p);
        if (stop == (long)this.start()) {
            range = this;
        } else {
            int x = (int)(stop - (long)this.step());
            range = x == this.last() ? this.newEmptyRange(this.last()) : new Inclusive(x + this.step(), this.last(), this.step());
        }
        return range;
    }

    @Override
    public final Tuple2<Range, Range> span(Function1<Object, Object> p) {
        Tuple2<Range, Range> tuple2;
        long border = this.argTakeWhile(p);
        if (border == (long)this.start()) {
            tuple2 = new Tuple2<Range, Range>(this.newEmptyRange(this.start()), this);
        } else {
            int x = (int)(border - (long)this.step());
            tuple2 = x == this.last() ? new Tuple2<Range, Range>(this, this.newEmptyRange(this.last())) : new Tuple2<Inclusive, Inclusive>(new Inclusive(this.start(), x, this.step()), new Inclusive(x + this.step(), this.last(), this.step()));
        }
        return tuple2;
    }

    @Override
    public final Tuple2<Range, Range> splitAt(int n) {
        return new Tuple2<Range, Range>(this.take(n), this.drop(n));
    }

    @Override
    public final Range takeRight(int n) {
        Range range;
        if (n <= 0) {
            range = this.newEmptyRange(this.start());
        } else if (this.numRangeElements() >= 0) {
            range = this.drop(this.numRangeElements() - n);
        } else {
            int y = this.last();
            long x = (long)y - (long)this.step() * (long)(n - 1);
            range = this.step() > 0 && x < (long)this.start() || this.step() < 0 && x > (long)this.start() ? this : new Inclusive((int)x, y, this.step());
        }
        return range;
    }

    @Override
    public final Range dropRight(int n) {
        Range range;
        if (n <= 0) {
            range = this;
        } else if (this.numRangeElements() >= 0) {
            range = this.take(this.numRangeElements() - n);
        } else {
            int y = this.last() - this.step() * n;
            range = this.step() > 0 && y < this.start() || this.step() < 0 && y > this.start() ? this.newEmptyRange(this.start()) : new Inclusive(this.start(), y, this.step());
        }
        return range;
    }

    @Override
    public final Range reverse() {
        return this.isEmpty() ? this : new Inclusive(this.last(), this.start(), -this.step());
    }

    public Range inclusive() {
        return this.isInclusive() ? this : new Inclusive(this.start(), this.end(), this.step());
    }

    @Override
    public final boolean contains(int x) {
        return x == this.end() && !this.isInclusive() ? false : (this.step() > 0 ? (x < this.start() || x > this.end() ? false : this.step() == 1 || (x - this.start()) % this.step() == 0) : (x < this.end() || x > this.start() ? false : this.step() == -1 || (x - this.start()) % this.step() == 0));
    }

    @Override
    public final <B> int sum(Numeric<B> num) {
        int n;
        if (num == Numeric$IntIsIntegral$.MODULE$) {
            n = this.isEmpty() ? 0 : (this.numRangeElements() == 1 ? this.head() : (int)((long)this.numRangeElements() * ((long)this.head() + (long)this.last()) / 2L));
        } else if (this.isEmpty()) {
            n = num.toInt(num.zero());
        } else {
            Object acc = num.zero();
            int i = this.head();
            while (true) {
                acc = num.plus(acc, BoxesRunTime.boxToInteger(i));
                if (i == this.lastElement()) {
                    return num.toInt(acc);
                }
                i += this.step();
            }
        }
        return n;
    }

    @Override
    public Range toIterable() {
        return this;
    }

    @Override
    public Range toSeq() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof Range)) return GenSeqLike$class.equals(this, other);
        Range range = (Range)object;
        if (!range.canEqual(this)) return false;
        if (!this.isEmpty()) {
            if (!range.nonEmpty() || this.start() != range.start()) return false;
            int l0 = this.last();
            if (l0 != range.last()) return false;
            if (this.start() == l0) return true;
            if (this.step() == range.step()) return true;
            return false;
        }
        boolean bl = range.isEmpty();
        if (bl) return true;
        return false;
    }

    @Override
    public String toString() {
        String endStr = this.numRangeElements() > Range$.MODULE$.MAX_PRINT() || !this.isEmpty() && this.numRangeElements() < 0 ? ", ... )" : ")";
        return this.take(Range$.MODULE$.MAX_PRINT()).mkString("Range(", ", ", endStr);
    }

    public final void foreach$mVc$sp(Function1<Object, BoxedUnit> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply$mcVI$sp(i);
                if (i == this.lastElement()) {
                    return;
                }
                i += this.step();
            }
        }
    }

    @Override
    public int apply$mcII$sp(int idx) {
        this.scala$collection$immutable$Range$$validateMaxLength();
        if (idx < 0 || idx >= this.numRangeElements()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(idx)).toString());
        }
        return this.start() + this.step() * idx;
    }

    public Range(int start, int end, int step) {
        int n;
        int n2;
        this.start = start;
        this.end = end;
        this.step = step;
        Traversable$class.$init$(this);
        Iterable$class.$init$(this);
        Seq$class.$init$(this);
        IndexedSeqLike$class.$init$(this);
        IndexedSeq$class.$init$(this);
        scala.collection.immutable.IndexedSeq$class.$init$(this);
        CustomParallelizable$class.$init$(this);
        boolean bl = this.isEmpty = start > end && step > 0 || start < end && step < 0 || start == end && !this.isInclusive();
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        if (this.isEmpty()) {
            n2 = 0;
        } else {
            long len = this.longLength();
            n2 = len > Integer.MAX_VALUE ? -1 : (this.numRangeElements = (int)len);
        }
        if (this.isEmpty()) {
            n = start - step;
        } else {
            int n3 = step;
            switch (n3) {
                case 1: {
                    if (this.isInclusive()) {
                        n = end;
                        break;
                    }
                    n = end - 1;
                    break;
                }
                case -1: {
                    if (this.isInclusive()) {
                        n = end;
                        break;
                    }
                    n = end + 1;
                    break;
                }
                default: {
                    int remainder = (int)(this.gap() % (long)step);
                    if (remainder != 0) {
                        n = end - remainder;
                        break;
                    }
                    if (this.isInclusive()) {
                        n = end;
                        break;
                    }
                    n = end - step;
                    break;
                }
            }
        }
        this.lastElement = n;
        this.terminalElement = this.lastElement() + step;
    }

    public static class Inclusive
    extends Range {
        @Override
        public boolean isInclusive() {
            return true;
        }

        @Override
        public Range copy(int start, int end, int step) {
            return new Inclusive(start, end, step);
        }

        public Inclusive(int start, int end, int step) {
            super(start, end, step);
        }
    }

    public static class Partial<T, U> {
        private final Function1<T, U> f;

        public U by(T x) {
            return this.f.apply(x);
        }

        public Partial(Function1<T, U> f) {
            this.f = f;
        }
    }
}

