/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.Array$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.Reporter;
import scala.reflect.internal.util.NoPosition$;
import scala.reflect.internal.util.Position;
import scala.reflect.io.AbstractFile;
import scala.reflect.io.PlainFile;
import scala.reflect.io.ZipArchive;
import scala.tools.nsc.io.SourceReader$;

@ScalaSignature(bytes="\u0006\u0003\u0005-c\u0001B\u0001\u0003\u0001-\u0011AbU8ve\u000e,'+Z1eKJT!a\u0001\u0003\u0002\u0005%|'BA\u0003\u0007\u0003\rq7o\u0019\u0006\u0003\u000f!\tQ\u0001^8pYNT\u0011!C\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t\u0001\"\u0003\u0002\u0010\u0011\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0002\u0003\u0006IAE\u0001\bI\u0016\u001cw\u000eZ3s!\t\u0019\"$D\u0001\u0015\u0015\t)b#A\u0004dQ\u0006\u00148/\u001a;\u000b\u0005]A\u0012a\u00018j_*\t\u0011$\u0001\u0003kCZ\f\u0017BA\u000e\u0015\u00059\u0019\u0005.\u0019:tKR$UmY8eKJD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\te\u0016\u0004xN\u001d;feB\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\tS:$XM\u001d8bY*\u00111\u0005C\u0001\be\u00164G.Z2u\u0013\t)\u0003E\u0001\u0005SKB|'\u000f^3s\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0019\u0011f\u000b\u0017\u0011\u0005)\u0002Q\"\u0001\u0002\t\u000bE1\u0003\u0019\u0001\n\t\u000bu1\u0003\u0019\u0001\u0010\t\u000f9\u0002!\u0019!C\u0005_\u0005)!-\u001f;fgV\t\u0001\u0007\u0005\u00022e5\ta#\u0003\u00024-\tQ!)\u001f;f\u0005V4g-\u001a:\t\rU\u0002\u0001\u0015!\u00031\u0003\u0019\u0011\u0017\u0010^3tA!9q\u0007\u0001a\u0001\n\u0013A\u0014!B2iCJ\u001cX#A\u001d\u0011\u0005ER\u0014BA\u001e\u0017\u0005)\u0019\u0005.\u0019:Ck\u001a4WM\u001d\u0005\b{\u0001\u0001\r\u0011\"\u0003?\u0003%\u0019\u0007.\u0019:t?\u0012*\u0017\u000f\u0006\u0002@\u0005B\u0011Q\u0002Q\u0005\u0003\u0003\"\u0011A!\u00168ji\"91\tPA\u0001\u0002\u0004I\u0014a\u0001=%c!1Q\t\u0001Q!\ne\naa\u00195beN\u0004\u0003\"B$\u0001\t\u0013A\u0015a\u0005:fa>\u0014H/\u00128d_\u0012LgnZ#se>\u0014HcA J-\")!J\u0012a\u0001\u0017\u0006Aa-\u001b7f]\u0006lW\r\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001d\"i\u0011a\u0014\u0006\u0003!*\ta\u0001\u0010:p_Rt\u0014B\u0001*\t\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005IC\u0001\"B,G\u0001\u0004A\u0016!A3\u0011\u0005esfB\u0001.]\u001d\tq5,C\u0001\n\u0013\ti\u0006\"A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'!C#yG\u0016\u0004H/[8o\u0015\ti\u0006\u0002C\u0003c\u0001\u0011\u00051-\u0001\u0003sK\u0006$GC\u00013k!\riQmZ\u0005\u0003M\"\u0011Q!\u0011:sCf\u0004\"!\u00045\n\u0005%D!\u0001B\"iCJDQa[1A\u00021\fAAZ5mKB\u0011Qn\u001c\b\u0003U9L!!\u0018\u0002\n\u0005A\f(!\u0002&GS2,'BA/\u0003\u0011\u0015\u0011\u0007\u0001\"\u0001t)\t!G\u000fC\u0003le\u0002\u0007Q\u000f\u0005\u0002nm&\u0011q/\u001d\u0002\r\u0003\n\u001cHO]1di\u001aKG.\u001a\u0005\u0006E\u0002!\t\"\u001f\u000b\u0003IjDQa\u001f=A\u0002q\fQ!\u001b8qkR\u00042!`A\u0001\u001b\u0005q(BA@\u0017\u0003!\u0019\u0007.\u00198oK2\u001c\u0018bAA\u0002}\n\u0019\"+Z1eC\ndWMQ=uK\u000eC\u0017M\u001c8fY\"1!\r\u0001C\t\u0003\u000f!2\u0001ZA\u0005\u0011\u0019q\u0013Q\u0001a\u0001a!9\u0011Q\u0002\u0001\u0005\n\u0005=\u0011!\u0003;fe6Lg.\u0019;f)\r!\u0017\u0011\u0003\u0005\u0007o\u0005-\u0001\u0019A\u001d\b\u000f\u0005U!\u0001#\u0001\u0002\u0018\u0005a1k\\;sG\u0016\u0014V-\u00193feB\u0019!&!\u0007\u0007\r\u0005\u0011\u0001\u0012AA\u000e'\r\tI\u0002\u0004\u0005\bO\u0005eA\u0011AA\u0010)\t\t9\u0002\u0003\u0005\u0002$\u0005eA\u0011AA\u0013\u0003\u0019!WmY8eKRI\u0011(a\n\u0002*\u0005-\u0012Q\u0006\u0005\u0007#\u0005\u0005\u0002\u0019\u0001\n\t\r9\n\t\u00031\u00011\u0011\u00199\u0014\u0011\u0005a\u0001s!A\u0011qFA\u0011\u0001\u0004\t\t$\u0001\u0006f]\u0012|e-\u00138qkR\u00042!DA\u001a\u0013\r\t)\u0004\u0003\u0002\b\u0005>|G.Z1o\u0011!\tI$!\u0007\u0005\u0002\u0005m\u0012!\u00024mkNDG#B\u001d\u0002>\u0005}\u0002BB\t\u00028\u0001\u0007!\u0003\u0003\u00048\u0003o\u0001\r!\u000f\u0005\t\u0003\u0007\nI\u0002\"\u0003\u0002F\u0005\u0001\u0012N\\2sK\u0006\u001cXmQ1qC\u000eLG/\u001f\u000b\u0004s\u0005\u001d\u0003bBA%\u0003\u0003\u0002\r!O\u0001\u0007EV4g-\u001a:")
public class SourceReader {
    private final CharsetDecoder decoder;
    private final Reporter reporter;
    private final ByteBuffer bytes;
    private CharBuffer chars;

    public static CharBuffer flush(CharsetDecoder charsetDecoder, CharBuffer charBuffer) {
        return SourceReader$.MODULE$.flush(charsetDecoder, charBuffer);
    }

    public static CharBuffer decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
        return SourceReader$.MODULE$.decode(charsetDecoder, byteBuffer, charBuffer, bl);
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private void chars_$eq(CharBuffer x$1) {
        this.chars = x$1;
    }

    private void reportEncodingError(String filename, Exception e) {
        String advice = "Please try specifying another one using the -encoding option";
        this.reporter.error((Position)NoPosition$.MODULE$, new StringBuilder(33).append("IO error while decoding ").append(filename).append(" with ").append(this.decoder.charset()).append(": ").append(e.getMessage()).append("\n").append(advice).toString());
    }

    public char[] read(File file) {
        char[] cArray;
        try (FileChannel c = new FileInputStream(file).getChannel();){
            try {
                cArray = this.read(c);
            }
            catch (InterruptedException ex) {
                throw ex;
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                throw new InterruptedException();
            }
            catch (Exception e) {
                this.reportEncodingError(String.valueOf(file), e);
                cArray = (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char());
            }
        }
        return cArray;
    }

    public char[] read(AbstractFile file) {
        char[] cArray;
        try {
            char[] cArray2;
            AbstractFile abstractFile = file;
            if (abstractFile instanceof PlainFile) {
                PlainFile plainFile = (PlainFile)abstractFile;
                cArray2 = this.read(plainFile.file());
            } else if (abstractFile instanceof ZipArchive.Entry) {
                ZipArchive.Entry entry = (ZipArchive.Entry)abstractFile;
                cArray2 = this.read(Channels.newChannel(entry.input()));
            } else {
                cArray2 = this.read(ByteBuffer.wrap(file.toByteArray()));
            }
            cArray = cArray2;
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            this.reportEncodingError(String.valueOf(file), e);
            cArray = (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char());
        }
        return cArray;
    }

    public char[] read(ReadableByteChannel input) {
        CharsetDecoder decoder = this.decoder.reset();
        ByteBuffer bytes = this.bytes();
        bytes.clear();
        CharBuffer chars = this.chars();
        chars.clear();
        boolean endOfInput = false;
        while (!endOfInput) {
            endOfInput = input.read(bytes) < 0;
            bytes.flip();
            chars = SourceReader$.MODULE$.decode(decoder, bytes, chars, endOfInput);
        }
        return this.terminate(SourceReader$.MODULE$.flush(decoder, chars));
    }

    public char[] read(ByteBuffer bytes) {
        CharsetDecoder decoder = this.decoder.reset();
        CharBuffer chars = this.chars();
        chars.clear();
        return this.terminate(SourceReader$.MODULE$.flush(decoder, SourceReader$.MODULE$.decode(decoder, bytes, chars, true)));
    }

    /*
     * WARNING - void declaration
     */
    private char[] terminate(CharBuffer chars) {
        void var2_2;
        char[] result = new char[chars.length()];
        chars.get(result);
        this.chars_$eq(chars);
        return var2_2;
    }

    public SourceReader(CharsetDecoder decoder, Reporter reporter) {
        this.decoder = decoder;
        this.reporter = reporter;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }
}

