/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.Array$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.util.NoPosition$;
import scala.reflect.internal.util.Position;
import scala.reflect.io.AbstractFile;
import scala.reflect.io.PlainFile;
import scala.reflect.io.ZipArchive;
import scala.tools.nsc.io.SourceReader$;
import scala.tools.nsc.reporters.Reporter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001-\u0011AbU8ve\u000e,'+Z1eKJT!a\u0001\u0003\u0002\u0005%|'BA\u0003\u0007\u0003\rq7o\u0019\u0006\u0003\u000f!\tQ\u0001^8pYNT\u0011!C\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t\u0001\"\u0003\u0002\u0010\u0011\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0002\u0003\u0006IAE\u0001\bI\u0016\u001cw\u000eZ3s!\t\u0019\"$D\u0001\u0015\u0015\t)b#A\u0004dQ\u0006\u00148/\u001a;\u000b\u0005]A\u0012a\u00018j_*\t\u0011$\u0001\u0003kCZ\f\u0017BA\u000e\u0015\u00059\u0019\u0005.\u0019:tKR$UmY8eKJD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\te\u0016\u0004xN\u001d;feB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005B\u0001\ne\u0016\u0004xN\u001d;feNL!a\t\u0011\u0003\u0011I+\u0007o\u001c:uKJDQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtDcA\u0014*UA\u0011\u0001\u0006A\u0007\u0002\u0005!)\u0011\u0003\na\u0001%!)Q\u0004\na\u0001=!9A\u0006\u0001b\u0001\n\u0013i\u0013!\u00022zi\u0016\u001cX#\u0001\u0018\u0011\u0005=\u0002T\"\u0001\f\n\u0005E2\"A\u0003\"zi\u0016\u0014UO\u001a4fe\"11\u0007\u0001Q\u0001\n9\naAY=uKN\u0004\u0003bB\u001b\u0001\u0001\u0004%IAN\u0001\u0006G\"\f'o]\u000b\u0002oA\u0011q\u0006O\u0005\u0003sY\u0011!b\u00115be\n+hMZ3s\u0011\u001dY\u0004\u00011A\u0005\nq\n\u0011b\u00195beN|F%Z9\u0015\u0005u\u0002\u0005CA\u0007?\u0013\ty\u0004B\u0001\u0003V]&$\bbB!;\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0004BB\"\u0001A\u0003&q'\u0001\u0004dQ\u0006\u00148\u000f\t\u0005\u0006\u000b\u0002!IAR\u0001\u0014e\u0016\u0004xN\u001d;F]\u000e|G-\u001b8h\u000bJ\u0014xN\u001d\u000b\u0004{\u001d#\u0006\"\u0002%E\u0001\u0004I\u0015\u0001\u00034jY\u0016t\u0017-\\3\u0011\u0005)\u000bfBA&P!\ta\u0005\"D\u0001N\u0015\tq%\"\u0001\u0004=e>|GOP\u0005\u0003!\"\ta\u0001\u0015:fI\u00164\u0017B\u0001*T\u0005\u0019\u0019FO]5oO*\u0011\u0001\u000b\u0003\u0005\u0006+\u0012\u0003\rAV\u0001\u0002KB\u0011q\u000b\u0018\b\u00031js!\u0001T-\n\u0003%I!a\u0017\u0005\u0002\u000fA\f7m[1hK&\u0011QL\u0018\u0002\n\u000bb\u001cW\r\u001d;j_:T!a\u0017\u0005\t\u000b\u0001\u0004A\u0011A1\u0002\tI,\u0017\r\u001a\u000b\u0003E\"\u00042!D2f\u0013\t!\u0007BA\u0003BeJ\f\u0017\u0010\u0005\u0002\u000eM&\u0011q\r\u0003\u0002\u0005\u0007\"\f'\u000fC\u0003j?\u0002\u0007!.\u0001\u0003gS2,\u0007CA6n\u001d\tAC.\u0003\u0002\\\u0005%\u0011an\u001c\u0002\u0006\u0015\u001aKG.\u001a\u0006\u00037\nAQ\u0001\u0019\u0001\u0005\u0002E$\"A\u0019:\t\u000b%\u0004\b\u0019A:\u0011\u0005-$\u0018BA;p\u00051\t%m\u001d;sC\u000e$h)\u001b7f\u0011\u0015\u0001\u0007\u0001\"\u0005x)\t\u0011\u0007\u0010C\u0003zm\u0002\u0007!0A\u0003j]B,H\u000f\u0005\u0002|}6\tAP\u0003\u0002~-\u0005A1\r[1o]\u0016d7/\u0003\u0002\u0000y\n\u0019\"+Z1eC\ndWMQ=uK\u000eC\u0017M\u001c8fY\"1\u0001\r\u0001C\t\u0003\u0007!2AYA\u0003\u0011\u0019a\u0013\u0011\u0001a\u0001]!9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0011!\u0003;fe6Lg.\u0019;f)\r\u0011\u0017Q\u0002\u0005\u0007k\u0005\u001d\u0001\u0019A\u001c\b\u000f\u0005E!\u0001#\u0001\u0002\u0014\u0005a1k\\;sG\u0016\u0014V-\u00193feB\u0019\u0001&!\u0006\u0007\r\u0005\u0011\u0001\u0012AA\f'\r\t)\u0002\u0004\u0005\bK\u0005UA\u0011AA\u000e)\t\t\u0019\u0002\u0003\u0005\u0002 \u0005UA\u0011AA\u0011\u0003\u0019!WmY8eKRIq'a\t\u0002&\u0005\u001d\u0012\u0011\u0006\u0005\u0007#\u0005u\u0001\u0019\u0001\n\t\r1\ni\u00021\u0001/\u0011\u0019)\u0014Q\u0004a\u0001o!A\u00111FA\u000f\u0001\u0004\ti#\u0001\u0006f]\u0012|e-\u00138qkR\u00042!DA\u0018\u0013\r\t\t\u0004\u0003\u0002\b\u0005>|G.Z1o\u0011!\t)$!\u0006\u0005\u0002\u0005]\u0012!\u00024mkNDG#B\u001c\u0002:\u0005m\u0002BB\t\u00024\u0001\u0007!\u0003\u0003\u00046\u0003g\u0001\ra\u000e\u0005\t\u0003\u007f\t)\u0002\"\u0003\u0002B\u0005\u0001\u0012N\\2sK\u0006\u001cXmQ1qC\u000eLG/\u001f\u000b\u0004o\u0005\r\u0003bBA#\u0003{\u0001\raN\u0001\u0007EV4g-\u001a:")
public class SourceReader {
    private final CharsetDecoder decoder;
    private final Reporter reporter;
    private final ByteBuffer bytes;
    private CharBuffer chars;

    public static CharBuffer flush(CharsetDecoder charsetDecoder, CharBuffer charBuffer) {
        return SourceReader$.MODULE$.flush(charsetDecoder, charBuffer);
    }

    public static CharBuffer decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
        return SourceReader$.MODULE$.decode(charsetDecoder, byteBuffer, charBuffer, bl);
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private void chars_$eq(CharBuffer x$1) {
        this.chars = x$1;
    }

    private void reportEncodingError(String filename, Exception e) {
        String advice = "Please try specifying another one using the -encoding option";
        this.reporter.error((Position)NoPosition$.MODULE$, new StringBuilder(33).append("IO error while decoding ").append(filename).append(" with ").append(this.decoder.charset()).append(": ").append(e.getMessage()).append("\n").append(advice).toString());
    }

    public char[] read(File file) {
        char[] cArray;
        try (FileChannel c = new FileInputStream(file).getChannel();){
            try {
                cArray = this.read(c);
            }
            catch (InterruptedException ex) {
                throw ex;
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                throw new InterruptedException();
            }
            catch (Exception e) {
                this.reportEncodingError(String.valueOf(file), e);
                cArray = (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char());
            }
        }
        return cArray;
    }

    public char[] read(AbstractFile file) {
        char[] cArray;
        try {
            char[] cArray2;
            AbstractFile abstractFile = file;
            if (abstractFile instanceof PlainFile) {
                PlainFile plainFile = (PlainFile)abstractFile;
                cArray2 = this.read(plainFile.file());
            } else if (abstractFile instanceof ZipArchive.Entry) {
                ZipArchive.Entry entry = (ZipArchive.Entry)abstractFile;
                cArray2 = this.read(Channels.newChannel(entry.input()));
            } else {
                cArray2 = this.read(ByteBuffer.wrap(file.toByteArray()));
            }
            cArray = cArray2;
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            this.reportEncodingError(String.valueOf(file), e);
            cArray = (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char());
        }
        return cArray;
    }

    public char[] read(ReadableByteChannel input) {
        CharsetDecoder decoder = this.decoder.reset();
        ByteBuffer bytes = this.bytes();
        bytes.clear();
        CharBuffer chars = this.chars();
        chars.clear();
        boolean endOfInput = false;
        while (!endOfInput) {
            endOfInput = input.read(bytes) < 0;
            bytes.flip();
            chars = SourceReader$.MODULE$.decode(decoder, bytes, chars, endOfInput);
        }
        return this.terminate(SourceReader$.MODULE$.flush(decoder, chars));
    }

    public char[] read(ByteBuffer bytes) {
        CharsetDecoder decoder = this.decoder.reset();
        CharBuffer chars = this.chars();
        chars.clear();
        return this.terminate(SourceReader$.MODULE$.flush(decoder, SourceReader$.MODULE$.decode(decoder, bytes, chars, true)));
    }

    /*
     * WARNING - void declaration
     */
    private char[] terminate(CharBuffer chars) {
        void var2_2;
        char[] result = new char[chars.length()];
        chars.get(result);
        this.chars_$eq(chars);
        return var2_2;
    }

    public SourceReader(CharsetDecoder decoder, Reporter reporter) {
        this.decoder = decoder;
        this.reporter = reporter;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }
}

