/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.Array$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.util.NoPosition$;
import scala.reflect.internal.util.Position;
import scala.reflect.io.AbstractFile;
import scala.reflect.io.PlainFile;
import scala.reflect.io.ZipArchive;
import scala.tools.nsc.io.SourceReader$;
import scala.tools.nsc.reporters.Reporter;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001-\u0011AbU8ve\u000e,'+Z1eKJT!a\u0001\u0003\u0002\u0005%|'BA\u0003\u0007\u0003\rq7o\u0019\u0006\u0003\u000f!\tQ\u0001^8pYNT\u0011!C\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t\u0001\"\u0003\u0002\u0010\u0011\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0002\u0003\u0006IAE\u0001\bI\u0016\u001cw\u000eZ3s!\t\u0019\"$D\u0001\u0015\u0015\t)b#A\u0004dQ\u0006\u00148/\u001a;\u000b\u0005]A\u0012a\u00018j_*\t\u0011$\u0001\u0003kCZ\f\u0017BA\u000e\u0015\u00059\u0019\u0005.\u0019:tKR$UmY8eKJD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\te\u0016\u0004xN\u001d;feB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005B\u0001\ne\u0016\u0004xN\u001d;feNL!a\t\u0011\u0003\u0011I+\u0007o\u001c:uKJDQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtDcA\u0014*UA\u0011\u0001\u0006A\u0007\u0002\u0005!)\u0011\u0003\na\u0001%!)Q\u0004\na\u0001=!9A\u0006\u0001b\u0001\n\u0013i\u0013!\u00022zi\u0016\u001cX#\u0001\u0018\u0011\u0005=\u0002T\"\u0001\f\n\u0005E2\"A\u0003\"zi\u0016\u0014UO\u001a4fe\"11\u0007\u0001Q\u0001\n9\naAY=uKN\u0004\u0003bB\u001b\u0001\u0001\u0004%IAN\u0001\u0006G\"\f'o]\u000b\u0002oA\u0011q\u0006O\u0005\u0003sY\u0011!b\u00115be\n+hMZ3s\u0011\u001dY\u0004\u00011A\u0005\nq\n\u0011b\u00195beN|F%Z9\u0015\u0005u\u0002\u0005CA\u0007?\u0013\ty\u0004B\u0001\u0003V]&$\bbB!;\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0004BB\"\u0001A\u0003&q'\u0001\u0004dQ\u0006\u00148\u000f\t\u0005\u0006\u000b\u0002!IAR\u0001\u0014e\u0016\u0004xN\u001d;F]\u000e|G-\u001b8h\u000bJ\u0014xN\u001d\u000b\u0003{\u001dCQ\u0001\u0013#A\u0002%\u000b\u0001BZ5mK:\fW.\u001a\t\u0003\u00156s!!D&\n\u00051C\u0011A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001\u0014\u0005\t\u000bE\u0003A\u0011\u0001*\u0002\tI,\u0017\r\u001a\u000b\u0003'f\u00032!\u0004+W\u0013\t)\u0006BA\u0003BeJ\f\u0017\u0010\u0005\u0002\u000e/&\u0011\u0001\f\u0003\u0002\u0005\u0007\"\f'\u000fC\u0003[!\u0002\u00071,\u0001\u0003gS2,\u0007C\u0001/`\u001d\tAS,\u0003\u0002_\u0005\u00059\u0001/Y2lC\u001e,\u0017B\u00011b\u0005\u0015Qe)\u001b7f\u0015\tq&\u0001C\u0003R\u0001\u0011\u00051\r\u0006\u0002TI\")!L\u0019a\u0001KB\u0011ALZ\u0005\u0003O\u0006\u0014A\"\u00112tiJ\f7\r\u001e$jY\u0016DQ!\u0015\u0001\u0005\u0012%$\"a\u00156\t\u000b-D\u0007\u0019\u00017\u0002\u000b%t\u0007/\u001e;\u0011\u00055\u0004X\"\u00018\u000b\u0005=4\u0012\u0001C2iC:tW\r\\:\n\u0005Et'a\u0005*fC\u0012\f'\r\\3CsR,7\t[1o]\u0016d\u0007\"B)\u0001\t#\u0019HCA*u\u0011\u0015a#\u000f1\u0001/\u0011\u00151\b\u0001\"\u0003x\u0003%!XM]7j]\u0006$X\r\u0006\u0002Tq\")Q'\u001ea\u0001o\u001d)!P\u0001E\u0001w\u0006a1k\\;sG\u0016\u0014V-\u00193feB\u0011\u0001\u0006 \u0004\u0006\u0003\tA\t!`\n\u0003y2AQ!\n?\u0005\u0002}$\u0012a\u001f\u0005\b\u0003\u0007aH\u0011AA\u0003\u0003\u0019!WmY8eKRIq'a\u0002\u0002\n\u0005-\u0011Q\u0002\u0005\u0007#\u0005\u0005\u0001\u0019\u0001\n\t\r1\n\t\u00011\u0001/\u0011\u0019)\u0014\u0011\u0001a\u0001o!A\u0011qBA\u0001\u0001\u0004\t\t\"\u0001\u0006f]\u0012|e-\u00138qkR\u00042!DA\n\u0013\r\t)\u0002\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\tI\u0002 C\u0001\u00037\tQA\u001a7vg\"$RaNA\u000f\u0003?Aa!EA\f\u0001\u0004\u0011\u0002BB\u001b\u0002\u0018\u0001\u0007q\u0007C\u0004\u0002$q$I!!\n\u0002!%t7M]3bg\u0016\u001c\u0015\r]1dSRLHcA\u001c\u0002(!9\u0011\u0011FA\u0011\u0001\u00049\u0014A\u00022vM\u001a,'\u000f")
public class SourceReader {
    private final CharsetDecoder decoder;
    private final Reporter reporter;
    private final ByteBuffer bytes;
    private CharBuffer chars;

    public static CharBuffer flush(CharsetDecoder charsetDecoder, CharBuffer charBuffer) {
        return SourceReader$.MODULE$.flush(charsetDecoder, charBuffer);
    }

    public static CharBuffer decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
        return SourceReader$.MODULE$.decode(charsetDecoder, byteBuffer, charBuffer, bl);
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private void chars_$eq(CharBuffer x$1) {
        this.chars = x$1;
    }

    private void reportEncodingError(String filename) {
        this.reporter.error((Position)NoPosition$.MODULE$, new StringBuilder().append((Object)"IO error while decoding ").append((Object)filename).append((Object)" with ").append((Object)this.decoder.charset()).append((Object)"\n").append((Object)"Please try specifying another one using the -encoding option").toString());
    }

    public char[] read(File file) {
        char[] cArray;
        try (FileChannel c = new FileInputStream(file).getChannel();){
            try {
                cArray = this.read(c);
            }
            catch (Exception e) {
                this.reportEncodingError(String.valueOf(file));
                cArray = (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char());
            }
        }
        return cArray;
    }

    public char[] read(AbstractFile file) {
        char[] cArray;
        try {
            char[] cArray2;
            AbstractFile abstractFile = file;
            if (abstractFile instanceof PlainFile) {
                PlainFile plainFile = (PlainFile)abstractFile;
                cArray2 = this.read(plainFile.file());
            } else if (abstractFile instanceof ZipArchive.Entry) {
                ZipArchive.Entry entry = (ZipArchive.Entry)abstractFile;
                cArray2 = this.read(Channels.newChannel(entry.input()));
            } else {
                cArray2 = this.read(ByteBuffer.wrap(file.toByteArray()));
            }
            cArray = cArray2;
        }
        catch (Exception e) {
            this.reportEncodingError(String.valueOf(file));
            cArray = (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char());
        }
        return cArray;
    }

    public char[] read(ReadableByteChannel input) {
        CharsetDecoder decoder = this.decoder.reset();
        ByteBuffer bytes = this.bytes();
        bytes.clear();
        CharBuffer chars = this.chars();
        chars.clear();
        boolean endOfInput = false;
        while (!endOfInput) {
            endOfInput = input.read(bytes) < 0;
            bytes.flip();
            chars = SourceReader$.MODULE$.decode(decoder, bytes, chars, endOfInput);
        }
        return this.terminate(SourceReader$.MODULE$.flush(decoder, chars));
    }

    public char[] read(ByteBuffer bytes) {
        CharsetDecoder decoder = this.decoder.reset();
        CharBuffer chars = this.chars();
        chars.clear();
        return this.terminate(SourceReader$.MODULE$.flush(decoder, SourceReader$.MODULE$.decode(decoder, bytes, chars, true)));
    }

    /*
     * WARNING - void declaration
     */
    private char[] terminate(CharBuffer chars) {
        void var2_2;
        char[] result = new char[chars.length()];
        chars.get(result);
        this.chars_$eq(chars);
        return var2_2;
    }

    public SourceReader(CharsetDecoder decoder, Reporter reporter) {
        this.decoder = decoder;
        this.reporter = reporter;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }
}

