/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline_embedded.console.completer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import scala.tools.jline_embedded.console.ConsoleReader;
import scala.tools.jline_embedded.console.CursorBuffer;
import scala.tools.jline_embedded.console.completer.CompletionHandler;
import scala.tools.jline_embedded.internal.Ansi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandidateListCompletionHandler
implements CompletionHandler {
    private boolean printSpaceAfterFullCompletion = true;
    private boolean stripAnsi;

    public boolean getPrintSpaceAfterFullCompletion() {
        return this.printSpaceAfterFullCompletion;
    }

    public void setPrintSpaceAfterFullCompletion(boolean printSpaceAfterFullCompletion) {
        this.printSpaceAfterFullCompletion = printSpaceAfterFullCompletion;
    }

    public boolean isStripAnsi() {
        return this.stripAnsi;
    }

    public void setStripAnsi(boolean stripAnsi) {
        this.stripAnsi = stripAnsi;
    }

    @Override
    public boolean complete(ConsoleReader reader, List<CharSequence> candidates2, int pos2) throws IOException {
        CursorBuffer buf = reader.getCursorBuffer();
        if (candidates2.size() == 1) {
            String value2 = Ansi.stripAnsi(candidates2.get(0).toString());
            if (buf.cursor == buf.buffer.length() && this.printSpaceAfterFullCompletion && !value2.endsWith(" ")) {
                value2 = value2 + " ";
            }
            if (value2.equals(buf.toString())) {
                return false;
            }
            CandidateListCompletionHandler.setBuffer(reader, value2, pos2);
            return true;
        }
        if (candidates2.size() > 1) {
            String value3 = this.getUnambiguousCompletions(candidates2);
            CandidateListCompletionHandler.setBuffer(reader, value3, pos2);
        }
        CandidateListCompletionHandler.printCandidates(reader, candidates2);
        reader.drawLine();
        return true;
    }

    public static void setBuffer(ConsoleReader reader, CharSequence value2, int offset) throws IOException {
        while (reader.getCursorBuffer().cursor > offset && reader.backspace()) {
        }
        reader.putString(value2);
        reader.setCursorPosition(offset + value2.length());
    }

    public static void printCandidates(ConsoleReader reader, Collection<CharSequence> candidates2) throws IOException {
        HashSet<CharSequence> distinct = new HashSet<CharSequence>(candidates2);
        if (distinct.size() > reader.getAutoprintThreshold()) {
            int c;
            reader.println();
            reader.print(Messages.DISPLAY_CANDIDATES.format(distinct.size()));
            reader.flush();
            String noOpt = Messages.DISPLAY_CANDIDATES_NO.format(new Object[0]);
            String yesOpt = Messages.DISPLAY_CANDIDATES_YES.format(new Object[0]);
            char[] allowed = new char[]{yesOpt.charAt(0), noOpt.charAt(0)};
            while ((c = reader.readCharacter(allowed)) != -1) {
                String tmp = new String(new char[]{(char)c});
                if (noOpt.startsWith(tmp)) {
                    reader.println();
                    return;
                }
                if (yesOpt.startsWith(tmp)) break;
                reader.beep();
            }
        }
        if (distinct.size() != candidates2.size()) {
            ArrayList<CharSequence> copy2 = new ArrayList<CharSequence>();
            for (CharSequence next : candidates2) {
                if (copy2.contains(next)) continue;
                copy2.add(next);
            }
            candidates2 = copy2;
        }
        reader.println();
        reader.printColumns(candidates2);
    }

    private String getUnambiguousCompletions(List<CharSequence> candidates2) {
        if (candidates2 == null || candidates2.isEmpty()) {
            return null;
        }
        if (candidates2.size() == 1) {
            return candidates2.get(0).toString();
        }
        String first = null;
        String[] strings = new String[candidates2.size() - 1];
        for (int i = 0; i < candidates2.size(); ++i) {
            String str = candidates2.get(i).toString();
            if (this.stripAnsi) {
                str = Ansi.stripAnsi(str);
            }
            if (first == null) {
                first = str;
                continue;
            }
            strings[i - 1] = str;
        }
        StringBuilder candidate = new StringBuilder();
        for (int i = 0; i < first.length() && CandidateListCompletionHandler.startsWith(first.substring(0, i + 1), strings); ++i) {
            candidate.append(first.charAt(i));
        }
        return candidate.toString();
    }

    private static boolean startsWith(String starts, String[] candidates2) {
        for (String candidate : candidates2) {
            if (candidate.toLowerCase().startsWith(starts.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Messages {
        DISPLAY_CANDIDATES,
        DISPLAY_CANDIDATES_YES,
        DISPLAY_CANDIDATES_NO;

        private static final ResourceBundle bundle;

        public String format(Object ... args2) {
            if (bundle == null) {
                return "";
            }
            return String.format(bundle.getString(this.name()), args2);
        }

        static {
            bundle = ResourceBundle.getBundle(CandidateListCompletionHandler.class.getName(), Locale.getDefault());
        }
    }
}

