/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.console.completer;

import java.io.File;
import java.util.List;
import scala.tools.jline.console.completer.Completer;
import scala.tools.jline.internal.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNameCompleter
implements Completer {
    private static final boolean OS_IS_WINDOWS;

    @Override
    public int complete(String string, int n, List<CharSequence> list) {
        Object object;
        assert (list != null);
        if (string == null) {
            string = "";
        }
        if (OS_IS_WINDOWS) {
            string = string.replace('/', '\\');
        }
        String string2 = string;
        File file = this.getUserHome();
        if (string2.startsWith("~" + this.separator())) {
            string2 = file.getPath() + string2.substring(1);
        } else if (string2.startsWith("~")) {
            string2 = file.getParentFile().getAbsolutePath();
        } else if (!string2.startsWith(this.separator())) {
            object = this.getUserDir().getAbsolutePath();
            string2 = (String)object + this.separator() + string2;
        }
        object = new File(string2);
        Object object2 = string2.endsWith(this.separator()) ? object : ((File)object).getParentFile();
        File[] fileArray = object2 == null ? new File[]{} : ((File)object2).listFiles();
        return this.matchFiles(string, string2, fileArray, list);
    }

    protected String separator() {
        return File.separator;
    }

    protected File getUserHome() {
        return Configuration.getUserHome();
    }

    protected File getUserDir() {
        return new File(".");
    }

    protected int matchFiles(String string, String string2, File[] fileArray, List<CharSequence> list) {
        if (fileArray == null) {
            return -1;
        }
        int n = 0;
        for (File file : fileArray) {
            if (!file.getAbsolutePath().startsWith(string2)) continue;
            ++n;
        }
        for (File file : fileArray) {
            if (!file.getAbsolutePath().startsWith(string2)) continue;
            String string3 = file.getName() + (n == 1 && file.isDirectory() ? this.separator() : " ");
            list.add(this.render(file, string3).toString());
        }
        int n2 = string.lastIndexOf(this.separator());
        return n2 + this.separator().length();
    }

    protected CharSequence render(File file, CharSequence charSequence) {
        assert (file != null);
        assert (charSequence != null);
        return charSequence;
    }

    static {
        String string = Configuration.getOsName();
        OS_IS_WINDOWS = string.contains("windows");
    }
}

