/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiOutputStream;
import org.fusesource.jansi.WindowsAnsiOutputStream;
import scala.tools.jline.WindowsTerminal;

public class AnsiWindowsTerminal
extends WindowsTerminal {
    private final boolean ansiSupported = AnsiWindowsTerminal.detectAnsiSupport();

    public OutputStream wrapOutIfNeeded(OutputStream outputStream) {
        return AnsiWindowsTerminal.wrapOutputStream(outputStream);
    }

    private static OutputStream wrapOutputStream(OutputStream outputStream) {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            try {
                return new WindowsAnsiOutputStream(outputStream);
            }
            catch (Throwable throwable) {
                return new AnsiOutputStream(outputStream);
            }
        }
        return outputStream;
    }

    private static boolean detectAnsiSupport() {
        OutputStream outputStream = AnsiConsole.wrapOutputStream(new ByteArrayOutputStream());
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outputStream instanceof WindowsAnsiOutputStream;
    }

    public boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    public boolean hasWeirdWrap() {
        return false;
    }
}

