/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.rocksdb.AbstractCompactionFilter;
import org.rocksdb.AbstractCompactionFilterFactory;
import org.rocksdb.AbstractComparator;
import org.rocksdb.AbstractSlice;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.ColumnFamilyOptionsInterface;
import org.rocksdb.CompactionOptionsFIFO;
import org.rocksdb.CompactionOptionsUniversal;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.MemTableConfig;
import org.rocksdb.MergeOperator;
import org.rocksdb.MutableColumnFamilyOptionsInterface;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksObject;
import org.rocksdb.TableFormatConfig;

public class ColumnFamilyOptions
extends RocksObject
implements ColumnFamilyOptionsInterface<ColumnFamilyOptions>,
MutableColumnFamilyOptionsInterface<ColumnFamilyOptions> {
    private MemTableConfig memTableConfig_;
    private TableFormatConfig tableFormatConfig_;
    private AbstractComparator comparator_;
    private AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter_;
    private AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory_;
    private CompactionOptionsUniversal compactionOptionsUniversal_;
    private CompactionOptionsFIFO compactionOptionsFIFO_;
    private CompressionOptions bottommostCompressionOptions_;
    private CompressionOptions compressionOptions_;

    public ColumnFamilyOptions() {
        super(ColumnFamilyOptions.newColumnFamilyOptions());
    }

    public ColumnFamilyOptions(ColumnFamilyOptions columnFamilyOptions) {
        super(ColumnFamilyOptions.copyColumnFamilyOptions(columnFamilyOptions.nativeHandle_));
        this.memTableConfig_ = columnFamilyOptions.memTableConfig_;
        this.tableFormatConfig_ = columnFamilyOptions.tableFormatConfig_;
        this.comparator_ = columnFamilyOptions.comparator_;
        this.compactionFilter_ = columnFamilyOptions.compactionFilter_;
        this.compactionFilterFactory_ = columnFamilyOptions.compactionFilterFactory_;
        this.compactionOptionsUniversal_ = columnFamilyOptions.compactionOptionsUniversal_;
        this.compactionOptionsFIFO_ = columnFamilyOptions.compactionOptionsFIFO_;
        this.bottommostCompressionOptions_ = columnFamilyOptions.bottommostCompressionOptions_;
        this.compressionOptions_ = columnFamilyOptions.compressionOptions_;
    }

    public ColumnFamilyOptions(Options options) {
        super(ColumnFamilyOptions.newColumnFamilyOptionsFromOptions(options.nativeHandle_));
    }

    ColumnFamilyOptions(long l) {
        super(l);
    }

    public static ColumnFamilyOptions getColumnFamilyOptionsFromProps(Properties properties) {
        if (properties == null || properties.size() == 0) {
            throw new IllegalArgumentException("Properties value must contain at least one value.");
        }
        ColumnFamilyOptions columnFamilyOptions = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : properties.stringPropertyNames()) {
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(properties.getProperty(string));
            stringBuilder.append(";");
        }
        long l = ColumnFamilyOptions.getColumnFamilyOptionsFromProps(stringBuilder.toString());
        if (l != 0L) {
            columnFamilyOptions = new ColumnFamilyOptions(l);
        }
        return columnFamilyOptions;
    }

    @Override
    public ColumnFamilyOptions optimizeForSmallDb() {
        this.optimizeForSmallDb(this.nativeHandle_);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeForPointLookup(long l) {
        this.optimizeForPointLookup(this.nativeHandle_, l);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeLevelStyleCompaction() {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeLevelStyleCompaction(long l) {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, l);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeUniversalStyleCompaction() {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeUniversalStyleCompaction(long l) {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, l);
        return this;
    }

    @Override
    public ColumnFamilyOptions setComparator(BuiltinComparator builtinComparator) {
        assert (this.isOwningHandle());
        this.setComparatorHandle(this.nativeHandle_, builtinComparator.ordinal());
        return this;
    }

    @Override
    public ColumnFamilyOptions setComparator(AbstractComparator abstractComparator) {
        assert (this.isOwningHandle());
        this.setComparatorHandle(this.nativeHandle_, abstractComparator.nativeHandle_, abstractComparator.getComparatorType().getValue());
        this.comparator_ = abstractComparator;
        return this;
    }

    @Override
    public ColumnFamilyOptions setMergeOperatorName(String string) {
        assert (this.isOwningHandle());
        if (string == null) {
            throw new IllegalArgumentException("Merge operator name must not be null.");
        }
        this.setMergeOperatorName(this.nativeHandle_, string);
        return this;
    }

    @Override
    public ColumnFamilyOptions setMergeOperator(MergeOperator mergeOperator) {
        this.setMergeOperator(this.nativeHandle_, mergeOperator.nativeHandle_);
        return this;
    }

    @Override
    public ColumnFamilyOptions setCompactionFilter(AbstractCompactionFilter<? extends AbstractSlice<?>> abstractCompactionFilter) {
        this.setCompactionFilterHandle(this.nativeHandle_, abstractCompactionFilter.nativeHandle_);
        this.compactionFilter_ = abstractCompactionFilter;
        return this;
    }

    @Override
    public AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter() {
        assert (this.isOwningHandle());
        return this.compactionFilter_;
    }

    @Override
    public ColumnFamilyOptions setCompactionFilterFactory(AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> abstractCompactionFilterFactory) {
        assert (this.isOwningHandle());
        this.setCompactionFilterFactoryHandle(this.nativeHandle_, abstractCompactionFilterFactory.nativeHandle_);
        this.compactionFilterFactory_ = abstractCompactionFilterFactory;
        return this;
    }

    @Override
    public AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory() {
        assert (this.isOwningHandle());
        return this.compactionFilterFactory_;
    }

    @Override
    public ColumnFamilyOptions setWriteBufferSize(long l) {
        assert (this.isOwningHandle());
        this.setWriteBufferSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long writeBufferSize() {
        assert (this.isOwningHandle());
        return this.writeBufferSize(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxWriteBufferNumber(int n) {
        assert (this.isOwningHandle());
        this.setMaxWriteBufferNumber(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxWriteBufferNumber() {
        assert (this.isOwningHandle());
        return this.maxWriteBufferNumber(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMinWriteBufferNumberToMerge(int n) {
        this.setMinWriteBufferNumberToMerge(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int minWriteBufferNumberToMerge() {
        return this.minWriteBufferNumberToMerge(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions useFixedLengthPrefixExtractor(int n) {
        assert (this.isOwningHandle());
        this.useFixedLengthPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public ColumnFamilyOptions useCappedPrefixExtractor(int n) {
        assert (this.isOwningHandle());
        this.useCappedPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public ColumnFamilyOptions setCompressionType(CompressionType compressionType) {
        this.setCompressionType(this.nativeHandle_, compressionType.getValue());
        return this;
    }

    @Override
    public CompressionType compressionType() {
        return CompressionType.getCompressionType(this.compressionType(this.nativeHandle_));
    }

    @Override
    public ColumnFamilyOptions setCompressionPerLevel(List<CompressionType> list) {
        byte[] byArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            byArray[i] = list.get(i).getValue();
        }
        this.setCompressionPerLevel(this.nativeHandle_, byArray);
        return this;
    }

    @Override
    public List<CompressionType> compressionPerLevel() {
        byte[] byArray = this.compressionPerLevel(this.nativeHandle_);
        ArrayList<CompressionType> arrayList = new ArrayList<CompressionType>();
        byte[] byArray2 = byArray;
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            Byte by = byArray2[i];
            arrayList.add(CompressionType.getCompressionType(by));
        }
        return arrayList;
    }

    @Override
    public ColumnFamilyOptions setBottommostCompressionType(CompressionType compressionType) {
        this.setBottommostCompressionType(this.nativeHandle_, compressionType.getValue());
        return this;
    }

    @Override
    public CompressionType bottommostCompressionType() {
        return CompressionType.getCompressionType(this.bottommostCompressionType(this.nativeHandle_));
    }

    @Override
    public ColumnFamilyOptions setBottommostCompressionOptions(CompressionOptions compressionOptions) {
        this.setBottommostCompressionOptions(this.nativeHandle_, compressionOptions.nativeHandle_);
        this.bottommostCompressionOptions_ = compressionOptions;
        return this;
    }

    @Override
    public CompressionOptions bottommostCompressionOptions() {
        return this.bottommostCompressionOptions_;
    }

    @Override
    public ColumnFamilyOptions setCompressionOptions(CompressionOptions compressionOptions) {
        this.setCompressionOptions(this.nativeHandle_, compressionOptions.nativeHandle_);
        this.compressionOptions_ = compressionOptions;
        return this;
    }

    @Override
    public CompressionOptions compressionOptions() {
        return this.compressionOptions_;
    }

    @Override
    public ColumnFamilyOptions setNumLevels(int n) {
        this.setNumLevels(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int numLevels() {
        return this.numLevels(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelZeroFileNumCompactionTrigger(int n) {
        this.setLevelZeroFileNumCompactionTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroFileNumCompactionTrigger() {
        return this.levelZeroFileNumCompactionTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelZeroSlowdownWritesTrigger(int n) {
        this.setLevelZeroSlowdownWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroSlowdownWritesTrigger() {
        return this.levelZeroSlowdownWritesTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelZeroStopWritesTrigger(int n) {
        this.setLevelZeroStopWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroStopWritesTrigger() {
        return this.levelZeroStopWritesTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setTargetFileSizeBase(long l) {
        this.setTargetFileSizeBase(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long targetFileSizeBase() {
        return this.targetFileSizeBase(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setTargetFileSizeMultiplier(int n) {
        this.setTargetFileSizeMultiplier(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int targetFileSizeMultiplier() {
        return this.targetFileSizeMultiplier(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxBytesForLevelBase(long l) {
        this.setMaxBytesForLevelBase(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxBytesForLevelBase() {
        return this.maxBytesForLevelBase(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelCompactionDynamicLevelBytes(boolean bl) {
        this.setLevelCompactionDynamicLevelBytes(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean levelCompactionDynamicLevelBytes() {
        return this.levelCompactionDynamicLevelBytes(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxBytesForLevelMultiplier(double d) {
        this.setMaxBytesForLevelMultiplier(this.nativeHandle_, d);
        return this;
    }

    @Override
    public double maxBytesForLevelMultiplier() {
        return this.maxBytesForLevelMultiplier(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxCompactionBytes(long l) {
        this.setMaxCompactionBytes(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxCompactionBytes() {
        return this.maxCompactionBytes(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setArenaBlockSize(long l) {
        this.setArenaBlockSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long arenaBlockSize() {
        return this.arenaBlockSize(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setDisableAutoCompactions(boolean bl) {
        this.setDisableAutoCompactions(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean disableAutoCompactions() {
        return this.disableAutoCompactions(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setCompactionStyle(CompactionStyle compactionStyle) {
        this.setCompactionStyle(this.nativeHandle_, compactionStyle.getValue());
        return this;
    }

    @Override
    public CompactionStyle compactionStyle() {
        return CompactionStyle.fromValue(this.compactionStyle(this.nativeHandle_));
    }

    @Override
    public ColumnFamilyOptions setMaxTableFilesSizeFIFO(long l) {
        assert (l > 0L);
        assert (this.isOwningHandle());
        this.setMaxTableFilesSizeFIFO(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxTableFilesSizeFIFO() {
        return this.maxTableFilesSizeFIFO(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxSequentialSkipInIterations(long l) {
        this.setMaxSequentialSkipInIterations(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxSequentialSkipInIterations() {
        return this.maxSequentialSkipInIterations(this.nativeHandle_);
    }

    @Override
    public MemTableConfig memTableConfig() {
        return this.memTableConfig_;
    }

    @Override
    public ColumnFamilyOptions setMemTableConfig(MemTableConfig memTableConfig) {
        this.setMemTableFactory(this.nativeHandle_, memTableConfig.newMemTableFactoryHandle());
        this.memTableConfig_ = memTableConfig;
        return this;
    }

    @Override
    public String memTableFactoryName() {
        assert (this.isOwningHandle());
        return this.memTableFactoryName(this.nativeHandle_);
    }

    @Override
    public TableFormatConfig tableFormatConfig() {
        return this.tableFormatConfig_;
    }

    @Override
    public ColumnFamilyOptions setTableFormatConfig(TableFormatConfig tableFormatConfig) {
        this.setTableFactory(this.nativeHandle_, tableFormatConfig.newTableFactoryHandle());
        this.tableFormatConfig_ = tableFormatConfig;
        return this;
    }

    @Override
    public String tableFactoryName() {
        assert (this.isOwningHandle());
        return this.tableFactoryName(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setInplaceUpdateSupport(boolean bl) {
        this.setInplaceUpdateSupport(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean inplaceUpdateSupport() {
        return this.inplaceUpdateSupport(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setInplaceUpdateNumLocks(long l) {
        this.setInplaceUpdateNumLocks(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long inplaceUpdateNumLocks() {
        return this.inplaceUpdateNumLocks(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMemtablePrefixBloomSizeRatio(double d) {
        this.setMemtablePrefixBloomSizeRatio(this.nativeHandle_, d);
        return this;
    }

    @Override
    public double memtablePrefixBloomSizeRatio() {
        return this.memtablePrefixBloomSizeRatio(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setBloomLocality(int n) {
        this.setBloomLocality(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int bloomLocality() {
        return this.bloomLocality(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxSuccessiveMerges(long l) {
        this.setMaxSuccessiveMerges(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxSuccessiveMerges() {
        return this.maxSuccessiveMerges(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setOptimizeFiltersForHits(boolean bl) {
        this.setOptimizeFiltersForHits(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean optimizeFiltersForHits() {
        return this.optimizeFiltersForHits(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMemtableHugePageSize(long l) {
        this.setMemtableHugePageSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long memtableHugePageSize() {
        return this.memtableHugePageSize(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setSoftPendingCompactionBytesLimit(long l) {
        this.setSoftPendingCompactionBytesLimit(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long softPendingCompactionBytesLimit() {
        return this.softPendingCompactionBytesLimit(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setHardPendingCompactionBytesLimit(long l) {
        this.setHardPendingCompactionBytesLimit(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long hardPendingCompactionBytesLimit() {
        return this.hardPendingCompactionBytesLimit(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevel0FileNumCompactionTrigger(int n) {
        this.setLevel0FileNumCompactionTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int level0FileNumCompactionTrigger() {
        return this.level0FileNumCompactionTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevel0SlowdownWritesTrigger(int n) {
        this.setLevel0SlowdownWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int level0SlowdownWritesTrigger() {
        return this.level0SlowdownWritesTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevel0StopWritesTrigger(int n) {
        this.setLevel0StopWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int level0StopWritesTrigger() {
        return this.level0StopWritesTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxBytesForLevelMultiplierAdditional(int[] nArray) {
        this.setMaxBytesForLevelMultiplierAdditional(this.nativeHandle_, nArray);
        return this;
    }

    @Override
    public int[] maxBytesForLevelMultiplierAdditional() {
        return this.maxBytesForLevelMultiplierAdditional(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setParanoidFileChecks(boolean bl) {
        this.setParanoidFileChecks(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean paranoidFileChecks() {
        return this.paranoidFileChecks(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxWriteBufferNumberToMaintain(int n) {
        this.setMaxWriteBufferNumberToMaintain(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxWriteBufferNumberToMaintain() {
        return this.maxWriteBufferNumberToMaintain(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setCompactionPriority(CompactionPriority compactionPriority) {
        this.setCompactionPriority(this.nativeHandle_, compactionPriority.getValue());
        return this;
    }

    @Override
    public CompactionPriority compactionPriority() {
        return CompactionPriority.getCompactionPriority(this.compactionPriority(this.nativeHandle_));
    }

    @Override
    public ColumnFamilyOptions setReportBgIoStats(boolean bl) {
        this.setReportBgIoStats(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean reportBgIoStats() {
        return this.reportBgIoStats(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setTtl(long l) {
        this.setTtl(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long ttl() {
        return this.ttl(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setCompactionOptionsUniversal(CompactionOptionsUniversal compactionOptionsUniversal) {
        this.setCompactionOptionsUniversal(this.nativeHandle_, compactionOptionsUniversal.nativeHandle_);
        this.compactionOptionsUniversal_ = compactionOptionsUniversal;
        return this;
    }

    @Override
    public CompactionOptionsUniversal compactionOptionsUniversal() {
        return this.compactionOptionsUniversal_;
    }

    @Override
    public ColumnFamilyOptions setCompactionOptionsFIFO(CompactionOptionsFIFO compactionOptionsFIFO) {
        this.setCompactionOptionsFIFO(this.nativeHandle_, compactionOptionsFIFO.nativeHandle_);
        this.compactionOptionsFIFO_ = compactionOptionsFIFO;
        return this;
    }

    @Override
    public CompactionOptionsFIFO compactionOptionsFIFO() {
        return this.compactionOptionsFIFO_;
    }

    @Override
    public ColumnFamilyOptions setForceConsistencyChecks(boolean bl) {
        this.setForceConsistencyChecks(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean forceConsistencyChecks() {
        return this.forceConsistencyChecks(this.nativeHandle_);
    }

    private static native long getColumnFamilyOptionsFromProps(String var0);

    private static native long newColumnFamilyOptions();

    private static native long copyColumnFamilyOptions(long var0);

    private static native long newColumnFamilyOptionsFromOptions(long var0);

    @Override
    protected final native void disposeInternal(long var1);

    private native void optimizeForSmallDb(long var1);

    private native void optimizeForPointLookup(long var1, long var3);

    private native void optimizeLevelStyleCompaction(long var1, long var3);

    private native void optimizeUniversalStyleCompaction(long var1, long var3);

    private native void setComparatorHandle(long var1, int var3);

    private native void setComparatorHandle(long var1, long var3, byte var5);

    private native void setMergeOperatorName(long var1, String var3);

    private native void setMergeOperator(long var1, long var3);

    private native void setCompactionFilterHandle(long var1, long var3);

    private native void setCompactionFilterFactoryHandle(long var1, long var3);

    private native void setWriteBufferSize(long var1, long var3) throws IllegalArgumentException;

    private native long writeBufferSize(long var1);

    private native void setMaxWriteBufferNumber(long var1, int var3);

    private native int maxWriteBufferNumber(long var1);

    private native void setMinWriteBufferNumberToMerge(long var1, int var3);

    private native int minWriteBufferNumberToMerge(long var1);

    private native void setCompressionType(long var1, byte var3);

    private native byte compressionType(long var1);

    private native void setCompressionPerLevel(long var1, byte[] var3);

    private native byte[] compressionPerLevel(long var1);

    private native void setBottommostCompressionType(long var1, byte var3);

    private native byte bottommostCompressionType(long var1);

    private native void setBottommostCompressionOptions(long var1, long var3);

    private native void setCompressionOptions(long var1, long var3);

    private native void useFixedLengthPrefixExtractor(long var1, int var3);

    private native void useCappedPrefixExtractor(long var1, int var3);

    private native void setNumLevels(long var1, int var3);

    private native int numLevels(long var1);

    private native void setLevelZeroFileNumCompactionTrigger(long var1, int var3);

    private native int levelZeroFileNumCompactionTrigger(long var1);

    private native void setLevelZeroSlowdownWritesTrigger(long var1, int var3);

    private native int levelZeroSlowdownWritesTrigger(long var1);

    private native void setLevelZeroStopWritesTrigger(long var1, int var3);

    private native int levelZeroStopWritesTrigger(long var1);

    private native void setTargetFileSizeBase(long var1, long var3);

    private native long targetFileSizeBase(long var1);

    private native void setTargetFileSizeMultiplier(long var1, int var3);

    private native int targetFileSizeMultiplier(long var1);

    private native void setMaxBytesForLevelBase(long var1, long var3);

    private native long maxBytesForLevelBase(long var1);

    private native void setLevelCompactionDynamicLevelBytes(long var1, boolean var3);

    private native boolean levelCompactionDynamicLevelBytes(long var1);

    private native void setMaxBytesForLevelMultiplier(long var1, double var3);

    private native double maxBytesForLevelMultiplier(long var1);

    private native void setMaxCompactionBytes(long var1, long var3);

    private native long maxCompactionBytes(long var1);

    private native void setArenaBlockSize(long var1, long var3) throws IllegalArgumentException;

    private native long arenaBlockSize(long var1);

    private native void setDisableAutoCompactions(long var1, boolean var3);

    private native boolean disableAutoCompactions(long var1);

    private native void setCompactionStyle(long var1, byte var3);

    private native byte compactionStyle(long var1);

    private native void setMaxTableFilesSizeFIFO(long var1, long var3);

    private native long maxTableFilesSizeFIFO(long var1);

    private native void setMaxSequentialSkipInIterations(long var1, long var3);

    private native long maxSequentialSkipInIterations(long var1);

    private native void setMemTableFactory(long var1, long var3);

    private native String memTableFactoryName(long var1);

    private native void setTableFactory(long var1, long var3);

    private native String tableFactoryName(long var1);

    private native void setInplaceUpdateSupport(long var1, boolean var3);

    private native boolean inplaceUpdateSupport(long var1);

    private native void setInplaceUpdateNumLocks(long var1, long var3) throws IllegalArgumentException;

    private native long inplaceUpdateNumLocks(long var1);

    private native void setMemtablePrefixBloomSizeRatio(long var1, double var3);

    private native double memtablePrefixBloomSizeRatio(long var1);

    private native void setBloomLocality(long var1, int var3);

    private native int bloomLocality(long var1);

    private native void setMaxSuccessiveMerges(long var1, long var3) throws IllegalArgumentException;

    private native long maxSuccessiveMerges(long var1);

    private native void setOptimizeFiltersForHits(long var1, boolean var3);

    private native boolean optimizeFiltersForHits(long var1);

    private native void setMemtableHugePageSize(long var1, long var3);

    private native long memtableHugePageSize(long var1);

    private native void setSoftPendingCompactionBytesLimit(long var1, long var3);

    private native long softPendingCompactionBytesLimit(long var1);

    private native void setHardPendingCompactionBytesLimit(long var1, long var3);

    private native long hardPendingCompactionBytesLimit(long var1);

    private native void setLevel0FileNumCompactionTrigger(long var1, int var3);

    private native int level0FileNumCompactionTrigger(long var1);

    private native void setLevel0SlowdownWritesTrigger(long var1, int var3);

    private native int level0SlowdownWritesTrigger(long var1);

    private native void setLevel0StopWritesTrigger(long var1, int var3);

    private native int level0StopWritesTrigger(long var1);

    private native void setMaxBytesForLevelMultiplierAdditional(long var1, int[] var3);

    private native int[] maxBytesForLevelMultiplierAdditional(long var1);

    private native void setParanoidFileChecks(long var1, boolean var3);

    private native boolean paranoidFileChecks(long var1);

    private native void setMaxWriteBufferNumberToMaintain(long var1, int var3);

    private native int maxWriteBufferNumberToMaintain(long var1);

    private native void setCompactionPriority(long var1, byte var3);

    private native byte compactionPriority(long var1);

    private native void setReportBgIoStats(long var1, boolean var3);

    private native boolean reportBgIoStats(long var1);

    private native void setTtl(long var1, long var3);

    private native long ttl(long var1);

    private native void setCompactionOptionsUniversal(long var1, long var3);

    private native void setCompactionOptionsFIFO(long var1, long var3);

    private native void setForceConsistencyChecks(long var1, boolean var3);

    private native boolean forceConsistencyChecks(long var1);

    static {
        RocksDB.loadLibrary();
    }
}

