/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

public enum CompressionType {
    NO_COMPRESSION(0, null),
    SNAPPY_COMPRESSION(1, "snappy"),
    ZLIB_COMPRESSION(2, "z"),
    BZLIB2_COMPRESSION(3, "bzip2"),
    LZ4_COMPRESSION(4, "lz4"),
    LZ4HC_COMPRESSION(5, "lz4hc"),
    XPRESS_COMPRESSION(6, "xpress"),
    ZSTD_COMPRESSION(7, "zstd"),
    DISABLE_COMPRESSION_OPTION(127, null);

    private final byte value_;
    private final String libraryName_;

    public static CompressionType getCompressionType(String string) {
        if (string != null) {
            for (CompressionType compressionType : CompressionType.values()) {
                if (compressionType.getLibraryName() == null || !compressionType.getLibraryName().equals(string)) continue;
                return compressionType;
            }
        }
        return NO_COMPRESSION;
    }

    public static CompressionType getCompressionType(byte by) {
        for (CompressionType compressionType : CompressionType.values()) {
            if (compressionType.getValue() != by) continue;
            return compressionType;
        }
        throw new IllegalArgumentException("Illegal value provided for CompressionType.");
    }

    public byte getValue() {
        return this.value_;
    }

    public String getLibraryName() {
        return this.libraryName_;
    }

    private CompressionType(byte by, String string2) {
        this.value_ = by;
        this.libraryName_ = string2;
    }
}

