/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.rocksdb.util.Environment;

public class NativeLibraryLoader {
    private static final NativeLibraryLoader instance = new NativeLibraryLoader();
    private static boolean initialized = false;
    private static final String sharedLibraryName = Environment.getSharedLibraryName("rocksdb");
    private static final String jniLibraryName = Environment.getJniLibraryName("rocksdb");
    private static final String jniLibraryFileName = Environment.getJniLibraryFileName("rocksdb");
    private static final String tempFilePrefix = "librocksdbjni";
    private static final String tempFileSuffix = Environment.getJniLibraryExtension();

    public static NativeLibraryLoader getInstance() {
        return instance;
    }

    public synchronized void loadLibrary(String string) throws IOException {
        try {
            System.loadLibrary(sharedLibraryName);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                System.loadLibrary(jniLibraryName);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                this.loadLibraryFromJar(string);
            }
        }
    }

    void loadLibraryFromJar(String string) throws IOException {
        if (!initialized) {
            System.load(this.loadLibraryFromJarToTemp(string).getAbsolutePath());
            initialized = true;
        }
    }

    File loadLibraryFromJarToTemp(String string) throws IOException {
        Object object;
        File file;
        if (string == null || string.isEmpty()) {
            file = File.createTempFile(tempFilePrefix, tempFileSuffix);
        } else {
            object = new File(string);
            if (!((File)object).exists()) {
                throw new RuntimeException("Directory: " + ((File)object).getAbsolutePath() + " does not exist!");
            }
            file = new File((File)object, jniLibraryFileName);
            if (file.exists() && !file.delete()) {
                throw new RuntimeException("File: " + file.getAbsolutePath() + " already exists and cannot be removed.");
            }
            if (!file.createNewFile()) {
                throw new RuntimeException("File: " + file.getAbsolutePath() + " could not be created.");
            }
        }
        if (!file.exists()) {
            throw new RuntimeException("File " + file.getAbsolutePath() + " does not exist.");
        }
        file.deleteOnExit();
        object = this.getClass().getClassLoader().getResourceAsStream(jniLibraryFileName);
        Throwable throwable = null;
        try {
            if (object == null) {
                throw new RuntimeException(jniLibraryFileName + " was not found inside JAR.");
            }
            Files.copy((InputStream)object, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((InputStream)object).close();
                }
            }
        }
        return file;
    }

    private NativeLibraryLoader() {
    }
}

