/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DBOptionsInterface;
import org.rocksdb.ExternalSstFileInfo;
import org.rocksdb.FlushOptions;
import org.rocksdb.MutableColumnFamilyOptions;
import org.rocksdb.NativeLibraryLoader;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksObject;
import org.rocksdb.Snapshot;
import org.rocksdb.TransactionLogIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchWithIndex;
import org.rocksdb.WriteOptions;
import org.rocksdb.util.Environment;

public class RocksDB
extends RocksObject {
    public static final byte[] DEFAULT_COLUMN_FAMILY = "default".getBytes();
    public static final int NOT_FOUND = -1;
    private static AtomicReference<LibraryState> libraryLoaded = new AtomicReference<LibraryState>(LibraryState.NOT_LOADED);
    protected DBOptionsInterface options_;

    public static void loadLibrary() {
        if (libraryLoaded.get() == LibraryState.LOADED) {
            return;
        }
        if (libraryLoaded.compareAndSet(LibraryState.NOT_LOADED, LibraryState.LOADING)) {
            String string = System.getenv("ROCKSDB_SHAREDLIB_DIR");
            for (CompressionType compressionType : CompressionType.values()) {
                try {
                    if (compressionType.getLibraryName() == null) continue;
                    System.loadLibrary(compressionType.getLibraryName());
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            try {
                NativeLibraryLoader.getInstance().loadLibrary(string);
            }
            catch (IOException iOException) {
                libraryLoaded.set(LibraryState.NOT_LOADED);
                throw new RuntimeException("Unable to load the RocksDB shared library" + iOException);
            }
            libraryLoaded.set(LibraryState.LOADED);
            return;
        }
        while (libraryLoaded.get() == LibraryState.LOADING) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void loadLibrary(List<String> list) {
        if (libraryLoaded.get() == LibraryState.LOADED) {
            return;
        }
        if (libraryLoaded.compareAndSet(LibraryState.NOT_LOADED, LibraryState.LOADING)) {
            block6: for (CompressionType object : CompressionType.values()) {
                if (object.equals((Object)CompressionType.NO_COMPRESSION)) continue;
                for (String string : list) {
                    try {
                        System.load(string + "/" + Environment.getSharedLibraryFileName(object.getLibraryName()));
                        continue block6;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    }
                }
            }
            boolean bl = false;
            UnsatisfiedLinkError unsatisfiedLinkError = null;
            for (String string : list) {
                try {
                    System.load(string + "/" + Environment.getJniLibraryFileName("rocksdbjni"));
                    bl = true;
                    break;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    unsatisfiedLinkError = unsatisfiedLinkError2;
                }
            }
            if (!bl) {
                libraryLoaded.set(LibraryState.NOT_LOADED);
                throw unsatisfiedLinkError;
            }
            libraryLoaded.set(LibraryState.LOADED);
            return;
        }
        while (libraryLoaded.get() == LibraryState.LOADING) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static RocksDB open(String string) throws RocksDBException {
        Options options = new Options();
        options.setCreateIfMissing(true);
        return RocksDB.open(options, string);
    }

    public static RocksDB open(String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        DBOptions dBOptions = new DBOptions();
        return RocksDB.open(dBOptions, string, list, list2);
    }

    public static RocksDB open(Options options, String string) throws RocksDBException {
        RocksDB rocksDB = new RocksDB(RocksDB.open(options.nativeHandle_, string));
        rocksDB.storeOptionsInstance(options);
        return rocksDB;
    }

    public static RocksDB open(DBOptions dBOptions, String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        Object object;
        byte[][] byArrayArray = new byte[list.size()][];
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            byArrayArray[i] = ((ColumnFamilyDescriptor)object).columnFamilyName();
            lArray[i] = ((ColumnFamilyDescriptor)object).columnFamilyOptions().nativeHandle_;
        }
        long[] lArray2 = RocksDB.open(dBOptions.nativeHandle_, string, byArrayArray, lArray);
        object = new RocksDB(lArray2[0]);
        super.storeOptionsInstance(dBOptions);
        for (int i = 1; i < lArray2.length; ++i) {
            list2.add(new ColumnFamilyHandle((RocksDB)object, lArray2[i]));
        }
        return object;
    }

    public static RocksDB openReadOnly(String string) throws RocksDBException {
        Options options = new Options();
        return RocksDB.openReadOnly(options, string);
    }

    public static RocksDB openReadOnly(String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        DBOptions dBOptions = new DBOptions();
        return RocksDB.openReadOnly(dBOptions, string, list, list2);
    }

    public static RocksDB openReadOnly(Options options, String string) throws RocksDBException {
        RocksDB rocksDB = new RocksDB(RocksDB.openROnly(options.nativeHandle_, string));
        rocksDB.storeOptionsInstance(options);
        return rocksDB;
    }

    public static RocksDB openReadOnly(DBOptions dBOptions, String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        Object object;
        byte[][] byArrayArray = new byte[list.size()][];
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            byArrayArray[i] = ((ColumnFamilyDescriptor)object).columnFamilyName();
            lArray[i] = ((ColumnFamilyDescriptor)object).columnFamilyOptions().nativeHandle_;
        }
        long[] lArray2 = RocksDB.openROnly(dBOptions.nativeHandle_, string, byArrayArray, lArray);
        object = new RocksDB(lArray2[0]);
        super.storeOptionsInstance(dBOptions);
        for (int i = 1; i < lArray2.length; ++i) {
            list2.add(new ColumnFamilyHandle((RocksDB)object, lArray2[i]));
        }
        return object;
    }

    public static List<byte[]> listColumnFamilies(Options options, String string) throws RocksDBException {
        return Arrays.asList(RocksDB.listColumnFamilies(options.nativeHandle_, string));
    }

    private void storeOptionsInstance(DBOptionsInterface dBOptionsInterface) {
        this.options_ = dBOptionsInterface;
    }

    public void put(byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void put(WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public boolean keyMayExist(byte[] byArray, StringBuilder stringBuilder) {
        return this.keyMayExist(this.nativeHandle_, byArray, 0, byArray.length, stringBuilder);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, StringBuilder stringBuilder) {
        return this.keyMayExist(this.nativeHandle_, byArray, 0, byArray.length, columnFamilyHandle.nativeHandle_, stringBuilder);
    }

    public boolean keyMayExist(ReadOptions readOptions, byte[] byArray, StringBuilder stringBuilder) {
        return this.keyMayExist(this.nativeHandle_, readOptions.nativeHandle_, byArray, 0, byArray.length, stringBuilder);
    }

    public boolean keyMayExist(ReadOptions readOptions, ColumnFamilyHandle columnFamilyHandle, byte[] byArray, StringBuilder stringBuilder) {
        return this.keyMayExist(this.nativeHandle_, readOptions.nativeHandle_, byArray, 0, byArray.length, columnFamilyHandle.nativeHandle_, stringBuilder);
    }

    public void write(WriteOptions writeOptions, WriteBatch writeBatch) throws RocksDBException {
        this.write0(this.nativeHandle_, writeOptions.nativeHandle_, writeBatch.nativeHandle_);
    }

    public void write(WriteOptions writeOptions, WriteBatchWithIndex writeBatchWithIndex) throws RocksDBException {
        this.write1(this.nativeHandle_, writeOptions.nativeHandle_, writeBatchWithIndex.nativeHandle_);
    }

    public void merge(byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void merge(WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public int get(byte[] byArray, byte[] byArray2) throws RocksDBException {
        return this.get(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException, IllegalArgumentException {
        return this.get(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public int get(ReadOptions readOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, byArray, 0, byArray.length);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, byArray, 0, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(ReadOptions readOptions, byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, 0, byArray.length);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, 0, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public Map<byte[], byte[]> multiGet(List<byte[]> list) throws RocksDBException {
        assert (list.size() != 0);
        byte[][] byArray = (byte[][])list.toArray((T[])new byte[list.size()][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        byte[][] byArray2 = this.multiGet(this.nativeHandle_, byArray, nArray, nArray2);
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>(RocksDB.computeCapacityHint(byArray2.length));
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == null) continue;
            hashMap.put(list.get(i), byArray2[i]);
        }
        return hashMap;
    }

    private static int computeCapacityHint(int n) {
        return (int)Math.ceil((double)n * 1.5 + 1.0);
    }

    public Map<byte[], byte[]> multiGet(List<ColumnFamilyHandle> list, List<byte[]> list2) throws RocksDBException, IllegalArgumentException {
        assert (list2.size() != 0);
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        byte[][] byArray = (byte[][])list2.toArray((T[])new byte[list2.size()][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        byte[][] byArray2 = this.multiGet(this.nativeHandle_, byArray, nArray, nArray2, lArray);
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>(RocksDB.computeCapacityHint(byArray2.length));
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == null) continue;
            hashMap.put(list2.get(i), byArray2[i]);
        }
        return hashMap;
    }

    public Map<byte[], byte[]> multiGet(ReadOptions readOptions, List<byte[]> list) throws RocksDBException {
        assert (list.size() != 0);
        byte[][] byArray = (byte[][])list.toArray((T[])new byte[list.size()][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        byte[][] byArray2 = this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, byArray, nArray, nArray2);
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>(RocksDB.computeCapacityHint(byArray2.length));
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == null) continue;
            hashMap.put(list.get(i), byArray2[i]);
        }
        return hashMap;
    }

    public Map<byte[], byte[]> multiGet(ReadOptions readOptions, List<ColumnFamilyHandle> list, List<byte[]> list2) throws RocksDBException {
        assert (list2.size() != 0);
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        byte[][] byArray = (byte[][])list2.toArray((T[])new byte[list2.size()][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        byte[][] byArray2 = this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, byArray, nArray, nArray2, lArray);
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>(RocksDB.computeCapacityHint(byArray2.length));
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == null) continue;
            hashMap.put(list2.get(i), byArray2[i]);
        }
        return hashMap;
    }

    @Deprecated
    public void remove(byte[] byArray) throws RocksDBException {
        this.delete(byArray);
    }

    public void delete(byte[] byArray) throws RocksDBException {
        this.delete(this.nativeHandle_, byArray, 0, byArray.length);
    }

    @Deprecated
    public void remove(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        this.delete(columnFamilyHandle, byArray);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        this.delete(this.nativeHandle_, byArray, 0, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    @Deprecated
    public void remove(WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.delete(writeOptions, byArray);
    }

    public void delete(WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.delete(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length);
    }

    @Deprecated
    public void remove(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.delete(columnFamilyHandle, writeOptions, byArray);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.delete(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public void singleDelete(byte[] byArray) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, byArray, byArray.length);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public void singleDelete(WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public String getProperty(ColumnFamilyHandle columnFamilyHandle, String string) throws RocksDBException {
        return this.getProperty0(this.nativeHandle_, columnFamilyHandle.nativeHandle_, string, string.length());
    }

    public void deleteRange(byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void deleteRange(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void deleteRange(WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void deleteRange(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public String getProperty(String string) throws RocksDBException {
        return this.getProperty0(this.nativeHandle_, string, string.length());
    }

    public long getLongProperty(String string) throws RocksDBException {
        return this.getLongProperty(this.nativeHandle_, string, string.length());
    }

    public long getLongProperty(ColumnFamilyHandle columnFamilyHandle, String string) throws RocksDBException {
        return this.getLongProperty(this.nativeHandle_, columnFamilyHandle.nativeHandle_, string, string.length());
    }

    public RocksIterator newIterator() {
        return new RocksIterator(this, this.iterator(this.nativeHandle_));
    }

    public RocksIterator newIterator(ReadOptions readOptions) {
        return new RocksIterator(this, this.iterator(this.nativeHandle_, readOptions.nativeHandle_));
    }

    public Snapshot getSnapshot() {
        long l = this.getSnapshot(this.nativeHandle_);
        if (l != 0L) {
            return new Snapshot(l);
        }
        return null;
    }

    public void releaseSnapshot(Snapshot snapshot) {
        if (snapshot != null) {
            this.releaseSnapshot(this.nativeHandle_, snapshot.nativeHandle_);
        }
    }

    public RocksIterator newIterator(ColumnFamilyHandle columnFamilyHandle) {
        return new RocksIterator(this, this.iteratorCF(this.nativeHandle_, columnFamilyHandle.nativeHandle_));
    }

    public RocksIterator newIterator(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions) {
        return new RocksIterator(this, this.iteratorCF(this.nativeHandle_, columnFamilyHandle.nativeHandle_, readOptions.nativeHandle_));
    }

    public List<RocksIterator> newIterators(List<ColumnFamilyHandle> list) throws RocksDBException {
        return this.newIterators(list, new ReadOptions());
    }

    public List<RocksIterator> newIterators(List<ColumnFamilyHandle> list, ReadOptions readOptions) throws RocksDBException {
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        long[] lArray2 = this.iterators(this.nativeHandle_, lArray, readOptions.nativeHandle_);
        ArrayList<RocksIterator> arrayList = new ArrayList<RocksIterator>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new RocksIterator(this, lArray2[i]));
        }
        return arrayList;
    }

    public ColumnFamilyHandle getDefaultColumnFamily() {
        ColumnFamilyHandle columnFamilyHandle = new ColumnFamilyHandle(this, this.getDefaultColumnFamily(this.nativeHandle_));
        columnFamilyHandle.disOwnNativeHandle();
        return columnFamilyHandle;
    }

    public ColumnFamilyHandle createColumnFamily(ColumnFamilyDescriptor columnFamilyDescriptor) throws RocksDBException {
        return new ColumnFamilyHandle(this, this.createColumnFamily(this.nativeHandle_, columnFamilyDescriptor.columnFamilyName(), columnFamilyDescriptor.columnFamilyOptions().nativeHandle_));
    }

    public void dropColumnFamily(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException, IllegalArgumentException {
        this.dropColumnFamily(this.nativeHandle_, columnFamilyHandle.nativeHandle_);
        columnFamilyHandle.disOwnNativeHandle();
    }

    public void flush(FlushOptions flushOptions) throws RocksDBException {
        this.flush(this.nativeHandle_, flushOptions.nativeHandle_);
    }

    public void flush(FlushOptions flushOptions, ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        this.flush(this.nativeHandle_, flushOptions.nativeHandle_, columnFamilyHandle.nativeHandle_);
    }

    public void compactRange() throws RocksDBException {
        this.compactRange0(this.nativeHandle_, false, -1, 0);
    }

    public void compactRange(byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.compactRange0(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, false, -1, 0);
    }

    public void compactRange(boolean bl, int n, int n2) throws RocksDBException {
        this.compactRange0(this.nativeHandle_, bl, n, n2);
    }

    public void compactRange(byte[] byArray, byte[] byArray2, boolean bl, int n, int n2) throws RocksDBException {
        this.compactRange0(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, bl, n, n2);
    }

    public void compactRange(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        this.compactRange(this.nativeHandle_, false, -1, 0, columnFamilyHandle.nativeHandle_);
    }

    public void compactRange(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.compactRange(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, false, -1, 0, columnFamilyHandle.nativeHandle_);
    }

    public void compactRange(ColumnFamilyHandle columnFamilyHandle, boolean bl, int n, int n2) throws RocksDBException {
        this.compactRange(this.nativeHandle_, bl, n, n2, columnFamilyHandle.nativeHandle_);
    }

    public void compactRange(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2, boolean bl, int n, int n2) throws RocksDBException {
        this.compactRange(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, bl, n, n2, columnFamilyHandle.nativeHandle_);
    }

    public void pauseBackgroundWork() throws RocksDBException {
        this.pauseBackgroundWork(this.nativeHandle_);
    }

    public void continueBackgroundWork() throws RocksDBException {
        this.continueBackgroundWork(this.nativeHandle_);
    }

    public long getLatestSequenceNumber() {
        return this.getLatestSequenceNumber(this.nativeHandle_);
    }

    public void disableFileDeletions() throws RocksDBException {
        this.disableFileDeletions(this.nativeHandle_);
    }

    public void enableFileDeletions(boolean bl) throws RocksDBException {
        this.enableFileDeletions(this.nativeHandle_, bl);
    }

    public TransactionLogIterator getUpdatesSince(long l) throws RocksDBException {
        return new TransactionLogIterator(this.getUpdatesSince(this.nativeHandle_, l));
    }

    public void setOptions(ColumnFamilyHandle columnFamilyHandle, MutableColumnFamilyOptions mutableColumnFamilyOptions) throws RocksDBException {
        this.setOptions(this.nativeHandle_, columnFamilyHandle.nativeHandle_, mutableColumnFamilyOptions.getKeys(), mutableColumnFamilyOptions.getValues());
    }

    private long[] toNativeHandleList(List<? extends RocksObject> list) {
        int n = list.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        return lArray;
    }

    public void addFileWithFilePath(ColumnFamilyHandle columnFamilyHandle, List<String> list) throws RocksDBException {
        this.addFile(this.nativeHandle_, columnFamilyHandle.nativeHandle_, list.toArray(new String[list.size()]), list.size(), false);
    }

    public void addFileWithFilePath(ColumnFamilyHandle columnFamilyHandle, List<String> list, boolean bl) throws RocksDBException {
        this.addFile(this.nativeHandle_, columnFamilyHandle.nativeHandle_, list.toArray(new String[list.size()]), list.size(), bl);
    }

    public void addFileWithFilePath(List<String> list) throws RocksDBException {
        this.addFile(this.nativeHandle_, this.getDefaultColumnFamily().nativeHandle_, list.toArray(new String[list.size()]), list.size(), false);
    }

    public void addFileWithFilePath(List<String> list, boolean bl) throws RocksDBException {
        this.addFile(this.nativeHandle_, this.getDefaultColumnFamily().nativeHandle_, list.toArray(new String[list.size()]), list.size(), bl);
    }

    public void addFileWithFilePath(ColumnFamilyHandle columnFamilyHandle, String string) throws RocksDBException {
        this.addFile(this.nativeHandle_, columnFamilyHandle.nativeHandle_, new String[]{string}, 1, false);
    }

    public void addFileWithFilePath(ColumnFamilyHandle columnFamilyHandle, String string, boolean bl) throws RocksDBException {
        this.addFile(this.nativeHandle_, columnFamilyHandle.nativeHandle_, new String[]{string}, 1, bl);
    }

    public void addFileWithFilePath(String string) throws RocksDBException {
        this.addFile(this.nativeHandle_, this.getDefaultColumnFamily().nativeHandle_, new String[]{string}, 1, false);
    }

    public void addFileWithFilePath(String string, boolean bl) throws RocksDBException {
        this.addFile(this.nativeHandle_, this.getDefaultColumnFamily().nativeHandle_, new String[]{string}, 1, bl);
    }

    public void addFileWithFileInfo(ColumnFamilyHandle columnFamilyHandle, List<ExternalSstFileInfo> list) throws RocksDBException {
        long[] lArray = this.toNativeHandleList(list);
        this.addFile(this.nativeHandle_, columnFamilyHandle.nativeHandle_, lArray, lArray.length, false);
    }

    public void addFileWithFileInfo(ColumnFamilyHandle columnFamilyHandle, List<ExternalSstFileInfo> list, boolean bl) throws RocksDBException {
        long[] lArray = this.toNativeHandleList(list);
        this.addFile(this.nativeHandle_, columnFamilyHandle.nativeHandle_, lArray, lArray.length, bl);
    }

    public void addFileWithFileInfo(List<ExternalSstFileInfo> list) throws RocksDBException {
        long[] lArray = this.toNativeHandleList(list);
        this.addFile(this.nativeHandle_, this.getDefaultColumnFamily().nativeHandle_, lArray, lArray.length, false);
    }

    public void addFileWithFileInfo(List<ExternalSstFileInfo> list, boolean bl) throws RocksDBException {
        long[] lArray = this.toNativeHandleList(list);
        this.addFile(this.nativeHandle_, this.getDefaultColumnFamily().nativeHandle_, lArray, lArray.length, bl);
    }

    public void addFileWithFileInfo(ColumnFamilyHandle columnFamilyHandle, ExternalSstFileInfo externalSstFileInfo) throws RocksDBException {
        this.addFile(this.nativeHandle_, columnFamilyHandle.nativeHandle_, new long[]{externalSstFileInfo.nativeHandle_}, 1, false);
    }

    public void addFileWithFileInfo(ColumnFamilyHandle columnFamilyHandle, ExternalSstFileInfo externalSstFileInfo, boolean bl) throws RocksDBException {
        this.addFile(this.nativeHandle_, columnFamilyHandle.nativeHandle_, new long[]{externalSstFileInfo.nativeHandle_}, 1, bl);
    }

    public void addFileWithFileInfo(ExternalSstFileInfo externalSstFileInfo) throws RocksDBException {
        this.addFile(this.nativeHandle_, this.getDefaultColumnFamily().nativeHandle_, new long[]{externalSstFileInfo.nativeHandle_}, 1, false);
    }

    public void addFileWithFileInfo(ExternalSstFileInfo externalSstFileInfo, boolean bl) throws RocksDBException {
        this.addFile(this.nativeHandle_, this.getDefaultColumnFamily().nativeHandle_, new long[]{externalSstFileInfo.nativeHandle_}, 1, bl);
    }

    protected RocksDB(long l) {
        super(l);
    }

    protected static native long open(long var0, String var2) throws RocksDBException;

    protected static native long[] open(long var0, String var2, byte[][] var3, long[] var4) throws RocksDBException;

    protected static native long openROnly(long var0, String var2) throws RocksDBException;

    protected static native long[] openROnly(long var0, String var2, byte[][] var3, long[] var4) throws RocksDBException;

    protected static native byte[][] listColumnFamilies(long var0, String var2) throws RocksDBException;

    protected native void put(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    protected native void put(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    protected native void put(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    protected native void put(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    protected native void write0(long var1, long var3, long var5) throws RocksDBException;

    protected native void write1(long var1, long var3, long var5) throws RocksDBException;

    protected native boolean keyMayExist(long var1, byte[] var3, int var4, int var5, StringBuilder var6);

    protected native boolean keyMayExist(long var1, byte[] var3, int var4, int var5, long var6, StringBuilder var8);

    protected native boolean keyMayExist(long var1, long var3, byte[] var5, int var6, int var7, StringBuilder var8);

    protected native boolean keyMayExist(long var1, long var3, byte[] var5, int var6, int var7, long var8, StringBuilder var10);

    protected native void merge(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    protected native void merge(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    protected native void merge(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    protected native void merge(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    protected native int get(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    protected native int get(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    protected native int get(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    protected native int get(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    protected native byte[][] multiGet(long var1, byte[][] var3, int[] var4, int[] var5);

    protected native byte[][] multiGet(long var1, byte[][] var3, int[] var4, int[] var5, long[] var6);

    protected native byte[][] multiGet(long var1, long var3, byte[][] var5, int[] var6, int[] var7);

    protected native byte[][] multiGet(long var1, long var3, byte[][] var5, int[] var6, int[] var7, long[] var8);

    protected native byte[] get(long var1, byte[] var3, int var4, int var5) throws RocksDBException;

    protected native byte[] get(long var1, byte[] var3, int var4, int var5, long var6) throws RocksDBException;

    protected native byte[] get(long var1, long var3, byte[] var5, int var6, int var7) throws RocksDBException;

    protected native byte[] get(long var1, long var3, byte[] var5, int var6, int var7, long var8) throws RocksDBException;

    protected native void delete(long var1, byte[] var3, int var4, int var5) throws RocksDBException;

    protected native void delete(long var1, byte[] var3, int var4, int var5, long var6) throws RocksDBException;

    protected native void delete(long var1, long var3, byte[] var5, int var6, int var7) throws RocksDBException;

    protected native void delete(long var1, long var3, byte[] var5, int var6, int var7, long var8) throws RocksDBException;

    protected native void singleDelete(long var1, byte[] var3, int var4) throws RocksDBException;

    protected native void singleDelete(long var1, byte[] var3, int var4, long var5) throws RocksDBException;

    protected native void singleDelete(long var1, long var3, byte[] var5, int var6) throws RocksDBException;

    protected native void singleDelete(long var1, long var3, byte[] var5, int var6, long var7) throws RocksDBException;

    protected native void deleteRange(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    protected native void deleteRange(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    protected native void deleteRange(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    protected native void deleteRange(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    protected native String getProperty0(long var1, String var3, int var4) throws RocksDBException;

    protected native String getProperty0(long var1, long var3, String var5, int var6) throws RocksDBException;

    protected native long getLongProperty(long var1, String var3, int var4) throws RocksDBException;

    protected native long getLongProperty(long var1, long var3, String var5, int var6) throws RocksDBException;

    protected native long iterator(long var1);

    protected native long iterator(long var1, long var3);

    protected native long iteratorCF(long var1, long var3);

    protected native long iteratorCF(long var1, long var3, long var5);

    protected native long[] iterators(long var1, long[] var3, long var4) throws RocksDBException;

    protected native long getSnapshot(long var1);

    protected native void releaseSnapshot(long var1, long var3);

    @Override
    protected final native void disposeInternal(long var1);

    private native long getDefaultColumnFamily(long var1);

    private native long createColumnFamily(long var1, byte[] var3, long var4) throws RocksDBException;

    private native void dropColumnFamily(long var1, long var3) throws RocksDBException;

    private native void flush(long var1, long var3) throws RocksDBException;

    private native void flush(long var1, long var3, long var5) throws RocksDBException;

    private native void compactRange0(long var1, boolean var3, int var4, int var5) throws RocksDBException;

    private native void compactRange0(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7, int var8, int var9) throws RocksDBException;

    private native void compactRange(long var1, boolean var3, int var4, int var5, long var6) throws RocksDBException;

    private native void compactRange(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7, int var8, int var9, long var10) throws RocksDBException;

    private native void pauseBackgroundWork(long var1) throws RocksDBException;

    private native void continueBackgroundWork(long var1) throws RocksDBException;

    private native long getLatestSequenceNumber(long var1);

    private native void disableFileDeletions(long var1) throws RocksDBException;

    private native void enableFileDeletions(long var1, boolean var3) throws RocksDBException;

    private native long getUpdatesSince(long var1, long var3) throws RocksDBException;

    private native void setOptions(long var1, long var3, String[] var5, String[] var6) throws RocksDBException;

    private native void addFile(long var1, long var3, String[] var5, int var6, boolean var7) throws RocksDBException;

    private native void addFile(long var1, long var3, long[] var5, int var6, boolean var7) throws RocksDBException;

    static {
        RocksDB.loadLibrary();
    }

    private static enum LibraryState {
        NOT_LOADED,
        LOADING,
        LOADED;

    }
}

