/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.List;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.OptimisticTransactionOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Transaction;
import org.rocksdb.TransactionalDB;
import org.rocksdb.WriteOptions;

public class OptimisticTransactionDB
extends RocksDB
implements TransactionalDB<OptimisticTransactionOptions> {
    private OptimisticTransactionDB(long l) {
        super(l);
    }

    public static OptimisticTransactionDB open(Options options, String string) throws RocksDBException {
        OptimisticTransactionDB optimisticTransactionDB = new OptimisticTransactionDB(OptimisticTransactionDB.open(options.nativeHandle_, string));
        optimisticTransactionDB.storeOptionsInstance(options);
        return optimisticTransactionDB;
    }

    public static OptimisticTransactionDB open(DBOptions dBOptions, String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        Object object;
        byte[][] byArrayArray = new byte[list.size()][];
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            byArrayArray[i] = ((ColumnFamilyDescriptor)object).columnFamilyName();
            lArray[i] = ((ColumnFamilyDescriptor)object).columnFamilyOptions().nativeHandle_;
        }
        long[] lArray2 = OptimisticTransactionDB.open(dBOptions.nativeHandle_, string, byArrayArray, lArray);
        object = new OptimisticTransactionDB(lArray2[0]);
        ((RocksDB)object).storeOptionsInstance(dBOptions);
        for (int i = 1; i < lArray2.length; ++i) {
            list2.add(new ColumnFamilyHandle((RocksDB)object, lArray2[i]));
        }
        return object;
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions) {
        return new Transaction(this, this.beginTransaction(this.nativeHandle_, writeOptions.nativeHandle_));
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, OptimisticTransactionOptions optimisticTransactionOptions) {
        return new Transaction(this, this.beginTransaction(this.nativeHandle_, writeOptions.nativeHandle_, optimisticTransactionOptions.nativeHandle_));
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, Transaction transaction) {
        long l = this.beginTransaction_withOld(this.nativeHandle_, writeOptions.nativeHandle_, transaction.nativeHandle_);
        assert (l == transaction.nativeHandle_);
        return transaction;
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, OptimisticTransactionOptions optimisticTransactionOptions, Transaction transaction) {
        long l = this.beginTransaction_withOld(this.nativeHandle_, writeOptions.nativeHandle_, optimisticTransactionOptions.nativeHandle_, transaction.nativeHandle_);
        assert (l == transaction.nativeHandle_);
        return transaction;
    }

    public RocksDB getBaseDB() {
        RocksDB rocksDB = new RocksDB(this.getBaseDB(this.nativeHandle_));
        rocksDB.disOwnNativeHandle();
        return rocksDB;
    }

    protected static native long open(long var0, String var2) throws RocksDBException;

    protected static native long[] open(long var0, String var2, byte[][] var3, long[] var4);

    private native long beginTransaction(long var1, long var3);

    private native long beginTransaction(long var1, long var3, long var5);

    private native long beginTransaction_withOld(long var1, long var3, long var5);

    private native long beginTransaction_withOld(long var1, long var3, long var5, long var7);

    private native long getBaseDB(long var1);

    @Override
    protected final native void disposeInternal(long var1);
}

