/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.List;
import org.rocksdb.BackupInfo;
import org.rocksdb.BackupableDBOptions;
import org.rocksdb.Env;
import org.rocksdb.RestoreOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;

public class BackupEngine
extends RocksObject
implements AutoCloseable {
    protected BackupEngine() {
    }

    public static BackupEngine open(Env env, BackupableDBOptions backupableDBOptions) throws RocksDBException {
        BackupEngine backupEngine = new BackupEngine();
        backupEngine.open(env.nativeHandle_, backupableDBOptions.nativeHandle_);
        return backupEngine;
    }

    public void createNewBackup(RocksDB rocksDB) throws RocksDBException {
        this.createNewBackup(rocksDB, false);
    }

    public void createNewBackup(RocksDB rocksDB, boolean bl) throws RocksDBException {
        assert (this.isInitialized());
        this.createNewBackup(this.nativeHandle_, rocksDB.nativeHandle_, bl);
    }

    public List<BackupInfo> getBackupInfo() {
        assert (this.isInitialized());
        return this.getBackupInfo(this.nativeHandle_);
    }

    public int[] getCorruptedBackups() {
        assert (this.isInitialized());
        return this.getCorruptedBackups(this.nativeHandle_);
    }

    public void garbageCollect() throws RocksDBException {
        assert (this.isInitialized());
        this.garbageCollect(this.nativeHandle_);
    }

    public void purgeOldBackups(int n) throws RocksDBException {
        assert (this.isInitialized());
        this.purgeOldBackups(this.nativeHandle_, n);
    }

    public void deleteBackup(int n) throws RocksDBException {
        assert (this.isInitialized());
        this.deleteBackup(this.nativeHandle_, n);
    }

    public void restoreDbFromBackup(int n, String string, String string2, RestoreOptions restoreOptions) throws RocksDBException {
        assert (this.isInitialized());
        this.restoreDbFromBackup(this.nativeHandle_, n, string, string2, restoreOptions.nativeHandle_);
    }

    public void restoreDbFromLatestBackup(String string, String string2, RestoreOptions restoreOptions) throws RocksDBException {
        assert (this.isInitialized());
        this.restoreDbFromLatestBackup(this.nativeHandle_, string, string2, restoreOptions.nativeHandle_);
    }

    @Override
    public void close() throws RocksDBException {
        this.dispose();
    }

    @Override
    protected void disposeInternal() {
        assert (this.isInitialized());
        this.disposeInternal(this.nativeHandle_);
    }

    private native void open(long var1, long var3) throws RocksDBException;

    private native void createNewBackup(long var1, long var3, boolean var5) throws RocksDBException;

    private native List<BackupInfo> getBackupInfo(long var1);

    private native int[] getCorruptedBackups(long var1);

    private native void garbageCollect(long var1) throws RocksDBException;

    private native void purgeOldBackups(long var1, int var3) throws RocksDBException;

    private native void deleteBackup(long var1, int var3) throws RocksDBException;

    private native void restoreDbFromBackup(long var1, int var3, String var4, String var5, long var6) throws RocksDBException;

    private native void restoreDbFromLatestBackup(long var1, String var3, String var4, long var5) throws RocksDBException;

    private native void disposeInternal(long var1);
}

