/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DBOptionsInterface;
import org.rocksdb.FlushOptions;
import org.rocksdb.NativeLibraryLoader;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksObject;
import org.rocksdb.Snapshot;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.rocksdb.util.Environment;

public class RocksDB
extends RocksObject {
    public static final String DEFAULT_COLUMN_FAMILY = "default";
    public static final int NOT_FOUND = -1;
    protected DBOptionsInterface options_;

    public static synchronized void loadLibrary() {
        String string = System.getenv("ROCKSDB_SHAREDLIB_DIR");
        for (CompressionType compressionType : CompressionType.values()) {
            try {
                if (compressionType.getLibraryName() == null) continue;
                System.loadLibrary(compressionType.getLibraryName());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        try {
            NativeLibraryLoader.getInstance().loadLibraryFromJar(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to load the RocksDB shared library" + iOException);
        }
    }

    public static synchronized void loadLibrary(List<String> list) {
        block4: for (CompressionType object : CompressionType.values()) {
            if (object.equals((Object)CompressionType.NO_COMPRESSION)) continue;
            for (String string : list) {
                try {
                    System.load(string + "/" + Environment.getSharedLibraryName(object.getLibraryName()));
                    continue block4;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                }
            }
        }
        boolean bl = false;
        UnsatisfiedLinkError unsatisfiedLinkError = null;
        for (String string : list) {
            try {
                System.load(string + "/" + Environment.getJniLibraryName("rocksdbjni"));
                bl = true;
                break;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                unsatisfiedLinkError = unsatisfiedLinkError2;
            }
        }
        if (!bl) {
            throw unsatisfiedLinkError;
        }
    }

    public static RocksDB open(String string) throws RocksDBException {
        Options options = new Options();
        options.setCreateIfMissing(true);
        return RocksDB.open(options, string);
    }

    public static RocksDB open(String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        DBOptions dBOptions = new DBOptions();
        return RocksDB.open(dBOptions, string, list, list2);
    }

    public static RocksDB open(Options options, String string) throws RocksDBException {
        RocksDB rocksDB = new RocksDB();
        rocksDB.open(options.nativeHandle_, string);
        rocksDB.storeOptionsInstance(options);
        return rocksDB;
    }

    public static RocksDB open(DBOptions dBOptions, String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        RocksDB rocksDB = new RocksDB();
        List<Long> list3 = rocksDB.open(dBOptions.nativeHandle_, string, list, list.size());
        for (int i = 0; i < list.size(); ++i) {
            list2.add(new ColumnFamilyHandle(rocksDB, list3.get(i)));
        }
        rocksDB.storeOptionsInstance(dBOptions);
        return rocksDB;
    }

    public static RocksDB openReadOnly(String string) throws RocksDBException {
        Options options = new Options();
        return RocksDB.openReadOnly(options, string);
    }

    public static RocksDB openReadOnly(String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        DBOptions dBOptions = new DBOptions();
        return RocksDB.openReadOnly(dBOptions, string, list, list2);
    }

    public static RocksDB openReadOnly(Options options, String string) throws RocksDBException {
        RocksDB rocksDB = new RocksDB();
        rocksDB.openROnly(options.nativeHandle_, string);
        rocksDB.storeOptionsInstance(options);
        return rocksDB;
    }

    public static RocksDB openReadOnly(DBOptions dBOptions, String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        RocksDB rocksDB = new RocksDB();
        List<Long> list3 = rocksDB.openROnly(dBOptions.nativeHandle_, string, list, list.size());
        for (int i = 0; i < list.size(); ++i) {
            list2.add(new ColumnFamilyHandle(rocksDB, list3.get(i)));
        }
        rocksDB.storeOptionsInstance(dBOptions);
        return rocksDB;
    }

    public static List<byte[]> listColumnFamilies(Options options, String string) throws RocksDBException {
        return RocksDB.listColumnFamilies(options.nativeHandle_, string);
    }

    private void storeOptionsInstance(DBOptionsInterface dBOptionsInterface) {
        this.options_ = dBOptionsInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposeInternal() {
        RocksDB rocksDB = this;
        synchronized (rocksDB) {
            assert (this.isInitialized());
            this.disposeInternal(this.nativeHandle_);
        }
    }

    public void close() {
        this.dispose();
    }

    public void put(byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void put(WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public boolean keyMayExist(byte[] byArray, StringBuffer stringBuffer) {
        return this.keyMayExist(byArray, byArray.length, stringBuffer);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, StringBuffer stringBuffer) {
        return this.keyMayExist(byArray, byArray.length, columnFamilyHandle.nativeHandle_, stringBuffer);
    }

    public boolean keyMayExist(ReadOptions readOptions, byte[] byArray, StringBuffer stringBuffer) {
        return this.keyMayExist(readOptions.nativeHandle_, byArray, byArray.length, stringBuffer);
    }

    public boolean keyMayExist(ReadOptions readOptions, ColumnFamilyHandle columnFamilyHandle, byte[] byArray, StringBuffer stringBuffer) {
        return this.keyMayExist(readOptions.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_, stringBuffer);
    }

    public void write(WriteOptions writeOptions, WriteBatch writeBatch) throws RocksDBException {
        this.write(writeOptions.nativeHandle_, writeBatch.nativeHandle_);
    }

    public void merge(byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void merge(WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public int get(byte[] byArray, byte[] byArray2) throws RocksDBException {
        return this.get(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException, IllegalArgumentException {
        return this.get(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public int get(ReadOptions readOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, byArray, byArray.length);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(ReadOptions readOptions, byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, byArray.length);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public Map<byte[], byte[]> multiGet(List<byte[]> list) throws RocksDBException {
        assert (list.size() != 0);
        List<byte[]> list2 = this.multiGet(this.nativeHandle_, list, list.size());
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i) == null) continue;
            hashMap.put(list.get(i), list2.get(i));
        }
        return hashMap;
    }

    public Map<byte[], byte[]> multiGet(List<ColumnFamilyHandle> list, List<byte[]> list2) throws RocksDBException, IllegalArgumentException {
        assert (list2.size() != 0);
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        List<byte[]> list3 = this.multiGet(this.nativeHandle_, list2, list2.size(), list);
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
        for (int i = 0; i < list3.size(); ++i) {
            if (list3.get(i) == null) continue;
            hashMap.put(list2.get(i), list3.get(i));
        }
        return hashMap;
    }

    public Map<byte[], byte[]> multiGet(ReadOptions readOptions, List<byte[]> list) throws RocksDBException {
        assert (list.size() != 0);
        List<byte[]> list2 = this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, list, list.size());
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i) == null) continue;
            hashMap.put(list.get(i), list2.get(i));
        }
        return hashMap;
    }

    public Map<byte[], byte[]> multiGet(ReadOptions readOptions, List<ColumnFamilyHandle> list, List<byte[]> list2) throws RocksDBException {
        assert (list2.size() != 0);
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        List<byte[]> list3 = this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, list2, list2.size(), list);
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
        for (int i = 0; i < list3.size(); ++i) {
            if (list3.get(i) == null) continue;
            hashMap.put(list2.get(i), list3.get(i));
        }
        return hashMap;
    }

    public void remove(byte[] byArray) throws RocksDBException {
        this.remove(this.nativeHandle_, byArray, byArray.length);
    }

    public void remove(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        this.remove(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public void remove(WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.remove(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length);
    }

    public void remove(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.remove(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public String getProperty(ColumnFamilyHandle columnFamilyHandle, String string) throws RocksDBException {
        return this.getProperty0(this.nativeHandle_, columnFamilyHandle.nativeHandle_, string, string.length());
    }

    public String getProperty(String string) throws RocksDBException {
        return this.getProperty0(this.nativeHandle_, string, string.length());
    }

    public long getLongProperty(String string) throws RocksDBException {
        return this.getLongProperty(this.nativeHandle_, string, string.length());
    }

    public long getLongProperty(ColumnFamilyHandle columnFamilyHandle, String string) throws RocksDBException {
        return this.getLongProperty(this.nativeHandle_, columnFamilyHandle.nativeHandle_, string, string.length());
    }

    public RocksIterator newIterator() {
        return new RocksIterator(this, this.iterator0(this.nativeHandle_));
    }

    public Snapshot getSnapshot() {
        long l = this.getSnapshot(this.nativeHandle_);
        if (l != 0L) {
            return new Snapshot(l);
        }
        return null;
    }

    public void releaseSnapshot(Snapshot snapshot) {
        if (snapshot != null) {
            this.releaseSnapshot(this.nativeHandle_, snapshot.nativeHandle_);
        }
    }

    public RocksIterator newIterator(ColumnFamilyHandle columnFamilyHandle) {
        return new RocksIterator(this, this.iterator0(this.nativeHandle_, columnFamilyHandle.nativeHandle_));
    }

    public List<RocksIterator> newIterators(List<ColumnFamilyHandle> list) throws RocksDBException {
        ArrayList<RocksIterator> arrayList = new ArrayList<RocksIterator>(list.size());
        long[] lArray = this.iterators(this.nativeHandle_, list);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new RocksIterator(this, lArray[i]));
        }
        return arrayList;
    }

    public ColumnFamilyHandle createColumnFamily(ColumnFamilyDescriptor columnFamilyDescriptor) throws RocksDBException {
        return new ColumnFamilyHandle(this, this.createColumnFamily(this.nativeHandle_, columnFamilyDescriptor));
    }

    public void dropColumnFamily(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException, IllegalArgumentException {
        this.dropColumnFamily(this.nativeHandle_, columnFamilyHandle.nativeHandle_);
        columnFamilyHandle.nativeHandle_ = 0L;
    }

    public void flush(FlushOptions flushOptions) throws RocksDBException {
        this.flush(this.nativeHandle_, flushOptions.nativeHandle_);
    }

    public void flush(FlushOptions flushOptions, ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        this.flush(this.nativeHandle_, flushOptions.nativeHandle_, columnFamilyHandle.nativeHandle_);
    }

    protected RocksDB() {
    }

    protected native void open(long var1, String var3) throws RocksDBException;

    protected native List<Long> open(long var1, String var3, List<ColumnFamilyDescriptor> var4, int var5) throws RocksDBException;

    protected static native List<byte[]> listColumnFamilies(long var0, String var2) throws RocksDBException;

    protected native void openROnly(long var1, String var3) throws RocksDBException;

    protected native List<Long> openROnly(long var1, String var3, List<ColumnFamilyDescriptor> var4, int var5) throws RocksDBException;

    protected native void put(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    protected native void put(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7) throws RocksDBException;

    protected native void put(long var1, long var3, byte[] var5, int var6, byte[] var7, int var8) throws RocksDBException;

    protected native void put(long var1, long var3, byte[] var5, int var6, byte[] var7, int var8, long var9) throws RocksDBException;

    protected native void write(long var1, long var3) throws RocksDBException;

    protected native boolean keyMayExist(byte[] var1, int var2, StringBuffer var3);

    protected native boolean keyMayExist(byte[] var1, int var2, long var3, StringBuffer var5);

    protected native boolean keyMayExist(long var1, byte[] var3, int var4, StringBuffer var5);

    protected native boolean keyMayExist(long var1, byte[] var3, int var4, long var5, StringBuffer var7);

    protected native void merge(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    protected native void merge(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7) throws RocksDBException;

    protected native void merge(long var1, long var3, byte[] var5, int var6, byte[] var7, int var8) throws RocksDBException;

    protected native void merge(long var1, long var3, byte[] var5, int var6, byte[] var7, int var8, long var9) throws RocksDBException;

    protected native int get(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    protected native int get(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7) throws RocksDBException;

    protected native int get(long var1, long var3, byte[] var5, int var6, byte[] var7, int var8) throws RocksDBException;

    protected native int get(long var1, long var3, byte[] var5, int var6, byte[] var7, int var8, long var9) throws RocksDBException;

    protected native List<byte[]> multiGet(long var1, List<byte[]> var3, int var4);

    protected native List<byte[]> multiGet(long var1, List<byte[]> var3, int var4, List<ColumnFamilyHandle> var5);

    protected native List<byte[]> multiGet(long var1, long var3, List<byte[]> var5, int var6);

    protected native List<byte[]> multiGet(long var1, long var3, List<byte[]> var5, int var6, List<ColumnFamilyHandle> var7);

    protected native byte[] get(long var1, byte[] var3, int var4) throws RocksDBException;

    protected native byte[] get(long var1, byte[] var3, int var4, long var5) throws RocksDBException;

    protected native byte[] get(long var1, long var3, byte[] var5, int var6) throws RocksDBException;

    protected native byte[] get(long var1, long var3, byte[] var5, int var6, long var7) throws RocksDBException;

    protected native void remove(long var1, byte[] var3, int var4) throws RocksDBException;

    protected native void remove(long var1, byte[] var3, int var4, long var5) throws RocksDBException;

    protected native void remove(long var1, long var3, byte[] var5, int var6) throws RocksDBException;

    protected native void remove(long var1, long var3, byte[] var5, int var6, long var7) throws RocksDBException;

    protected native String getProperty0(long var1, String var3, int var4) throws RocksDBException;

    protected native String getProperty0(long var1, long var3, String var5, int var6) throws RocksDBException;

    protected native long getLongProperty(long var1, String var3, int var4) throws RocksDBException;

    protected native long getLongProperty(long var1, long var3, String var5, int var6) throws RocksDBException;

    protected native long iterator0(long var1);

    protected native long iterator0(long var1, long var3);

    protected native long[] iterators(long var1, List<ColumnFamilyHandle> var3) throws RocksDBException;

    protected native long getSnapshot(long var1);

    protected native void releaseSnapshot(long var1, long var3);

    private native void disposeInternal(long var1);

    private native long createColumnFamily(long var1, ColumnFamilyDescriptor var3) throws RocksDBException;

    private native void dropColumnFamily(long var1, long var3) throws RocksDBException;

    private native void flush(long var1, long var3) throws RocksDBException;

    private native void flush(long var1, long var3, long var5) throws RocksDBException;

    static {
        RocksDB.loadLibrary();
    }
}

