/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.ArrayList;
import java.util.List;
import org.rocksdb.AbstractComparator;
import org.rocksdb.AbstractSlice;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.ColumnFamilyOptionsInterface;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DBOptionsInterface;
import org.rocksdb.Env;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Logger;
import org.rocksdb.MemTableConfig;
import org.rocksdb.MergeOperator;
import org.rocksdb.RateLimiterConfig;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksObject;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;

public class Options
extends RocksObject
implements DBOptionsInterface,
ColumnFamilyOptionsInterface {
    Env env_;
    MemTableConfig memTableConfig_;
    TableFormatConfig tableFormatConfig_;
    RateLimiterConfig rateLimiterConfig_;
    AbstractComparator<? extends AbstractSlice<?>> comparator_;

    public Options() {
        this.newOptions();
        this.env_ = Env.getDefault();
    }

    public Options(DBOptions dBOptions, ColumnFamilyOptions columnFamilyOptions) {
        this.newOptions(dBOptions.nativeHandle_, columnFamilyOptions.nativeHandle_);
        this.env_ = Env.getDefault();
    }

    @Override
    public Options setIncreaseParallelism(int n) {
        assert (this.isInitialized());
        this.setIncreaseParallelism(this.nativeHandle_, n);
        return this;
    }

    @Override
    public Options setCreateIfMissing(boolean bl) {
        assert (this.isInitialized());
        this.setCreateIfMissing(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public Options setCreateMissingColumnFamilies(boolean bl) {
        assert (this.isInitialized());
        this.setCreateMissingColumnFamilies(this.nativeHandle_, bl);
        return this;
    }

    public Options setEnv(Env env) {
        assert (this.isInitialized());
        this.setEnv(this.nativeHandle_, env.nativeHandle_);
        this.env_ = env;
        return this;
    }

    public Env getEnv() {
        return this.env_;
    }

    public Options prepareForBulkLoad() {
        this.prepareForBulkLoad(this.nativeHandle_);
        return this;
    }

    @Override
    public boolean createIfMissing() {
        assert (this.isInitialized());
        return this.createIfMissing(this.nativeHandle_);
    }

    @Override
    public boolean createMissingColumnFamilies() {
        assert (this.isInitialized());
        return this.createMissingColumnFamilies(this.nativeHandle_);
    }

    @Override
    public Options optimizeForPointLookup(long l) {
        this.optimizeForPointLookup(this.nativeHandle_, l);
        return this;
    }

    @Override
    public Options optimizeLevelStyleCompaction() {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public Options optimizeLevelStyleCompaction(long l) {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, l);
        return this;
    }

    @Override
    public Options optimizeUniversalStyleCompaction() {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public Options optimizeUniversalStyleCompaction(long l) {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, l);
        return this;
    }

    @Override
    public Options setComparator(BuiltinComparator builtinComparator) {
        assert (this.isInitialized());
        this.setComparatorHandle(this.nativeHandle_, builtinComparator.ordinal());
        return this;
    }

    @Override
    public Options setComparator(AbstractComparator<? extends AbstractSlice<?>> abstractComparator) {
        assert (this.isInitialized());
        this.setComparatorHandle(this.nativeHandle_, abstractComparator.nativeHandle_);
        this.comparator_ = abstractComparator;
        return this;
    }

    @Override
    public Options setMergeOperatorName(String string) {
        assert (this.isInitialized());
        if (string == null) {
            throw new IllegalArgumentException("Merge operator name must not be null.");
        }
        this.setMergeOperatorName(this.nativeHandle_, string);
        return this;
    }

    @Override
    public Options setMergeOperator(MergeOperator mergeOperator) {
        this.setMergeOperator(this.nativeHandle_, mergeOperator.newMergeOperatorHandle());
        return this;
    }

    @Override
    public Options setWriteBufferSize(long l) {
        assert (this.isInitialized());
        this.setWriteBufferSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long writeBufferSize() {
        assert (this.isInitialized());
        return this.writeBufferSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxWriteBufferNumber(int n) {
        assert (this.isInitialized());
        this.setMaxWriteBufferNumber(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxWriteBufferNumber() {
        assert (this.isInitialized());
        return this.maxWriteBufferNumber(this.nativeHandle_);
    }

    @Override
    public boolean errorIfExists() {
        assert (this.isInitialized());
        return this.errorIfExists(this.nativeHandle_);
    }

    @Override
    public Options setErrorIfExists(boolean bl) {
        assert (this.isInitialized());
        this.setErrorIfExists(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean paranoidChecks() {
        assert (this.isInitialized());
        return this.paranoidChecks(this.nativeHandle_);
    }

    @Override
    public Options setParanoidChecks(boolean bl) {
        assert (this.isInitialized());
        this.setParanoidChecks(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public int maxOpenFiles() {
        assert (this.isInitialized());
        return this.maxOpenFiles(this.nativeHandle_);
    }

    @Override
    public Options setMaxTotalWalSize(long l) {
        assert (this.isInitialized());
        this.setMaxTotalWalSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxTotalWalSize() {
        assert (this.isInitialized());
        return this.maxTotalWalSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxOpenFiles(int n) {
        assert (this.isInitialized());
        this.setMaxOpenFiles(this.nativeHandle_, n);
        return this;
    }

    @Override
    public boolean disableDataSync() {
        assert (this.isInitialized());
        return this.disableDataSync(this.nativeHandle_);
    }

    @Override
    public Options setDisableDataSync(boolean bl) {
        assert (this.isInitialized());
        this.setDisableDataSync(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean useFsync() {
        assert (this.isInitialized());
        return this.useFsync(this.nativeHandle_);
    }

    @Override
    public Options setUseFsync(boolean bl) {
        assert (this.isInitialized());
        this.setUseFsync(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public String dbLogDir() {
        assert (this.isInitialized());
        return this.dbLogDir(this.nativeHandle_);
    }

    @Override
    public Options setDbLogDir(String string) {
        assert (this.isInitialized());
        this.setDbLogDir(this.nativeHandle_, string);
        return this;
    }

    @Override
    public String walDir() {
        assert (this.isInitialized());
        return this.walDir(this.nativeHandle_);
    }

    @Override
    public Options setWalDir(String string) {
        assert (this.isInitialized());
        this.setWalDir(this.nativeHandle_, string);
        return this;
    }

    @Override
    public long deleteObsoleteFilesPeriodMicros() {
        assert (this.isInitialized());
        return this.deleteObsoleteFilesPeriodMicros(this.nativeHandle_);
    }

    @Override
    public Options setDeleteObsoleteFilesPeriodMicros(long l) {
        assert (this.isInitialized());
        this.setDeleteObsoleteFilesPeriodMicros(this.nativeHandle_, l);
        return this;
    }

    @Override
    public int maxBackgroundCompactions() {
        assert (this.isInitialized());
        return this.maxBackgroundCompactions(this.nativeHandle_);
    }

    @Override
    public Options createStatistics() {
        assert (this.isInitialized());
        this.createStatistics(this.nativeHandle_);
        return this;
    }

    @Override
    public Statistics statisticsPtr() {
        assert (this.isInitialized());
        long l = this.statisticsPtr(this.nativeHandle_);
        if (l == 0L) {
            this.createStatistics();
            l = this.statisticsPtr(this.nativeHandle_);
        }
        return new Statistics(l);
    }

    @Override
    public Options setMaxBackgroundCompactions(int n) {
        assert (this.isInitialized());
        this.setMaxBackgroundCompactions(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxBackgroundFlushes() {
        assert (this.isInitialized());
        return this.maxBackgroundFlushes(this.nativeHandle_);
    }

    @Override
    public Options setMaxBackgroundFlushes(int n) {
        assert (this.isInitialized());
        this.setMaxBackgroundFlushes(this.nativeHandle_, n);
        return this;
    }

    @Override
    public long maxLogFileSize() {
        assert (this.isInitialized());
        return this.maxLogFileSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxLogFileSize(long l) {
        assert (this.isInitialized());
        this.setMaxLogFileSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long logFileTimeToRoll() {
        assert (this.isInitialized());
        return this.logFileTimeToRoll(this.nativeHandle_);
    }

    @Override
    public Options setLogFileTimeToRoll(long l) {
        assert (this.isInitialized());
        this.setLogFileTimeToRoll(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long keepLogFileNum() {
        assert (this.isInitialized());
        return this.keepLogFileNum(this.nativeHandle_);
    }

    @Override
    public Options setKeepLogFileNum(long l) {
        assert (this.isInitialized());
        this.setKeepLogFileNum(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxManifestFileSize() {
        assert (this.isInitialized());
        return this.maxManifestFileSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxManifestFileSize(long l) {
        assert (this.isInitialized());
        this.setMaxManifestFileSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public int tableCacheNumshardbits() {
        assert (this.isInitialized());
        return this.tableCacheNumshardbits(this.nativeHandle_);
    }

    @Override
    public Options setTableCacheNumshardbits(int n) {
        assert (this.isInitialized());
        this.setTableCacheNumshardbits(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int tableCacheRemoveScanCountLimit() {
        assert (this.isInitialized());
        return this.tableCacheRemoveScanCountLimit(this.nativeHandle_);
    }

    @Override
    public Options setTableCacheRemoveScanCountLimit(int n) {
        assert (this.isInitialized());
        this.setTableCacheRemoveScanCountLimit(this.nativeHandle_, n);
        return this;
    }

    @Override
    public long walTtlSeconds() {
        assert (this.isInitialized());
        return this.walTtlSeconds(this.nativeHandle_);
    }

    @Override
    public Options setWalTtlSeconds(long l) {
        assert (this.isInitialized());
        this.setWalTtlSeconds(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long walSizeLimitMB() {
        assert (this.isInitialized());
        return this.walSizeLimitMB(this.nativeHandle_);
    }

    @Override
    public Options setWalSizeLimitMB(long l) {
        assert (this.isInitialized());
        this.setWalSizeLimitMB(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long manifestPreallocationSize() {
        assert (this.isInitialized());
        return this.manifestPreallocationSize(this.nativeHandle_);
    }

    @Override
    public Options setManifestPreallocationSize(long l) {
        assert (this.isInitialized());
        this.setManifestPreallocationSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public boolean allowOsBuffer() {
        assert (this.isInitialized());
        return this.allowOsBuffer(this.nativeHandle_);
    }

    @Override
    public Options setAllowOsBuffer(boolean bl) {
        assert (this.isInitialized());
        this.setAllowOsBuffer(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowMmapReads() {
        assert (this.isInitialized());
        return this.allowMmapReads(this.nativeHandle_);
    }

    @Override
    public Options setAllowMmapReads(boolean bl) {
        assert (this.isInitialized());
        this.setAllowMmapReads(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowMmapWrites() {
        assert (this.isInitialized());
        return this.allowMmapWrites(this.nativeHandle_);
    }

    @Override
    public Options setAllowMmapWrites(boolean bl) {
        assert (this.isInitialized());
        this.setAllowMmapWrites(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean isFdCloseOnExec() {
        assert (this.isInitialized());
        return this.isFdCloseOnExec(this.nativeHandle_);
    }

    @Override
    public Options setIsFdCloseOnExec(boolean bl) {
        assert (this.isInitialized());
        this.setIsFdCloseOnExec(this.nativeHandle_, bl);
        return this;
    }

    @Override
    @Deprecated
    public boolean skipLogErrorOnRecovery() {
        assert (this.isInitialized());
        return this.skipLogErrorOnRecovery(this.nativeHandle_);
    }

    @Override
    @Deprecated
    public Options setSkipLogErrorOnRecovery(boolean bl) {
        assert (this.isInitialized());
        this.setSkipLogErrorOnRecovery(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public int statsDumpPeriodSec() {
        assert (this.isInitialized());
        return this.statsDumpPeriodSec(this.nativeHandle_);
    }

    @Override
    public Options setStatsDumpPeriodSec(int n) {
        assert (this.isInitialized());
        this.setStatsDumpPeriodSec(this.nativeHandle_, n);
        return this;
    }

    @Override
    public boolean adviseRandomOnOpen() {
        return this.adviseRandomOnOpen(this.nativeHandle_);
    }

    @Override
    public Options setAdviseRandomOnOpen(boolean bl) {
        assert (this.isInitialized());
        this.setAdviseRandomOnOpen(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean useAdaptiveMutex() {
        assert (this.isInitialized());
        return this.useAdaptiveMutex(this.nativeHandle_);
    }

    @Override
    public Options setUseAdaptiveMutex(boolean bl) {
        assert (this.isInitialized());
        this.setUseAdaptiveMutex(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public long bytesPerSync() {
        return this.bytesPerSync(this.nativeHandle_);
    }

    @Override
    public Options setBytesPerSync(long l) {
        assert (this.isInitialized());
        this.setBytesPerSync(this.nativeHandle_, l);
        return this;
    }

    @Override
    public Options setMemTableConfig(MemTableConfig memTableConfig) {
        this.memTableConfig_ = memTableConfig;
        this.setMemTableFactory(this.nativeHandle_, memTableConfig.newMemTableFactoryHandle());
        return this;
    }

    @Override
    public Options setRateLimiterConfig(RateLimiterConfig rateLimiterConfig) {
        this.rateLimiterConfig_ = rateLimiterConfig;
        this.setRateLimiter(this.nativeHandle_, rateLimiterConfig.newRateLimiterHandle());
        return this;
    }

    @Override
    public Options setLogger(Logger logger) {
        assert (this.isInitialized());
        this.setLogger(this.nativeHandle_, logger.nativeHandle_);
        return this;
    }

    @Override
    public Options setInfoLogLevel(InfoLogLevel infoLogLevel) {
        assert (this.isInitialized());
        this.setInfoLogLevel(this.nativeHandle_, infoLogLevel.getValue());
        return this;
    }

    @Override
    public InfoLogLevel infoLogLevel() {
        assert (this.isInitialized());
        return InfoLogLevel.getInfoLogLevel(this.infoLogLevel(this.nativeHandle_));
    }

    @Override
    public String memTableFactoryName() {
        assert (this.isInitialized());
        return this.memTableFactoryName(this.nativeHandle_);
    }

    @Override
    public Options setTableFormatConfig(TableFormatConfig tableFormatConfig) {
        this.tableFormatConfig_ = tableFormatConfig;
        this.setTableFactory(this.nativeHandle_, tableFormatConfig.newTableFactoryHandle());
        return this;
    }

    @Override
    public String tableFactoryName() {
        assert (this.isInitialized());
        return this.tableFactoryName(this.nativeHandle_);
    }

    @Override
    public Options useFixedLengthPrefixExtractor(int n) {
        assert (this.isInitialized());
        this.useFixedLengthPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public CompressionType compressionType() {
        return CompressionType.values()[this.compressionType(this.nativeHandle_)];
    }

    @Override
    public Options setCompressionPerLevel(List<CompressionType> list) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>(list.size());
        for (CompressionType compressionType : list) {
            arrayList.add(compressionType.getValue());
        }
        this.setCompressionPerLevel(this.nativeHandle_, arrayList);
        return this;
    }

    @Override
    public List<CompressionType> compressionPerLevel() {
        List<Byte> list = this.compressionPerLevel(this.nativeHandle_);
        ArrayList<CompressionType> arrayList = new ArrayList<CompressionType>();
        for (Byte by : list) {
            arrayList.add(CompressionType.getCompressionType(by));
        }
        return arrayList;
    }

    @Override
    public Options setCompressionType(CompressionType compressionType) {
        this.setCompressionType(this.nativeHandle_, compressionType.getValue());
        return this;
    }

    @Override
    public CompactionStyle compactionStyle() {
        return CompactionStyle.values()[this.compactionStyle(this.nativeHandle_)];
    }

    @Override
    public Options setCompactionStyle(CompactionStyle compactionStyle) {
        this.setCompactionStyle(this.nativeHandle_, compactionStyle.getValue());
        return this;
    }

    @Override
    public int numLevels() {
        return this.numLevels(this.nativeHandle_);
    }

    @Override
    public Options setNumLevels(int n) {
        this.setNumLevels(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroFileNumCompactionTrigger() {
        return this.levelZeroFileNumCompactionTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevelZeroFileNumCompactionTrigger(int n) {
        this.setLevelZeroFileNumCompactionTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroSlowdownWritesTrigger() {
        return this.levelZeroSlowdownWritesTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevelZeroSlowdownWritesTrigger(int n) {
        this.setLevelZeroSlowdownWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroStopWritesTrigger() {
        return this.levelZeroStopWritesTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevelZeroStopWritesTrigger(int n) {
        this.setLevelZeroStopWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxMemCompactionLevel() {
        return this.maxMemCompactionLevel(this.nativeHandle_);
    }

    @Override
    public Options setMaxMemCompactionLevel(int n) {
        this.setMaxMemCompactionLevel(this.nativeHandle_, n);
        return this;
    }

    @Override
    public long targetFileSizeBase() {
        return this.targetFileSizeBase(this.nativeHandle_);
    }

    @Override
    public Options setTargetFileSizeBase(long l) {
        this.setTargetFileSizeBase(this.nativeHandle_, l);
        return this;
    }

    @Override
    public int targetFileSizeMultiplier() {
        return this.targetFileSizeMultiplier(this.nativeHandle_);
    }

    @Override
    public Options setTargetFileSizeMultiplier(int n) {
        this.setTargetFileSizeMultiplier(this.nativeHandle_, n);
        return this;
    }

    @Override
    public Options setMaxBytesForLevelBase(long l) {
        this.setMaxBytesForLevelBase(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxBytesForLevelBase() {
        return this.maxBytesForLevelBase(this.nativeHandle_);
    }

    @Override
    public Options setLevelCompactionDynamicLevelBytes(boolean bl) {
        this.setLevelCompactionDynamicLevelBytes(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean levelCompactionDynamicLevelBytes() {
        return this.levelCompactionDynamicLevelBytes(this.nativeHandle_);
    }

    @Override
    public int maxBytesForLevelMultiplier() {
        return this.maxBytesForLevelMultiplier(this.nativeHandle_);
    }

    @Override
    public Options setMaxBytesForLevelMultiplier(int n) {
        this.setMaxBytesForLevelMultiplier(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int expandedCompactionFactor() {
        return this.expandedCompactionFactor(this.nativeHandle_);
    }

    @Override
    public Options setExpandedCompactionFactor(int n) {
        this.setExpandedCompactionFactor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int sourceCompactionFactor() {
        return this.sourceCompactionFactor(this.nativeHandle_);
    }

    @Override
    public Options setSourceCompactionFactor(int n) {
        this.setSourceCompactionFactor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxGrandparentOverlapFactor() {
        return this.maxGrandparentOverlapFactor(this.nativeHandle_);
    }

    @Override
    public Options setMaxGrandparentOverlapFactor(int n) {
        this.setMaxGrandparentOverlapFactor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public double softRateLimit() {
        return this.softRateLimit(this.nativeHandle_);
    }

    @Override
    public Options setSoftRateLimit(double d) {
        this.setSoftRateLimit(this.nativeHandle_, d);
        return this;
    }

    @Override
    public double hardRateLimit() {
        return this.hardRateLimit(this.nativeHandle_);
    }

    @Override
    public Options setHardRateLimit(double d) {
        this.setHardRateLimit(this.nativeHandle_, d);
        return this;
    }

    @Override
    public int rateLimitDelayMaxMilliseconds() {
        return this.rateLimitDelayMaxMilliseconds(this.nativeHandle_);
    }

    @Override
    public Options setRateLimitDelayMaxMilliseconds(int n) {
        this.setRateLimitDelayMaxMilliseconds(this.nativeHandle_, n);
        return this;
    }

    @Override
    public long arenaBlockSize() {
        return this.arenaBlockSize(this.nativeHandle_);
    }

    @Override
    public Options setArenaBlockSize(long l) {
        this.setArenaBlockSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public boolean disableAutoCompactions() {
        return this.disableAutoCompactions(this.nativeHandle_);
    }

    @Override
    public Options setDisableAutoCompactions(boolean bl) {
        this.setDisableAutoCompactions(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean purgeRedundantKvsWhileFlush() {
        return this.purgeRedundantKvsWhileFlush(this.nativeHandle_);
    }

    @Override
    public Options setPurgeRedundantKvsWhileFlush(boolean bl) {
        this.setPurgeRedundantKvsWhileFlush(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean verifyChecksumsInCompaction() {
        return this.verifyChecksumsInCompaction(this.nativeHandle_);
    }

    @Override
    public Options setVerifyChecksumsInCompaction(boolean bl) {
        this.setVerifyChecksumsInCompaction(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean filterDeletes() {
        return this.filterDeletes(this.nativeHandle_);
    }

    @Override
    public Options setFilterDeletes(boolean bl) {
        this.setFilterDeletes(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public long maxSequentialSkipInIterations() {
        return this.maxSequentialSkipInIterations(this.nativeHandle_);
    }

    @Override
    public Options setMaxSequentialSkipInIterations(long l) {
        this.setMaxSequentialSkipInIterations(this.nativeHandle_, l);
        return this;
    }

    @Override
    public boolean inplaceUpdateSupport() {
        return this.inplaceUpdateSupport(this.nativeHandle_);
    }

    @Override
    public Options setInplaceUpdateSupport(boolean bl) {
        this.setInplaceUpdateSupport(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public long inplaceUpdateNumLocks() {
        return this.inplaceUpdateNumLocks(this.nativeHandle_);
    }

    @Override
    public Options setInplaceUpdateNumLocks(long l) {
        this.setInplaceUpdateNumLocks(this.nativeHandle_, l);
        return this;
    }

    @Override
    public int memtablePrefixBloomBits() {
        return this.memtablePrefixBloomBits(this.nativeHandle_);
    }

    @Override
    public Options setMemtablePrefixBloomBits(int n) {
        this.setMemtablePrefixBloomBits(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int memtablePrefixBloomProbes() {
        return this.memtablePrefixBloomProbes(this.nativeHandle_);
    }

    @Override
    public Options setMemtablePrefixBloomProbes(int n) {
        this.setMemtablePrefixBloomProbes(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int bloomLocality() {
        return this.bloomLocality(this.nativeHandle_);
    }

    @Override
    public Options setBloomLocality(int n) {
        this.setBloomLocality(this.nativeHandle_, n);
        return this;
    }

    @Override
    public long maxSuccessiveMerges() {
        return this.maxSuccessiveMerges(this.nativeHandle_);
    }

    @Override
    public Options setMaxSuccessiveMerges(long l) {
        this.setMaxSuccessiveMerges(this.nativeHandle_, l);
        return this;
    }

    @Override
    public int minWriteBufferNumberToMerge() {
        return this.minWriteBufferNumberToMerge(this.nativeHandle_);
    }

    @Override
    public Options setMinWriteBufferNumberToMerge(int n) {
        this.setMinWriteBufferNumberToMerge(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int minPartialMergeOperands() {
        return this.minPartialMergeOperands(this.nativeHandle_);
    }

    @Override
    public Options setMinPartialMergeOperands(int n) {
        this.setMinPartialMergeOperands(this.nativeHandle_, n);
        return this;
    }

    @Override
    public Options setOptimizeFiltersForHits(boolean bl) {
        this.setOptimizeFiltersForHits(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean optimizeFiltersForHits() {
        return this.optimizeFiltersForHits(this.nativeHandle_);
    }

    @Override
    protected void disposeInternal() {
        assert (this.isInitialized());
        this.disposeInternal(this.nativeHandle_);
    }

    private native void newOptions();

    private native void newOptions(long var1, long var3);

    private native void disposeInternal(long var1);

    private native void setEnv(long var1, long var3);

    private native void prepareForBulkLoad(long var1);

    private native void setIncreaseParallelism(long var1, int var3);

    private native void setCreateIfMissing(long var1, boolean var3);

    private native boolean createIfMissing(long var1);

    private native void setCreateMissingColumnFamilies(long var1, boolean var3);

    private native boolean createMissingColumnFamilies(long var1);

    private native void setErrorIfExists(long var1, boolean var3);

    private native boolean errorIfExists(long var1);

    private native void setParanoidChecks(long var1, boolean var3);

    private native boolean paranoidChecks(long var1);

    private native void setRateLimiter(long var1, long var3);

    private native void setLogger(long var1, long var3);

    private native void setInfoLogLevel(long var1, byte var3);

    private native byte infoLogLevel(long var1);

    private native void setMaxOpenFiles(long var1, int var3);

    private native int maxOpenFiles(long var1);

    private native void setMaxTotalWalSize(long var1, long var3);

    private native long maxTotalWalSize(long var1);

    private native void createStatistics(long var1);

    private native long statisticsPtr(long var1);

    private native void setDisableDataSync(long var1, boolean var3);

    private native boolean disableDataSync(long var1);

    private native boolean useFsync(long var1);

    private native void setUseFsync(long var1, boolean var3);

    private native void setDbLogDir(long var1, String var3);

    private native String dbLogDir(long var1);

    private native void setWalDir(long var1, String var3);

    private native String walDir(long var1);

    private native void setDeleteObsoleteFilesPeriodMicros(long var1, long var3);

    private native long deleteObsoleteFilesPeriodMicros(long var1);

    private native void setMaxBackgroundCompactions(long var1, int var3);

    private native int maxBackgroundCompactions(long var1);

    private native void setMaxBackgroundFlushes(long var1, int var3);

    private native int maxBackgroundFlushes(long var1);

    private native void setMaxLogFileSize(long var1, long var3) throws IllegalArgumentException;

    private native long maxLogFileSize(long var1);

    private native void setLogFileTimeToRoll(long var1, long var3) throws IllegalArgumentException;

    private native long logFileTimeToRoll(long var1);

    private native void setKeepLogFileNum(long var1, long var3) throws IllegalArgumentException;

    private native long keepLogFileNum(long var1);

    private native void setMaxManifestFileSize(long var1, long var3);

    private native long maxManifestFileSize(long var1);

    private native void setTableCacheNumshardbits(long var1, int var3);

    private native int tableCacheNumshardbits(long var1);

    private native void setTableCacheRemoveScanCountLimit(long var1, int var3);

    private native int tableCacheRemoveScanCountLimit(long var1);

    private native void setWalTtlSeconds(long var1, long var3);

    private native long walTtlSeconds(long var1);

    private native void setWalSizeLimitMB(long var1, long var3);

    private native long walSizeLimitMB(long var1);

    private native void setManifestPreallocationSize(long var1, long var3) throws IllegalArgumentException;

    private native long manifestPreallocationSize(long var1);

    private native void setAllowOsBuffer(long var1, boolean var3);

    private native boolean allowOsBuffer(long var1);

    private native void setAllowMmapReads(long var1, boolean var3);

    private native boolean allowMmapReads(long var1);

    private native void setAllowMmapWrites(long var1, boolean var3);

    private native boolean allowMmapWrites(long var1);

    private native void setIsFdCloseOnExec(long var1, boolean var3);

    private native boolean isFdCloseOnExec(long var1);

    private native void setSkipLogErrorOnRecovery(long var1, boolean var3);

    private native boolean skipLogErrorOnRecovery(long var1);

    private native void setStatsDumpPeriodSec(long var1, int var3);

    private native int statsDumpPeriodSec(long var1);

    private native void setAdviseRandomOnOpen(long var1, boolean var3);

    private native boolean adviseRandomOnOpen(long var1);

    private native void setUseAdaptiveMutex(long var1, boolean var3);

    private native boolean useAdaptiveMutex(long var1);

    private native void setBytesPerSync(long var1, long var3);

    private native long bytesPerSync(long var1);

    private native void optimizeForPointLookup(long var1, long var3);

    private native void optimizeLevelStyleCompaction(long var1, long var3);

    private native void optimizeUniversalStyleCompaction(long var1, long var3);

    private native void setComparatorHandle(long var1, int var3);

    private native void setComparatorHandle(long var1, long var3);

    private native void setMergeOperatorName(long var1, String var3);

    private native void setMergeOperator(long var1, long var3);

    private native void setWriteBufferSize(long var1, long var3) throws IllegalArgumentException;

    private native long writeBufferSize(long var1);

    private native void setMaxWriteBufferNumber(long var1, int var3);

    private native int maxWriteBufferNumber(long var1);

    private native void setMinWriteBufferNumberToMerge(long var1, int var3);

    private native int minWriteBufferNumberToMerge(long var1);

    private native void setCompressionType(long var1, byte var3);

    private native byte compressionType(long var1);

    private native void setCompressionPerLevel(long var1, List<Byte> var3);

    private native List<Byte> compressionPerLevel(long var1);

    private native void useFixedLengthPrefixExtractor(long var1, int var3);

    private native void setNumLevels(long var1, int var3);

    private native int numLevels(long var1);

    private native void setLevelZeroFileNumCompactionTrigger(long var1, int var3);

    private native int levelZeroFileNumCompactionTrigger(long var1);

    private native void setLevelZeroSlowdownWritesTrigger(long var1, int var3);

    private native int levelZeroSlowdownWritesTrigger(long var1);

    private native void setLevelZeroStopWritesTrigger(long var1, int var3);

    private native int levelZeroStopWritesTrigger(long var1);

    private native void setMaxMemCompactionLevel(long var1, int var3);

    private native int maxMemCompactionLevel(long var1);

    private native void setTargetFileSizeBase(long var1, long var3);

    private native long targetFileSizeBase(long var1);

    private native void setTargetFileSizeMultiplier(long var1, int var3);

    private native int targetFileSizeMultiplier(long var1);

    private native void setMaxBytesForLevelBase(long var1, long var3);

    private native long maxBytesForLevelBase(long var1);

    private native void setLevelCompactionDynamicLevelBytes(long var1, boolean var3);

    private native boolean levelCompactionDynamicLevelBytes(long var1);

    private native void setMaxBytesForLevelMultiplier(long var1, int var3);

    private native int maxBytesForLevelMultiplier(long var1);

    private native void setExpandedCompactionFactor(long var1, int var3);

    private native int expandedCompactionFactor(long var1);

    private native void setSourceCompactionFactor(long var1, int var3);

    private native int sourceCompactionFactor(long var1);

    private native void setMaxGrandparentOverlapFactor(long var1, int var3);

    private native int maxGrandparentOverlapFactor(long var1);

    private native void setSoftRateLimit(long var1, double var3);

    private native double softRateLimit(long var1);

    private native void setHardRateLimit(long var1, double var3);

    private native double hardRateLimit(long var1);

    private native void setRateLimitDelayMaxMilliseconds(long var1, int var3);

    private native int rateLimitDelayMaxMilliseconds(long var1);

    private native void setArenaBlockSize(long var1, long var3) throws IllegalArgumentException;

    private native long arenaBlockSize(long var1);

    private native void setDisableAutoCompactions(long var1, boolean var3);

    private native boolean disableAutoCompactions(long var1);

    private native void setCompactionStyle(long var1, byte var3);

    private native byte compactionStyle(long var1);

    private native void setPurgeRedundantKvsWhileFlush(long var1, boolean var3);

    private native boolean purgeRedundantKvsWhileFlush(long var1);

    private native void setVerifyChecksumsInCompaction(long var1, boolean var3);

    private native boolean verifyChecksumsInCompaction(long var1);

    private native void setFilterDeletes(long var1, boolean var3);

    private native boolean filterDeletes(long var1);

    private native void setMaxSequentialSkipInIterations(long var1, long var3);

    private native long maxSequentialSkipInIterations(long var1);

    private native void setMemTableFactory(long var1, long var3);

    private native String memTableFactoryName(long var1);

    private native void setTableFactory(long var1, long var3);

    private native String tableFactoryName(long var1);

    private native void setInplaceUpdateSupport(long var1, boolean var3);

    private native boolean inplaceUpdateSupport(long var1);

    private native void setInplaceUpdateNumLocks(long var1, long var3) throws IllegalArgumentException;

    private native long inplaceUpdateNumLocks(long var1);

    private native void setMemtablePrefixBloomBits(long var1, int var3);

    private native int memtablePrefixBloomBits(long var1);

    private native void setMemtablePrefixBloomProbes(long var1, int var3);

    private native int memtablePrefixBloomProbes(long var1);

    private native void setBloomLocality(long var1, int var3);

    private native int bloomLocality(long var1);

    private native void setMaxSuccessiveMerges(long var1, long var3) throws IllegalArgumentException;

    private native long maxSuccessiveMerges(long var1);

    private native void setMinPartialMergeOperands(long var1, int var3);

    private native int minPartialMergeOperands(long var1);

    private native void setOptimizeFiltersForHits(long var1, boolean var3);

    private native boolean optimizeFiltersForHits(long var1);

    static {
        RocksDB.loadLibrary();
    }
}

