/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jnr.posix.util.Platform;
import org.python.Version;
import org.python.core.ClassDictInit;
import org.python.core.ClasspathPyImporter;
import org.python.core.Console;
import org.python.core.FloatInfo;
import org.python.core.JavaImporter;
import org.python.core.JythonInitializer;
import org.python.core.LongInfo;
import org.python.core.Options;
import org.python.core.PlainConsole;
import org.python.core.Py;
import org.python.core.PyAttributeDeleted;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFrame;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyMethod;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySyntaxError;
import org.python.core.PySystemStateFunctions;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.PythonTraceFunction;
import org.python.core.SyspathJavaLoader;
import org.python.core.ThreadState;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.__builtin__;
import org.python.core.adapter.ClassicPyObjectAdapter;
import org.python.core.adapter.ExtensiblePyObjectAdapter;
import org.python.core.codecs;
import org.python.core.imp;
import org.python.core.packagecache.PackageManager;
import org.python.core.packagecache.SysPackageManager;
import org.python.modules.Setup;
import org.python.modules.zipimport.zipimporter;
import org.python.util.Generic;

public class PySystemState
extends PyObject
implements AutoCloseable,
ClassDictInit,
Closeable,
Traverseproc {
    public static final String PYTHON_CACHEDIR = "python.cachedir";
    public static final String PYTHON_CACHEDIR_SKIP = "python.cachedir.skip";
    public static final String PYTHON_CONSOLE_ENCODING = "python.console.encoding";
    public static final String PYTHON_IO_ENCODING = "python.io.encoding";
    public static final String PYTHON_IO_ERRORS = "python.io.errors";
    protected static final String CACHEDIR_DEFAULT_NAME = "cachedir";
    public static final String JYTHON_JAR = "jython.jar";
    public static final String JYTHON_DEV_JAR = "jython-dev.jar";
    private static final String JAR_URL_PREFIX = "jar:file:";
    private static final String JAR_SEPARATOR = "!";
    private static final String VFSZIP_PREFIX = "vfszip:";
    private static final String VFS_PREFIX = "vfs:";
    public static final PyString version = new PyString(Version.getVersion());
    public static final PyTuple subversion = new PyTuple(new PyString("Jython"), Py.newString(""), Py.newString(""));
    public static final int hexversion = Version.PY_MAJOR_VERSION << 24 | Version.PY_MINOR_VERSION << 16 | Version.PY_MICRO_VERSION << 8 | Version.PY_RELEASE_LEVEL << 4 | Version.PY_RELEASE_SERIAL << 0;
    public static final PyTuple version_info = PySystemState.getVersionInfo();
    public static final int maxunicode = 0x10FFFF;
    public static final int maxsize = Integer.MAX_VALUE;
    public static final PyString float_repr_style = Py.newString("short");
    public static boolean py3kwarning = false;
    public static final Class flags = Options.class;
    public static final PyTuple _mercurial = new PyTuple(Py.newString("Jython"), Py.newString(Version.getHGIdentifier()), Py.newString(Version.getHGVersion()));
    public static final PyObject copyright = Py.newString("Copyright (c) 2000-2014 Jython Developers.\nAll rights reserved.\n\nCopyright (c) 2000 BeOpen.com.\nAll Rights Reserved.\n\nCopyright (c) 2000 The Apache Software Foundation.\nAll rights reserved.\n\nCopyright (c) 1995-2000 Corporation for National Research Initiatives.\nAll Rights Reserved.\n\nCopyright (c) 1991-1995 Stichting Mathematisch Centrum, Amsterdam.\nAll Rights Reserved.");
    private static Map<String, String> builtinNames;
    public static PyTuple builtin_module_names;
    public static PackageManager packageManager;
    private static File cachedir;
    private static PyList defaultPath;
    private static PyList defaultArgv;
    private static PyObject defaultExecutable;
    public static Properties registry;
    public static PyObject prefix;
    public static PyObject exec_prefix;
    public static final PyString byteorder;
    public static final int maxint = Integer.MAX_VALUE;
    public static final int minint = Integer.MIN_VALUE;
    private static boolean initialized;
    public PyList argv = new PyList();
    public PyObject modules;
    public Map<String, PyModule> modules_reloading;
    private ReentrantLock importLock;
    private ClassLoader syspathJavaLoader;
    public PyList path;
    public PyList warnoptions = new PyList();
    public PyObject builtins;
    private static PyObject defaultPlatform;
    public PyObject platform = defaultPlatform;
    public PyList meta_path;
    public PyList path_hooks;
    public PyObject path_importer_cache;
    public PyObject ps1 = new PyString(">>> ");
    public PyObject ps2 = new PyString("... ");
    public PyObject executable;
    private String currentWorkingDir;
    private ClassLoader classLoader = null;
    public PyObject stdout;
    public PyObject stderr;
    public PyObject stdin;
    public PyObject __stdout__;
    public PyObject __stderr__;
    public PyObject __stdin__;
    public PyObject __displayhook__;
    public PyObject __excepthook__;
    public PyObject last_value = Py.None;
    public PyObject last_type = Py.None;
    public PyObject last_traceback = Py.None;
    public PyObject __name__ = new PyString("sys");
    public PyObject __dict__;
    private int recursionlimit = 1000;
    private codecs.CodecState codecState;
    public boolean _systemRestart = false;
    public boolean dont_write_bytecode = false;
    private final PySystemStateCloser closer;
    private static final ReferenceQueue<PySystemState> systemStateQueue;
    private static final ConcurrentMap<WeakReference<PySystemState>, PySystemStateCloser> sysClosers;
    public static final PyObject float_info;
    public static final PyObject long_info;
    private static final String INITIALIZER_SERVICE = "META-INF/services/org.python.core.JythonInitializer";

    public PySystemState() {
        PySystemState.initialize();
        this.closer = new PySystemStateCloser(this);
        this.modules = new PyStringMap();
        this.modules_reloading = new HashMap<String, PyModule>();
        this.importLock = new ReentrantLock();
        this.syspathJavaLoader = new SyspathJavaLoader(imp.getParentClassLoader());
        this.argv = (PyList)defaultArgv.repeat(1);
        this.path = (PyList)defaultPath.repeat(1);
        this.path.append(Py.newString("__classpath__"));
        this.path.append(Py.newString("__pyclasspath__/"));
        this.executable = defaultExecutable;
        this.builtins = PySystemState.getDefaultBuiltins();
        this.platform = defaultPlatform;
        this.meta_path = new PyList();
        this.path_hooks = new PyList();
        this.path_hooks.append(new JavaImporter());
        this.path_hooks.append(zipimporter.TYPE);
        this.path_hooks.append(ClasspathPyImporter.TYPE);
        this.path_importer_cache = new PyDictionary();
        this.currentWorkingDir = new File("").getAbsolutePath();
        this.dont_write_bytecode = Options.dont_write_bytecode;
        py3kwarning = Options.py3k_warning;
        String mode = Options.unbuffered ? "b" : "";
        int buffering = Options.unbuffered ? 0 : 1;
        this.stdin = this.__stdin__ = new PyFile(System.in, "<stdin>", "r" + mode, buffering, false);
        this.stdout = this.__stdout__ = new PyFile(System.out, "<stdout>", "w" + mode, buffering, false);
        this.stderr = this.__stderr__ = new PyFile(System.err, "<stderr>", "w" + mode, 0, false);
        this.initEncoding();
        this.__displayhook__ = new PySystemStateFunctions("displayhook", 10, 1, 1);
        this.__excepthook__ = new PySystemStateFunctions("excepthook", 30, 3, 3);
        if (this.builtins == null) {
            this.builtins = PySystemState.getDefaultBuiltins();
        }
        this.modules.__setitem__("__builtin__", (PyObject)new PyModule("__builtin__", PySystemState.getDefaultBuiltins()));
        this.__dict__ = new PyStringMap();
        this.__dict__.invoke("update", this.getType().fastGetDict());
        this.__dict__.__setitem__("displayhook", this.__displayhook__);
        this.__dict__.__setitem__("excepthook", this.__excepthook__);
    }

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("trace", null);
        dict.__setitem__("profile", null);
    }

    void reload() throws PyIgnoreMethodTag {
        this.__dict__.invoke("update", this.getType().fastGetDict());
    }

    private static void checkReadOnly(String name) {
        if (name == "__dict__" || name == "__class__" || name == "registry" || name == "exec_prefix" || name == "packageManager") {
            throw Py.TypeError("readonly attribute");
        }
    }

    private static void checkMustExist(String name) {
        if (name == "__dict__" || name == "__class__" || name == "registry" || name == "exec_prefix" || name == "platform" || name == "packageManager" || name == "builtins" || name == "warnoptions") {
            throw Py.TypeError("readonly attribute");
        }
    }

    private void initEncoding() {
        String encoding = registry.getProperty(PYTHON_IO_ENCODING);
        String errors = registry.getProperty(PYTHON_IO_ERRORS);
        if (encoding == null) {
            encoding = Py.getConsole().getEncoding();
        }
        ((PyFile)this.stdin).setEncoding(encoding, errors);
        ((PyFile)this.stdout).setEncoding(encoding, errors);
        ((PyFile)this.stderr).setEncoding(encoding, "backslashreplace");
    }

    @Deprecated
    public void shadow() {
    }

    public static PyObject getDefaultBuiltins() {
        return DefaultBuiltinsHolder.builtins;
    }

    public PyObject getBuiltins() {
        return this.builtins;
    }

    public void setBuiltins(PyObject value) {
        this.builtins = value;
        this.modules.__setitem__("__builtin__", (PyObject)new PyModule("__builtin__", value));
    }

    public PyObject getWarnoptions() {
        return this.warnoptions;
    }

    public void setWarnoptions(PyObject value) {
        this.warnoptions = new PyList(value);
    }

    public PyObject getPlatform() {
        return this.platform;
    }

    public void setPlatform(PyObject value) {
        this.platform = value;
    }

    public synchronized codecs.CodecState getCodecState() {
        block3: {
            if (this.codecState == null) {
                this.codecState = new codecs.CodecState();
                try {
                    imp.load("encodings");
                }
                catch (PyException exc) {
                    if (exc.type == Py.ImportError) break block3;
                    throw exc;
                }
            }
        }
        return this.codecState;
    }

    public ReentrantLock getImportLock() {
        return this.importLock;
    }

    public ClassLoader getSyspathJavaLoader() {
        return this.syspathJavaLoader;
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        if (name == "exc_value") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.value;
        }
        if (name == "exc_type") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.type;
        }
        if (name == "exc_traceback") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.traceback;
        }
        PyObject ret = super.__findattr_ex__(name);
        if (ret != null) {
            if (ret instanceof PyMethod) {
                if (this.__dict__.__finditem__(name) instanceof PyReflectedFunction) {
                    return ret;
                }
            } else {
                if (ret == PyAttributeDeleted.INSTANCE) {
                    return null;
                }
                return ret;
            }
        }
        return this.__dict__.__finditem__(name);
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        PySystemState.checkReadOnly(name);
        if (name == "builtins") {
            this.setBuiltins(value);
        } else {
            PyObject ret = this.getType().lookup(name);
            if (ret != null && ret._doset(this, value)) {
                return;
            }
            this.__dict__.__setitem__(name, value);
        }
    }

    @Override
    public void __delattr__(String name) {
        block3: {
            PySystemState.checkMustExist(name);
            PyObject ret = this.getType().lookup(name);
            if (ret != null) {
                ret._doset(this, PyAttributeDeleted.INSTANCE);
            }
            try {
                this.__dict__.__delitem__(name);
            }
            catch (PyException pye) {
                if (ret != null) break block3;
                throw Py.AttributeError(name);
            }
        }
    }

    @Override
    public void __rawdir__(PyDictionary accum) {
        accum.update(this.__dict__);
    }

    @Override
    public String toString() {
        return "<module '" + this.__name__ + "' (built-in)>";
    }

    public int getrecursionlimit() {
        return this.recursionlimit;
    }

    public void setrecursionlimit(int recursionlimit) {
        if (recursionlimit <= 0) {
            throw Py.ValueError("Recursion limit must be positive");
        }
        this.recursionlimit = recursionlimit;
    }

    public PyObject gettrace() {
        ThreadState ts = Py.getThreadState();
        if (ts.tracefunc == null) {
            return Py.None;
        }
        return ((PythonTraceFunction)ts.tracefunc).tracefunc;
    }

    public void settrace(PyObject tracefunc) {
        ThreadState ts = Py.getThreadState();
        ts.tracefunc = tracefunc == Py.None ? null : new PythonTraceFunction(tracefunc);
    }

    public PyObject getprofile() {
        ThreadState ts = Py.getThreadState();
        if (ts.profilefunc == null) {
            return Py.None;
        }
        return ((PythonTraceFunction)ts.profilefunc).tracefunc;
    }

    public void setprofile(PyObject profilefunc) {
        ThreadState ts = Py.getThreadState();
        ts.profilefunc = profilefunc == Py.None ? null : new PythonTraceFunction(profilefunc);
    }

    public PyString getdefaultencoding() {
        return new PyString(codecs.getDefaultEncoding());
    }

    public void setdefaultencoding(String encoding) {
        codecs.setDefaultEncoding(encoding);
    }

    public PyObject getfilesystemencoding() {
        return Py.None;
    }

    public void setCurrentWorkingDir(String path) {
        this.currentWorkingDir = path;
    }

    public String getCurrentWorkingDir() {
        return this.currentWorkingDir;
    }

    public String getPath(String path) {
        return PySystemState.getPath(this, path);
    }

    public static String getPathLazy(String path) {
        return PySystemState.getPath(null, path);
    }

    private static String getPath(PySystemState sys, String path) {
        if (path != null) {
            path = PySystemState.getFile(sys, path).getAbsolutePath();
        }
        return path;
    }

    public File getFile(String path) {
        return PySystemState.getFile(this, path);
    }

    private static File getFile(PySystemState sys, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            if (sys == null) {
                sys = Py.getSystemState();
            }
            String cwd = sys.getCurrentWorkingDir();
            file = Platform.IS_WINDOWS ? PySystemState.getWindowsFile(cwd, path) : new File(cwd, path);
        }
        return file;
    }

    private static File getWindowsFile(String cwd, String path) {
        char d;
        if (path.indexOf(47) >= 0) {
            path = path.replace('/', '\\');
        }
        if ((d = PySystemState.driveLetter(path)) != '\u0000') {
            if (d == PySystemState.driveLetter(cwd)) {
                return new File(cwd, path.substring(2));
            }
            return new File(path);
        }
        if (path.startsWith("\\")) {
            if (PySystemState.driveLetter(cwd) != '\u0000') {
                return new File(cwd.substring(0, 2), path);
            }
            return new File(PySystemState.uncShare(cwd), path);
        }
        return new File(cwd, path);
    }

    private static char driveLetter(String path) {
        char pathDrive;
        if (path.length() >= 2 && path.charAt(1) == ':' && Character.isLetter(pathDrive = path.charAt(0))) {
            return Character.toUpperCase(pathDrive);
        }
        return '\u0000';
    }

    private static String uncShare(String path) {
        int p;
        int n = path.length();
        if (n >= 5 && path.startsWith("\\\\") && (p = path.indexOf(92, 2)) >= 3 && n > p + 2) {
            int dir = path.indexOf(92, p + 1);
            if (dir < 0) {
                return path;
            }
            if (dir > p + 1) {
                return path.substring(0, dir);
            }
        }
        return null;
    }

    public void callExitFunc() throws PyIgnoreMethodTag {
        PyObject exitfunc = this.__findattr__("exitfunc");
        if (exitfunc != null) {
            try {
                exitfunc.__call__();
            }
            catch (PyException exc) {
                if (!exc.match(Py.SystemExit)) {
                    Py.println(this.stderr, Py.newString("Error in sys.exitfunc:"));
                }
                Py.printException(exc);
            }
        }
        Py.flushLine();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static String findRoot(Properties preProperties, Properties postProperties, String jarFileName) {
        String classpath;
        String root = null;
        try {
            if (postProperties != null) {
                root = postProperties.getProperty("python.home");
            }
            if (root == null) {
                root = preProperties.getProperty("python.home");
            }
            if (root == null) {
                root = preProperties.getProperty("install.root");
            }
            PySystemState.determinePlatform(preProperties);
        }
        catch (Exception exc) {
            return null;
        }
        if (root == null && (classpath = preProperties.getProperty("java.class.path")) != null) {
            String lowerCaseClasspath = classpath.toLowerCase();
            int jarIndex = lowerCaseClasspath.indexOf(JYTHON_JAR);
            if (jarIndex < 0) {
                jarIndex = lowerCaseClasspath.indexOf(JYTHON_DEV_JAR);
            }
            if (jarIndex >= 0) {
                int start = classpath.lastIndexOf(File.pathSeparator, jarIndex) + 1;
                root = classpath.substring(start, jarIndex);
            } else if (jarFileName != null) {
                root = new File(jarFileName).getParent();
            }
        }
        if (root == null) {
            return null;
        }
        File rootFile = new File(root);
        try {
            return rootFile.getCanonicalPath();
        }
        catch (IOException ioe) {
            return rootFile.getAbsolutePath();
        }
    }

    private static void determinePlatform(Properties props) {
        String lversion;
        String version = props.getProperty("java.version");
        if (version == null) {
            version = "???";
        }
        if ((lversion = version.toLowerCase()).startsWith("java")) {
            version = version.substring(4, version.length());
        }
        if (lversion.startsWith("jdk") || lversion.startsWith("jre")) {
            version = version.substring(3, version.length());
        }
        if (version.equals("12")) {
            version = "1.2";
        }
        defaultPlatform = new PyString("java" + version);
    }

    private static void initRegistry(Properties preProperties, Properties postProperties, boolean standalone, String jarFileName) {
        String encoding;
        String prefix;
        if (registry != null) {
            Py.writeError("systemState", "trying to reinitialize registry");
            return;
        }
        registry = preProperties;
        String exec_prefix = prefix = PySystemState.findRoot(preProperties, postProperties, jarFileName);
        if (prefix != null) {
            if (prefix.length() == 0) {
                exec_prefix = ".";
                prefix = ".";
            }
            try {
                File homeFile = new File(registry.getProperty("user.home"), ".jython");
                PySystemState.addRegistryFile(homeFile);
                PySystemState.addRegistryFile(new File(prefix, "registry"));
            }
            catch (Exception homeFile) {
                // empty catch block
            }
        }
        if (prefix != null) {
            PySystemState.prefix = Py.newString(prefix);
        }
        if (exec_prefix != null) {
            PySystemState.exec_prefix = Py.newString(exec_prefix);
        }
        try {
            String jythonpath = System.getenv("JYTHONPATH");
            if (jythonpath != null) {
                registry.setProperty("python.path", jythonpath);
            }
        }
        catch (SecurityException jythonpath) {
            // empty catch block
        }
        registry.putAll((Map<?, ?>)postProperties);
        if (standalone && !registry.containsKey(PYTHON_CACHEDIR_SKIP)) {
            registry.put(PYTHON_CACHEDIR_SKIP, "true");
        }
        if (!registry.containsKey(PYTHON_CONSOLE_ENCODING) && (encoding = PySystemState.getPlatformEncoding()) != null) {
            registry.put(PYTHON_CONSOLE_ENCODING, encoding);
        }
        Options.setFromRegistry();
    }

    private static String getPlatformEncoding() {
        String encoding = PySystemState.getConsoleEncoding();
        if (encoding == null) {
            try {
                encoding = System.getProperty("file.encoding");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return encoding;
    }

    private static String getConsoleEncoding() {
        String encoding = null;
        try {
            Method encodingMethod = java.io.Console.class.getDeclaredMethod("encoding", new Class[0]);
            encodingMethod.setAccessible(true);
            encoding = (String)encodingMethod.invoke(Console.class, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRegistryFile(File file) {
        if (file.exists()) {
            if (!file.isDirectory()) {
                Properties fileProperties = new Properties();
                try (FileInputStream fp = new FileInputStream(file);){
                    fileProperties.load(fp);
                    for (Map.Entry<Object, Object> kv : fileProperties.entrySet()) {
                        Object key = kv.getKey();
                        if (registry.containsKey(key)) continue;
                        registry.put(key, kv.getValue());
                    }
                }
                catch (IOException e) {
                    System.err.println("couldn't open registry file: " + file.toString());
                }
            } else {
                System.err.println("warning: " + file.toString() + " is a directory, not a file");
            }
        }
    }

    public static Properties getBaseProperties() {
        try {
            return System.getProperties();
        }
        catch (AccessControlException ace) {
            return new Properties();
        }
    }

    public static synchronized void initialize() {
        PySystemState.initialize(null, null);
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties) {
        PySystemState.initialize(preProperties, postProperties, new String[]{""});
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties, String[] argv) {
        PySystemState.initialize(preProperties, postProperties, argv, null);
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties, String[] argv, ClassLoader classLoader) {
        PySystemState.initialize(preProperties, postProperties, argv, classLoader, new ClassicPyObjectAdapter());
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties, String[] argv, ClassLoader classLoader, ExtensiblePyObjectAdapter adapter) {
        if (initialized) {
            return;
        }
        if (preProperties == null) {
            preProperties = PySystemState.getBaseProperties();
        }
        if (postProperties == null) {
            postProperties = new Properties();
        }
        try {
            ClassLoader sysStateLoader;
            ClassLoader context = Thread.currentThread().getContextClassLoader();
            if (context != null) {
                if (PySystemState.initialize(preProperties, postProperties, argv, classLoader, adapter, context)) {
                    return;
                }
            } else {
                Py.writeDebug("initializer", "Context class loader null, skipping");
            }
            if ((sysStateLoader = PySystemState.class.getClassLoader()) != null) {
                if (PySystemState.initialize(preProperties, postProperties, argv, classLoader, adapter, sysStateLoader)) {
                    return;
                }
            } else {
                Py.writeDebug("initializer", "PySystemState.class class loader null, skipping");
            }
        }
        catch (UnsupportedCharsetException e) {
            Py.writeWarning("initializer", "Unable to load the UTF-8 charset to read an initializer definition");
            e.printStackTrace(System.err);
        }
        catch (SecurityException e) {
        }
        catch (Exception e) {
            Py.writeWarning("initializer", "Unexpected exception thrown while trying to use initializer service");
            e.printStackTrace(System.err);
        }
        PySystemState.doInitialize(preProperties, postProperties, argv, classLoader, adapter);
    }

    private static boolean initialize(Properties pre, Properties post, String[] argv, ClassLoader sysClassLoader, ExtensiblePyObjectAdapter adapter, ClassLoader initializerClassLoader) {
        Class<?> initializer;
        String className;
        InputStream in = initializerClassLoader.getResourceAsStream(INITIALIZER_SERVICE);
        if (in == null) {
            Py.writeDebug("initializer", "'META-INF/services/org.python.core.JythonInitializer' not found on " + initializerClassLoader);
            return false;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        try {
            className = r.readLine();
        }
        catch (IOException e) {
            Py.writeWarning("initializer", "Failed reading 'META-INF/services/org.python.core.JythonInitializer' from " + initializerClassLoader);
            e.printStackTrace(System.err);
            return false;
        }
        try {
            initializer = initializerClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Py.writeWarning("initializer", "Specified initializer class '" + className + "' not found, continuing");
            return false;
        }
        try {
            ((JythonInitializer)initializer.newInstance()).initialize(pre, post, argv, sysClassLoader, adapter);
        }
        catch (Exception e) {
            Py.writeWarning("initializer", "Failed initializing with class '" + className + "', continuing");
            e.printStackTrace(System.err);
            return false;
        }
        if (!initialized) {
            Py.writeWarning("initializer", "Initializer '" + className + "' failed to call doInitialize, using default initialization");
        }
        return initialized;
    }

    public static synchronized PySystemState doInitialize(Properties preProperties, Properties postProperties, String[] argv, ClassLoader classLoader, ExtensiblePyObjectAdapter adapter) {
        if (initialized) {
            return Py.defaultSystemState;
        }
        initialized = true;
        Py.setAdapter(adapter);
        boolean standalone = false;
        String jarFileName = PySystemState.getJarFileName();
        if (jarFileName != null) {
            standalone = PySystemState.isStandalone(jarFileName);
        }
        PySystemState.initRegistry(preProperties, postProperties, standalone, jarFileName);
        PySystemState.initBuiltins(registry);
        defaultPath = PySystemState.initPath(registry, standalone, jarFileName);
        defaultArgv = PySystemState.initArgv(argv);
        defaultExecutable = PySystemState.initExecutable(registry);
        PySystemState.initPackages(registry);
        PySystemState.initConsole(registry);
        Py.defaultSystemState = new PySystemState();
        Py.setSystemState(Py.defaultSystemState);
        if (classLoader != null) {
            Py.defaultSystemState.setClassLoader(classLoader);
        }
        Py.initClassExceptions(PySystemState.getDefaultBuiltins());
        new PySyntaxError("", 1, 1, "", "");
        Py.defaultSystemState.__setattr__("_jy_console", Py.java2py(Py.getConsole()));
        return Py.defaultSystemState;
    }

    private static PyTuple getVersionInfo() {
        String s;
        if (Version.PY_RELEASE_LEVEL == 10) {
            s = "alpha";
        } else if (Version.PY_RELEASE_LEVEL == 11) {
            s = "beta";
        } else if (Version.PY_RELEASE_LEVEL == 12) {
            s = "candidate";
        } else if (Version.PY_RELEASE_LEVEL == 15) {
            s = "final";
        } else if (Version.PY_RELEASE_LEVEL == 170) {
            s = "snapshot";
        } else {
            throw new RuntimeException("Illegal value for PY_RELEASE_LEVEL: " + Version.PY_RELEASE_LEVEL);
        }
        return new PyTuple(Py.newInteger(Version.PY_MAJOR_VERSION), Py.newInteger(Version.PY_MINOR_VERSION), Py.newInteger(Version.PY_MICRO_VERSION), Py.newString(s), Py.newInteger(Version.PY_RELEASE_SERIAL));
    }

    public static boolean isPackageCacheEnabled() {
        return cachedir != null;
    }

    private static void initCacheDirectory(Properties props) {
        String skip = props.getProperty(PYTHON_CACHEDIR_SKIP, "false");
        if (skip.equalsIgnoreCase("true")) {
            cachedir = null;
            return;
        }
        cachedir = new File(props.getProperty(PYTHON_CACHEDIR, CACHEDIR_DEFAULT_NAME));
        if (!cachedir.isAbsolute()) {
            cachedir = new File(prefix == null ? null : prefix.toString(), cachedir.getPath());
        }
    }

    private static void initPackages(Properties props) {
        PySystemState.initCacheDirectory(props);
        File pkgdir = cachedir != null ? new File(cachedir, "packages") : null;
        packageManager = new SysPackageManager(pkgdir, props);
    }

    private static PyList initArgv(String[] args) {
        PyList argv = new PyList();
        if (args != null) {
            for (String arg : args) {
                argv.append(Py.newStringOrUnicode(arg));
            }
        }
        return argv;
    }

    private static PyObject initExecutable(Properties props) {
        String executable = props.getProperty("python.executable");
        if (executable == null) {
            return Py.None;
        }
        File executableFile = new File(executable);
        try {
            executableFile = executableFile.getCanonicalFile();
        }
        catch (IOException ioe) {
            executableFile = executableFile.getAbsoluteFile();
        }
        if (!executableFile.isFile()) {
            return Py.None;
        }
        return new PyString(executableFile.getPath());
    }

    private static void initConsole(Properties props) {
        String encoding = props.getProperty(PYTHON_CONSOLE_ENCODING);
        String consoleName = props.getProperty("python.console", "").trim();
        Class<Console> consoleType = Console.class;
        if (consoleName.length() > 0 && Py.isInteractive()) {
            try {
                Class<?> consoleClass = Class.forName(consoleName);
                if (!consoleType.isAssignableFrom(consoleClass)) {
                    throw new ClassCastException();
                }
                Constructor<?> consoleConstructor = consoleClass.getConstructor(String.class);
                Object consoleObject = consoleConstructor.newInstance(encoding);
                Console console = (Console)consoleType.cast(consoleObject);
                Py.installConsole(console);
                return;
            }
            catch (NoClassDefFoundError e) {
                PySystemState.writeConsoleWarning(consoleName, "not found");
            }
            catch (ClassCastException e) {
                PySystemState.writeConsoleWarning(consoleName, "does not implement " + consoleType);
            }
            catch (NoSuchMethodException e) {
                PySystemState.writeConsoleWarning(consoleName, "has no constructor from String");
            }
            catch (InvocationTargetException e) {
                PySystemState.writeConsoleWarning(consoleName, e.getCause().toString());
            }
            catch (Exception e) {
                PySystemState.writeConsoleWarning(consoleName, e.toString());
            }
        }
        try {
            Py.installConsole(new PlainConsole(encoding));
            return;
        }
        catch (Exception e) {
            PySystemState.writeConsoleWarning(consoleName, e.toString());
            return;
        }
    }

    private static void writeConsoleWarning(String consoleName, String msg) {
        Py.writeWarning("console", "Failed to install '" + consoleName + "': " + msg + ".");
    }

    private static void addBuiltin(String name) {
        String classname;
        String modname;
        int colon = name.indexOf(58);
        if (colon != -1) {
            modname = name.substring(0, colon).trim();
            classname = name.substring(colon + 1, name.length()).trim();
            if (classname.equals("null")) {
                classname = null;
            }
        } else {
            modname = name.trim();
            classname = "org.python.modules." + modname;
        }
        if (classname != null) {
            builtinNames.put(modname, classname);
        } else {
            builtinNames.remove(modname);
        }
    }

    private static void initBuiltins(Properties props) {
        builtinNames = Generic.map();
        builtinNames.put("__builtin__", "");
        builtinNames.put("sys", "");
        for (String builtinModule : Setup.builtinModules) {
            PySystemState.addBuiltin(builtinModule);
        }
        String builtinprop = props.getProperty("python.modules.builtin", "");
        StringTokenizer tok = new StringTokenizer(builtinprop, ",");
        while (tok.hasMoreTokens()) {
            PySystemState.addBuiltin(tok.nextToken());
        }
        int n = builtinNames.size();
        PyObject[] built_mod = new PyObject[n];
        int i = 0;
        for (String key : builtinNames.keySet()) {
            built_mod[i++] = Py.newString(key);
        }
        builtin_module_names = new PyTuple(built_mod);
    }

    public static String getBuiltin(String name) {
        return builtinNames.get(name);
    }

    private static PyList initPath(Properties props, boolean standalone, String jarFileName) {
        PyList path = new PyList();
        PySystemState.addPaths(path, props.getProperty("python.path", ""));
        if (prefix != null) {
            String libpath = new File(prefix.toString(), "Lib").toString();
            path.append(new PyString(libpath));
        }
        if (standalone) {
            PySystemState.addPaths(path, jarFileName + "/Lib");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isStandalone(String jarFileName) {
        boolean standalone = false;
        if (jarFileName != null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(jarFileName);
                JarEntry jarEntry = jarFile.getJarEntry("Lib/os.py");
                standalone = jarEntry != null;
            }
            catch (IOException iOException) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return standalone;
    }

    private static String getJarFileName() {
        Class<PySystemState> thisClass = PySystemState.class;
        String fullClassName = thisClass.getName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        URL url = thisClass.getResource(className + ".class");
        return PySystemState.getJarFileNameFromURL(url);
    }

    protected static String getJarFileNameFromURL(URL url) {
        String jarFileName = null;
        if (url != null) {
            try {
                String path;
                int jarIndex;
                String plus = "\\+";
                String escapedPlus = "__ppluss__";
                String rawUrl = url.toString();
                rawUrl = rawUrl.replaceAll("\\+", "__ppluss__");
                String urlString = URLDecoder.decode(rawUrl, "UTF-8");
                urlString = urlString.replaceAll("__ppluss__", "\\+");
                int jarSeparatorIndex = urlString.lastIndexOf(JAR_SEPARATOR);
                if (urlString.startsWith(JAR_URL_PREFIX) && jarSeparatorIndex > 0) {
                    jarFileName = urlString.substring(JAR_URL_PREFIX.length(), jarSeparatorIndex);
                } else if (urlString.startsWith(VFSZIP_PREFIX)) {
                    String path2 = PySystemState.class.getName().replace('.', '/');
                    int jarIndex2 = urlString.indexOf(".jar/".concat(path2));
                    if (jarIndex2 > 0) {
                        jarIndex2 += 4;
                        int start = VFSZIP_PREFIX.length();
                        if (Platform.IS_WINDOWS) {
                            ++start;
                        }
                        jarFileName = urlString.substring(start, jarIndex2);
                    }
                } else if (urlString.startsWith(VFS_PREFIX) && (jarIndex = urlString.indexOf(".jar/".concat(path = PySystemState.class.getName().replace('.', '/')))) > 0) {
                    jarIndex += 4;
                    int start = VFS_PREFIX.length();
                    if (Platform.IS_WINDOWS) {
                        ++start;
                    }
                    jarFileName = urlString.substring(start, jarIndex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jarFileName;
    }

    private static void addPaths(PyList path, String pypath) {
        StringTokenizer tok = new StringTokenizer(pypath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            path.append(new PyString(tok.nextToken().trim()));
        }
    }

    public static PyJavaPackage add_package(String n) {
        return PySystemState.add_package(n, null);
    }

    public static PyJavaPackage add_package(String n, String contents) {
        return packageManager.makeJavaPackage(n, contents, null);
    }

    public static void add_classdir(String directoryPath) {
        packageManager.addDirectory(new File(directoryPath));
    }

    public static void add_extdir(String directoryPath) {
        packageManager.addJarDir(directoryPath, false);
    }

    public static void add_extdir(String directoryPath, boolean cache) {
        packageManager.addJarDir(directoryPath, cache);
    }

    static void displayhook(PyObject o) {
        if (o == Py.None) {
            return;
        }
        PyObject currentBuiltins = Py.getSystemState().getBuiltins();
        currentBuiltins.__setitem__("_", Py.None);
        Py.stdout.println(o.__repr__());
        currentBuiltins.__setitem__("_", o);
    }

    static void excepthook(PyObject type, PyObject val, PyObject tb) {
        Py.displayException(type, val, tb, null);
    }

    public static void exit(PyObject status) {
        throw new PyException(Py.SystemExit, status);
    }

    public static void exit() {
        PySystemState.exit(Py.None);
    }

    public static PyTuple exc_info() {
        PyException exc = Py.getThreadState().exception;
        if (exc == null) {
            return new PyTuple(Py.None, Py.None, Py.None);
        }
        PyTraceback tb = exc.traceback;
        PyObject value = exc.value;
        return new PyTuple(exc.type, value == null ? Py.None : value, tb == null ? Py.None : tb);
    }

    public static void exc_clear() {
        Py.getThreadState().exception = null;
    }

    public static PyFrame _getframe() {
        return PySystemState._getframe(-1);
    }

    public static PyFrame _getframe(int depth) {
        PyFrame f = Py.getFrame();
        while (depth > 0 && f != null) {
            f = f.f_back;
            --depth;
        }
        if (f == null) {
            throw Py.ValueError("call stack is not deep enough");
        }
        return f;
    }

    public void registerCloser(Callable<Void> resourceCloser) {
        this.closer.registerCloser(resourceCloser);
    }

    public boolean unregisterCloser(Callable<Void> resourceCloser) {
        return this.closer.unregisterCloser(resourceCloser);
    }

    public void cleanup() {
        this.closer.cleanup();
    }

    @Override
    public void close() {
        this.cleanup();
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.argv != null && (retVal = visit.visit(this.argv, arg)) != 0) {
            return retVal;
        }
        if (this.modules != null && (retVal = visit.visit(this.modules, arg)) != 0) {
            return retVal;
        }
        if (this.path != null && (retVal = visit.visit(this.path, arg)) != 0) {
            return retVal;
        }
        if (this.warnoptions != null && (retVal = visit.visit(this.warnoptions, arg)) != 0) {
            return retVal;
        }
        if (this.builtins != null && (retVal = visit.visit(this.builtins, arg)) != 0) {
            return retVal;
        }
        if (this.platform != null && (retVal = visit.visit(this.platform, arg)) != 0) {
            return retVal;
        }
        if (this.meta_path != null && (retVal = visit.visit(this.meta_path, arg)) != 0) {
            return retVal;
        }
        if (this.path_hooks != null && (retVal = visit.visit(this.path_hooks, arg)) != 0) {
            return retVal;
        }
        if (this.path_importer_cache != null && (retVal = visit.visit(this.path_importer_cache, arg)) != 0) {
            return retVal;
        }
        if (this.ps1 != null && (retVal = visit.visit(this.ps1, arg)) != 0) {
            return retVal;
        }
        if (this.ps2 != null && (retVal = visit.visit(this.ps2, arg)) != 0) {
            return retVal;
        }
        if (this.executable != null && (retVal = visit.visit(this.executable, arg)) != 0) {
            return retVal;
        }
        if (this.stdout != null && (retVal = visit.visit(this.stdout, arg)) != 0) {
            return retVal;
        }
        if (this.stderr != null && (retVal = visit.visit(this.stderr, arg)) != 0) {
            return retVal;
        }
        if (this.stdin != null && (retVal = visit.visit(this.stdin, arg)) != 0) {
            return retVal;
        }
        if (this.__stdout__ != null && (retVal = visit.visit(this.__stdout__, arg)) != 0) {
            return retVal;
        }
        if (this.__stderr__ != null && (retVal = visit.visit(this.__stderr__, arg)) != 0) {
            return retVal;
        }
        if (this.__stdin__ != null && (retVal = visit.visit(this.__stdin__, arg)) != 0) {
            return retVal;
        }
        if (this.__displayhook__ != null && (retVal = visit.visit(this.__displayhook__, arg)) != 0) {
            return retVal;
        }
        if (this.__excepthook__ != null && (retVal = visit.visit(this.__excepthook__, arg)) != 0) {
            return retVal;
        }
        if (this.last_value != null && (retVal = visit.visit(this.last_value, arg)) != 0) {
            return retVal;
        }
        if (this.last_type != null && (retVal = visit.visit(this.last_type, arg)) != 0) {
            return retVal;
        }
        if (this.last_traceback != null && (retVal = visit.visit(this.last_traceback, arg)) != 0) {
            return retVal;
        }
        if (this.__name__ != null && (retVal = visit.visit(this.__name__, arg)) != 0) {
            return retVal;
        }
        return this.__dict__ == null ? 0 : visit.visit(this.__dict__, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.argv || ob == this.modules || ob == this.path || ob == this.warnoptions || ob == this.builtins || ob == this.platform || ob == this.meta_path || ob == this.path_hooks || ob == this.path_importer_cache || ob == this.ps1 || ob == this.ps2 || ob == this.executable || ob == this.stdout || ob == this.stderr || ob == this.stdin || ob == this.__stdout__ || ob == this.__stderr__ || ob == this.__stdin__ || ob == this.__displayhook__ || ob == this.__excepthook__ || ob == this.last_value || ob == this.last_type || ob == this.last_traceback || ob == this.__name__ || ob == this.__dict__);
    }

    static {
        builtin_module_names = null;
        exec_prefix = Py.EmptyString;
        byteorder = new PyString("big");
        initialized = false;
        defaultPlatform = new PyString("java");
        systemStateQueue = new ReferenceQueue();
        sysClosers = Generic.concurrentMap();
        float_info = FloatInfo.getInfo();
        long_info = LongInfo.getInfo();
    }

    private static class PySystemStateCloser {
        private final Set<Callable<Void>> resourceClosers = new LinkedHashSet<Callable<Void>>();
        private volatile boolean isCleanup = false;
        private final Thread shutdownHook = this.initShutdownCloser();

        private PySystemStateCloser(PySystemState sys) {
            WeakReference<PySystemState> ref = new WeakReference<PySystemState>(sys, systemStateQueue);
            sysClosers.put(ref, this);
            PySystemStateCloser.cleanupOtherClosers();
        }

        private static void cleanupOtherClosers() {
            Reference ref;
            while ((ref = systemStateQueue.poll()) != null) {
                PySystemStateCloser closer = (PySystemStateCloser)sysClosers.get(ref);
                closer.cleanup();
            }
        }

        private synchronized void registerCloser(Callable<Void> closer) {
            if (!this.isCleanup) {
                this.resourceClosers.add(closer);
            }
        }

        private synchronized boolean unregisterCloser(Callable<Void> closer) {
            return this.resourceClosers.remove(closer);
        }

        private synchronized void cleanup() {
            if (this.isCleanup) {
                return;
            }
            this.isCleanup = true;
            if (this.shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            this.runClosers();
            this.resourceClosers.clear();
            this.isCleanup = false;
        }

        private synchronized void runClosers() {
            if (this.resourceClosers != null) {
                LinkedList<Callable<Void>> rc = new LinkedList<Callable<Void>>(this.resourceClosers);
                Iterator<Callable<Void>> iter = rc.descendingIterator();
                while (iter.hasNext()) {
                    Callable<Void> callable = iter.next();
                    try {
                        callable.call();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private Thread initShutdownCloser() {
            try {
                Thread shutdownHook = new Thread((Runnable)new ShutdownCloser(), "Jython Shutdown Closer");
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                return shutdownHook;
            }
            catch (SecurityException se) {
                Py.writeDebug("PySystemState", "Can't register cleanup closer hook");
                return null;
            }
        }

        private class ShutdownCloser
        implements Runnable {
            private ShutdownCloser() {
            }

            @Override
            public synchronized void run() {
                PySystemStateCloser.this.runClosers();
                PySystemStateCloser.this.resourceClosers.clear();
            }
        }
    }

    private static class DefaultBuiltinsHolder {
        static final PyObject builtins = DefaultBuiltinsHolder.fillin();

        private DefaultBuiltinsHolder() {
        }

        static PyObject fillin() {
            PyStringMap temp = new PyStringMap();
            __builtin__.fillWithBuiltins(temp);
            return temp;
        }
    }
}

