/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._weakref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.modules._weakref.AbstractReference;
import org.python.util.Generic;

public class GlobalRef
extends WeakReference {
    private int hashCode;
    private int pythonHashCode;
    private boolean havePythonHashCode;
    private List references = new ArrayList();
    private static ReferenceQueue referenceQueue = new ReferenceQueue();
    private static Thread reaperThread;
    private static ReentrantReadWriteLock reaperLock;
    private static ConcurrentMap<GlobalRef, GlobalRef> objects;

    public GlobalRef(PyObject object) {
        super(object, referenceQueue);
        this.hashCode = System.identityHashCode(object);
    }

    public synchronized void add(AbstractReference ref) {
        WeakReference<AbstractReference> r = new WeakReference<AbstractReference>(ref);
        this.references.add(r);
    }

    private final AbstractReference getReferenceAt(int idx) {
        WeakReference wref = (WeakReference)this.references.get(idx);
        return (AbstractReference)wref.get();
    }

    synchronized AbstractReference find(Class cls) {
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference r = this.getReferenceAt(i);
            if (r == null) {
                this.references.remove(i);
                continue;
            }
            if (r.callback != null || r.getClass() != cls) continue;
            return r;
        }
        return null;
    }

    synchronized void call() {
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference r = this.getReferenceAt(i);
            if (r == null) {
                this.references.remove(i);
                continue;
            }
            r.call();
        }
    }

    public synchronized int count() {
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference r = this.getReferenceAt(i);
            if (r != null) continue;
            this.references.remove(i);
        }
        return this.references.size();
    }

    public synchronized PyList refs() {
        ArrayList<AbstractReference> list = new ArrayList<AbstractReference>();
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference r = this.getReferenceAt(i);
            if (r == null) {
                this.references.remove(i);
                continue;
            }
            list.add(r);
        }
        return new PyList(list);
    }

    public static GlobalRef newInstance(PyObject object) {
        GlobalRef.createReaperThreadIfAbsent();
        GlobalRef newRef = new GlobalRef(object);
        GlobalRef ref = objects.putIfAbsent(newRef, newRef);
        if (ref == null) {
            ref = newRef;
        }
        return ref;
    }

    private static void createReaperThreadIfAbsent() {
        block6: {
            reaperLock.readLock().lock();
            try {
                if (reaperThread != null && reaperThread.isAlive()) break block6;
                reaperLock.readLock().unlock();
                reaperLock.writeLock().lock();
                if (reaperThread != null && reaperThread.isAlive()) break block6;
                try {
                    GlobalRef.initReaperThread();
                }
                finally {
                    reaperLock.readLock().lock();
                    reaperLock.writeLock().unlock();
                }
            }
            finally {
                reaperLock.readLock().unlock();
            }
        }
    }

    public static int getCount(PyObject object) {
        GlobalRef ref = (GlobalRef)objects.get(new GlobalRef(object));
        return ref == null ? 0 : ref.count();
    }

    public static PyList getRefs(PyObject object) {
        GlobalRef ref = (GlobalRef)objects.get(new GlobalRef(object));
        return ref == null ? new PyList() : ref.refs();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GlobalRef)) {
            return false;
        }
        Object t = this.get();
        Object u = ((GlobalRef)o).get();
        if (t == null || u == null) {
            return false;
        }
        return t == u;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int pythonHashCode() {
        if (this.havePythonHashCode) {
            return this.pythonHashCode;
        }
        Object referent = this.get();
        if (referent == null) {
            throw Py.TypeError("weak object has gone away");
        }
        this.pythonHashCode = referent.hashCode();
        this.havePythonHashCode = true;
        return this.pythonHashCode;
    }

    private static void initReaperThread() {
        RefReaper reaper = new RefReaper();
        PySystemState systemState = Py.getSystemState();
        systemState.registerCloser(reaper);
        reaperThread = new Thread((Runnable)reaper, "weakref reaper");
        reaperThread.setDaemon(true);
        reaperThread.start();
    }

    static {
        reaperLock = new ReentrantReadWriteLock();
        objects = Generic.concurrentMap();
    }

    private static class RefReaper
    implements Runnable,
    Callable<Void> {
        private volatile boolean exit = false;
        private Thread thread;

        private RefReaper() {
        }

        public void collect() throws InterruptedException {
            GlobalRef gr = (GlobalRef)referenceQueue.remove();
            gr.call();
            objects.remove(gr);
            gr = null;
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            while (true) {
                try {
                    while (true) {
                        this.collect();
                    }
                }
                catch (InterruptedException exc) {
                    if (!this.exit) continue;
                    return;
                }
                break;
            }
        }

        @Override
        public Void call() throws Exception {
            this.exit = true;
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
                this.thread = null;
            }
            return null;
        }
    }
}

