/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.python.core.JavaIterator;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinClassMethodNarrow;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.Untraversable;

class JavaProxyMap {
    private static final PyBuiltinMethodNarrow mapLenProxy = new MapMethod("__len__", 0){

        @Override
        public PyObject __call__() {
            return Py.java2py(this.asMap().size());
        }
    };
    private static final PyBuiltinMethodNarrow mapReprProxy = new MapMethod("__repr__", 0){

        @Override
        public PyObject __call__() {
            ThreadState ts = Py.getThreadState();
            if (!ts.enterRepr(this.self)) {
                return Py.newString("{...}");
            }
            StringBuilder repr = new StringBuilder("{");
            boolean first = true;
            for (Map.Entry<Object, Object> entry : this.asMap().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    repr.append(", ");
                }
                PyObject key = Py.java2py(entry.getKey());
                repr.append(key.__repr__().toString());
                repr.append(": ");
                PyObject value = Py.java2py(entry.getValue());
                repr.append(value.__repr__().toString());
            }
            repr.append("}");
            ts.exitRepr(this.self);
            return Py.newString(repr.toString());
        }
    };
    private static final PyBuiltinMethodNarrow mapEqProxy = new MapMethod("__eq__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return JavaProxyMap.mapEq(this.self, other);
        }
    };
    private static final PyBuiltinMethodNarrow mapNeProxy = new MapMethod("__ne__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            PyBoolean equal = JavaProxyMap.mapEq(this.self, other);
            if (equal != null) {
                return equal.__not__();
            }
            return null;
        }
    };
    private static final PyBuiltinMethodNarrow mapLeProxy = new MapMethod("__le__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return JavaProxyMap.mapLe(this.self, other);
        }
    };
    private static final PyBuiltinMethodNarrow mapGeProxy = new MapMethod("__ge__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return JavaProxyMap.mapLe(this.self, other).__not__().__or__(JavaProxyMap.mapEq(this.self, other));
        }
    };
    private static final PyBuiltinMethodNarrow mapLtProxy = new MapMethod("__lt__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return JavaProxyMap.mapLe(this.self, other).__and__(JavaProxyMap.mapEq(this.self, other).__not__());
        }
    };
    private static final PyBuiltinMethodNarrow mapGtProxy = new MapMethod("__gt__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return JavaProxyMap.mapLe(this.self, other).__not__();
        }
    };
    private static final PyBuiltinMethodNarrow mapIterProxy = new MapMethod("__iter__", 0){

        @Override
        public PyObject __call__() {
            return new JavaIterator(this.asMap().keySet());
        }
    };
    private static final PyBuiltinMethodNarrow mapContainsProxy = new MapMethod("__contains__", 1){

        @Override
        public PyObject __call__(PyObject obj) {
            return this.asMap().containsKey(JavaProxyMap.tojava(obj)) ? Py.True : Py.False;
        }
    };
    private static final PyBuiltinMethodNarrow mapGetProxy = new MapMethod("get", 1, 2){

        @Override
        public PyObject __call__(PyObject key) {
            return this.__call__(key, Py.None);
        }

        @Override
        public PyObject __call__(PyObject key, PyObject _default) {
            Object k;
            Map<Object, Object> map = this.asMap();
            if (map.containsKey(k = JavaProxyMap.tojava(key))) {
                return Py.java2py(map.get(k));
            }
            return _default;
        }
    };
    private static final PyBuiltinMethodNarrow mapGetItemProxy = new MapMethod("__getitem__", 1){

        @Override
        public PyObject __call__(PyObject key) {
            Object k;
            Map<Object, Object> map = this.asMap();
            if (map.containsKey(k = JavaProxyMap.tojava(key))) {
                return Py.java2py(map.get(k));
            }
            throw Py.KeyError(key);
        }
    };
    private static final PyBuiltinMethodNarrow mapPutProxy = new MapMethod("__setitem__", 2){

        @Override
        public PyObject __call__(PyObject key, PyObject value) {
            try {
                this.asMap().put(JavaProxyMap.tojava(key), JavaProxyMap.tojava(value));
                return Py.None;
            }
            catch (NullPointerException npe) {
                throw JavaProxyMap.nullException(npe, key, value);
            }
        }
    };
    private static final PyBuiltinMethodNarrow mapRemoveProxy = new MapMethod("__delitem__", 1){

        @Override
        public PyObject __call__(PyObject key) {
            Object k;
            Map<Object, Object> map = this.asMap();
            if (map.containsKey(k = JavaProxyMap.tojava(key))) {
                map.remove(k);
                return Py.None;
            }
            throw Py.KeyError(key);
        }
    };
    private static final PyBuiltinMethodNarrow mapIterItemsProxy = new MapMethod("iteritems", 0){

        @Override
        public PyObject __call__() {
            final Iterator<Map.Entry<Object, Object>> entryIterator = this.asMap().entrySet().iterator();
            return new PyIterator(){

                @Override
                public PyObject __iternext__() {
                    if (entryIterator.hasNext()) {
                        Map.Entry e = (Map.Entry)entryIterator.next();
                        return new PyTuple(Py.java2py(e.getKey()), Py.java2py(e.getValue()));
                    }
                    return null;
                }
            };
        }
    };
    private static final PyBuiltinMethodNarrow mapIterKeysProxy = new MapMethod("iterkeys", 0){

        @Override
        public PyObject __call__() {
            final Iterator<Object> keyIterator = this.asMap().keySet().iterator();
            return new PyIterator(){

                @Override
                public PyObject __iternext__() {
                    if (keyIterator.hasNext()) {
                        Object nextKey = keyIterator.next();
                        return Py.java2py(nextKey);
                    }
                    return null;
                }
            };
        }
    };
    private static final PyBuiltinMethodNarrow mapIterValuesProxy = new MapMethod("itervalues", 0){

        @Override
        public PyObject __call__() {
            final Iterator<Object> valueIterator = this.asMap().values().iterator();
            return new PyIterator(){

                @Override
                public PyObject __iternext__() {
                    if (valueIterator.hasNext()) {
                        Object nextValue = valueIterator.next();
                        return Py.java2py(nextValue);
                    }
                    return null;
                }
            };
        }
    };
    private static final PyBuiltinMethodNarrow mapHasKeyProxy = new MapMethod("has_key", 1){

        @Override
        public PyObject __call__(PyObject key) {
            return this.asMap().containsKey(JavaProxyMap.tojava(key)) ? Py.True : Py.False;
        }
    };
    private static final PyBuiltinMethodNarrow mapKeysProxy = new MapMethod("keys", 0){

        @Override
        public PyObject __call__() {
            PyList keys = new PyList();
            for (Object key : this.asMap().keySet()) {
                keys.add(Py.java2py(key));
            }
            return keys;
        }
    };
    private static final PyBuiltinMethod mapValuesProxy = new MapMethod("values", 0){

        @Override
        public PyObject __call__() {
            PyList values = new PyList();
            for (Object value : this.asMap().values()) {
                values.add(Py.java2py(value));
            }
            return values;
        }
    };
    private static final PyBuiltinMethodNarrow mapSetDefaultProxy = new MapMethod("setdefault", 1, 2){

        @Override
        public PyObject __call__(PyObject key) {
            return this.__call__(key, Py.None);
        }

        @Override
        public PyObject __call__(PyObject pykey, PyObject _default) {
            Map<Object, Object> map = this.asMap();
            Object key = JavaProxyMap.tojava(pykey);
            try {
                if (map.containsKey(key)) {
                    return Py.java2py(map.get(key));
                }
                map.put(key, JavaProxyMap.tojava(_default));
                return _default;
            }
            catch (NullPointerException npe) {
                throw JavaProxyMap.nullException(npe, key, _default);
            }
        }
    };
    private static final PyBuiltinMethodNarrow mapPopProxy = new MapMethod("pop", 1, 2){

        @Override
        public PyObject __call__(PyObject key) {
            return this.__call__(key, null);
        }

        @Override
        public PyObject __call__(PyObject key, PyObject _default) {
            Object k;
            Map<Object, Object> map = this.asMap();
            if (map.containsKey(k = JavaProxyMap.tojava(key))) {
                return Py.java2py(map.remove(k));
            }
            if (_default == null) {
                throw Py.KeyError(key);
            }
            return _default;
        }
    };
    private static final PyBuiltinMethodNarrow mapPopItemProxy = new MapMethod("popitem", 0){

        @Override
        public PyObject __call__() {
            Map<Object, Object> map = this.asMap();
            Iterator<Map.Entry<Object, Object>> entryIterator = map.entrySet().iterator();
            if (entryIterator.hasNext()) {
                Map.Entry<Object, Object> e = entryIterator.next();
                entryIterator.remove();
                return new PyTuple(Py.java2py(e.getKey()), Py.java2py(e.getValue()));
            }
            throw Py.KeyError("popitem(): map is empty");
        }
    };
    private static final PyBuiltinMethodNarrow mapItemsProxy = new MapMethod("items", 0){

        @Override
        public PyObject __call__() {
            PyList items = new PyList();
            for (Map.Entry<Object, Object> entry : this.asMap().entrySet()) {
                items.add(new PyTuple(Py.java2py(entry.getKey()), Py.java2py(entry.getValue())));
            }
            return items;
        }
    };
    private static final PyBuiltinMethodNarrow mapCopyProxy = new MapMethod("copy", 0){

        @Override
        public PyObject __call__() {
            Map newMap;
            Map<Object, Object> map = this.asMap();
            try {
                Class<?> clazz = map.getClass();
                Constructor<?> ctor = clazz.getDeclaredConstructor(new Class[0]);
                newMap = (Map)ctor.newInstance(new Object[0]);
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    newMap.put(entry.getKey(), entry.getValue());
                }
            }
            catch (NullPointerException npe) {
                throw JavaProxyMap.nullException();
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw Py.JavaError(e);
            }
            return Py.java2py(newMap);
        }
    };
    private static final PyBuiltinMethodNarrow mapUpdateProxy = new MapMethod("update", 0, 1){

        @Override
        public PyObject __call__() {
            return Py.None;
        }

        @Override
        public PyObject __call__(PyObject other) {
            return this.__call__(new PyObject[]{other}, new String[0]);
        }

        @Override
        public PyObject __call__(PyObject[] args, String[] keywords) {
            int nargs = args.length - keywords.length;
            if (nargs > 1) {
                throw PyBuiltinCallable.DefaultInfo.unexpectedCall(nargs, false, "update", 0, 1);
            }
            Map<Object, Object> map = this.asMap();
            try {
                if (nargs == 1) {
                    PyObject other = args[0];
                    Object proxy = other.getJavaProxy();
                    if (proxy instanceof Map) {
                        map.putAll((Map)proxy);
                    } else if (other instanceof PyDictionary) {
                        this.mergeFromSeq(map, other.invoke("items"));
                    } else if (other instanceof PyStringMap) {
                        this.mergeFromKeys(map, other, ((PyStringMap)other).keys());
                    } else if (other.__findattr__("keys") != null) {
                        this.mergeFromKeys(map, other, other.invoke("keys"));
                    } else {
                        this.mergeFromSeq(map, other);
                    }
                }
                for (int i = 0; i < keywords.length; ++i) {
                    String k = keywords[i];
                    Object v = JavaProxyMap.tojava(args[nargs + i]);
                    map.put(k, v);
                }
            }
            catch (NullPointerException npe) {
                throw JavaProxyMap.nullException();
            }
            return Py.None;
        }

        private void mergeFromKeys(Map<Object, Object> map, PyObject other, PyObject keys) {
            for (PyObject key : keys.asIterable()) {
                Object value = JavaProxyMap.tojava(other.__getitem__(key));
                map.put(JavaProxyMap.tojava(key), value);
            }
        }

        private void mergeFromSeq(Map<Object, Object> map, PyObject other) {
            PyObject pair;
            PyObject pairs = other.__iter__();
            int i = 0;
            while ((pair = pairs.__iternext__()) != null) {
                try {
                    pair = PySequence.fastSequence(pair, "");
                }
                catch (PyException pye) {
                    if (pye.match(Py.TypeError)) {
                        throw Py.TypeError(String.format("cannot convert dictionary update sequence element #%d to a sequence", i));
                    }
                    throw pye;
                }
                int n = pair.__len__();
                if (n != 2) {
                    throw Py.ValueError(String.format("dictionary update sequence element #%d has length %d; 2 is required", i, n));
                }
                map.put(JavaProxyMap.tojava(pair.__getitem__(0)), JavaProxyMap.tojava(pair.__getitem__(1)));
                ++i;
            }
        }
    };
    private static final PyBuiltinClassMethodNarrow mapFromKeysProxy = new MapClassMethod("fromkeys", 1, 2){

        @Override
        public PyObject __call__(PyObject keys) {
            return this.__call__(keys, null);
        }

        @Override
        public PyObject __call__(PyObject keys, PyObject _default) {
            Object defobj = JavaProxyMap.tojava(_default);
            try {
                Class<?> clazz = this.asClass();
                Constructor<?> ctor = clazz.getDeclaredConstructor(new Class[0]);
                Map theMap = (Map)ctor.newInstance(new Object[0]);
                for (PyObject key : keys.asIterable()) {
                    theMap.put(JavaProxyMap.tojava(key), defobj);
                }
                return Py.java2py(theMap);
            }
            catch (NullPointerException npe) {
                throw JavaProxyMap.nullException();
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw Py.JavaError(e);
            }
        }
    };

    JavaProxyMap() {
    }

    private static PyBoolean mapEq(PyObject self, PyObject other) {
        if (JavaProxyMap.isPyDict(other)) {
            PyDictionary oDict = (PyDictionary)other;
            Map selfMap = (Map)self.getJavaProxy();
            if (selfMap.size() != oDict.size()) {
                return Py.False;
            }
            for (Map.Entry entry : selfMap.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                PyObject oVal = oDict.__finditem__(Py.java2py(k));
                if (oVal == null) {
                    return Py.False;
                }
                if (Py.java2py(v)._eq(oVal).__nonzero__()) continue;
                return Py.False;
            }
            return Py.True;
        }
        Object oj = other.getJavaProxy();
        if (oj instanceof Map) {
            Map map = (Map)oj;
            HashMap<PyObject, PyObject> pyMap = new HashMap<PyObject, PyObject>();
            for (Map.Entry el : map.entrySet()) {
                pyMap.put(Py.java2py(el.getKey()), Py.java2py(el.getValue()));
            }
            return JavaProxyMap.mapEq(self, new PyDictionary(pyMap));
        }
        return null;
    }

    private static boolean isPyDict(PyObject object) {
        return object.getType().isSubType(PyDictionary.TYPE);
    }

    private static Object tojava(PyObject pyo) {
        return pyo == null || pyo == Py.None ? null : Py.tojava(pyo, Object.class);
    }

    private static RuntimeException nullException() {
        return Py.ValueError("None is not allowed because underlying container cannot store a Java null.");
    }

    private static RuntimeException nullException(NullPointerException npe, Object key, Object value) {
        return value == Py.None || value == Py.None ? JavaProxyMap.nullException() : npe;
    }

    private static PyObject mapLe(PyObject self, PyObject other) {
        Set selfKeys = ((Map)self.getJavaProxy()).keySet();
        if (other.getType().isSubType(PyDictionary.TYPE)) {
            PyDictionary oDict = (PyDictionary)other;
            for (Object k : selfKeys) {
                if (oDict.__contains__(Py.java2py(k))) continue;
                return Py.False;
            }
            return Py.True;
        }
        Object oj = other.getJavaProxy();
        if (oj instanceof Map) {
            Map map = (Map)oj;
            return Py.newBoolean(map.keySet().containsAll(selfKeys));
        }
        return null;
    }

    static PyBuiltinMethod[] getProxyMethods() {
        return new PyBuiltinMethod[]{mapLenProxy, mapIterProxy, mapReprProxy, mapEqProxy, mapNeProxy, mapLeProxy, mapLtProxy, mapGeProxy, mapGtProxy, mapContainsProxy, mapGetItemProxy, mapPutProxy, mapRemoveProxy, mapIterItemsProxy, mapIterKeysProxy, mapIterValuesProxy, mapHasKeyProxy, mapKeysProxy, mapSetDefaultProxy, mapPopProxy, mapPopItemProxy, mapItemsProxy, mapCopyProxy, mapUpdateProxy, mapFromKeysProxy};
    }

    static PyBuiltinMethod[] getPostProxyMethods() {
        return new PyBuiltinMethod[]{mapGetProxy, mapValuesProxy};
    }

    @Untraversable
    private static class MapClassMethod
    extends PyBuiltinClassMethodNarrow {
        protected MapClassMethod(String name, int minArgs, int maxArgs) {
            super(name, minArgs, maxArgs);
        }

        protected Class<?> asClass() {
            return (Class)this.self.getJavaProxy();
        }
    }

    @Untraversable
    private static class MapMethod
    extends PyBuiltinMethodNarrow {
        protected MapMethod(String name, int numArgs) {
            super(name, numArgs);
        }

        protected MapMethod(String name, int minArgs, int maxArgs) {
            super(name, minArgs, maxArgs);
        }

        protected Map<Object, Object> asMap() {
            return (Map)this.self.getJavaProxy();
        }
    }
}

